package com.payu.ui.model.adapters.viewholders

import android.view.View
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.ImageDetails
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.models.TilesData
import com.payu.ui.model.utils.ImageViewUtils

class TpvAccountInfoViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
    private var ivImage: ImageView = itemView.findViewById(R.id.ivImage)
    private var tvBankName : TextView = itemView.findViewById(R.id.pay_using_s)

    fun bind(tilesData: TilesData){
        tvBankName.text = itemView.context.getString(
            R.string.payu_tpv_account_info_text,
            tilesData.title,
            tilesData.subText
        )
        tilesData.imageUrl?.let {
            SdkUiInitializer.apiLayer?.getBitmapImageFormURL(it,object : OnFetchImageListener{
                override fun onImageGenerated(result: ImageDetails) {
                    ImageViewUtils.setImage(ivImage, result)
                }

            })
        }
    }
}