package com.payu.ui.model.adapters.viewholders

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.EditText
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.annotation.DrawableRes
import androidx.appcompat.widget.SearchView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView
import com.payu.ui.R
import com.payu.ui.model.utils.ViewUtils

class SearchViewHolder(view: View) : RecyclerView.ViewHolder(view) {
    private val context: Context = view.context

    
    private var rlSearchView: ConstraintLayout? = view.findViewById(R.id.rlSearchView)
    private var tvAllBanks: TextView? = view.findViewById(R.id.tvAllBanks)
    private var ivLeftIcon: ImageView? = view.findViewById(R.id.ivLeftIcon)
    private var searchView: SearchView? = view.findViewById(R.id.searchView)
    private var etSearch: EditText? = searchView?.findViewById(R.id.search_src_text)
    private var ivSearchIcon: ImageView? = searchView?.findViewById(R.id.search_button)
    private var ivCloseIcon: ImageView? = searchView?.findViewById(R.id.search_close_btn)
    private var resetSelection: (() -> Unit)? = null
    private var isLeftIconAvailable = false

    private fun updateViews(
        allBanksText: String? = null,
        leftIcon: Int? = null,
        hideSearchView: Boolean? = null,
        hideHeaderView: Boolean? = null,
        offerUpdated: Boolean = false,
        updateOfferUpdatedFlag: (Boolean) -> Unit
    ) {
        if (allBanksText != null) tvAllBanks?.text =
            allBanksText else rlSearchView?.visibility = View.GONE

        leftIcon?.let {
            isLeftIconAvailable = true
            ivLeftIcon?.visibility = View.VISIBLE
            ivLeftIcon?.setImageResource(it)
        }

        searchView?.visibility =
            if (hideSearchView == true) View.GONE else View.VISIBLE

        rlSearchView?.visibility =
            if (hideHeaderView == true) View.GONE else
                View.VISIBLE

        if (offerUpdated) {
            updateOfferUpdatedFlag.invoke(false)
            resetAndHideSearchView()
        }
    }

    fun bind(
        allBanksText: String? = null,
        @DrawableRes leftIcon: Int? = null,
        isSearchInitDone: Boolean = false,
        hideSearchView: Boolean? = null,
        hideHeaderView: Boolean? = null,
        offerUpdated: Boolean = false,
        resetSelection: () -> Unit,
        filterItems: (String) -> Unit,
        updateOfferUpdatedFlag: (Boolean) -> Unit,
        updateSearchInitFlag: (Boolean) -> Unit,
    ) {
        this.resetSelection = resetSelection
        if (isSearchInitDone.not())
            initSearchView(updateSearchInitFlag = updateSearchInitFlag)
        updateViews(
            allBanksText = allBanksText,
            leftIcon = leftIcon,
            hideSearchView = hideSearchView,
            hideHeaderView = hideHeaderView,
            offerUpdated = offerUpdated,
            updateOfferUpdatedFlag = updateOfferUpdatedFlag
        )

        ivCloseIcon?.setOnClickListener {
            etSearch?.setText("")
            etSearch?.requestFocus()
            ivCloseIcon?.visibility = View.GONE
        }

        etSearch?.setOnFocusChangeListener { v, hasFocus ->
            val searchText = etSearch?.text?.toString()
            if (!hasFocus) {
                if ((searchText?.length ?: 0) > 0)
                    ViewUtils.hideSoftKeyboard(v)
                else {
                    tvAllBanks?.visibility = View.VISIBLE
                    ivLeftIcon?.isVisible = isLeftIconAvailable
                    searchView?.apply {
                        this.layoutParams.also {
                            it.width = ViewGroup.LayoutParams.WRAP_CONTENT
                        }
                    }
                    searchView?.isIconified = true
                    updateSearchIconEndMargin()
                }
            }
        }

        searchView?.setOnSearchClickListener {
            tvAllBanks?.visibility = View.GONE
            ivLeftIcon?.visibility = View.GONE
            ivCloseIcon?.visibility = View.GONE
            resetSelection()
            searchView?.apply {
                this.layoutParams.also {
                    it.width = ViewGroup.LayoutParams.MATCH_PARENT
                }
            }
            etSearch?.apply {
                this.setCompoundDrawablesWithIntrinsicBounds(
                    R.drawable.payu_search_hint,
                    0,
                    0,
                    0
                )
                this.compoundDrawablePadding =
                    context.resources.getDimension(R.dimen.payu_dimen_8dp).toInt()
            }
        }

        searchView?.setOnQueryTextListener(object : SearchView.OnQueryTextListener {
            override fun onQueryTextSubmit(query: String?): Boolean {
                searchQueryEntered(searchQuery = query, filterItems = filterItems)
                return false
            }

            override fun onQueryTextChange(newText: String?): Boolean {
                searchQueryEntered(searchQuery = newText, filterItems = filterItems)
                return false
            }

        })
    }

    private fun resetAndHideSearchView() {
        tvAllBanks?.visibility = View.VISIBLE
        ivLeftIcon?.isVisible = isLeftIconAvailable
        etSearch?.setText("")
        searchView?.apply {
            this.layoutParams.also {
                it.width = ViewGroup.LayoutParams.WRAP_CONTENT
            }
        }
        searchView?.isIconified = true
        updateSearchIconEndMargin()
    }

    private fun searchQueryEntered(searchQuery: String?, filterItems: (String) -> Unit) {
        ivCloseIcon?.isVisible = !searchQuery.isNullOrEmpty()
        if (!searchQuery.isNullOrEmpty()) {
            filterItems.invoke(searchQuery)
        } else {
            filterItems.invoke("")
        }
    }

    private fun initSearchView(updateSearchInitFlag: (Boolean) -> Unit) {
        searchView?.setQuery("", false)
        searchView?.queryHint = context.getString(R.string.payu_search)
        tvAllBanks?.isVisible = true
        ivLeftIcon?.isVisible = isLeftIconAvailable
        searchView?.apply {
            this.layoutParams.also {
                it.width = ViewGroup.LayoutParams.WRAP_CONTENT
            }
        }
        searchView?.isIconified = true
        updateSearchIconEndMargin()

        clearSearchViewFocus()
        updateSearchInitFlag.invoke(true)
    }

    private fun clearSearchViewFocus() {
        if (etSearch != null && etSearch!!.hasFocus()) {
            //Request focus on root view of search view to remove focus
            if (null != rlSearchView && rlSearchView!!.isFocusable) rlSearchView!!.requestFocus()
        }
    }

    private fun updateSearchIconEndMargin() {
        ivSearchIcon?.apply {
            val layoutParams: LinearLayout.LayoutParams =
                this.layoutParams as LinearLayout.LayoutParams
            layoutParams.marginEnd = resources.getDimension(R.dimen.payu_dimen_minus_12dp)
                .toInt()
            this.layoutParams = layoutParams
        }
    }
}
