package com.payu.ui.model.adapters

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView.Adapter
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.ui.R
import com.payu.ui.model.adapters.viewholders.QuickPayNBViewHolder
import com.payu.ui.model.adapters.viewholders.QuickPayBNPLViewHolder
import com.payu.ui.model.adapters.viewholders.QuickPayCardsViewHolder
import com.payu.ui.model.adapters.viewholders.QuickPayViewHolder
import com.payu.ui.model.listeners.ValidateOfferResultListener

class QuickPayAdapter(
    var quickPayList: ArrayList<PaymentMode>,
    private val onQuickOptionAdapterListener: OnQuickOptionAdapterListener
) : Adapter<QuickPayViewHolder>() {

    private var selectedPosition: Int = -1
    private var onItemClickListener: ((paymentMode: PaymentMode, position: Int) -> Unit)? =
        null
    private var makePayment: ((paymentOption: PaymentOption, position: Int) -> Unit)? = null
    private var isFirstItemSelected: Boolean = true


    init {
        onItemClickListener = { paymentMode, position ->
            if (paymentMode.type != null)
                setSelection(position)
            else onQuickOptionAdapterListener.otherOptionClicked()
        }
        makePayment = { paymentOption: PaymentOption, position: Int ->
            onQuickOptionAdapterListener.makePayment(paymentOption, position)
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): QuickPayViewHolder {

        val inflater = LayoutInflater.from(parent.context)

        return when (viewType) {

            1 -> { //CC
                val view = inflater.inflate(R.layout.activity_item_cc, parent, false)
                return QuickPayCardsViewHolder(view)
            }

            2 -> { //BNPL
                val view = inflater.inflate(R.layout.activity_item_bnpl, parent, false)
                return QuickPayBNPLViewHolder(view)
            }

            else -> {
                val view = inflater.inflate(R.layout.activity_item_nb, parent, false)
                QuickPayNBViewHolder(view)
            }
        }

    }

    override fun getItemCount(): Int {
        return quickPayList.size
    }

    override fun getItemViewType(position: Int): Int {
        return when (quickPayList[position].type) {
            PaymentType.CARD -> 1
            PaymentType.BNPL -> 2
            else -> 0
        }
    }

    override fun onBindViewHolder(holder: QuickPayViewHolder, position: Int) {
        holder.onItemClickListener = onItemClickListener
        holder.makePayment = makePayment
         if (position==0 && isFirstItemSelected){
             selectedPosition= 0
             isFirstItemSelected = false
             if (quickPayList[0].isOfferValid) onQuickOptionAdapterListener.showOfferView(true)
         }
        when (holder) {
            is QuickPayCardsViewHolder -> holder.bind(quickPayList[position], selectedPosition)
            is QuickPayBNPLViewHolder -> holder.bind(quickPayList[position], selectedPosition)
            else -> (holder as QuickPayNBViewHolder).bind(quickPayList[position], selectedPosition)
        }

    }

    private fun setSelection(position: Int) {
        if (selectedPosition != position) {
            resetSelection()
            selectedPosition = position
            //TODO will uncomment when offer is supported
//            val paymentOption = quickPayList[position].optionDetail?.get(0)
//            if (paymentOption != null) {
//                onQuickOptionAdapterListener.validate(paymentOption,
//                    object : ValidateOfferResultListener {
//                        override fun onValidateOfferResponse(isOfferValid: Boolean) {
//                            quickPayList[position].isOfferValid = isOfferValid
//                            notifyItemChanged(position)
//                        }
//                    })
//            }

            notifyItemChanged(selectedPosition)
        } else {
            quickPayList[position].isOfferValid = false
            resetSelection()
        }
    }

    private fun resetSelection() {
        val oldSelectedPosition = selectedPosition
//        onQuickOptionAdapterListener.showOfferView(InternalConfig.selectedOfferInfo?.isAutoApply == false)
        InternalConfig.isPaymentOptionSelected = false
        if (oldSelectedPosition != -1)
            quickPayList[oldSelectedPosition].isOfferValid = false
        selectedPosition = -1 //reset the position
        notifyItemChanged(oldSelectedPosition)
    }

}

interface OnQuickOptionAdapterListener {
    fun validate(
        paymentOption: PaymentOption,
        onValidateOfferResultListener: ValidateOfferResultListener
    )

    fun showOfferView(showOffer: Boolean)
    fun makePayment(paymentOption: PaymentOption, position: Int)

    fun otherOptionClicked()

}

