package com.payu.ui.model.adapters

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.models.*
import com.payu.ui.R
import com.payu.ui.model.utils.SdkUiConstants.LAYOUT_CLOSED_LOOP_WALLET
import com.payu.ui.model.utils.SdkUiConstants.LAYOUT_OTHER
import com.payu.ui.model.adapters.viewholders.ClosedLoopWalletViewHolder
import com.payu.ui.model.adapters.viewholders.QuickOptionViewHolder
import com.payu.ui.model.adapters.viewholders.SavedOptionViewHolder
import com.payu.ui.model.listeners.ValidateOfferResultListener

class QuickOptionsAdapter(
    var quickOptionList: ArrayList<PaymentMode>,
    private val onQuickOptionAdapterListener: OnQuickOptionAdapterListener
) :
    RecyclerView.Adapter<QuickOptionViewHolder>() {
    private var selectedPosition: Int = -1
    private var onItemClickListener: ((paymentMode: PaymentMode, position: Int, isBalanceFetched: Boolean) -> Unit)? =
        null

    init {
        onItemClickListener = { paymentMode, position, isBalanceFetched ->
            onQuickOptionAdapterListener.onItemClick(paymentMode)
            if (isBalanceFetched) setSelection(position)
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): QuickOptionViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        return when (viewType) {
            LAYOUT_CLOSED_LOOP_WALLET -> {
                ClosedLoopWalletViewHolder(
                    inflater.inflate(
                        R.layout.quick_option_list_item,
                        parent,
                        false
                    )
                )
            }

            else -> {
                SavedOptionViewHolder(
                    inflater.inflate(
                        R.layout.quick_option_list_item,
                        parent,
                        false
                    )
                )
            }
        }
    }

    override fun getItemCount(): Int {
        return quickOptionList.size
    }

    override fun getItemViewType(position: Int): Int {
        return if (quickOptionList[position].type == PaymentType.CLOSED_LOOP_WALLET || quickOptionList[position].type == PaymentType.SODEXO)
            LAYOUT_CLOSED_LOOP_WALLET
        else
            LAYOUT_OTHER
    }

    override fun onBindViewHolder(recyclerViewHolder: QuickOptionViewHolder, position: Int) {
        recyclerViewHolder.onItemClickListener = onItemClickListener
        if (recyclerViewHolder is ClosedLoopWalletViewHolder) {
            recyclerViewHolder.bind(quickOptionList[position], selectedPosition)

        } else if (recyclerViewHolder is SavedOptionViewHolder) {
            recyclerViewHolder.bind(quickOptionList[position], selectedPosition)
        }
    }

    private fun setSelection(position: Int) {
        if (selectedPosition != position) {
            resetSelection()
            selectedPosition = position
            val paymentOption = quickOptionList[position].optionDetail?.get(0)
            paymentOption?.let {
                onQuickOptionAdapterListener.updateHeaderAmount(it)
                if (InternalConfig.isOfferEnabled && quickOptionList[position].type != PaymentType.CARD) {
                    onQuickOptionAdapterListener.validate(paymentOption,
                        object : ValidateOfferResultListener {
                            override fun onValidateOfferResponse(isOfferValid: Boolean) {
                                quickOptionList[position].isOfferValid = isOfferValid
                                notifyItemChanged(position)
                            }
                        })
                }
            }

            notifyItemChanged(selectedPosition)
        } else {
            quickOptionList[position].isOfferValid = false
            resetSelection()
            onQuickOptionAdapterListener.updateHeaderAmount()

        }
    }

    //
    private fun resetSelection() {
        val oldSelectedPosition = selectedPosition
        onQuickOptionAdapterListener.showOfferView(InternalConfig.selectedOfferInfo?.isAutoApply == false)
        InternalConfig.isPaymentOptionSelected = false
        if (oldSelectedPosition != -1)
            quickOptionList[oldSelectedPosition].isOfferValid = false
        selectedPosition = -1 //reset the position
        notifyItemChanged(oldSelectedPosition)
    }

    interface OnQuickOptionAdapterListener {
        fun validate(
            paymentOption: PaymentOption,
            onValidateOfferResultListener: ValidateOfferResultListener
        )
        fun showOfferView(showOffer: Boolean)
        fun onItemClick(paymentMode: PaymentMode)
        fun updateHeaderAmount(paymentOption: PaymentOption? = null)
    }

}