package com.payu.ui.model.adapters

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.models.OrderDetails
import com.payu.ui.R

class OrderDetailsListAdapter(
    var orderDetailsList: ArrayList<OrderDetails>
) :
    RecyclerView.Adapter<OrderDetailsListAdapter.ViewHolder>() {
    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val tvOrderKey: TextView = itemView.findViewById(R.id.tvOrderKey)
        val tvOrderValue: TextView = itemView.findViewById(R.id.tvOrderValue)

    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        val view: View = inflater.inflate(R.layout.item_layout_order_detail, parent, false)

        return ViewHolder(view)
    }

    override fun getItemCount(): Int {
        return orderDetailsList.size
    }

    override fun getItemId(position: Int): Long {
        return position.toLong()
    }

    override fun getItemViewType(position: Int): Int {
        return position
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {

        holder.tvOrderKey.text = orderDetailsList[position].key
        holder.tvOrderValue.text = orderDetailsList[position].value

    }
}