package com.payu.ui.model.adapters

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.google.android.material.chip.Chip
import com.google.android.material.chip.ChipGroup
import com.payu.ui.R
import com.payu.ui.model.adapters.HorizontalAdapter.HorizontalViewHolder
import com.payu.ui.viewmodel.WalletViewModel

class HorizontalAdapter(
    private val items: ArrayList<String>,
    private val handleEntered: (handle: String)-> Unit
) :
    RecyclerView.Adapter<HorizontalViewHolder>() {
    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): HorizontalViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        val view = inflater.inflate(R.layout.horizontal_item_layout, parent, false)
        return HorizontalViewHolder(view)
    }

    override fun onBindViewHolder(holder: HorizontalViewHolder, position: Int) {
        holder.chipItemPayHandles.text = items[position]
    }

    override fun getItemCount(): Int {
        return items.size
    }

    inner class HorizontalViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var chipItemPayHandles: Chip = itemView.findViewById(R.id.chip_list_item)
        val chipGroupPayHandlesCollection: ChipGroup = itemView.findViewById(R.id.chipGroup)

        init {
            chipGroupPayHandlesCollection.setOnCheckedChangeListener { chipGroupPayHandlesCollection, chipItemPayHandles ->
                handleEntered.invoke(
                    chipGroupPayHandlesCollection.findViewById<Chip>(
                        chipItemPayHandles
                    )?.text.toString()
                )
            }

        }
    }
}