package com.payu.ui.viewmodel

import android.app.Application
import android.content.Intent
import android.os.Bundle
import android.os.CountDownTimer
import android.os.Handler
import android.os.Looper
import android.text.Editable
import android.util.Log
import android.webkit.WebView
import androidx.activity.ComponentActivity
import androidx.appcompat.content.res.AppCompatResources
import androidx.fragment.app.Fragment
import androidx.lifecycle.MutableLiveData
import com.payu.base.listeners.BaseTransactionListener
import com.payu.base.listeners.HashGenerationListener
import com.payu.base.listeners.OnCardBinInfoListener
import com.payu.base.listeners.OnEmiDetailsListener
import com.payu.base.listeners.OnFetchGaidListener
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.listeners.OnGVQuickPayListener
import com.payu.base.listeners.PaymentVerificationListener
import com.payu.base.models.CardBinInfo
import com.payu.base.models.CardOption
import com.payu.base.models.CardScheme
import com.payu.base.models.DrawableType
import com.payu.base.models.EMIOption
import com.payu.base.models.ErrorResponse
import com.payu.base.models.FetchOfferDetails
import com.payu.base.models.GlobalVaultAPIsCommand
import com.payu.base.models.ImageDetails
import com.payu.base.models.InternalConfig
import com.payu.base.models.OfferInfo
import com.payu.base.models.PayUBillingCycle
import com.payu.base.models.PayUSIParams
import com.payu.base.models.PayUVerifyOtpData
import com.payu.base.models.PaymentFlowState
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentModel
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentState
import com.payu.base.models.PaymentType
import com.payu.base.models.QuickOptionsModel
import com.payu.base.models.SavedCardOption
import com.payu.base.models.SelectedOfferInfo
import com.payu.base.models.SodexoCardOption
import com.payu.base.models.UPIOption
import com.payu.base.models.VariableDynamics
import com.payu.nfc.PayUNFC
import com.payu.otpparser.OtpCallback
import com.payu.otpparser.OtpParser
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.listeners.EnachCallback
import com.payu.ui.model.managers.BottomSheetManager
import com.payu.ui.model.managers.EnachDialogHandler
import com.payu.ui.model.managers.NetworkManager
import com.payu.ui.model.managers.OfferFilterListener
import com.payu.ui.model.managers.OfferFilterManager
import com.payu.ui.model.models.FragmentModel
import com.payu.ui.model.models.PaymentStatus
import com.payu.ui.model.models.SnackBarModel
import com.payu.ui.model.models.TilesData
import com.payu.ui.model.models.ToolTipModel
import com.payu.ui.model.utils.AnalyticsConstant
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.CPCallbackType
import com.payu.ui.model.utils.GlobalVaultResponseCodes
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.SdkUiConstants.CP_REWARD
import com.payu.ui.model.utils.SdkUiConstants.PAYU_PAYMENT_ID
import com.payu.ui.model.utils.SdkUiConstants.PAYU_RESPONSE
import com.payu.ui.model.utils.SdkUiConstants.PAYU_RESULT
import com.payu.ui.model.utils.SdkUiConstants.PAYU_UID
import com.payu.ui.model.utils.SdkUiConstants.TAG_DYNAMIC_FRAGMENT
import com.payu.ui.model.utils.SdkUiConstants.TAG_NB_DETAILS_FRAGMENT
import com.payu.ui.model.utils.SdkUiConstants.TAG_PAYMENT_OPTION_FRAGMENT
import com.payu.ui.model.utils.SdkUiConstants.TAG_RESULT_FRAGMENT
import com.payu.ui.model.utils.SdkUiConstants.TAG_WALLET_FRAGMENT
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.view.fragments.AddCardFragment
import com.payu.ui.view.fragments.BankFragment
import com.payu.ui.view.fragments.EmiTenureFragment
import com.payu.ui.view.fragments.NBDetailsFragment
import com.payu.ui.view.fragments.PayUSavedCardsFragment
import com.payu.ui.view.fragments.PaymentOptionFragment
import com.payu.ui.view.fragments.WalletFragment
import org.json.JSONException
import org.json.JSONObject
import java.util.Stack
import java.util.concurrent.Executors


 class PaymentOptionViewModel(
    application: Application
) :
    OLWViewModel(application), BaseTransactionListener,
    OnEmiDetailsListener, OnCardBinInfoListener, OnFetchImageListener, PaymentVerificationListener,
    OnFetchGaidListener, OfferFilterListener {
    private val TAG = this.javaClass.simpleName

    var additonalCharges: String = "0.0"
    var convenienceFeeCharges: String = "0.0"
    var gstAmount: String = "0.0"
    var gstPercent: String = "0.0"
    var quickOptions: MutableLiveData<ArrayList<PaymentMode>?> = MutableLiveData()
    var updatedSodexoOptionList: MutableLiveData<ArrayList<PaymentMode>> = MutableLiveData()
    var otherOptions: MutableLiveData<ArrayList<PaymentMode>?> = MutableLiveData()
    var headerAmount: MutableLiveData<String> = MutableLiveData()
    var additionalCharge: MutableLiveData<String> = MutableLiveData()
    var payText: MutableLiveData<String> = MutableLiveData()
    val merchantIcon: MutableLiveData<ImageDetails> = MutableLiveData()
    val showBottomSheet: MutableLiveData<Pair<Int, BottomSheetManager?>> = MutableLiveData()
    val showOfferBottomSheet: MutableLiveData<Pair<Int, Boolean>> = MutableLiveData()
    val showL1BottomSheet: MutableLiveData<Pair<Int, String>> = MutableLiveData()
    val hideBottomFooter: MutableLiveData<Boolean> = MutableLiveData()
    val hideBackNavigation: MutableLiveData<Boolean> = MutableLiveData()
    val expandToolbar: MutableLiveData<Boolean> = MutableLiveData()
    val updateSavedCardBottomSheet: MutableLiveData<SavedCardOption> = MutableLiveData()
    val updateSodexoCardBottomSheet: MutableLiveData<SodexoCardOption> = MutableLiveData()
    val updateExitDialogBottomSheet: MutableLiveData<Boolean> = MutableLiveData()
    val updateOrderDetailsBottomSheet: MutableLiveData<Boolean> = MutableLiveData()
    val updateOfferDetailsBottomSheet: MutableLiveData<Boolean> = MutableLiveData()
    val updateBankBottomSheet: MutableLiveData<PaymentOption> = MutableLiveData()
    val cvvLengthFilter: MutableLiveData<Int> = MutableLiveData()
    val enablePayButtonBottomSheet: MutableLiveData<Boolean> = MutableLiveData()
    var savedCardCvvToolTip: MutableLiveData<ToolTipModel> = MutableLiveData()
    var showTransparentView: MutableLiveData<Boolean> = MutableLiveData()
    var hideToolTip: MutableLiveData<Boolean> = MutableLiveData()
    var showSavedCardOfferUI: MutableLiveData<Boolean> = MutableLiveData()
    var savedCardOfferText: MutableLiveData<String> = MutableLiveData()
    var paymentResponse: Any? = null
    var selectedPaymentMode: PaymentMode? = null
    var offerDetailsInflated: Boolean = false
    var orderDetailsInflated: Boolean = false
    var savedCardInflated: Boolean = false
    var exitDialogInflated: Boolean = false
    var bankInflated: Boolean = false
    private var sendOtpInflated: Boolean = false
    var handleErroMessage: Boolean = false
    var isPaymentViaMCP: Boolean = false
    private var logoutSheetInflated: Boolean = false
    val applicationContext = application
    private var savedInstance: Bundle? = null
    var listenerMap = HashMap<String, HashGenerationListener>()
    var siHeaderSummary: MutableLiveData<String> = MutableLiveData()
    var isSISupportedForSavedCard: MutableLiveData<Boolean> = MutableLiveData()
    val savedCardCvvFieldColor: MutableLiveData<Int> = MutableLiveData()
    val checkoutScreenName: MutableLiveData<String> = MutableLiveData()
    var fetchApiCalledTimeStamp: MutableLiveData<Long> = MutableLiveData()
    var moreOptionsListLiveData: MutableLiveData<ArrayList<PaymentMode>?> = MutableLiveData()
    var moreOptionsList: ArrayList<PaymentMode>? = null
    val showChangeOfferView: MutableLiveData<Boolean> = MutableLiveData()
    val updateOffer: MutableLiveData<Boolean> = MutableLiveData()
    var retryError: MutableLiveData<Event<String>> = MutableLiveData()
    val payUId = MutableLiveData<String>()
    val showOfferIcon: MutableLiveData<FetchOfferDetails> = MutableLiveData()
    var updateConfigView: MutableLiveData<Boolean> = MutableLiveData()
    var updateOTPBottomSheet: MutableLiveData<Boolean> = MutableLiveData()
    var logoutBottomSheet: MutableLiveData<Boolean> = MutableLiveData()
    var logoutFromGlobalVault: MutableLiveData<Boolean> = MutableLiveData()
    var manage: MutableLiveData<Boolean> = MutableLiveData()
    val gvShowOTPModeBottomSheet: MutableLiveData<Boolean> = MutableLiveData()
    val gvLoadGlobalVaultData: MutableLiveData<Boolean> = MutableLiveData()
    val gvPayuNoSavedOptions: MutableLiveData<Boolean> = MutableLiveData()
    var gvSubmittingTimeInt: MutableLiveData<Int> = MutableLiveData()
    var gvResendOTPTimeInt: MutableLiveData<Int> = MutableLiveData()
    var gvSendOTPError: MutableLiveData<String> = MutableLiveData()
    var gvResendOTPError: MutableLiveData<String> = MutableLiveData()
    var gvVerifyOTPError: MutableLiveData<String> = MutableLiveData()
    var gvVerifyOTPExceedError: MutableLiveData<Boolean> = MutableLiveData()
    var fetchGVData: MutableLiveData<Boolean> = MutableLiveData()
    var showLoaderScreen: MutableLiveData<Boolean> = MutableLiveData()
    var refreshPaymentModesForOffers: MutableLiveData<Boolean> = MutableLiveData()
    var uuidGlobalVault = ""
    var userTokenGlobalVault = ""
    private var gvOtpAttemptCounter = 0
    private var gvVerifyAttemptCounter = 3
    private lateinit var gvSubmitProgressTimer: CountDownTimer
    private lateinit var resendOTPTimerTransactionCounter: CountDownTimer
    var vaultVerificationPhoneNumber = SdkUiInitializer.apiLayer?.payUPaymentParams?.phone
    var recommendedOptions: MutableLiveData<ArrayList<PaymentMode>?> = MutableLiveData(null)
    private var otpParser: OtpParser? = null
    var showUnlockOption: MutableLiveData<Boolean> = MutableLiveData()
    var showLoginPhoneLayout: MutableLiveData<Boolean> = MutableLiveData()
    var sodexoList: ArrayList<PaymentMode> = ArrayList()
    val showClwLoadAndPayBottomSheet: MutableLiveData<Pair<Event<Boolean>, SodexoCardOption?>> =
        MutableLiveData()
    val validateOffer: MutableLiveData<Boolean> = MutableLiveData()

    val selectedOption: MutableLiveData<PaymentOption> = MutableLiveData()
    var skuDetailsInflated: Boolean = false
    val updateSkuDetailsBottomSheet: MutableLiveData<Boolean> = MutableLiveData()
    private val recommendedSavedList = ArrayList<PaymentMode>()
    private var quickOptionList = ArrayList<PaymentMode>()
    internal var isOfferAvailable: MutableLiveData<Event<Boolean>> = MutableLiveData()
    private var fetchOfferDetails: FetchOfferDetails? = null
    private var isMoreOptionEmpty = false
    private var isQuickOptionEmpty = false
    internal val readOtpGV: MutableLiveData<Editable> = MutableLiveData()

    val verifyButtonVisibility: MutableLiveData<Boolean> = MutableLiveData()
    val tilesList = ArrayList<TilesData>()

    var cachedUserConsent: Boolean? = null
    var showConsentPopup: MutableLiveData<Event<Boolean>> = MutableLiveData()
    var retryFlow: MutableLiveData<Boolean> = MutableLiveData()

    var showVerifyOtpBottomSheet: MutableLiveData<Event<PayUVerifyOtpData>> = MutableLiveData()
    var showCouponError: MutableLiveData<Event<Pair<Boolean, String?>>> = MutableLiveData()
    var hideOtpBottomSheet: MutableLiveData<Event<Boolean>> = MutableLiveData()
    private var verifyOtpInflated: Boolean = false
    private var pendingOffer: OfferInfo? = null

    internal fun resetMorePaymentOptionsList() {
        moreOptionsList?.forEach { it.isOfferValid = false }
        moreOptionsListLiveData.value = moreOptionsList
    }

    internal fun showMoreOptionList(list: ArrayList<PaymentMode>?) {
        if (list.isNullOrEmpty())
            otherOptions.value = null
        else {
            moreOptionsListLiveData.value = list
            isMoreOptionEmpty = false
            val paymentState = SdkUiInitializer.apiLayer?.getEnforcedState()
            // For OTM, if there is only one payment Mode, user should be redirected to L2
            if (SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.isPreAuthTxn == true && list.size == 1) {
                otherOptionSelected(list.first())
            } else if (list.size == 1 && !InternalConfig.isRetryTxn) {
                if (paymentState != null && list.first().optionDetail?.size == 1) {  // this will be for enach txn
                    val paymentModel = PaymentModel()
                    val paymentFlowState = PaymentFlowState()
                    paymentFlowState.paymentState = paymentState
                    paymentModel.paymentFlowState = paymentFlowState
                    paymentModel.paymentOption = list.first().optionDetail?.first()
                    loadNextState(paymentModel)
                } else
                    otherOptionSelected(list.first())   // other than enach
            } else otherOptions.value = list
        }
        if (savedInstance != null) {
            verifyPayment()
        }
        showTpvTiles.value = InternalConfig.userAccountInfoList.isNullOrEmpty().not()
    }

    fun loadFragment(
        fragment: Fragment,
        tag: String?,
        paymentType: PaymentType? = null
    ) {
        if (paymentType != null)
            OfferFilterManager.handleOfferListForSelectedPaymentMode(
                paymentType = paymentType,
                listener = this
            )
        //dismiss snackbar
        ViewUtils.dismissSnackBar()
        val fragmentModel = FragmentModel()
        fragmentModel.fragment = fragment
        fragmentModel.tag = tag
        loadFragment.value = fragmentModel
    }

    private fun onRecommendedOptionFetched(list: ArrayList<PaymentMode>?) {
        recommendedSavedList.clear()
        if (list != null) {
            recommendedSavedList.addAll(list)
        }
        if (!moreOptionsList.isNullOrEmpty())
            recommendedOptions.value =
                if (InternalConfig.selectedOfferInfo != null && InternalConfig.selectedOfferInfo?.isValid == true) OfferFilterManager.filterRecommendedMode(
                    recommendedSavedList
                ) else recommendedSavedList
    }

    override fun onPaymentSuccess(response: Any) {
        processResponse(PaymentStatus.SUCCESS, response)
        resetUIOnCancel()

//        loadFragment(ResultFragment.newInstance(PaymentStatus.SUCCESS), TAG_RESULT_FRAGMENT)
    }

    private fun processResponse(paymentStatus: PaymentStatus, response: Any) {
        if (Utils.isEnachPayment(selectedPaymentMode?.type) &&
            SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.enachEnableFeedback == true
        ) {
            showBottomSheet.value =
                Pair(R.layout.enach_feedback_dialog, EnachDialogHandler(object : EnachCallback {
                    override fun onCompleted() {
                        if (SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.enachEnableFeedbackHandler == false) {
                            val map = response as HashMap<String, String>
                            map[SdkUiConstants.CP_ENACH_URL] = SdkUiConstants.ENACH_FEEDBACK_URL
                            paymentResponse = map
                        } else {
                            paymentResponse = response
                        }

                        continueShoppingClicked(paymentStatus)
                        getPayUIDetails(response)
                    }
                }))
        } else {
            paymentResponse = response
            getPayUIDetails(response)
            initiateDeviceInfoApi()
            continueShoppingClicked(paymentStatus)
        }
    }

    override fun onPaymentFailure(response: Any) {
        processResponse(PaymentStatus.FAILED, response)
        resetUIOnCancel()
//        loadFragment(ResultFragment.newInstance(PaymentStatus.FAILED), TAG_RESULT_FRAGMENT)
    }

    override fun onPaymentCancel() {
        continueShoppingClicked(PaymentStatus.CANCELLED)
        resetUIOnCancel()
//        loadFragment(
//            ResultFragment.newInstance(PaymentStatus.CANCELLED),
//            TAG_RESULT_FRAGMENT
//        )
    }

    override fun loadNextState(fragment: Fragment?) {
        fragment?.let {
            loadFragment(it, TAG_DYNAMIC_FRAGMENT)
        }
    }

    override fun loadNextState(paymentModel: PaymentModel) {
        paymentModel.paymentFlowState?.paymentState?.let {
            when (it) {
                PaymentState.BankDetails -> {
                    val nbDetailsFragment = NBDetailsFragment.newInstance(paymentModel)
                    loadFragment(nbDetailsFragment, TAG_NB_DETAILS_FRAGMENT)
                    AnalyticsUtils.logL3CTAClickEvent(
                        applicationContext,
                        paymentModel.paymentOption?.bankName!!,
                        paymentModel.paymentOption?.paymentType!!
                    )
                }

                PaymentState.MCP -> {
                    paymentModel.paymentOptionList?.let {
                        val bankFragment =
                            BankFragment.newInstance(
                                paymentModel.paymentFlowState?.paymentState!!,
                                ((paymentModel.paymentOption) as CardOption).cardBinInfo?.additionalCharge,
                                it,
                                PaymentType.CARD
                            )
                        loadFragment(bankFragment, null)
                    }
                }

                PaymentState.CardTenureEligibility,
                PaymentState.CardnumMobileTenureEligibility,
                PaymentState.CardnumTenureEligibility,
                PaymentState.CardMobileTenureEligibility,
                PaymentState.MobilePanTenureEligibility -> {
                    paymentModel.paymentOptionList?.let {
                        Handler(Looper.getMainLooper()).post {
                            val emiTenureFragment = EmiTenureFragment.newInstance(
                                it,
                                paymentModel.paymentFlowState?.paymentState
                            )
                            OfferFilterManager.handleOfferListForEMITenures(it, this)
                            loadFragment(emiTenureFragment, null)
                            AnalyticsUtils.logL3CTAClickEvent(
                                applicationContext,
                                paymentModel.paymentOption?.bankName!!,
                                paymentModel.paymentOption?.paymentType!!
                            )
                        }
                    }
                }

                PaymentState.ClosedLoopWalletLoadAndPay -> {
                    val sodexoCardOption = paymentModel.paymentOption as? SodexoCardOption
                    showClwLoadAndPayBottomSheet.value = Pair(Event(true), sodexoCardOption)
                }

                PaymentState.OLW -> {
                    SdkUiInitializer.apiLayer?.updatePaymentState(
                        Utils.getPaymentModel(
                            paymentModel.paymentOption ?: PaymentOption(),
                            PaymentFlowState().apply { paymentState = PaymentState.OLW }
                        ),
                        ViewUtils.getToolbar(
                            applicationContext,
                            null
                        )
                    )
                }

                else -> {
                    val walletFragment = WalletFragment.newInstance(paymentModel)
                    loadFragment(
                        walletFragment,
                        TAG_WALLET_FRAGMENT
                    )
                }
            }
        }
    }

    override fun setWebViewProperties(webView: WebView?, bank: Any?) {
        SdkUiInitializer.checkoutProListener?.setWebViewProperties(webView, bank)
    }

    fun getImage(url: String) {
        SdkUiInitializer.apiLayer?.getBitmapImageFormURL(url, this)
    }

    override fun loadRetryPaymentOption() {
        resetOfferViewForRetry()
        SdkUiInitializer.apiLayer?.fetchRetryOptions(
            quickOptionsListener = { quickOptionsModel ->
                globalVaultPayuResponse()
                if (!quickOptionsModel?.quickOptionsList.isNullOrEmpty()) {
                    quickOptionsModel?.quickOptionsList?.let {
                        quickOptionList = it
                    }
                    updateQuickOptionsValue(getQuickOptionsList(quickOptionsModel?.quickOptionsList))
                } else {

                    updateQuickOptionsValue(null)
                }
                onRecommendedOptionFetched(quickOptionsModel?.recommendedOptionsList)
                updateGvView(quickOptionsModel?.quickOptionsList)
                gvLoadGlobalVaultData.value = false
                // Todo : to refactor this call in further release.
                fetchBalanceForClwOrSodexo()
            },
            listener = { it2 ->
                init()
                moreOptionsList = it2
                // To handle retry flow for OTM Transaction only
                retryFlow.value =
                    SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.isPreAuthTxn == true

                if (!Utils.isSiTxn())
                    fetchRecommendedOptions()
                showMoreOptionList(it2)
            }
        )
//        showUnlockSavedOptionsGlobalVault()
    }

    override fun onPaymentVerificationFailed(response: Any?) {
        response?.let { onPaymentFailure(it) }
    }

    override fun onPaymentVerificationSuccess(response: Any?) {
        response?.let { onPaymentSuccess(it) }

    }

    override fun onPaymentVerificationPending(errorResponse: ErrorResponse) {
        SdkUiInitializer.apiLayer?.getRetryCount()?.let {
            if (it > 0) {
                retryError.value = Event(
                    applicationContext.getString(
                        R.string.payu_unknown_status_error_message
                    )
                )
                SdkUiInitializer.apiLayer?.setRetryCount(it - 1)
            } else {
                val response = HashMap<String, Any?>()
                val transactionResponse = JSONObject()
                transactionResponse.put(
                    SdkUiConstants.ERROR_CODE,
                    errorResponse.errorCode.toString()
                )
                transactionResponse.put(SdkUiConstants.ERROR_MESSAGE, errorResponse.errorMessage)
                response[SdkUiConstants.CP_PAYU_RESPONSE] = transactionResponse
                response[SdkUiConstants.CP_MERCHANT_RESPONSE] = null
                onPaymentFailure(response)
            }
        }
    }


    override fun onError(errorResponse: ErrorResponse) {
        if (handleErroMessage) {
            handleErroMessage = false //reset value
            showSnackBar.value =
                SnackBarModel(
                    (errorResponse.errorMessage
                        ?: applicationContext.getString(R.string.payu_please_try_another_payment)),
                    R.drawable.payu_emi
                )
        } else {
            flowComplete.postValue(true)
            AnalyticsUtils.logCPCallbackEventKibana(application.applicationContext, CPCallbackType.Error)
            SdkUiInitializer.checkoutProListener?.onError(errorResponse)
        }
    }

    override fun showProgressDialog(showDialog: Boolean) {
        showProgressDialog.postValue(showDialog)
    }

    override fun showLoaderScreen(showLoader: Boolean) {
        showLoaderScreen.postValue(showLoader)
    }

    fun fetchPaymentOptions(savedInstance: Bundle?) {
        this.savedInstance = savedInstance
        fetchApiCalledTimeStamp.value = System.currentTimeMillis() //tracking this for Analytics
        SdkUiInitializer.apiLayer?.fetchConfig()
        SdkUiInitializer.apiLayer?.fetchPaymentOptions(
            this
        ) { it ->
            if (!it.isNullOrEmpty()) {
                init()
                moreOptionsList = it
                if (!Utils.isSiTxn())
                    fetchRecommendedOptions()
                showMoreOptionList(it)
            } else {
                val errorResponse = ErrorResponse()
                errorResponse.errorCode = SdkUiConstants.CP_ERROR_PAYMENT_MODE_NOT_ALLOWED
                errorResponse.errorMessage = SdkUiConstants.CP_ERROR_PAYMENT_MODE_NOT_ALLOWED_MSG
                AnalyticsUtils.logCPCallbackEventKibana(application.applicationContext, CPCallbackType.Error)
                SdkUiInitializer.checkoutProListener?.onError(errorResponse)
                flowComplete.value = true
            }
        }
    }

    private fun updateQuickOptionsValue(list: ArrayList<PaymentMode>?) {
        quickOptions.value = list
    }

    internal fun fetchBalanceForClwOrSodexo() {
        if (InternalConfig.walletIdentifier.isNullOrEmpty() || InternalConfig.walletIdentifier == "null") {
            SdkUiInitializer.apiLayer?.getBalanceFromSodexo(
            ) { quickOptionsModel ->
                if (!quickOptionsModel?.quickOptionsList.isNullOrEmpty()) {
                    quickOptionsModel?.quickOptionsList?.let {
                        quickOptionList = it
                    }
                    updateQuickOptionsValue(getQuickOptionsList(quickOptionList))
                }
            }
        } else {
            SdkUiInitializer.apiLayer?.payUPaymentParams?.phone?.let {
                SdkUiInitializer.apiLayer?.getBalanceForClosedLoopWallet(
                    InternalConfig.walletIdentifier,
                    it
                ) { quickOptionsModel ->
                    if (!quickOptionsModel?.quickOptionsList.isNullOrEmpty()) {
                        quickOptionsModel?.quickOptionsList?.let {
                            quickOptionList = it
                        }
                        updateQuickOptionsValue(getQuickOptionsList(quickOptionList))
                    }
                    //TODO calling avoid thread issue wil need to check for better solution
                    SdkUiInitializer.apiLayer?.getBalanceFromSodexo(
                    ) { quickOptionsModel ->
                        if (!quickOptionsModel?.quickOptionsList.isNullOrEmpty()) {
                            quickOptionsModel?.quickOptionsList?.let {
                                quickOptionList = it
                            }
                            updateQuickOptionsValue(getQuickOptionsList(quickOptionList))
                        }
                    }
                }

            }
        }

    }


    private fun fetchRecommendedOptions() {
        if (!Utils.isSiTxn() && SdkUiInitializer.apiLayer?.config?.enableREOptions == true) {
            val hashMap = HashMap<String, String>()
            SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.let {
                hashMap.put(
                    SdkUiConstants.CP_AMOUNT,
                    it
                )
            }
            SdkUiInitializer.apiLayer?.payUPaymentParams?.phone?.let {
                hashMap.put(
                    SdkUiConstants.MOBILE_NUMBER,
                    it
                )
            }
            SdkUiInitializer.apiLayer?.fetchGvQuickPay(
                hashMap
            )
            { quickOptionsModel ->
                if (quickOptionsModel?.errorResponse != null) {
                    onRecommendedOptionFetched(quickOptionsModel.recommendedOptionsList)
                } else {
                    onRecommendedOptionFetched(quickOptionsModel?.recommendedOptionsList)
                }

            }
        } else if (InternalConfig.isUserPersonalizedOffersAvailable) {
            // sending empty list will only show login tile, in this scenario to unlock personalised offer
            recommendedOptions.value = arrayListOf()
        }
    }


    fun invalidateOffers(userConsent: Boolean) {
        if (InternalConfig.isOfferEnabled) {

            // cachedUserConsent could be be null
            //      - if user has logged-in in older sdk
            //      - If user has logged-in in new sdk when isUserPersonalizedOffersAvailable is not enabled for the merchant

            // cachedUserConsent could be false
            //      - if user has logged in after entering the current sdk and not given consent
            //      - if user has skipped, when showing initial consent popup

            // cachedUserConsent could be true
            //      - if user has logged in after entering the current sdk and given consent
            //      - if user has confirmed with consent enabled, when showing initial consent popup

            if ((cachedUserConsent == null) && InternalConfig.isUserPersonalizedOffersAvailable) {
                fetchOfferDetails(true)
                cachedUserConsent = userConsent
                return
            }

            if (cachedUserConsent == false && userConsent && InternalConfig.isUserPersonalizedOffersAvailable) {
                fetchOfferDetails(true)
                cachedUserConsent = true
                return
            }

            if (!userConsent) {
                fetchOfferDetails?.let {
                    OfferFilterManager.filterOffersForPaymentType(
                        ignoreRewardsOffer = true,
                        fetchOfferDetails = it
                    )
                    fetchOfferDetails = OfferFilterManager.getCurrentOfferList()
                    showOfferIcon.value = fetchOfferDetails
                }
                cachedUserConsent = false
                return
            }
        }
    }

    fun fetchOfferDetails(resetCache: Boolean? = false) {
        if (Utils.isSiTxn().not())
            fetchOfferDetails(resetCache = resetCache, getLoggedInPhoneNumber())
    }

    private fun fetchOfferDetails(
        resetCache: Boolean? = false,
        loggedInPhoneNumber: String? = null
    ) {
        SdkUiInitializer.apiLayer?.fetchOfferDetails(
            resetCache = resetCache,
            loggedInPhoneNumber = loggedInPhoneNumber
        ) {
            this.fetchOfferDetails = it
            refreshPaymentModesForOffers.value = true
            showOfferIcon()
            showConsentPopup.value = Event(true)
            recommendedOptions.value = recommendedSavedList
            Unit
        }
    }

    fun init() {
        if (InternalConfig.isNfcEnabled) {
            Executors.newSingleThreadExecutor().execute {
                PayUNFC.initNFC(applicationContext)
            }
        }
        cachedUserConsent = Utils.getUserConsent(applicationContext).also {
            InternalConfig.isUserConsentAvailableForPersonalisedOffers = it
        }
        showOfferIcon()
        //load PaymentOptionFragment
        loadFragment(PaymentOptionFragment(), TAG_PAYMENT_OPTION_FRAGMENT)
        headerAmount.value = Utils.getFormattedAmount(
            SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull(),
            applicationContext
        )
        payText.value = applicationContext.getString(
            R.string.payu_pay_merchant,
            SdkUiInitializer.apiLayer?.config?.merchantName?.take(25)
        )
        SdkUiInitializer.apiLayer?.config?.merchantLogo?.let {
            merchantIcon.value = AppCompatResources.getDrawable(applicationContext, it)
                ?.let { it1 -> ImageDetails(DrawableType.PictureDrawable, it1) }
        }
//                applicationContext.getDrawable(SdkUiInitializer.apiLayer?.config?.merchantLogo!!)

        updateSiDetails()
        updateConfigView.value = true
        if (InternalConfig.isRetryTxn) retryError.value = Event(
            applicationContext.getString(
                R.string.payu_payment_failed_error
            )
        )
    }

    fun updateSiDetails() {
        val siDetails = SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams
        val isCusNoteCategoryNull =
            Utils.isCustomeNoteCategoryNull(SdkUiInitializer.apiLayer?.config?.customNoteDetails)
        if (siDetails != null) {
            val billingInterval = siDetails.billingInterval
            val isAdhocOrOnce =
                siDetails.billingCycle == PayUBillingCycle.ONCE || siDetails.billingCycle == PayUBillingCycle.ADHOC
            if (!isCusNoteCategoryNull) {
                //TODO removing for healthcare merchant issue
//                if (siDetails.isFreeTrial) {
////                    siHeaderSummary.value =
////                        applicationContext.getString(R.string.payu_si_header_summary_start_with_free_trial) +
////                                " " + getSIHeaderSummaryEndingString(
////                            siDetails,
////                            billingInterval,
////                            isAdhocOrOnce
////                        )
//                } else {
//                    siHeaderSummary.value = String.format(
//                        applicationContext.getString(R.string.payu_si_header_summary_start_without_free_trial),
//                        headerAmount.value
//                    ) + " " + getSIHeaderSummaryEndingString(
//                        siDetails,
//                        billingInterval,
//                        isAdhocOrOnce
//                    )
//                }
            } else {
                siHeaderSummary.value = Utils.customNote
            }
        } else {
            if (isCusNoteCategoryNull)
                siHeaderSummary.value = Utils.customNote
        }
    }

    private fun getSIHeaderSummaryEndingString(
        siDetails: PayUSIParams,
        billingInterval: Int?,
        isAdhocOrOnce: Boolean
    ): String {

        return applicationContext.getString(
            R.string.payu_si_header_summary_end,
            applicationContext.getString(
                R.string.payu_amount_with_rupee_symbol,
                siDetails.billingAmount
            ), if (!isAdhocOrOnce && billingInterval!! > 1)
                "every $billingInterval " else "",
            if (!isAdhocOrOnce)
                if (billingInterval!! <= 1) "every " + Utils.convertBillingCycle(siDetails.billingCycle) + " "
                else Utils.convertBillingCycle(siDetails.billingCycle) +
                        if (billingInterval > 1) "s " else " "
            else ""
        )
    }

    fun otherOptionSelected(paymentMode: PaymentMode) {
        handleErroMessage = false //reset value
        selectedPaymentMode = paymentMode
        InternalConfig.isPaymentOptionSelected = false
        if (InternalConfig.selectedOfferInfo?.isAutoApply == true) showChangeOfferView(false)
        when (paymentMode.type) {

            PaymentType.CARD -> {
                AnalyticsUtils.logCheckoutL1CTAClickEvent(
                    applicationContext,
                    SdkUiConstants.CP_CARDS,
                    SdkUiConstants.CP_MORE_OPTIONS,
                    paymentMode.isOfferValid
                )
                if ((quickOptions.value != null)
                    && !(quickOptions.value.isNullOrEmpty())
                    && Utils.isNonSodexoCardPresent(quickOptions.value)
                ) {
                    val quickOptionsSavedCard = ArrayList<PaymentMode>()
                    quickOptionsSavedCard.addAll(quickOptions.value!!)
                    val quickOptionsSavedCardFiltered = ArrayList<PaymentMode>()
                    for (savedItems in quickOptionsSavedCard) {
                        if (savedItems.type != PaymentType.CLOSED_LOOP_WALLET && savedItems.type == PaymentType.CARD) {
                            quickOptionsSavedCardFiltered.add(savedItems);
                        }
                    }

                    val payUSavedCardsFragment =
                        PayUSavedCardsFragment.newInstance(
                            quickOptionsSavedCardFiltered,
                            false
                        )
                    loadFragment(payUSavedCardsFragment, null)
                } else {
                    loadFragment(AddCardFragment(), null)
                }
                OfferFilterManager.handleOfferListForSelectedPaymentMode(
                    paymentType = paymentMode.type,
                    listener = this
                )
            }

            PaymentType.NB, PaymentType.WALLET -> {
                val ctaName =
                    if (paymentMode.type == PaymentType.NB) SdkUiConstants.CP_NET_BANKING else SdkUiConstants.CP_WALLET
                AnalyticsUtils.logCheckoutL1CTAClickEvent(
                    applicationContext,
                    ctaName,
                    SdkUiConstants.CP_MORE_OPTIONS,
                    paymentMode.isOfferValid
                )
                val paymentOption =
                    Utils.getPaymentOptionFromModeList(moreOptionsList!!, paymentMode.type!!)
                if (paymentOption != null) {
                    loadBankFragmentForPaymentMode(paymentMode)
                }
            }

            PaymentType.BNPL -> {
                val paymentOption =
                    Utils.getPaymentOptionFromModeList(moreOptionsList!!, paymentMode.type!!)
                if (paymentOption != null) {
                    loadBankFragmentForPaymentMode(paymentMode)
                }
                AnalyticsUtils.logCheckoutL1CTAClickEvent(
                    applicationContext,
                    SdkUiConstants.CP_BNPL,
                    SdkUiConstants.CP_MORE_OPTIONS,
                    paymentMode.isOfferValid
                )
            }

            PaymentType.EMI -> {
                AnalyticsUtils.logCheckoutL1CTAClickEvent(
                    applicationContext,
                    SdkUiConstants.CP_EMI,
                    SdkUiConstants.CP_MORE_OPTIONS,
                    paymentMode.isOfferValid
                )
                handleErroMessage =
                    true //handle error message for this api to show snackbar on screen
                SdkUiInitializer.apiLayer?.emiDetails(this)

            }

            PaymentType.UPI -> {
                AnalyticsUtils.logCheckoutL1CTAClickEvent(
                    applicationContext,
                    SdkUiConstants.CP_UPI,
                    SdkUiConstants.CP_MORE_OPTIONS,
                    paymentMode.isOfferValid
                )


                val list = Utils.getPaymentOptionList(
                    moreOptionsList ?: arrayListOf(),
                    paymentMode.type ?: PaymentType.UPI
                )
                if (list != null && list.size > 0) {
                    when (list.size) {
                        1 -> {
                            //check if only tezomni/upicollect is enabled
                            if (Utils.isPaymentTypeAvailable(list, PaymentType.UPI)) {
                                val upiCollectOption = Utils.getUpiCollectPaymentOption(list)
                                if (upiCollectOption != null && upiCollectOption is UPIOption) {
                                    val paymentFlowState = PaymentFlowState()
                                    val isUpiFlowAvailable = Utils.isPaymentOptionAvailable(
                                        list,
                                        SdkUiConstants.CP_UPI
                                    )
                                    val isTezOmniFlowAvailable = Utils.isPaymentOptionAvailable(
                                        list,
                                        SdkUiConstants.CP_TEZOMNI
                                    )

                                    if (isUpiFlowAvailable && isTezOmniFlowAvailable) {
                                        paymentFlowState.paymentState =
                                            PaymentState.VpaAndMobileEligibility
                                    } else if (isUpiFlowAvailable)
                                        paymentFlowState.paymentState = PaymentState.VPAEligibility
                                    else paymentFlowState.paymentState =
                                        PaymentState.MobileEligibility

                                    val walletFragment = WalletFragment.newInstance(
                                        Utils.getPaymentModel(
                                            upiCollectOption,
                                            paymentFlowState
                                        )
                                    )
                                    loadFragment(walletFragment, TAG_WALLET_FRAGMENT)
                                } else {
                                    showSnackBar.value =
                                        SnackBarModel(
                                            applicationContext.getString(R.string.payu_please_try_another_payment),
                                            R.drawable.payu_upi
                                        )
                                }
                                OfferFilterManager.handleOfferListForSelectedPaymentMode(
                                    paymentType = paymentMode.type,
                                    listener = this
                                )
                            } else if (Utils.isUpiIntentAvailable(list)) {
                                loadBankFragment(list, paymentMode.type!!)
                            }
                        }

                        2 -> {
                            if (Utils.isPaymentTypeAvailable(list, PaymentType.UPI_INTENT)
                                    .not() && Utils.isPaymentOptionAvailable(
                                    list,
                                    SdkUiConstants.CP_TEZOMNI
                                ) && Utils.isPaymentTypeAvailable(list, PaymentType.UPI)
                            ) {
                                //check if only tezomni/upicollect is enabled
                                if (Utils.isPaymentTypeAvailable(list, PaymentType.UPI)) {
                                    val upiCollectOption = Utils.getUpiCollectPaymentOption(list)
                                    if (upiCollectOption != null && upiCollectOption is UPIOption) {
                                        val paymentFlowState = PaymentFlowState()
                                        val isUpiFlowAvailable = Utils.isPaymentOptionAvailable(
                                            list,
                                            SdkUiConstants.CP_UPI
                                        )
                                        val isTezOmniFlowAvailable = Utils.isPaymentOptionAvailable(
                                            list,
                                            SdkUiConstants.CP_TEZOMNI
                                        )

                                        if (isUpiFlowAvailable && isTezOmniFlowAvailable) {
                                            paymentFlowState.paymentState =
                                                PaymentState.VpaAndMobileEligibility
                                        } else if (isUpiFlowAvailable)
                                            paymentFlowState.paymentState =
                                                PaymentState.VPAEligibility
                                        else paymentFlowState.paymentState =
                                            PaymentState.MobileEligibility

                                        val walletFragment = WalletFragment.newInstance(
                                            Utils.getPaymentModel(
                                                upiCollectOption,
                                                paymentFlowState
                                            )
                                        )
                                        loadFragment(walletFragment, TAG_WALLET_FRAGMENT)
                                    } else {
                                        showSnackBar.value =
                                            SnackBarModel(
                                                applicationContext.getString(R.string.payu_please_try_another_payment),
                                                R.drawable.payu_upi
                                            )
                                    }
                                    OfferFilterManager.handleOfferListForSelectedPaymentMode(
                                        paymentType = paymentMode.type,
                                        listener = this
                                    )
                                } else if (Utils.isUpiIntentAvailable(list)) {
                                    loadBankFragment(list, paymentMode.type!!)
                                }
                            } else {
                                loadBankFragment(list, paymentMode.type!!)
                            }
                        }

                        else -> {
                            loadBankFragment(list, paymentMode.type!!)
                        }
                    }
                }
            }

            PaymentType.L1_OPTION -> {
                AnalyticsUtils.logCheckoutL1CTAClickEvent(
                    applicationContext,
                    paymentMode.name,
                    SdkUiConstants.CP_MORE_OPTIONS,
                    paymentMode.isOfferValid
                )
                var list: ArrayList<PaymentOption>? = null
                if (!paymentMode.optionDetail.isNullOrEmpty())
                    list = paymentMode.optionDetail
                if (!list.isNullOrEmpty()) {
                    if (paymentMode.name.equals(SdkUiConstants.SODEXO, ignoreCase = true)) {
                        if ((quickOptions.value != null)
                            && !quickOptions.value.isNullOrEmpty()
                            && !Utils.getSodexoPaymentOptionList(quickOptions.value!!)
                                .isNullOrEmpty()
                        ) {
                            val payUSavedCardsFragment =
                                PayUSavedCardsFragment.newInstance(
                                    Utils.getSodexoPaymentOptionList(quickOptions.value!!),
                                    false,
                                    SdkUiConstants.SODEXO
                                )
                            loadFragment(payUSavedCardsFragment, SdkUiConstants.SODEXO)
                        } else {
                            loadFragment(
                                AddCardFragment.newInstance(SdkUiConstants.SODEXO),
                                SdkUiConstants.SODEXO
                            )
                        }
                        OfferFilterManager.handleOfferListForSelectedPaymentMode(
                            paymentType = paymentMode.type,
                            listener = this
                        )
                    } else {
                        if (!moreOptionsList.isNullOrEmpty() && (moreOptionsList?.size ?: 0) > 1) {
                            val paymentOption = list.first()
                            fetchConvFeeForIntentUpiOption(paymentOption)
                            showBottomSheet(paymentMode.type, paymentOption)
                        } else {
                            SdkUiInitializer.apiLayer?.updatePaymentState(
                                Utils.getPaymentModel(list.get(0), null),
                                ViewUtils.getToolbar(
                                    applicationContext,
                                    paymentMode.optionDetail?.get(0)?.additionalCharge
                                )
                            )
                        }
                    }
                }
            }

            PaymentType.NEFTRTGS -> {
                val list = paymentMode.optionDetail!!
                if (!moreOptionsList.isNullOrEmpty() && moreOptionsList!!.size > 1) { // when paymentmode are more that 1
                    if (list.size > 1) {
                        loadBankFragmentForPaymentMode(paymentMode)
                    } else { // only one bank in neft is enabled
                        showBottomSheet(paymentMode.type, list.get(0))
                    }
                } else {  // when only neft is enabled
                    if (list.size > 1) {
                        loadBankFragmentForPaymentMode(paymentMode)
                    } else {  // only one bank in neft is enabled
                        SdkUiInitializer.apiLayer?.updatePaymentState(
                            Utils.getPaymentModel(list.get(0), null),
                            ViewUtils.getToolbar(
                                applicationContext,
                                paymentMode.optionDetail?.get(0)?.additionalCharge
                            )
                        )
                    }
                }

            }
        }

    }

    private fun loadBankFragmentForPaymentMode(paymentMode: PaymentMode) {
        val list = Utils.getPaymentOptionList(moreOptionsList!!, paymentMode.type!!)
        if (list != null && list.size > 0) {
            loadBankFragment(list, paymentMode.type!!)
        }
    }

    fun loadBankFragment(
        list: ArrayList<PaymentOption>,
        paymentType: PaymentType
    ) {
        OfferFilterManager.handleOfferListForSelectedPaymentMode(list, paymentType, this)
        if (Utils.isEnachPayment(paymentType)) updateHeaderAmount(
            additionalCharge = null,
            gstPercentageValue = null,
            isEnachPayment = true
        )
        if (OfferFilterManager.filterPaymentOption(paymentType, list)
                .isNullOrEmpty()
        ) {
            resetMorePaymentOptionsList()
            OfferFilterManager.updateOfferListOnBackPress(this)
            showErrorWithSnackBar.value = Pair(
                Event(true),
                applicationContext.getString(R.string.payu_offer_not_applicable_on_this)
            )
        } else {
            val bankFragment =
                BankFragment.newInstance(
                    Utils.getSavedOptionsList(
                        quickOptions.value,
                        paymentType
                    ), list, paymentType
                )
            loadFragment(bankFragment, null)
        }
    }


    fun quickOptionSelected(paymentMode: PaymentMode) {
        when (paymentMode.type) {
            PaymentType.CARD -> {
                selectedOption.value = paymentMode.optionDetail?.first()
                AnalyticsUtils.logCheckoutL1CTAClickEvent(
                    applicationContext,
                    SdkUiConstants.CP_SAVED_CARD,
                    SdkUiConstants.CP_QUICK_OPTIONS,
                    paymentMode.isOfferValid
                )
                showBottomSheet(paymentMode.type, paymentMode.optionDetail?.get(0))
            }

            PaymentType.SODEXO -> {
                val paymentOption = paymentMode.optionDetail?.get(0)
                val sodexoCardOption = paymentOption as SodexoCardOption
                when (sodexoCardOption.fetchedStatus) {
                    0 -> {
                        SdkUiInitializer.apiLayer?.getBalanceFromSodexo() { it ->
                            val quickOptionsList = it?.quickOptionsList
                            if (quickOptionsList == null || quickOptionsList.size == 0) {
                                updateQuickOptionsValue(null)
//                                showUnlockSavedOptionsGlobalVault()
                            } else if (isOnlySodexoOrClwPresent(quickOptionsList)) {
//                                showUnlockSavedOptionsGlobalVault()
                                this.quickOptionList = quickOptionsList
                                updateQuickOptionsValue(getQuickOptionsList(quickOptionsList))
                                sodexoList = quickOptionsList
                            } else {
                                val quickOptionsModel = QuickOptionsModel()
                                quickOptionsModel.quickOptionsList = quickOptionsList
                                updateQuickOptionsValue(getQuickOptionsList(quickOptionsModel.quickOptionsList))
                                quickOptionList = quickOptionsModel.quickOptionsList!!
                                val sodexoList = quickOptionsModel.quickOptionsList?.let {
                                    Utils.getSodexoPaymentOptionList(
                                        it
                                    )
                                }
                                if (!sodexoList.isNullOrEmpty())
                                    updatedSodexoOptionList.value = sodexoList
                            }
                        }
                    }

                    1 -> {
                        showBottomSheet(paymentMode.type, paymentOption)
                    }
                }
            }

            PaymentType.CLOSED_LOOP_WALLET -> {
                val clwCardOption = paymentMode.optionDetail?.get(0) as SodexoCardOption
                selectedOption.value = clwCardOption
                when (clwCardOption.fetchedStatus) {
                    0 -> {
                        SdkUiInitializer.apiLayer?.payUPaymentParams?.phone?.let {
                            InternalConfig.walletIdentifier?.let { it1 ->
                                SdkUiInitializer.apiLayer?.getBalanceForClosedLoopWallet(
                                    it1,
                                    it,
                                ) { it ->
                                    val quickOptionsList = it?.quickOptionsList
                                    if (quickOptionsList == null || quickOptionsList.size == 0) {
                                        updateQuickOptionsValue(null)
//                                        showUnlockSavedOptionsGlobalVault()
                                    } else if (isOnlySodexoOrClwPresent(quickOptionsList)) {
//                                        showUnlockSavedOptionsGlobalVault()
                                        this.quickOptionList = quickOptionsList
                                        updateQuickOptionsValue(getQuickOptionsList(quickOptionList))
                                        sodexoList = quickOptionsList
                                    } else {
                                        val quickOptionsModel = QuickOptionsModel()
                                        quickOptionsModel.quickOptionsList = quickOptionsList
                                        quickOptions.value =
                                            getQuickOptionsList(quickOptionsModel.quickOptionsList)
                                        quickOptionList = quickOptionsModel.quickOptionsList!!
                                        val sodexoList = quickOptionsModel.quickOptionsList?.let {
                                            Utils.getSodexoPaymentOptionList(
                                                it
                                            )
                                        }
                                        if (!sodexoList.isNullOrEmpty())
                                            updatedSodexoOptionList.value = sodexoList
                                    }
                                }
                            }
                        }
                    }
                }
            }

            PaymentType.UPI, PaymentType.UPI_INTENT -> {
                val paymentOption = paymentMode.optionDetail?.first()
                if (InternalConfig.isPricingCFCall == true && paymentOption != null && paymentOption.feeCombinations == null) {
                    val upiOptions = moreOptionsList
                        ?.filter { it.type == PaymentType.UPI }
                        .orEmpty()
                    val firstUpiOption = upiOptions.firstOrNull()
                    val matchingOption = firstUpiOption?.optionDetail
                        ?.firstOrNull { it.paymentType == paymentOption.paymentType }
                    if (matchingOption != null) {
                        paymentOption.feeCombinations = matchingOption.feeCombinations
                    }
                }
                selectedOption.value = paymentOption
            }

            else -> {
                val paymentOption = paymentMode.optionDetail?.first()
                selectedOption.value = paymentOption
            }
        }
    }

    fun showBottomSheet(type: PaymentType?, paymentOption: PaymentOption?) {
        if (type == null || paymentOption == null) return else selectedPaymentOption = paymentOption

        Log.d(TAG, "bottom sheet type$type")
        when (type) {

            PaymentType.CARD -> {
                setSavedCardInflated()
                showBottomSheet.value = Pair(R.layout.bottom_sheet_saved_card, null)
            }

            PaymentType.L1_OPTION, PaymentType.NEFTRTGS -> {
                setBankInflated()
                showL1BottomSheet.value =
                    Pair(R.layout.bottom_sheet_bank, SdkUiConstants.PAYU_L1_OPTION)
            }

            PaymentType.SODEXO -> {
                setSavedCardInflated()
                showBottomSheet.value = Pair(R.layout.bottom_sheet_sodexo_card, null)
            }
        }
    }

    fun showSkuBottomSheet(isSkuDetailsInflate: Boolean) {
        if (isSkuDetailsInflate) {
            setSkuInflated()
            showBottomSheet.value = Pair(R.layout.layout_sku_details, null)
        }
    }

    fun logoutFromGlobalVault() {
        InternalConfig.isUserConsentAvailableForPersonalisedOffers = false
        Utils.clearSharedPref(applicationContext, SdkUiConstants.GLOBAL_VAULT_USER_TOKEN_PREF)
        logoutFromGlobalVault.value = true
        showLoginPhoneLayout.value = false
        quickOptionList = sodexoList
        fetchGVData.value = InternalConfig.isQuickPayEnabled
        invalidateOffers(false)
        InternalConfig.appliedCouponOfferKey = null
        removeAppliedOfferAndResetPaymentOptions()
    }

    private fun removeAppliedOfferAndResetPaymentOptions() {
        if (InternalConfig.userSelectedOfferInfo?.userDetail != null || InternalConfig.userSelectedOfferInfo?.offerType == CP_REWARD) {
            InternalConfig.userSelectedOfferInfo = null
            showChangeOfferView(false)
            updateRecommendedAndQuickPaymentListBasedOnOffers()
        }
    }

    fun manageSavedOptions() {
        manage.value = true
    }

    fun showBottomSheetGlobalVaultInfo() {
        showBottomSheet.value = Pair(R.layout.global_vault_info_bottomsheet, null)
    }

    fun showBottomSheetGlobalVaultSettings() {
        AnalyticsUtils.logKibanaInfoEvent(
            context = applicationContext,
            eventKey = SdkUiConstants.CP_LOGIN_SETTINGS_CLICKED,
            screenName = getScreenName()
        )
        logoutGlobalVaultSheetInflated()
        showBottomSheet.value = Pair(R.layout.global_vault_logout_bottomsheet, null)
    }

    fun showBottomSheetGlobalVaultSendOTP() {
        showBottomSheetGlobalVaultVerifyOTP(false)
        cancelGlobalVaultResendOTPTimer()
        sendGlobalVaultOTPInflated()
        showBottomSheet.value = Pair(R.layout.globalvault_bottomsheet, null)
        gvVerifyOTPExceedError.postValue(true)
    }

    private fun showBottomSheetGlobalVaultVerifyOTP(isVerificationScreen: Boolean) {
        gvShowOTPModeBottomSheet.value = isVerificationScreen
    }

    private fun globalVaultPayuResponse() {
        hideBottomSheet.value = true
        gvLoadGlobalVaultData.value = true
    }

    fun sendOTPGlobalVault(verificationPhoneNumber: String, postSendOtpAction:(() -> Unit)? = null) {
        pendingOffer = null
        gvOtpAttemptCounter = 0
        vaultVerificationPhoneNumber = verificationPhoneNumber
        val hashMap = HashMap<String, String>()
        hashMap[SdkUiConstants.MOBILE_NUMBER] = verificationPhoneNumber

        SdkUiInitializer.apiLayer?.fetchQuickPay(
            GlobalVaultAPIsCommand.SEND_OTP,
            hashMap,
            object : OnGVQuickPayListener {
                override fun onSuccess(responseMap: Any) {
                    Log.d(TAG, "GV_SEND_OTP_SUCCESS")
                    uuidGlobalVault = responseMap as String
                    postSendOtpAction?.let {
                        postSendOtpAction.invoke()
                    }
                    if(postSendOtpAction == null) {
                        showBottomSheetGlobalVaultVerifyOTP(true)
                        showGlobalVaultResendOTPTimer()
                    }
                }

                override fun onError(errorResponse: ErrorResponse) {
                    Log.d(TAG, "GV_SEND_OTP_ERROR")
                    if (errorResponse.errorMessage is String) {
                        gvSendOTPError.postValue(errorResponse.errorMessage as String)
                    } else {
                        gvSendOTPError.postValue(applicationContext.getString(R.string.payu_couldnt_fetch_details))
                    }
                }
            })
    }


    fun reSendOTPForCouponVerification() {
        vaultVerificationPhoneNumber?.let { resendOTPGlobalVault(it) }
    }

    fun resendOTPGlobalVault(verificationPhoneNumber: String) {

        if (gvOtpAttemptCounter == 3) {
            gvResendOTPError.postValue(applicationContext.resources.getString(R.string.payu_resend_otp_exceed))
            gvResendOTPTimeInt.value = 0

        } else {
            gvOtpAttemptCounter += 1
            val hashMap = HashMap<String, String>()
            hashMap[SdkUiConstants.MOBILE_NUMBER] = verificationPhoneNumber
            hashMap[SdkUiConstants.UUID] = uuidGlobalVault
            SdkUiInitializer.apiLayer?.fetchQuickPay(GlobalVaultAPIsCommand.RESEND_OTP, hashMap,
                onGVQuickPayListener = object : OnGVQuickPayListener {
                    override fun onSuccess(responseMap: Any) {
                        Log.d(TAG, "GV_RESEND_OTP_SUCCESS")
                        showGlobalVaultResendOTPTimer()
                    }

                    override fun onError(errorResponse: ErrorResponse) {
                        if (errorResponse.errorMessage is String) {
                            when (errorResponse.errorCode) {
                                GlobalVaultResponseCodes.GV_RESEND_OTP_ATTEMPT_EXCEED -> {
                                    gvResendOTPError.postValue(
                                        applicationContext.resources.getString(
                                            R.string.payu_resend_otp_exceed
                                        )
                                    )
                                }

                                else -> {
                                    gvResendOTPError.postValue(
                                        applicationContext.resources.getString(
                                            R.string.payu_couldnt_fetch_details
                                        )
                                    )
                                }
                            }
                        } else {
                            gvResendOTPError.postValue(
                                applicationContext.resources.getString(
                                    R.string.payu_couldnt_fetch_details
                                )
                            )
                        }

                    }
                })
        }
    }


    fun verifyOTPForCouponVerification(userConsent: Boolean? = null,
                                       otp: String,
                                       postVerificationAction: (()-> Unit)? = null) {
        vaultVerificationPhoneNumber?.let { verifyOTPGlobalVault(userConsent, it, otp, postVerificationAction) }
    }

    fun verifyOTPGlobalVault(
        userConsent: Boolean? = null,
        verificationPhoneNumber: String,
        otp: String,
        postVerificationAction: (()-> Unit)? = null
    ) {
        Log.v("verify_attempt_counter ", "verify_attempt_counter $gvVerifyAttemptCounter")
        if (gvVerifyAttemptCounter != 0) {
            gvVerifyAttemptCounter -= 1
            val hashMap = HashMap<String, String>()
            hashMap[SdkUiConstants.MOBILE_NUMBER] = verificationPhoneNumber
            hashMap[SdkUiConstants.OTP] = otp
            hashMap[SdkUiConstants.UUID] = uuidGlobalVault
            showGlobalVaultSubmitProgress()
            SdkUiInitializer.apiLayer?.fetchQuickPay(
                GlobalVaultAPIsCommand.VERIFY_OTP,
                hashMap,
                onGVQuickPayListener = object : OnGVQuickPayListener {
                    override fun onSuccess(responseMap: Any) {
                        Log.d(TAG, "GV_VERIFY_OTP_SUCCESS")
                        postVerificationAction?.invoke()
                        cancelGlobalVaultResendOTPTimer()
                        userTokenGlobalVault = responseMap as String
                        //TODO: uncomment in final code
                        Utils.storeGlobalVaultUserToken(
                            applicationContext,
                            userTokenGlobalVault,
                            verificationPhoneNumber
                        )
                        if (userConsent != null) {
                            Utils.storeUserConsent(
                                applicationContext,
                                userConsent
                            )
                            invalidateOffers(userConsent)
                        }
                        //TODO: remove in final code
                        //  storeTempVerificationInfo()
                        fetchGVData.value = InternalConfig.isQuickPayEnabled
                    }

                    override fun onError(errorResponse: ErrorResponse) {
                        if (errorResponse.errorMessage is String) {
                            cancelGlobalVaultSubmitProgressTimer()
                            AnalyticsUtils.logOtpSubmission(
                                applicationContext,
                                AnalyticsConstant.CP_OTP_SUBMISSION_STATUS,
                                AnalyticsConstant.CP_FAILED
                            )
                            AnalyticsUtils.logOtpSubmissionForKibana(
                                applicationContext,
                                AnalyticsConstant.CP_OTP_SUBMISSION_STATUS,
                                AnalyticsConstant.CP_FAILED
                            )
                            when (errorResponse.errorCode) {
                                GlobalVaultResponseCodes.GV_VERIFY_OTP_ATTEMPT_EXCEED, GlobalVaultResponseCodes.GV_VERIFY_OTP_INCORRECT -> {
                                    if (gvVerifyAttemptCounter == 0) {
                                        Log.d(TAG, "VERIFY_OTP_ATTEMPT_EXCEED")
                                        gvVerifyAttemptCounter = 3
                                        if(postVerificationAction == null) {
                                            gvVerifyOTPExceedError.postValue(false)
                                            gvShowOTPModeBottomSheet.postValue(false)
                                        } else {
                                            showCouponError.value = Event(Pair(true,
                                                applicationContext.getString(
                                                    R.string.otp_verification_limit_exhausted_please_try_again
                                                )))
                                            hideOtpBottomSheet.value = Event(true)
                                        }
                                        cancelGlobalVaultResendOTPTimer()
                                    } else {
                                        Log.d(TAG, "VERIFY_OTP_INCORRECT")
                                        gvVerifyOTPError.postValue(
                                            applicationContext.resources.getString(
                                                R.string.payu_otp_attempts,
                                                "" + (gvVerifyAttemptCounter)
                                            )
                                        )
                                    }
                                }

                                else -> {
                                    Log.d(TAG, "VERIFY_OTP_FAILURE")
                                    gvVerifyOTPError.postValue(
                                        applicationContext.resources.getString(
                                            R.string.payu_couldnt_fetch_details
                                        )
                                    )
                                }
                            }
                        } else {
                            Log.d(TAG, "VERIFY_OTP_FAILURE")
                            gvVerifyOTPError.postValue(
                                applicationContext.resources.getString(
                                    R.string.payu_couldnt_fetch_details
                                )
                            )
                        }
                    }
                })
        }
    }

    fun fetchGlobalVault(
        storedUserToken: Pair<String?, String?>,
        isNeedToApiCall: Boolean = false
    ) {
        globalVaultPayuResponse()
        val hashMap = HashMap<String, String>()
        hashMap[SdkUiConstants.USER_TOKEN] = storedUserToken.first ?: ""
        hashMap[SdkUiConstants.MERCHANT_ID] = uuidGlobalVault
        hashMap[SdkUiConstants.MOBILE_NUMBER] = storedUserToken.second ?: ""
        SdkUiInitializer.apiLayer?.fetchGvQuickPay(
            hashMap, isNeedToApiCall
        )
        { quickOptionsModel ->

            globalVaultPayuResponse()
            if (!quickOptionsModel?.quickOptionsList.isNullOrEmpty()) {
                quickOptionsModel?.quickOptionsList?.let {
                    quickOptionList = it
                }
                updateQuickOptionsValue(getQuickOptionsList(quickOptionsModel?.quickOptionsList))
            } else {
                globalVaultPayuResponse()
                if (!quickOptionsModel?.quickOptionsList.isNullOrEmpty()) {
                    quickOptionsModel?.quickOptionsList?.let {
                        quickOptionList = it
                    }
                    updateQuickOptionsValue(getQuickOptionsList(quickOptionList))
                } else {

                    updateQuickOptionsValue(null)
                }

                updateGvView(quickOptionsModel?.quickOptionsList)
                gvLoadGlobalVaultData.value = false
                // Todo : to refactor this call in further release.
                if (!Utils.isSiTxn()) {
                    onRecommendedOptionFetched(quickOptionsModel?.recommendedOptionsList)
                    fetchBalanceForClwOrSodexo()
                }
                updateQuickOptionsValue(null)
            }
            updateGvView(quickOptionsModel?.quickOptionsList)
            gvLoadGlobalVaultData.value = false
            // Todo : to refactor this call in further release.
            if (!Utils.isSiTxn()) {
                fetchBalanceForClwOrSodexo()
                onRecommendedOptionFetched(quickOptionsModel?.recommendedOptionsList)
            }
        }
    }

    fun showOrderDetails() {
        hideSoftKeyboard.value = true
        setOrderDetailsInflated()
        showBottomSheet.value = Pair(R.layout.order_details_bottom_sheet_layout, null)
    }

    private fun showGlobalVaultSubmitProgress() {

        //The button progress bar wil run with 30 Seconds time line
        val time = 30 * 1000L
        gvSubmitProgressTimer = object : CountDownTimer(time, 300) {
            override fun onTick(millisUntilFinished: Long) {
                val minutes = (millisUntilFinished / 300)
                gvSubmittingTimeInt.value = 100 - minutes.toInt()
                Log.d(TAG, "showSubmitProgress " + (100 - minutes.toInt()))
            }

            override fun onFinish() {
                gvSubmittingTimeInt.value = 100
                Log.d(TAG, "showSubmitProgress 100")
            }
        }.start()

    }

    private fun cancelGlobalVaultSubmitProgressTimer() {
        if (::gvSubmitProgressTimer.isInitialized)
            gvSubmitProgressTimer.cancel()
    }


    private fun showGlobalVaultResendOTPTimer() {
        stopOtpReaderTimerAndEnableManualEntry()
        Log.d(TAG, "showGlobalVaultResendOTPTimer")
        //The Resend button enable timer will run with 30 Seconds timeline
        val time = 30 * 1000L
        resendOTPTimerTransactionCounter = object : CountDownTimer(time, 1000) {
            override fun onTick(millisUntilFinished: Long) {
                val secondsLeft = (millisUntilFinished / 1000)
                gvResendOTPTimeInt.value = secondsLeft.toInt()
            }

            override fun onFinish() {
                Log.d(TAG, "showGlobalVaultResendOTPTimer finish")
                gvResendOTPTimeInt.value = 0
            }
        }.start()

    }

    fun stopOtpReaderTimerAndEnableManualEntry() {
        gvResendOTPTimeInt.value = 0
        cancelGlobalVaultResendOTPTimer()
    }

    private fun cancelGlobalVaultResendOTPTimer() {
        if (::resendOTPTimerTransactionCounter.isInitialized)
            resendOTPTimerTransactionCounter.cancel()
    }

    private fun setBankInflated() {
        inflateBlocks(bankInflate = true)
    }

    private fun setSkuInflated() {
        inflateBlocks(skuDetailsInflate = true)
    }

    fun showExitConfirmationBottomSheet(fragmentStack: Stack<FragmentModel>?) {
        if (false == SdkUiInitializer.apiLayer?.config?.showExitConfirmationOnCheckoutScreen) {
            exitDialogYesClicked(fragmentStack)
            return
        }
        if (!exitDialogInflated) {
            setExitDialogInflated()
            selectedPaymentOption = null
            showBottomSheet.value = Pair(R.layout.payu_cancel_payment_confirmation, null)
        }
    }

    fun setSavedCardInflated() {
        inflateBlocks(savedCardInflate = true)
    }

    fun setOrderDetailsInflated() {
        inflateBlocks(orderDetailsInflate = true)
    }

    fun setOfferDetailsInflated() {
        inflateBlocks(offerDetailsInflate = true)
    }

    fun setExitDialogInflated() {
        inflateBlocks(exitDialogInflate = true)
    }

    private fun sendGlobalVaultOTPInflated() {
        inflateBlocks(sendOtpInflate = true)
    }

    private fun logoutGlobalVaultSheetInflated() {
        inflateBlocks(logoutSheetInflate = true)
    }

    private fun inflateBlocks(
        bankInflate: Boolean = false, savedCardInflate: Boolean = false,
        exitDialogInflate: Boolean = false, orderDetailsInflate: Boolean = false,
        offerDetailsInflate: Boolean = false, skuDetailsInflate: Boolean = false,
        sendOtpInflate: Boolean = false, logoutSheetInflate: Boolean = false, verifyOtpSheetInflated: Boolean = false
    ) {
        bankInflated = bankInflate
        savedCardInflated = savedCardInflate
        exitDialogInflated = exitDialogInflate
        orderDetailsInflated = orderDetailsInflate
        offerDetailsInflated = offerDetailsInflate
        sendOtpInflated = sendOtpInflate
        logoutSheetInflated = logoutSheetInflate
        skuDetailsInflated = skuDetailsInflate
        verifyOtpInflated = verifyOtpSheetInflated
    }

    fun continueShoppingClicked(paymentStatus: PaymentStatus) {
        flowComplete.value = true

        if (paymentResponse != null) {

            when (paymentStatus) {
                PaymentStatus.SUCCESS -> {
//                    AnalyticsUtils.logTxnCompleteEvent(applicationContext, SdkUiConstants.CP_EVENT_PAYMENT_SUCCESSFUL, paymentResponse)
                    AnalyticsUtils.logCPCallbackEventKibana(applicationContext, CPCallbackType.Success)
                    SdkUiInitializer.checkoutProListener?.onPaymentSuccess(
                        paymentResponse!!
                    )
                }

                PaymentStatus.FAILED -> {
                    AnalyticsUtils.logCPCallbackEventKibana(applicationContext, CPCallbackType.Failure)
//                    AnalyticsUtils.logTxnCompleteEvent(applicationContext, SdkUiConstants.CP_EVENT_PAYMENT_FAILED, paymentResponse)
                    SdkUiInitializer.checkoutProListener?.onPaymentFailure(
                        paymentResponse!!
                    )
                }
            }
        } else {
//            AnalyticsUtils.logTxnCompleteEvent(applicationContext, SdkUiConstants.CP_EVENT_PAYMENT_CANCELED)
            AnalyticsUtils.logCPCallbackEventKibana(applicationContext, CPCallbackType.Cancel)
            SdkUiInitializer.checkoutProListener?.onPaymentCancel(true)
        }
    }

    fun handleBackpress(
        fragmentBackStackEntryCount: Int,
        topFragmentName: String?,
        fragmentStack: Stack<FragmentModel>
    ) {
        when {
            fragmentBackStackEntryCount - 1 == 0 ||
                    (moreOptionsList?.size == 1
                            && fragmentBackStackEntryCount - 1 == 1) -> showExitConfirmationBottomSheet(
                fragmentStack
            )

            else -> {
                if (topFragmentName.equals(TAG_PAYMENT_OPTION_FRAGMENT, ignoreCase = true)) {
                    showExitConfirmationBottomSheet(fragmentStack)
                    resetOfferAmount()
                } else if (fragmentStack.isNotEmpty() && fragmentStack.peek()?.handleBackPress != null) {
                    fragmentStack.peek()?.handleBackPress?.onBackPressed()
                } else if (!topFragmentName.equals(
                        TAG_RESULT_FRAGMENT,
                        ignoreCase = true
                    ) && !topFragmentName.equals(TAG_DYNAMIC_FRAGMENT, ignoreCase = true)
                ) {
                    if (fragmentBackStackEntryCount == 2) {  // L2 ----> L1
                        selectedPaymentMode = null
                    }
                    resetOfferState()
                    updateRecommendedAndQuickPaymentListBasedOnOffers()
                    resetMorePaymentOptionsList()
                    OfferFilterManager.updateOfferListOnBackPress(this)
                    NetworkManager.unRegisterReceiver(applicationContext)
                    popBackStack.value = true
                }
            }
        }
    }

    private fun resetOfferState() {
        ViewUtils.dismissSnackBar()
        InternalConfig.userSelectedOfferInfo = null
        InternalConfig.selectedOfferInfo = null
        showOfferAppliedDialog.value = Event(false)
        showOfferError.value = Pair(Event(false), null)
        resetOfferAmount()
        resetHeaderAmount(
            isEnachPayment = isEnachPayment(),
            isOfferValid = (InternalConfig.selectedOfferInfo?.totalInstantDiscount != null)
        )
        InternalConfig.isPaymentOptionSelected = false
        hideToolTip.value = true
        hideSoftKeyboard.value = true
        selectedPaymentOption = null
    }

    fun makeStoreCardPayment(savedCardOption: SavedCardOption) {
        //TODO: Uncomment and change when MCP is implemented
        //Check if card is not domestic
//        savedCardOption.cardBinInfo?.let {
//            if (!it.isDomestic) {
//                isPaymentViaMCP = true
//                hideSoftKeyboard.value = true
//                hideBottomSheet.value = true
//                showProgressDialog.value = true
//                SdkUiInitializer.apiLayer?.callLookupApi(
//                    savedCardOption,
//                    object : OnLookupApiListener {
//                        override fun onLookupApiCalled() {
//                            isPaymentViaMCP = false
//                            makePayment(savedCardOption)
//                        }
//
//                        override fun onError(errorResponse: ErrorResponse) {
////                        AnalyticsUtils.logErrorOccurredEvent(applicationContext, errorResponse.errorMessage)
//                            isPaymentViaMCP = false
//                        }
//
//                        override fun showProgressDialog(showDialog: Boolean) {
//                            showProgressDialog.value = showDialog
//                        }
//                    })
//            } else {
        makePayment(savedCardOption)
//            }
//        }
    }

    fun makePayment(paymentOption: PaymentOption) {
        //Todo: Need to make proper fix in next version @Puspendra
        if (paymentOption is SavedCardOption)
            savedCardInflated = false
        makePaymentApiCall(paymentOption)
    }


    fun bottomSheetViewInflated() {
        when {
            savedCardInflated -> {
                if (selectedPaymentOption is SodexoCardOption) {
                    val sodexoCardOption = selectedPaymentOption as? SodexoCardOption
                    updateSodexoCardBottomSheet.value = sodexoCardOption
                    updateHeaderAmount(
                        additionalCharge = sodexoCardOption?.cardBinInfo?.additionalCharge,
                        gstPercentageValue = sodexoCardOption?.cardBinInfo?.gstPercentageValue
                    )
                } else {
                    val savedCardOption = selectedPaymentOption as? SavedCardOption
                    updateSavedCardBottomSheet.value = savedCardOption
                    updateHeaderAmount(
                        additionalCharge = savedCardOption?.cardBinInfo?.additionalCharge,
                        gstPercentageValue = savedCardOption?.cardBinInfo?.gstPercentageValue
                    )
                }
                Handler().postDelayed({
                    selectedPaymentOption?.let {
                        if (selectedPaymentOption?.paymentType != PaymentType.CARD) validateOffer()
                    }

                }, 300)
            }

            exitDialogInflated -> updateExitDialogBottomSheet.value = true
            bankInflated -> {
                updateBankBottomSheet.value = selectedPaymentOption
                InternalConfig.isPaymentOptionSelected = true
                var headeramout =
                    SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull() ?: 0.0
                updateHeaderAmount(
                    InternalConfig.selectedOfferInfo?.totalDiscountedAmount ?: headeramout,
                    additionalCharge = selectedPaymentOption?.additionalCharge ?: 0.0,
                    gstPercentageValue = selectedPaymentOption?.gstPercentageValue,
                    isOfferValid = Utils.isOfferSelected()
                )
            }

            orderDetailsInflated -> updateOrderDetailsBottomSheet.value = true
            offerDetailsInflated -> updateOfferDetailsBottomSheet.value = true
            skuDetailsInflated -> updateSkuDetailsBottomSheet.value = true

            sendOtpInflated -> {
                updateOTPBottomSheet.value = true
            }

            logoutSheetInflated -> {
                logoutBottomSheet.value = true
            }

            verifyOtpInflated -> {
                val maskedNumber = vaultVerificationPhoneNumber?.let {
                    Utils.getMaskedMobileNumber(
                        applicationContext,
                        it
                    )
                }
                showVerifyOtpBottomSheet.value = Event(
                    PayUVerifyOtpData(
                        mobileNumber = vaultVerificationPhoneNumber,
                        maskedMobileNumber = maskedNumber,
                        verifyOtpDesc = applicationContext.getString(
                            R.string.payu_enter_otp_mask_number,
                            maskedNumber
                        ),
                        postVerifyAction = {
                            pendingOffer?.let {
                                InternalConfig.userSelectedOfferInfo = it
                                updateSelectedOfferForUserSelected()
                                showChangeOfferView(true, false)
                                updateRecommendedAndQuickPaymentListBasedOnOffers()
                                hideBottomSheet()
                            }
                        }
                    )
                )
            }
        }
    }

    fun resetUIOnCancel() {
        OfferFilterManager.resetOfferFilterData()
    }

    fun exitDialogYesClicked(fragmentStack: Stack<FragmentModel>?) {
        ViewUtils.dismissSnackBar()
        fragmentStack?.let {
            if (it.isNotEmpty()) {
                it.pop()
            }
        }
        AnalyticsUtils.logCPCallbackEventKibana(applicationContext, CPCallbackType.Cancel)
        SdkUiInitializer.checkoutProListener?.onPaymentCancel(false)
        flowComplete.value = true
        resetUIOnCancel()
        AnalyticsUtils.logBackButtonClickEvent(
            applicationContext,
            SdkUiConstants.CP_CHECKOUT_BACK_BUTTON,
            SdkUiConstants.CP_L1_CHECKOUT_SCREEN,
            true
        )
    }

    fun exitDialogNoClicked() {
        hideBottomSheet.value = true
        AnalyticsUtils.logBackButtonClickEvent(
            applicationContext,
            SdkUiConstants.CP_CHECKOUT_BACK_BUTTON,
            SdkUiConstants.CP_L1_CHECKOUT_SCREEN,
            false
        )
    }

    fun updateBottomSheetCvvFilter(savedCardOption: SavedCardOption?) {
        if (!Utils.isCvvLessCard(savedCardOption?.cardBinInfo?.cardScheme)) {
            val cvvLength: Int = Utils.getCvvInputLength(savedCardOption?.cardBinInfo?.cardScheme)
            cvvLengthFilter.value = cvvLength
        } else {
            enablePayButtonBottomSheet.value = true
        }
    }

    fun bottomsheetCvvTextChanged(cvv: String, cvvLength: Int) {
        hideToolTip.value = true
        when {
            cvv.length == cvvLength -> enablePayButtonBottomSheet.value = true
            else -> enablePayButtonBottomSheet.value = false
        }
    }

    fun resetBottomSheetFlags() {
        //reset the amount only if saved card bottom sheet is closed and is not MCP flow
        if ((savedCardInflated || bankInflated) && !isPaymentViaMCP) resetHeaderAmount(
            isOfferValid = (InternalConfig.selectedOfferInfo?.totalCashbackDiscount != null)
        )
        savedCardInflated = false
        exitDialogInflated = false
        bankInflated = false
        orderDetailsInflated = false
        offerDetailsInflated = false
        verifyOtpInflated = false
    }

    fun savedCardCvvToolTipClicked(cardScheme: CardScheme?) {
        showTransparentView.value = true
        savedCardCvvToolTip.value = when (cardScheme) {
            CardScheme.AMEX -> ToolTipModel(
                applicationContext.getString(R.string.payu_what_is_csc),
                applicationContext.getString(R.string.payu_the_card_security_code),
                R.drawable.payu_tt_amex_cvv
            )

            else -> ToolTipModel(
                applicationContext.getString(R.string.payu_what_is_cvv),
                applicationContext.getString(R.string.payu_the_card_verification_value),
                R.drawable.payu_tt_cvv
            )
        }
    }

    fun transparentViewClicked() {
        showTransparentView.value = false
        hideToolTip.value = true
    }


    override fun emiDetailsReceived(emiList: ArrayList<PaymentOption>) {
        handleErroMessage = false //reset value for handling error message

        if (emiList.isNotEmpty()) {
            /**
             * If EMI list has only 1 category like CC or DC or Cardless. Then directly show the item in that category.
             * */
            if (emiList.size == 1)
                launchBankFragmentWithList(emiList[0].optionList, PaymentType.EMI)
            else {
                for (emiOption in emiList) {
                    for (emi in emiOption.optionList!!) {
                        for (tenure in emi.optionList!!) {
                            val bankCode =
                                (tenure.otherParams as HashMap<String, String>)[SdkUiConstants.CP_BANK_CODE]
                            if (InternalConfig.noCostEmi?.contains(bankCode) == true) {
                                (emiOption as EMIOption).isNoCostEmi = true
                                (emi as EMIOption).isNoCostEmi = true
                                (tenure as EMIOption).isNoCostEmi = true
                            }
                            if (InternalConfig.offerBankListEmi?.contains(bankCode) == true) {
                                (emiOption as EMIOption).isOfferAvailable = true
                                (emi as EMIOption).isOfferAvailable = true
                            }
                        }
                    }

                }
//                val filterEmiList = OfferFilterManager.filterEMIOption(emiList)
                launchBankFragmentWithList(emiList, PaymentType.EMI)
            }
        }
    }

    fun launchBankFragmentWithList(
        list: ArrayList<PaymentOption>?,
        paymentType: PaymentType?,
    ) {
        if (list != null && list.size > 0 && paymentType != null) {
            loadBankFragment(list, paymentType)
        }
    }


    fun showOfferDetails() {
        hideSoftKeyboard.value = true
        setOfferDetailsInflated()
        showOfferBottomSheet.value = Pair(R.layout.layout_offer_details, true)
    }

    fun initOffersUI(savedCardOption: SavedCardOption) {
        if (Utils.isOfferSelected() && savedCardOption.cardBinInfo?.issuingBank?.let {
                Utils.isOfferAvailableForCards(
                    it,
                    savedCardOption.cardBinInfo?.cardScheme.toString(),
                    savedCardOption.cardBinInfo?.cardType
                )
            } == true)
            showSavedCardOfferUI.value = true
    }

    fun updateHeaderAmount(
        amount: Double? = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull(),
        additionalCharge: Double? = null,
        gstFlatValue: Double? = null,
        gstPercentageValue: Double? = null,
        isEnachPayment: Boolean = false,
        isOfferValid: Boolean = false
    ) {
        if (isEnachPayment) {
            headerAmount.value = Utils.getFormattedAmount(0.0, applicationContext)
            return
        }

        if (!isOfferValid && (additionalCharge == null || additionalCharge.equals(0.0))) resetHeaderAmount()
        else {
            if (additionalCharge != null && !additionalCharge.equals(0.0)) {
                additonalCharges = additionalCharge.toString()
                gstPercent = gstPercentageValue.toString()
                convenienceFeeCharges =
                    getConvenienceFeeCharges(
                        gstValue = gstFlatValue,
                        gstPercentage = gstPercentageValue,
                        additionalCharge
                    ).toString()

                gstAmount = additionalCharge.minus(
                    convenienceFeeCharges.toDouble()
                ).toString()
                val updatedAmount = amount?.plus(additonalCharges.toDouble())
                headerAmount.value = Utils.getFormattedAmount(updatedAmount, applicationContext)
            } else {
                resetHeaderAmount(isOfferValid = isOfferValid)
            }
        }
    }


    fun resetHeaderAmount(isEnachPayment: Boolean = false, isOfferValid: Boolean = false) {
        additonalCharges = "0.0" //reset additional charges
        convenienceFeeCharges = "0.0"
        gstAmount = "0.0"
        if (isEnachPayment)
            headerAmount.value = Utils.getFormattedAmount(0.0, applicationContext)
        else if (isOfferValid) {
            headerAmount.value = Utils.getFormattedAmount(
                SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                    ?.minus(InternalConfig.selectedOfferInfo?.totalInstantDiscount ?: 0.0),
                applicationContext
            )

        } else
            headerAmount.value = Utils.getFormattedAmount(
                SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull(),
                applicationContext
            )
    }

    internal fun resetOfferAmount() {
        InternalConfig.emiOfferInfo = null
        InternalConfig.interestCharged = null
    }

    private fun resetOfferViewForRetry() {
        OfferFilterManager.resetOfferPaymentTypeFlowStack()
        showChangeOfferView(false)
    }

    internal fun fetchBinBaseDetails(
        cardNumber: String,
        cardToken: String?,
        category: String?,
        paymentCode: String?
    ) {
        Handler(Looper.getMainLooper()).postDelayed({
            showAndroidLoader.value = Event(true) // Hide progress bar after the delay
        }, 300)

        SdkUiInitializer.apiLayer?.fetchBinBaseDetails(
            cardNumber = cardNumber,
            cardToken = cardToken,
            category = category,
            paymentCode = paymentCode
        ) { binBaseDetails ->
            showAndroidLoader.value = Event(false)
            onCardBinInfo(binBaseDetails?.cardBinInfo)
            selectedPaymentOption?.feeCombinations = binBaseDetails?.feeCombinations
            onValidateOfferResponse(binBaseDetails?.selectedOfferInfo)
        }
    }

    override fun onCardBinInfo(cardBinInfo: CardBinInfo?) {
        val isSiMode = SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams != null
        if (cardBinInfo == null)
            isSISupportedForSavedCard.value = isSiMode.not()
        else
            isSISupportedForSavedCard.value = (cardBinInfo.isSiSupported || isSiMode.not())
        cardBinInfo?.binNumber = selectedPaymentOption?.cardBinInfo?.binNumber
        selectedPaymentOption?.cardBinInfo = cardBinInfo
        selectedPaymentOption?.bankCode = cardBinInfo?.bankCode
        updateHeaderAmount(
            gstFlatValue = cardBinInfo?.gstFlatValue,
            additionalCharge = cardBinInfo?.additionalCharge
        )
    }

    fun savedCardCVVFocused() {
        savedCardCvvFieldColor.value = R.drawable.payu_rounded_corner_image_for_edittext_highlighted
    }

    internal fun getConvenienceFeeCharges(
        gstValue: Double?,
        gstPercentage: Double?,
        additionalCharge: Double?
    ): Double? {
        return if (gstValue != null && !gstValue.equals(0.0)) additionalCharge?.minus(gstValue)
        else if (gstPercentage != null)
            (additionalCharge ?: 0.0) / (1 + (gstPercentage / 100))
        else additionalCharge
    }

    override fun showChangeOfferView(
        shouldShowChangeOffer: Boolean,
        isAutoApply: Boolean,
        handleBackstack: Boolean
    ) {
        if (shouldShowChangeOffer) {
            showOfferIcon.value = null
        } else {
            showOfferIcon.value = OfferFilterManager.getCurrentOfferList()
            InternalConfig.selectedOfferInfo = null
            InternalConfig.userSelectedOfferInfo = null
            InternalConfig.emiOfferInfo = null
        }
        isOfferAvailable.value = Event(shouldShowChangeOffer)
        showChangeOfferView.value = shouldShowChangeOffer
        updateOffer.value = !isAutoApply
        validateOffer.value = !isAutoApply && InternalConfig.userSelectedOfferInfo != null
    }

    private fun getPayUIDetails(response: Any) {
        if (InternalConfig.isAdsEnabled && response is HashMap<*, *>) {
            val payuResponse = JSONObject((response as HashMap<String, String>)[PAYU_RESPONSE])
            if (payuResponse.has(PAYU_PAYMENT_ID) && payuResponse.getString(PAYU_PAYMENT_ID) != null)
                payUId.value = payuResponse.getString(PAYU_PAYMENT_ID)
        }
    }

    private fun getPayUEncodedId(response: Any?): String? {
        try {
            if (response is HashMap<*, *>) {
                val responseValue = (response as HashMap<String, String>)[PAYU_RESPONSE];
                if (responseValue != null && responseValue != "null") {
                    val payuResponse = JSONObject(responseValue)
                    if (payuResponse.has(PAYU_PAYMENT_ID)) {
                        return payuResponse.getString(PAYU_PAYMENT_ID)
                    } else if (payuResponse.has(PAYU_RESULT) && payuResponse.getJSONObject(
                            PAYU_RESULT
                        ).has(PAYU_UID)
                    ) {
                        return payuResponse.getJSONObject(PAYU_RESULT).getString(PAYU_UID)
                    }

                }
            }
        } catch (e: JSONException) {
            Log.d(TAG, "getPayUEncodedId JSONException ${e.message}")

        } catch (e: Exception) {
            Log.d(TAG, "getPayUEncodedId Exception ${e.message}")

        }
        return null
    }

    internal fun setScreenName(screenName: String) {
        checkoutScreenName.value = screenName
    }

    internal fun getScreenName(): String? {
        return checkoutScreenName.value
    }

    override fun onImageGenerated(result: ImageDetails) {
        merchantIcon.postValue(result)
    }


    internal fun initiateSMSReader(activity: ComponentActivity) {

        if (OtpParser.getInstance(activity) != null) {
            OtpParser.getInstance(activity).lifeCycleOnDestroy()
        }
        otpParser = OtpParser.getInstance(activity)
    }

    internal fun prepareSmsListener() {
        stopSmsListener()
        otpParser?.startListening(object : OtpCallback {
            override fun onOtpReceived(otp: String) {
                Log.d(TAG, "SmsListener onOtpReceived$otp")
                readOtpGV.value = Editable.Factory.getInstance().newEditable(otp)
            }

            override fun onUserDenied() {
                Log.d(TAG, "SmsListener onUserDenied")
                stopOtpReaderTimerAndEnableManualEntry()
            }
        })
    }

    internal fun stopSmsListener() {
        otpParser?.stopListening()
    }

    internal fun sendResultToOtpParser(requestCode: Int, resultCode: Int, data: Intent?) {
        otpParser?.onActivityResult(requestCode, resultCode, data)
    }

    internal fun showUnlockSavedOptionsGlobalVault() {
        if (Utils.isSiTxn()) {
            showUnlockOption.value = false
        } else {
            gvPayuNoSavedOptions.value = false
        }
        fetchGlobalVault(Utils.getGlobalVaultStoredUserToken(applicationContext))
    }

    private fun isOnlySodexoOrClwPresent(list: ArrayList<PaymentMode>?): Boolean {
        val storedCardList = ArrayList<PaymentMode>()
        if (list != null) {
            for (item in list) {
                if (item.type != PaymentType.SODEXO && item.type != PaymentType.CLOSED_LOOP_WALLET) {
                    storedCardList.add(item)
                }
            }
        }
        return storedCardList.isEmpty() && !list.isNullOrEmpty()
    }

    override fun onFetchGaidResponse(gaid: String) {
        Utils.storeGaidToken(applicationContext, gaid)
        callDeviceInfoApi(gaid)
    }

    private fun initiateDeviceInfoApi() {
        if (InternalConfig.isDeviceIdApiEnabled) {
            if (!Utils.getGaidToken(applicationContext).isNullOrEmpty()) {
                callDeviceInfoApi(Utils.getGaidToken(applicationContext).toString())
            } else {
                SdkUiInitializer.apiLayer?.fetchGaid(this)
            }
        }
    }

    private fun callDeviceInfoApi(gaid: String) {
        val payUEncodedId = getPayUEncodedId(paymentResponse);
        if (!payUEncodedId.isNullOrEmpty()) {
            SdkUiInitializer.apiLayer?.callDeviceInfoApi(payUEncodedId, gaid)
        }
    }

    private fun verifyPayment() {
        SdkUiInitializer.apiLayer?.verifyPayment(this)
    }

    internal fun reloadMoreOptions() {
        otherOptions.value = moreOptionsList
    }

    internal fun updateSelectedPaymentOption(paymentOption: PaymentOption?) {
        selectedOption.value = paymentOption
        selectedPaymentOption = paymentOption
    }

    fun onChangeOfPhoneNumber(text: CharSequence?) {
        verifyButtonVisibility.value =
            text != null && text.length == 10 && Utils.isValidPhoneNumber(text.toString())
    }

    internal fun validateOffer(category: String?, bankCode: String?) {

        if (shouldCallValidateOfferApi().not())
            return

        if (category != null) {
            showAndroidLoader.value = Event(true)
            SdkUiInitializer.apiLayer?.validateOfferDetails(
                category,
                null,
                bankCode,
                null,
                loggedInPhoneNumber = getLoggedInPhoneNumber(),
                this
            )
        }
    }

    internal fun validateOffer() {
        if (shouldCallValidateOfferApi().not())
            return
        if (selectedPaymentOption != null) {
            val bankCode = selectedPaymentOption?.bankName
            val category = selectedPaymentOption?.paymentType?.name
            if (category != null) {
                showAndroidLoader.value = Event(true)
                SdkUiInitializer.apiLayer?.validateOfferDetails(
                    category,
                    null,
                    bankCode,
                    (selectedPaymentOption as? SavedCardOption)?.cardToken,
                    loggedInPhoneNumber = getLoggedInPhoneNumber(),
                    this
                )

            }
        }
    }

    internal fun showOfferNotAvailableSnackBar() {
        InternalConfig.selectedOfferInfo?.let {
            showOfferAppliedDialog.value = Event(false)
            showOfferError.value = Pair(Event(true), null)
            showOfferApplied.value = Event(false)
        }
    }

    internal fun hideBottomSheet() {
        hideBottomSheet.value = true
    }

    internal fun updateRecommendedAndQuickPaymentListBasedOnOffers() {
        val quickOptionFilteredList = OfferFilterManager.filterSavedPaymentMode(quickOptionList)
        if (quickOptionFilteredList.isNotEmpty()) {
            isQuickOptionEmpty = false
            updateQuickOptionsValue(quickOptionFilteredList)
        } else {
            isQuickOptionEmpty = true
            updateL1ForEmptyList(isMoreOptionsListEmpty = isMoreOptionEmpty)
        }
        recommendedOptions.value =
            if (InternalConfig.selectedOfferInfo != null) OfferFilterManager.filterRecommendedMode(
                recommendedSavedList
            ) else recommendedSavedList
    }

    fun handleEMITenureOnOfferSelection(list: ArrayList<PaymentOption>?): ArrayList<PaymentOption>? {
        val filteredList = OfferFilterManager.handleEMITenureOnOfferSelection(list)
        return if (filteredList.isNullOrEmpty()) {
            showChangeOfferView(false)
            list
        } else {
            filteredList
        }
    }

    fun handlePayUsingEMI(isOn: Boolean, list: ArrayList<PaymentOption>?) {
        OfferFilterManager.handlePayUsingEMI(isOn, list, this)
        showChangeOfferView(false)
        InternalConfig.userSelectedOfferInfo = null
    }

    override fun offerDetails(fetchOfferDetails: FetchOfferDetails?) {
        showOfferIcon.value = fetchOfferDetails
    }

    private fun showOfferIcon() {
        if (InternalConfig.isOfferEnabled || InternalConfig.couponsAvailable) {
            showOfferIcon.value = fetchOfferDetails
            fetchOfferDetails?.let {
                OfferFilterManager.resetOfferFilterData()
                OfferFilterManager.filterOffersForPaymentType(
                    ignoreRewardsOffer = Utils.getUserConsent(
                        applicationContext
                    ) != true, fetchOfferDetails = it
                )
            }
        }
    }

    internal fun updateSelectedOfferForUserSelected() {
        InternalConfig.userSelectedOfferInfo?.let { offerInfo ->
            val offerList = ArrayList<OfferInfo>()
            offerList.add(offerInfo)
            val offerInfoMap = HashMap<String, OfferInfo>()
            offerInfoMap[InternalConfig.userSelectedOfferInfo?.offerKey.toString()] =
                offerInfo
            var cashBack: Double? = null
            var discount: Double? = null
            if (offerInfo.offerType == SdkUiConstants.CP_CASHBACK || offerInfo.offerType == SdkUiConstants.CP_REWARD) cashBack =
                offerInfo.discountDetailsOfOffers?.discount
            else discount =
                offerInfo.discountDetailsOfOffers?.discount
            val selectedOfferInfo = SelectedOfferInfo(
                SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull(),
                cashBack,
                discount,
                offerInfo.discountDetailsOfOffers?.discountedAmount,
                offerInfo.isSkuOffer,
                false,
                offerInfo.isNoCostEmi,
                false,
                isValid = true,
                offerInfoMap,
                failureReason = null
            )
            InternalConfig.selectedOfferInfo = selectedOfferInfo
        }

    }

    internal fun updateL1ForEmptyList(isMoreOptionsListEmpty: Boolean) {
        this.isMoreOptionEmpty = isMoreOptionsListEmpty
        if (isMoreOptionEmpty && isQuickOptionEmpty) {
            showOfferError()
            showChangeOfferView(shouldShowChangeOffer = false)
        } else if (isMoreOptionEmpty) otherOptions.value = null
        else updateQuickOptionsValue(null)
    }

    private fun getQuickOptionsList(quickOptionList: ArrayList<PaymentMode>?): ArrayList<PaymentMode>? {
        return if (InternalConfig.userSelectedOfferInfo != null) OfferFilterManager.filterSavedPaymentMode(
            quickOptionList
        ) else quickOptionList
    }

    private fun updateGvView(quickOptionList: ArrayList<PaymentMode>?) {
        if (!Utils.getGlobalVaultStoredUserToken(
                applicationContext
            ).first.isNullOrEmpty()
        ) {
            gvPayuNoSavedOptions.value =
                quickOptionList.isNullOrEmpty()
        }
        showLoginPhoneLayout.value = !Utils.getGlobalVaultStoredUserToken(
            applicationContext
        ).first.isNullOrEmpty()
        updateBankItem.value = selectedPaymentOption?.apply {
            error = ""
        }
    }

    internal fun popBackStack() {
        popBackStack.value = true
        OfferFilterManager.getPaymentStack().pop()
    }

    fun isEnachPayment(): Boolean {
        return Utils.isEnachPayment(selectedPaymentMode?.type)
    }


    internal fun getTilesList(): ArrayList<TilesData> {
        if (tilesList.isEmpty()) {
            InternalConfig.userAccountInfoList?.forEach {
                val tilesData = TilesData(
                    it.bankName,
                    it.accountDetails?.beneficiaryAccountNumber?.let { it1 ->
                        Utils.getMaskedAccountNoForTpv(
                            R.string.payu_account_string, applicationContext,
                            it1
                        )
                    }, it.imageUrl
                )
                tilesList.add(tilesData)
            }
        }
        return tilesList;
    }

    fun getLoginTileTexts(): Pair<String, String?>? {
        return when {
            InternalConfig.isQuickPayEnabled && InternalConfig.isOfferEnabled && InternalConfig.isUserPersonalizedOffersAvailable -> {
                Pair(
                    applicationContext.getString(R.string.payu_unlock_your_saved_options_and_more_offers),
                    null
                )
            }

            !InternalConfig.isQuickPayEnabled && InternalConfig.isOfferEnabled && InternalConfig.isUserPersonalizedOffersAvailable -> {
                Pair(applicationContext.getString(R.string.payu_unlock_more_offers_for_you), null)
            }

            InternalConfig.isQuickPayEnabled -> {
                Pair(
                    applicationContext.getString(R.string.payu_unlock_saved_options),
                    applicationContext.getString(R.string.payu_view_your_saved)
                )
            }

            else -> null
        }
    }

    fun getLoginBottomSheetTileAndDescriptionText(): Pair<String, String>? {
        return when {
            InternalConfig.isQuickPayEnabled && InternalConfig.isOfferEnabled && InternalConfig.isUserPersonalizedOffersAvailable -> {
                Pair(
                    applicationContext.getString(R.string.payu_access_saved_options_and_offers),
                    applicationContext.getString(
                        R.string.payu_verify_phone_number_to_access_your_saved_payment_options_and_more_offers
                    )
                )
            }

            !InternalConfig.isQuickPayEnabled && InternalConfig.isOfferEnabled && InternalConfig.isUserPersonalizedOffersAvailable -> {
                Pair(
                    applicationContext.getString(R.string.payu_access_personalized_offers),
                    applicationContext.getString(
                        R.string.payu_verify_phone_number_to_access_personalized_offers
                    )
                )
            }

            InternalConfig.isQuickPayEnabled -> {
                Pair(
                    applicationContext.getString(R.string.payu_access_saved_option),
                    applicationContext.getString(R.string.payu_verify_phone_number_to_access_your_saved_payment_options)
                )
            }

            else -> null
        }
    }

    fun isUserConsentRequiredForOffers(): Boolean {
        if (InternalConfig.isOfferEnabled && InternalConfig.isUserPersonalizedOffersAvailable) {
            return Utils.getUserConsent(applicationContext) == null && Utils.getGlobalVaultStoredUserToken(
                applicationContext
            ).first.isNullOrEmpty().not() && Utils.getGlobalVaultStoredUserToken(
                applicationContext
            ).second.isNullOrEmpty().not()
        }
        return false
    }

    internal fun fetchConvenienceFee(
        mode: String,
        variableDynamicsAttributes: ArrayList<VariableDynamics>
    ) {

        //TODO will uncomment when upi pricing engine support will be available
//        if (InternalConfig.isPricingCFCall == true && variableDynamicsAttributes.isNotEmpty())
//            SdkUiInitializer.apiLayer?.fetchConvenienceFee(mode, variableDynamicsAttributes) {}
    }

    internal fun fetchConvFeeForIntentUpiOption(paymentOption: PaymentOption?) {
        val bankCode =
            (paymentOption?.otherParams as? HashMap<String, Any>)?.let {
                Utils.getBankCodeFromMap(
                    it
                )
            }
        if (bankCode == SdkUiConstants.INTENT || bankCode == SdkUiConstants.CP_TEZ) {
            fetchConvFeeForUPIMode(paymentOption)
        }
    }

    private fun prepareVariableDynamicAttributes(
        paymentOption: PaymentOption
    ): ArrayList<VariableDynamics> {
        val variableDynamicList: ArrayList<VariableDynamics> = ArrayList()
        if (paymentOption.feeCombinations == null) {
            val variableDynamics = VariableDynamics(
                SdkUiConstants.CP_UPI.plus("_${SdkUiConstants.CP_TEZ}"),
                SdkUiConstants.CP_TEZ
            )
            variableDynamicList.add(variableDynamics)
            val variableDynamics1 = VariableDynamics(
                SdkUiConstants.CP_UPI.plus("_${SdkUiConstants.CP_TEZOMNI}"),
                SdkUiConstants.CP_TEZOMNI
            )
            variableDynamicList.add(variableDynamics1)
            val variableDynamics2 = VariableDynamics(
                SdkUiConstants.CP_UPI.plus("_${SdkUiConstants.INTENT}"),
                SdkUiConstants.INTENT
            )
            variableDynamicList.add(variableDynamics2)
            val variableDynamics3 = VariableDynamics(
                SdkUiConstants.CP_UPI.plus("_" + SdkUiConstants.CP_UPI),
                SdkUiConstants.CP_UPI
            )
            variableDynamicList.add(variableDynamics3)
        }
        return variableDynamicList
    }

    internal fun fetchConvFeeForUPIMode(paymentOption: PaymentOption) {
        val variableDynamicList = prepareVariableDynamicAttributes(paymentOption)
        fetchConvenienceFee(SdkUiConstants.CP_UPI, variableDynamicList)
    }



    fun applyCoupon(coupon: String? = null) {
        coupon?.let { nonNullCoupon ->
            var availableOffer: OfferInfo? = null
            availableOffer = OfferFilterManager.findCouponInCache(nonNullCoupon, fetchOfferDetails)
            if (availableOffer == null && nonNullCoupon.trim().length > 1) {
                InternalConfig.appliedCouponOfferKey = coupon
                showAndroidLoader.value = Event(true)
                SdkUiInitializer.apiLayer?.fetchOfferDetails(
                    resetCache = true,
                    loggedInPhoneNumber = getLoggedInPhoneNumber()
                ) { fetchOfferDetails ->
                    Handler().postDelayed({
                        showAndroidLoader.value = Event(false)
                    }, 0)
                    InternalConfig.appliedCouponOfferKey = null
                    availableOffer = getFirstAvailableOffer(fetchOfferDetails)
                    handleCouponOffer(availableOffer)
                }
            }
            availableOffer?.let { validOffer ->
                handleCouponOffer(validOffer)
            }
        }
    }

    private fun getFirstAvailableOffer(fetchOfferDetails: FetchOfferDetails?): OfferInfo? {
        fetchOfferDetails?.payuOfferArrayList?.firstOrNull()?.let {
            return it
        }
        fetchOfferDetails?.payuRewardOfferArrayList?.firstOrNull()?.let {
            return it
        }
        fetchOfferDetails?.payuSkuOfferList?.firstOrNull()?.let {
            return it
        }
        return null
    }

    private fun handleCouponOffer(offerInfo: OfferInfo?) {
        if(offerInfo == null) {
            showCouponError.value = Event(Pair(true, applicationContext.getString(R.string.this_coupon_is_invalid)))
            return
        }
        if (checkIfLogInIsRequiredForACoupon(offerInfo)) {
            offerInfo.userDetail?.phoneNo?.let {
                sendOTPGlobalVault(it, postSendOtpAction = {
                    inflateBlocks(verifyOtpSheetInflated = true)
                    showBottomSheet.value = Pair(R.layout.globalvault_bottomsheet, null)
                    showGlobalVaultResendOTPTimer()
                    pendingOffer = offerInfo
                })
            }
        } else {
            InternalConfig.userSelectedOfferInfo = offerInfo
            updateSelectedOfferForUserSelected()
            showChangeOfferView(true, false)
            updateRecommendedAndQuickPaymentListBasedOnOffers()
            hideBottomSheet()
        }
        OfferFilterManager.addCouponToCache(offerInfo.offerKey ?: "", offerInfo)
    }

    private fun checkIfLogInIsRequiredForACoupon(offerInfo: OfferInfo): Boolean {
        if (offerInfo.userDetail?.phoneNo == null)
            return false

        val loggedInNumber = getLoggedInPhoneNumber() ?: return true

        if (loggedInNumber != offerInfo.userDetail?.phoneNo) {
            logoutFromGlobalVault()
            return true
        } else return false
    }





}