package com.payu.ui.view.fragments.handlers

import android.app.Activity
import android.content.Context
import android.view.View
import android.view.View.GONE
import android.view.View.VISIBLE
import android.widget.EditText
import android.widget.ImageView
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.lifecycle.LifecycleOwner
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.view.CustomTextWatcher
import com.payu.ui.view.fragments.InputWatcher
import com.payu.ui.viewmodel.CardBaseViewModel


open class CvvExpiryUiHandler(private val cardBaseViewModel: CardBaseViewModel) : InputWatcher,
    View.OnFocusChangeListener {

    private var etExpiry: EditText? = null
    private var etCvv: EditText? = null
    private val expiryDivider = 3
    private val expirySeparator = '/'
    private var expiryTextWatcher: CustomTextWatcher? = null
    private var cvvTextWatcher: CustomTextWatcher? = null
    private var rlCvv: ConstraintLayout? = null
    private var rlExpiry: ConstraintLayout? = null
    private var tvErrorCvv: TextView? = null
    private var tvErrorExpiry: TextView? = null
    private var tvCvv: TextView? = null
    private var tvExpiry: TextView? = null
    private var ivToolTipExpiry: ImageView? = null
    private var ivToolTipCvv: ImageView? = null

    internal fun initCVVExpiryUi(view: View) {
        etExpiry = view.findViewById(R.id.etExpiry)
        etCvv = view.findViewById(R.id.etCvv)
        rlCvv = view.findViewById(R.id.rlCvv)
        rlExpiry = view.findViewById(R.id.rlExpiry)
        tvErrorCvv = view.findViewById(R.id.tvErrorCvv)
        tvErrorExpiry = view.findViewById(R.id.tvErrorExpiry)
        tvCvv = view.findViewById(R.id.tvCvv)
        tvExpiry = view.findViewById(R.id.tvExpiry)
        ivToolTipExpiry = view.findViewById(R.id.ivToolTipExpiry)
        ivToolTipCvv = view.findViewById(R.id.ivToolTipCvv)
        etCvv?.let { cvvTextWatcher = CustomTextWatcher(it, 6, 0.toChar(), this) }
        etExpiry?.let {
            expiryTextWatcher = CustomTextWatcher(
                it,
                expiryDivider,
                expirySeparator,
                this
            )
        }
        etExpiry?.addTextChangedListener(expiryTextWatcher)
        etCvv?.addTextChangedListener(cvvTextWatcher)
        etExpiry?.onFocusChangeListener = this
        etCvv?.onFocusChangeListener = this
        ivToolTipExpiry?.setOnClickListener{
            cardBaseViewModel.toolTipExpiryClicked()
        }
        ivToolTipCvv?.setOnClickListener {
            cardBaseViewModel.toolTipCvvClicked()
        }
    }

    private fun updateCvvExpiryView(it: Boolean) {
        if (it) {
            rlCvv?.setBackgroundResource(R.drawable.payu_rounded_corner_image_for_edittext)
            rlExpiry?.setBackgroundResource(R.drawable.payu_rounded_corner_image_for_edittext)
            etCvv?.alpha = 0.5f
            etExpiry?.alpha = 0.5f
            tvCvv?.alpha = 0.5f
            tvExpiry?.alpha = 0.5f

        } else {
            etCvv?.alpha = 1f
            etExpiry?.alpha = 1f
            tvCvv?.alpha = 1f
            tvExpiry?.alpha = 1f
        }
    }

    internal fun addCvvExpiryObserver(
        context: Activity
    ) {
        cardBaseViewModel.cvvError.observe(context as LifecycleOwner) {
            if (it == null) {
                ViewUtils.updateStrokeColor(context, rlCvv)
                tvErrorCvv?.visibility = GONE
            } else {
                ViewUtils.updateStrokeColor(context, rlCvv, R.color.payu_color_de350b)
                tvErrorCvv?.visibility = VISIBLE
                tvErrorCvv?.text = it
            }
        }
        cardBaseViewModel.expiryError.observe(context as LifecycleOwner) {
            if (it == null) {
                ViewUtils.updateStrokeColor(context, rlExpiry)
                tvErrorExpiry?.visibility = GONE
            } else {
                ViewUtils.updateStrokeColor(context, rlExpiry, R.color.payu_color_de350b)
                tvErrorExpiry?.visibility = VISIBLE
                tvErrorExpiry?.text = it
            }
        }
        cardBaseViewModel.disableCvvExpiry.observe(
            context as LifecycleOwner
        ) {
            etCvv?.isEnabled = !it
            etExpiry?.isEnabled = !it
            updateCvvExpiryView(it)
        }
        cardBaseViewModel.expiryValid.observe(context as LifecycleOwner) {
            if (it) etCvv?.requestFocus()
        }
        cardBaseViewModel.cvvValid.observe(context as LifecycleOwner) { it ->
            if (it) {
                etCvv?.let { it1 -> ViewUtils.hideSoftKeyboard(it1) }
                etCvv?.clearFocus()
            }
        }
        cardBaseViewModel.highlightCardCvv.observe(context as LifecycleOwner) {
            if (it) {
                ViewUtils.updateStrokeColor(
                    context,
                    rlCvv,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
                tvErrorCvv?.visibility = GONE
            } else {
                ViewUtils.updateStrokeColor(context, rlCvv)
            }
        }
        cardBaseViewModel.highlightCardExpiry.observe(context as LifecycleOwner) {
            if (it) {
                ViewUtils.updateStrokeColor(
                    context,
                    rlExpiry,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
                tvErrorExpiry?.visibility = GONE
            } else {
                ViewUtils.updateStrokeColor(context, rlExpiry)
            }
        }
        cardBaseViewModel.cardNumberValid.observe(context as LifecycleOwner) {
            if (it) {
              //  etExpiry?.requestFocus()
            }
        }
        cardBaseViewModel.expiryToolTip.observe(context as LifecycleOwner) {
            if (it != null) {
                ViewUtils.showTextToolTip(context, ivToolTipExpiry!!, null, it)
            }
        }

        cardBaseViewModel.cvvToolTip.observe(context as LifecycleOwner) {
            if (it != null) {
                ViewUtils.showImageToolTip(context, ivToolTipCvv!!, null, it)
            }
        }

        cardBaseViewModel.hideToolTip.observe(context as LifecycleOwner) {
            if (it) ViewUtils.hideToolTip()
        }
    }

    override fun onInputReceived(input: String, inputType: Int) {
        when (inputType) {
            R.id.etCvv -> cardBaseViewModel.cvv = input
            R.id.etExpiry -> cardBaseViewModel.cardExpiry = input
        }
    }

    override fun onFocusChange(p0: View?, hasFocus: Boolean) {
        cardBaseViewModel.cardExpiryFocused(hasFocus)
        cardBaseViewModel.cardCvvFocused(hasFocus)
    }

}