package com.payu.ui.view.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.BnplOption
import com.payu.base.models.CardOption
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.base.models.UPIOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.adapters.SavedOptionsListAdapter
import com.payu.ui.model.managers.NetworkManager
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.widgets.RoundedCornerBottomSheet
import com.payu.ui.viewmodel.BaseViewModelFactory
import com.payu.ui.viewmodel.PaymentOptionViewModel
import com.payu.ui.viewmodel.SavedOptionsViewModel

class SavedOptionFragment: Fragment(),RoundedCornerBottomSheet.OnBottomSheetListener,
    SavedOptionsListAdapter.SavedOptionsListener {

    private var savedOptionsViewModel: SavedOptionsViewModel? = null
    private var paymentOptionViewModel: PaymentOptionViewModel? = null
    private var quickOptionList: ArrayList<PaymentMode>? = ArrayList()
    private var rvSavedOptions: RecyclerView? = null
    private var roundedCornerBottomSheet: RoundedCornerBottomSheet? = null
    private var deleteIndex: Int = -1
    private var deletedSavedOptions: PaymentOption? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
             quickOptionList = it.getParcelableArrayList<PaymentMode>(SdkUiConstants.SAVED_CARDS)
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {

        return inflater.inflate(R.layout.layout_saved_options, container, false)

    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        rvSavedOptions = view.findViewById(R.id.rcvSavedOptions)
        initViewModel()
        addObserver()
    }

    companion object {
        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         * @return A new instance of fragment PayUSavedCardsFragment.
         */
        @JvmStatic
        fun newInstance(quickOptionsList: ArrayList<PaymentMode>?) =
            SavedOptionFragment().apply {
                arguments = Bundle().apply {
                    putParcelableArrayList(SdkUiConstants.SAVED_CARDS, quickOptionsList)
                }
            }
    }

    private fun addObserver(){
        savedOptionsViewModel?.adapterList?.observe(viewLifecycleOwner) {
            rvSavedOptions?.layoutManager = LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
            val savedOptionsListAdapter = SavedOptionsListAdapter(filterListWithoutSodexoAndClw(quickOptionList), this)
            rvSavedOptions?.adapter = savedOptionsListAdapter

        }

        savedOptionsViewModel?.savedCardsListEmpty?.observe(viewLifecycleOwner){
            ViewUtils.hideProgressDialog()
            paymentOptionViewModel?.popBackStack()
        }
        savedOptionsViewModel?.apiError?.observe(viewLifecycleOwner) { errorResponse ->
            ViewUtils.showSnackBar(errorResponse.errorMessage, R.drawable.payu_error, activity)
        }
        savedOptionsViewModel?.showAndroidLoader?.observe(viewLifecycleOwner) {
            if (it.getContentIfNotHandled() == true)
                ViewUtils.showProgressDialog(context)
            else
                ViewUtils.hideProgressDialog()
        }
    }

    private fun initViewModel() {

        /**
         * We will create ViewModel instance in the fragment using the activity scope so
         * that it will be available for all the fragment of the activity including activity itself.
         * */

        paymentOptionViewModel = activity?.run {
            ViewModelProvider(this)[PaymentOptionViewModel::class.java]
        } ?: throw Exception("Invalid Activity")

        if (null != activity && !activity?.isFinishing!! && !activity?.isDestroyed!!) {
            quickOptionList?.let {
                val map = HashMap<String, Any>()
                map[SdkUiConstants.SAVED_CARDS] = it
                savedOptionsViewModel = ViewModelProvider(
                    this,
                    BaseViewModelFactory(activity?.application!!, map)
                ).get(SavedOptionsViewModel::class.java)
            }
        }
    }

    private fun showBottomSheet(layout: Int) {
            roundedCornerBottomSheet =
                RoundedCornerBottomSheet.newInstance(layout)
            roundedCornerBottomSheet?.show(
                requireActivity().supportFragmentManager,
                SdkUiConstants.CP_SAVED_CARD_BOTTOM_SHEET
            )
            roundedCornerBottomSheet?.setListener(this)
        }

    override fun onDeleteClicked(deleteIndex: Int, savedCardOption: PaymentOption) {
        this.deleteIndex = deleteIndex
        this.deletedSavedOptions = savedCardOption
        showBottomSheet(R.layout.layout_delete_saved_option)
        savedOptionsViewModel?.handleDeleteItemClicked(deleteIndex)
    }

    override fun getInflatedView(view: View, roundedCornerBottomSheet: RoundedCornerBottomSheet) {
        val tvYes: TextView = view.findViewById(R.id.tvYes)
        val btnNo: Button = view.findViewById(R.id.btnNo)
        val ivCardIssuerIcon: ImageView = view.findViewById(R.id.ivCardIssuerIcon)
        val tvBankName: TextView = view.findViewById(R.id.tvBankName)
        val tvCardNumber: TextView = view.findViewById(R.id.tvCardNumber)

        var param: ImageParam ? = null
        ViewUtils.updateBackgroundColor(
            requireContext(),
            btnNo,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(btnNo, SdkUiInitializer.apiLayer?.config?.baseTextColor)

        when (deletedSavedOptions?.paymentType) {
            PaymentType.CARD -> {
                val cardOption = deletedSavedOptions as? CardOption
                if (!cardOption?.bankName.equals(SdkUiConstants.CP_NULL, ignoreCase = true)) {
                    tvBankName.text = cardOption?.bankName+" "+cardOption?.cardBinInfo?.cardType?.getTypeName()
                }

                tvCardNumber.text = cardOption?.cardNumber
                param = cardOption?.let { ImageParam(it, true, R.drawable.payu_cards_placeholder) }

            }

            PaymentType.UPI, PaymentType.UPI_INTENT -> {
                val upiOption = (deletedSavedOptions as UPIOption)
                tvCardNumber.text = upiOption.vpa
                tvBankName.text = upiOption?.bankName
                param = ImageParam(upiOption, false, R.drawable.payu_upi)
            }

            PaymentType.NB -> {

                tvCardNumber.text =
                    requireContext().getString(R.string.payu_pay_using_nb_text)
                tvBankName.text =
                    deletedSavedOptions?.bankName + " " + requireContext().getString(R.string.payu_netbanking)
                param = deletedSavedOptions?.let { ImageParam(it, false, R.drawable.payu_netbanking) }
            }

            PaymentType.WALLET -> {
                tvCardNumber.text =
                    requireContext().getString(R.string.pay_using_wallet_text)
                tvBankName.text = deletedSavedOptions?.bankName + " " + requireContext().getString(R.string.payu_wallet)
                param = deletedSavedOptions?.let { ImageParam(it, false, R.drawable.payu_wallet) }
            }

            PaymentType.BNPL -> {
                val bnplOption = (deletedSavedOptions as BnplOption)
                tvCardNumber.text = bnplOption.phoneNumber
                tvBankName.text = bnplOption.bankName
                param = ImageParam(bnplOption, false, R.drawable.payu_wallet)
            }

        }
        if (param != null) {
            SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                param,
                onFetchImageListener = object : OnFetchImageListener {
                    override fun onImageGenerated(result: ImageDetails) {
                        ImageViewUtils.setImage(ivCardIssuerIcon, result)
                    }
                })
        }

        tvYes.setOnClickListener {
            if (ViewUtils.isInternetAvailable(requireContext())) {
                ViewUtils.dismissSnackBar()
                deletedSavedOptions?.let { it1 ->
                    val storedUserToken = Utils.getGlobalVaultStoredUserToken(requireActivity().applicationContext)
                   val phone = storedUserToken.second
                    deletedSavedOptions?.phoneNumber = phone ?: ""
                    savedOptionsViewModel?.callDeleteSavedOptionApi(
                        it1
                    )
                }
            } else {
                NetworkManager.registerReceiver(requireContext().applicationContext)
                ViewUtils.showSnackBar(
                    resources.getString(R.string.payu_no_internet_connection),
                    R.drawable.payu_no_internet,
                    activity
                )
            }
            roundedCornerBottomSheet.dismiss()
        }

            btnNo.setOnClickListener {
                this.roundedCornerBottomSheet?.dismiss()
            }
    }

    override fun handleBottomSheetClose() {
    }

    override fun bottomSheetDetach() {
    }

    override fun bottomSheetAttach() {
    }

    private fun filterListWithoutSodexoAndClw(quickOptionsList: ArrayList<PaymentMode>?): ArrayList<PaymentMode> {
        val savedOptionList = ArrayList<PaymentMode>()
        quickOptionsList?.forEach { paymentMode ->
            if (paymentMode.type != PaymentType.SODEXO && paymentMode.type != PaymentType.CLOSED_LOOP_WALLET) {
                savedOptionList.add(paymentMode)
            }
        }
        return savedOptionList
    }
}