package com.payu.ui.view.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.EditText
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.models.EMIOption
import com.payu.base.models.InternalConfig
import com.payu.base.models.OfferInfo
import com.payu.base.models.PaymentFlowState
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentState
import com.payu.base.models.PaymentType
import com.payu.base.models.UPIOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.adapters.NetBankingAdapter
import com.payu.ui.model.listeners.OfferApplyListener
import com.payu.ui.model.listeners.OnBankAdapterListener
import com.payu.ui.model.listeners.OnNetBankingAdapterListener
import com.payu.ui.model.listeners.OnOfferDetailsListener
import com.payu.ui.model.listeners.ValidateOfferResultListener
import com.payu.ui.model.models.AdapterViewSections
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.SdkUiConstants.CP_ADDITIONAL_CHARGE
import com.payu.ui.model.utils.SdkUiConstants.CP_ALL_BANKS_LIST
import com.payu.ui.model.utils.SdkUiConstants.CP_IS_SKU_OFFER
import com.payu.ui.model.utils.SdkUiConstants.CP_KEY_IS_USER_ALREADY_LOGGED_IN
import com.payu.ui.model.utils.SdkUiConstants.CP_KEY_WALLET_NAME
import com.payu.ui.model.utils.SdkUiConstants.CP_OFFERS_LIST
import com.payu.ui.model.utils.SdkUiConstants.CP_PAYMENT_STATE
import com.payu.ui.model.utils.SdkUiConstants.CP_PAYMENT_TYPE
import com.payu.ui.model.utils.SdkUiConstants.CP_SAVED_BANKS_LIST
import com.payu.ui.model.utils.SdkUiConstants.CP_SHOW_LOGIN_VIEW
import com.payu.ui.model.utils.SdkUiConstants.TAG_WALLET_FRAGMENT
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.view.customViews.OfferAppliedDialog
import com.payu.ui.view.customViews.UpiOtmDetailBottomSheet
import com.payu.ui.viewmodel.BankViewModel
import com.payu.ui.viewmodel.BaseViewModelFactory
import com.payu.ui.viewmodel.PaymentOptionViewModel
import org.json.JSONObject


class BankFragment : Fragment(), OnBankAdapterListener,
    OnOfferDetailsListener, OfferApplyListener, OnNetBankingAdapterListener {

    private var TAG = javaClass.simpleName

    private var savedBanksList: ArrayList<PaymentMode>? = null
    private var allBanksList: ArrayList<PaymentOption>? = null
    private var offersList: ArrayList<OfferInfo>? = null
    private var paymentType: PaymentType? = null
    private var paymentState: PaymentState? = null

    private var paymentOptionViewModel: PaymentOptionViewModel? = null
    private var bankViewModel: BankViewModel? = null

    private var additionalCharge: Double = 0.0
    private var isSkuOffer: Boolean = false
    private var validateOfferResultListener: ValidateOfferResultListener? = null

    private var rvSectionsAndList: RecyclerView? = null

    private var sections = arrayListOf<AdapterViewSections>()
    private lateinit var netBankingAdapter: NetBankingAdapter

    private var showLoginView: Boolean = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            savedBanksList = it.getParcelableArrayList(CP_SAVED_BANKS_LIST)
            allBanksList = it.getParcelableArrayList(CP_ALL_BANKS_LIST)
            offersList = it.getParcelableArrayList(CP_OFFERS_LIST)
            paymentType = it.get(CP_PAYMENT_TYPE) as? PaymentType
            paymentState = it.get(CP_PAYMENT_STATE) as? PaymentState
            additionalCharge = it.getDouble(CP_ADDITIONAL_CHARGE)
            isSkuOffer = it.getBoolean(CP_IS_SKU_OFFER)
            showLoginView = it.getBoolean(CP_SHOW_LOGIN_VIEW)
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        val view = inflater.inflate(R.layout.fragment_net_banking, container, false)
        return view
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initUi(view)
        initViewModel()
        addObservers()
    }

    private fun addObservers() {

        bankViewModel?.resetBankSelection?.observe(viewLifecycleOwner, Observer {
            if (it) {
                netBankingAdapter.setResetBankSelection()
            }
        })

        bankViewModel?.allBanksText?.observe(viewLifecycleOwner, Observer {
            it?.let { allbanksText ->
                netBankingAdapter.setAllBanksText(allbanksText)
            }
        })

        bankViewModel?.allBanksIcon?.observe(viewLifecycleOwner, Observer {
            netBankingAdapter.setAllBanksIcon(it)
        })


        bankViewModel?.showUpiCollectView?.observe(viewLifecycleOwner, Observer {
            if (it) {
                val olderSection =
                    sections.firstOrNull {
                        it is AdapterViewSections.AddNewCard
                    }
                olderSection?.let {
                    netBankingAdapter.removeSections(olderSection)
                }
                val addNewCardSection = AdapterViewSections.AddNewCard(
                    title = context?.getString(R.string.payu_pay_by_upi_id),
                    detailsText = context?.getString(R.string.payu_or_phone_number),
                    showDetails = false,
                    addIconRes = R.drawable.payu_upi,
                    showHeader = true,
                    showRightIcon = true,
                    rightIcon = R.drawable.payu_add_icon,
                    showAddIcon = true,
                    showOffer = false
                )
//                sections.add(addNewCardSection)
//                netBankingAdapter.addSection(section = addNewCardSection)
                netBankingAdapter.setUpiCollectView(addNewCardSection)
            }
        })
        bankViewModel?.showTezOmniView?.observe(viewLifecycleOwner, Observer {
            netBankingAdapter.setShowTezOmniView(it)
        })

        bankViewModel?.showOfferViewInUPICOllect?.observe(viewLifecycleOwner, Observer {
            netBankingAdapter.setShowOfferViewInUPICollect(it)
        })

        bankViewModel?.showMCPHeader?.observe(viewLifecycleOwner, Observer {
            if (it) {
                var transactionAmount =
                    SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull()
                transactionAmount = transactionAmount?.plus(additionalCharge)
                val olderSection =
                    sections.firstOrNull {
                        it is AdapterViewSections.AddNewCard
                    }
                olderSection?.let {
                    netBankingAdapter.removeSections(olderSection)
                }
                val addNewCardSection = AdapterViewSections.AddNewCard(
                    title = context?.getString(R.string.payu_choose_currency_to_pay),
                    detailsText = context?.getString(
                        R.string.payu_equivalent_to_amount,
                        Utils.formatAmount(transactionAmount?.toString())
                    ),
                    showDetails = true,
                    addIconRes = R.drawable.payu_all_currencies,
                    showHeader = true,
                    showRightIcon = false,
                    showAddIcon = true,
                    showOffer = false
                )
                sections.add(addNewCardSection)
                netBankingAdapter.addSection(section = addNewCardSection)
            } else {
                val olderSection =
                    sections.firstOrNull {
                        it is AdapterViewSections.AddNewCard
                    }
                olderSection?.let {
                    netBankingAdapter.removeSections(olderSection)
                }
            }
        })


        bankViewModel?.adapterList?.observe(viewLifecycleOwner) {
            var topBankSection: AdapterViewSections.TopBanks? = null
            if (!it.isNullOrEmpty() && InternalConfig.userAccountInfoList.isNullOrEmpty().not()) {
                netBankingAdapter.setBankListData(it)
            } else if (!it.isNullOrEmpty()) {
                val topBankList =
                    if (paymentType == PaymentType.NB) Utils.getTopBankList() else arrayListOf()
                var banksFilteredList = it
                if (paymentType == PaymentType.NB) {
                    banksFilteredList = Utils.getOtherBanksList()
                    if (topBankList.isNotEmpty()) {
                        paymentType?.let {
                            topBankSection = AdapterViewSections.TopBanks(
                                paymentType = it,
                                topBankList = topBankList,
                                paymentState = paymentState,
                                childFragmentManager = childFragmentManager,
                                offerApplyListener = this,
                                onBankAdapterListener = this
                            )
                        }
                    }
                }

                if (paymentType == PaymentType.UPI) {
                    banksFilteredList = Utils.getUpiIntentList()
                }
                if ((bankViewModel?.showUpiCollectView?.value == true || bankViewModel?.showTezOmniView?.value == true) && paymentType == PaymentType.UPI && banksFilteredList.isEmpty()) {
                    addNewCard()
                    return@observe
                } else if (topBankList.isEmpty() && banksFilteredList.isEmpty()) {
                    bankViewModel?.showOfferError()
                    bankViewModel?.removeOffer(true)
                } else {
                    netBankingAdapter.setBankListData(banksFilteredList)
                }

                topBankSection?.let { validTopBankSection ->
                    sections.add(validTopBankSection)
                    netBankingAdapter.updateTopBanks(validTopBankSection)
                }
            } else {
                bankViewModel?.showOfferError()
                bankViewModel?.removeOffer(true)
            }
        }

        bankViewModel?.offersListLiveData?.observe(viewLifecycleOwner) {
            if (it != null) {
                netBankingAdapter.setOfferListData(it)
            }
        }

        bankViewModel?.skuListLiveData?.observe(viewLifecycleOwner) {
            if (it != null) {
                netBankingAdapter.setSkuOfferListData(it)
            }
        }

        bankViewModel?.hideSearchView?.observe(viewLifecycleOwner, Observer {
            netBankingAdapter.setHideSearchView(it)
        })

        bankViewModel?.hideHeaderView?.observe(viewLifecycleOwner, Observer {
            val olderSection =
                sections.firstOrNull {
                    it is AdapterViewSections.SearchSection
                }
            olderSection?.let {
                netBankingAdapter.removeSections(olderSection)
            }
            if (!it) {
                val searchSection =
                    AdapterViewSections.SearchSection()
                sections.add(searchSection)
                netBankingAdapter.addSection(section = searchSection)
            }
        })

        bankViewModel?.siHeaderSummary?.observe(viewLifecycleOwner, Observer { value ->
            if (value != null && value.isNotEmpty()) {
                val olderSection =
                    sections.firstOrNull {
                        it is AdapterViewSections.Summary
                    }
                olderSection?.let {
                    netBankingAdapter.removeSections(olderSection)
                }
                val summarySection =
                    AdapterViewSections.Summary(title = value)
                sections.add(summarySection)
                netBankingAdapter.addSection(section = summarySection)
            }

        })

        // For One Time Mandate Message View
        bankViewModel?.otmMessageView?.observe(viewLifecycleOwner) {
            if (it) {
                val otmMessageView = AdapterViewSections.OTMMessageView(
                    title = getString(R.string.payu_setup_otm),
                    subTitle = getString(R.string.payu_setup_otm_message)
                )
                sections.add(otmMessageView)
                netBankingAdapter.addSection(section = otmMessageView)
            }
        }

        paymentOptionViewModel?.showChangeOfferView?.observe(viewLifecycleOwner) { value ->
            val olderSection = sections.firstOrNull {
                it is AdapterViewSections.Offer
            }
            olderSection?.let {
                netBankingAdapter.removeSections(olderSection)
            }
            if (value != null && value && offersList.isNullOrEmpty()) {
                val offerSection = AdapterViewSections.Offer()
                sections.add(offerSection)
                netBankingAdapter.addSection(section = offerSection)
            }
        }

        paymentOptionViewModel?.updateOffer?.observe(viewLifecycleOwner) {
            when (paymentType) {
                PaymentType.EMI -> {
                    paymentType?.let { it1 -> bankViewModel?.getAllBanksList(it1) }
                }

                else -> {
                    if (it) paymentType?.let { it1 ->
                        if (InternalConfig.selectedOfferInfo?.isAutoApply == false) {
                            netBankingAdapter.setClearBankAdapter()
                            netBankingAdapter.setOfferUpdated(true)
                        }
                        bankViewModel?.getAllBanksList(
                            it1
                        )
                    }
                }
            }

        }

        bankViewModel?.displayTopBanks?.observe(viewLifecycleOwner, Observer {
            netBankingAdapter.setDisplayTopBanks(it)
        })

        bankViewModel?.showOfferApplied?.observe(viewLifecycleOwner) {
            it.getContentIfNotHandled()?.let { isOfferAvailable ->
                if (!isOfferAvailable && InternalConfig.userSelectedOfferInfo != null) {
                    paymentOptionViewModel?.updateSelectedOfferForUserSelected()
                    paymentOptionViewModel?.showChangeOfferView(true)
                } else {
                    paymentOptionViewModel?.showChangeOfferView(
                        shouldShowChangeOffer = isOfferAvailable
                    )
                }
            }
        }
        bankViewModel?.showOfferAppliedDialog?.observe(viewLifecycleOwner) {
            if (it.getContentIfNotHandled() == true && InternalConfig.isPaymentOptionSelected) {
                validateOfferResultListener?.onValidateOfferResponse(true)
                val offerAppliedDialog = OfferAppliedDialog(requireContext())
                offerAppliedDialog.showOfferDialog(paymentOptionViewModel?.selectedPaymentOption)
            }
        }

        bankViewModel?.removeAnyAppliedOffer?.observe(viewLifecycleOwner) {
            if (it) {
                removeOffers()
            }
        }

        bankViewModel?.showOfferError?.observe(viewLifecycleOwner) {
            if (it.first.getContentIfNotHandled() == true) {
                InternalConfig.selectedOfferInfo?.let {
                    ViewUtils.showSnackBar(
                        InternalConfig.selectedOfferInfo?.failureReason
                            ?: requireContext().getString(R.string.payu_offer_not_applicable_on_this),
                        R.drawable.verification, requireActivity(),
                        R.color.payu_color_FCE9E9
                    )
                } ?: run {
                    it?.second?.let { errorReason ->
                        ViewUtils.showSnackBar(
                            errorReason,
                            R.drawable.verification, requireActivity(),
                            R.color.payu_color_FCE9E9
                        )

                    }
                }
            }
        }

        bankViewModel?.showProgressDialog?.observe(viewLifecycleOwner) { showProgressDialog ->
            if (showProgressDialog)
                ViewUtils.showProgressDialog(context)
            else
                ViewUtils.hideProgressDialog()
        }
        bankViewModel?.showAndroidLoader?.observe(viewLifecycleOwner) {
            if (it.getContentIfNotHandled() == true)
                ViewUtils.showProgressDialog(context)
            else
                ViewUtils.hideProgressDialog()
        }

        paymentOptionViewModel?.refreshPaymentModesForOffers?.observe(viewLifecycleOwner) {
            if (it) {
                if (paymentType == PaymentType.EMI) {
                    bankViewModel?.updateListRefreshedForOffer(paymentType)
                    netBankingAdapter.notifyDataSetChanged()
                }
            }
        }

        paymentOptionViewModel?.showTpvTiles?.observe(viewLifecycleOwner) {
            if (it) {
                val tilesDataList = paymentOptionViewModel?.getTilesList() ?: arrayListOf()
                val tpvAccountView = AdapterViewSections.TpvAccountView(tilesDataList)
                netBankingAdapter.setTpvAccountInfoView(
                    tpvAccountView,
                    showTpvAccountView = paymentType == PaymentType.UPI,
                    showTpvInfo = paymentType == PaymentType.UPI
                )
            }
        }

        paymentOptionViewModel?.showLoginPhoneLayout?.observe(viewLifecycleOwner) {
            populateLogInContainer()
            if (it.not()){
                paymentOptionViewModel?.resetBankItem()
            }
        }

        paymentOptionViewModel?.updateBankItem?.observe(viewLifecycleOwner) {
            it?.let { netBankingAdapter.setErrorOnBankListItem(it) }
        }
    }

    private fun initUi(view: View) {
        rvSectionsAndList = view.findViewById<RecyclerView>(R.id.nbRecyclerView)
        rvSectionsAndList?.layoutManager = LinearLayoutManager(requireActivity())
        paymentType.let {
            netBankingAdapter = NetBankingAdapter(
                paymentState = paymentState,
                onOfferDetailsListener = this,
                onNetBankingAdapterListener = this,
                onBankAdapterListener = this
            )
            rvSectionsAndList?.adapter = netBankingAdapter
        }

        populateLogInContainer()
    }

    private fun populateLogInContainer(){
        if (showLoginView.not()) {
            return
        }

        val olderSection = sections.firstOrNull {
            it is AdapterViewSections.LoginSection
        }
        olderSection?.let {
            netBankingAdapter.removeSections(olderSection)
        }
        val loggedInNumber = paymentOptionViewModel?.getLoggedInPhoneNumber()
        if (loggedInNumber != null) {
            val loginSection = AdapterViewSections.LoginSection(phoneNumber = loggedInNumber)
            sections.add(loginSection)
            netBankingAdapter.addSection(section = loginSection)
//            paymentOptionViewModel?.fetchBalanceForOlw(requireContext())
        }
    }

    private fun initViewModel() {

        /**
         * We will create ViewModel instance in the fragment using the requireActivity() scope so
         * that it will be available for all the fragment of the requireActivity() including requireActivity() itself.
         * */

        paymentOptionViewModel = requireActivity().run {
            ViewModelProvider(this)[PaymentOptionViewModel::class.java]
        } ?: throw Exception("Invalid Activity")

        val map = HashMap<String, Any>()
        if (!offersList.isNullOrEmpty()) {
            offersList?.let {
                map[CP_OFFERS_LIST] = it
                map[CP_IS_SKU_OFFER] = isSkuOffer
            }
        } else {
            if (paymentState != null) {
                paymentState?.let { map[CP_PAYMENT_STATE] = it }
            }
            paymentType?.let { map[CP_PAYMENT_TYPE] = it }
            allBanksList?.let { map[CP_ALL_BANKS_LIST] = it }
        }
        bankViewModel = ViewModelProvider(
            this,
            BaseViewModelFactory(requireActivity().application, map)
        )[BankViewModel::class.java]
        if (bankViewModel?.isEmiOption == true)
            paymentOptionViewModel?.setScreenName("L3 " + paymentType?.name)
        else paymentOptionViewModel?.setScreenName("L2 " + paymentType?.name)
    }

    companion object {
        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         *
         * @param paymentState PaymentState
         * @param allBanksList all banks list
         * @param paymentType paymentType
         * @return A new instance of fragment BankFragment.
         */
        @JvmStatic
        fun newInstance(
            paymentState: PaymentState,
            additionalCharge: Double?,
            allBanksList: ArrayList<PaymentOption>,
            paymentType: PaymentType
        ) =
            BankFragment().apply {
                arguments = Bundle().apply {
                    putParcelableArrayList(CP_ALL_BANKS_LIST, allBanksList)
                    putSerializable(CP_PAYMENT_TYPE, paymentType)
                    putSerializable(CP_PAYMENT_STATE, paymentState)
                    putSerializable(CP_ADDITIONAL_CHARGE, additionalCharge)
                    putBoolean(CP_SHOW_LOGIN_VIEW, false)
                }
            }

        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         *
         * @param savedBanksList saved banks list
         * @param allBanksList all banks list
         * @return A new instance of fragment NetBankingFragment.
         */
        @JvmStatic
        fun newInstance(
            savedBanksList: ArrayList<PaymentMode>?,
            allBanksList: ArrayList<PaymentOption>,
            paymentType: PaymentType
        ) =
            BankFragment().apply {
                arguments = Bundle().apply {
                    putParcelableArrayList(CP_SAVED_BANKS_LIST, savedBanksList)
                    putParcelableArrayList(CP_ALL_BANKS_LIST, allBanksList)
                    putSerializable(CP_PAYMENT_TYPE, paymentType)
                    putBoolean(CP_SHOW_LOGIN_VIEW, true)
                }
            }

        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         *
         * @param offersList offers list
         * @return A new instance of fragment NetBankingFragment.
         */
        @JvmStatic
        fun newInstance(
            offersList: ArrayList<OfferInfo>?,
            isSkuOffer: Boolean
        ) =
            BankFragment().apply {
                arguments = Bundle().apply {
                    putParcelableArrayList(CP_OFFERS_LIST, offersList)
                    putSerializable(CP_IS_SKU_OFFER, isSkuOffer)
                    putBoolean(CP_SHOW_LOGIN_VIEW, false)
                }
            }
    }

    override fun updateSelectedOfferForUserSelected() {
        paymentOptionViewModel?.updateSelectedOfferForUserSelected()
    }

    override fun showChangeOfferView(shouldShowChangeOffer: Boolean, isAutoApply: Boolean) {
        paymentOptionViewModel?.showChangeOfferView(
            shouldShowChangeOffer = shouldShowChangeOffer,
            isAutoApply = isAutoApply
        )
    }

    override fun updateOffer() {
        paymentOptionViewModel?.updateRecommendedAndQuickPaymentListBasedOnOffers()
    }

    override fun hideBottomSheet() {
        paymentOptionViewModel?.hideBottomSheet()
    }

    override fun emiSelected(paymentOption: PaymentOption, isForcedPayment: Boolean) {
        if (paymentOption.optionList != null) {
            val emiOption = paymentOption as? EMIOption
            emiOption?.let {
                if (it.isBankOption) {
                    requireActivity().let {
                        if (isForcedPayment)
                            paymentOptionViewModel?.popBackStack()
                        SdkUiInitializer.apiLayer?.updatePaymentState(
                            Utils.getPaymentModel(
                                paymentOption,
                                PaymentFlowState().also { it.paymentState = paymentState }),
                            ViewUtils.getToolbar(
                                it.applicationContext,
                                paymentOption.additionalCharge
                            )
                        )
                    }
                } else {
                    paymentOptionViewModel?.loadBankFragment(
                        paymentOption.optionList!!,
                        PaymentType.EMI
                    )

                }
            }
        }
    }

    override fun itemSelected(paymentOption: PaymentOption, isOfferValid: Boolean, isTopItem: Boolean) {

        if (isTopItem)
            bankViewModel?.isTopBankSelected = true
        else
            bankViewModel?.isBankListItemSelected = true
        paymentOptionViewModel?.updateHeaderAmount(
            amount = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                ?.minus(InternalConfig.selectedOfferInfo?.totalInstantDiscount ?: 0.0),
            additionalCharge = paymentOption.additionalCharge ?: 0.0,
            gstPercentageValue = paymentOption.gstPercentageValue ?: 0.0,
            isEnachPayment = Utils.isEnachPayment(paymentOption.paymentType),
            isOfferValid = true
        )
        val bankCode = Utils.getValueFromPaymentOption<String>(
            SdkUiConstants.CP_BANK_CODE,
            paymentOption.otherParams as? HashMap<String, Any?>
        ).toString()

        when (paymentOption.paymentType) {
            PaymentType.UPI_INTENT -> {
                // To show OTM detail Bottomsheet on payment option selection
                if (SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.isPreAuthTxn == true) {
                    val bottomSheet =
                        UpiOtmDetailBottomSheet.Builder(
                            childFragmentManager,
                            TAG
                        )
                    bottomSheet.setPrivacyUrlClickListener {
                        ViewUtils.openPrivacyUrl(requireActivity())
                    }
                    bottomSheet.setProceedListener {
                        context?.let {
                            if (bankCode == SdkUiConstants.INTENT) {
                                paymentOption.userAgent = Utils.getUpiAnalyticsString(it)
                            }
                            paymentOptionViewModel?.makePayment(paymentOption)
                        }
                    }
                    bottomSheet.build().show()
                }
            }

            PaymentType.WALLET -> {
                // only moved code from above from if block
                if (bankCode == SdkUiConstants.CP_TWID || bankCode == SdkUiConstants.CP_OLAM)
                    paymentOptionViewModel?.showSkuBottomSheet(isOfferValid)
            }

            PaymentType.OPEN_LOOP_WALLET -> {
                paymentOptionViewModel?.updateSelectedPaymentOption(paymentOption)
                val isUserLoggedIn = Utils.getGlobalVaultStoredUserToken(
                    requireContext()
                ).first.isNullOrEmpty().not()
                if (isUserLoggedIn)
                    paymentOptionViewModel?.fetchBalanceForOlw(requireContext())
                else {
                    paymentOptionViewModel?.showBottomSheetGlobalVaultSendOTP()
                }
                AnalyticsUtils.logKibanaInfoEvent(context = requireContext(), eventKey = SdkUiConstants.CP_OLW_ITEM_CLICK, eventValue = JSONObject().apply {
                    put(CP_KEY_WALLET_NAME, paymentOption.bankName)
                    put(CP_KEY_IS_USER_ALREADY_LOGGED_IN, isUserLoggedIn)
                })
            }

            else -> {}
        }

    }

    override fun itemUnSelected(isTopItem: Boolean) {
        if(isTopItem)
            bankViewModel?.isTopBankSelected = false
        else
            bankViewModel?.isBankListItemSelected = false
        if(bankViewModel?.checkIfHeaderNeedToBeReset() == true) {
            bankViewModel?.updateSelectedPaymentOption(null)
            paymentOptionViewModel?.updateSelectedPaymentOption(null)
            paymentOptionViewModel?.resetHeaderAmount(
                Utils.isEnachPayment(paymentType),
                (InternalConfig.selectedOfferInfo?.totalInstantDiscount != null)
            )
        }
    }

    override fun removeOffer() {
        if (InternalConfig.selectedOfferInfo?.isAutoApply == true && !InternalConfig.isPaymentOptionSelected) {
            if (InternalConfig.userSelectedOfferInfo != null) {
                paymentOptionViewModel?.updateSelectedOfferForUserSelected()
                paymentOptionViewModel?.showChangeOfferView(
                    true
                )
            } else {
                paymentOptionViewModel?.showChangeOfferView(
                    false
                )
                paymentType?.let { bankViewModel?.getAllBanksList(it) }
            }
        }
    }

    override fun validateOffer(
        paymentOption: PaymentOption,
        validateOfferResultListener: ValidateOfferResultListener
    ) {
        this.validateOfferResultListener = validateOfferResultListener
        bankViewModel?.updateSelectedPaymentOption(paymentOption)
        paymentOptionViewModel?.updateSelectedPaymentOption(paymentOption)
        bankViewModel?.validateOffer()
    }


    override fun removeOffer(isAutoApply: Boolean) {
        bankViewModel?.removeOffer(isAutoApply)
    }

    override fun isActivityAlive(): Boolean {
        return !requireActivity().isFinishing && !requireActivity().isDestroyed
    }

    override fun showSnackBar(message: String?, icon: Int?, bgColor: Int?) {
        ViewUtils.showSnackBar(
            message,
            icon,
            requireActivity()
        )
    }

    override fun getCurrentFocus(): View? {
        return requireActivity().currentFocus
    }

    override fun clearFocus(endAction: (() -> Unit)?) {
        val search = requireActivity().findViewById<EditText>(R.id.search_src_text)
        if (search != null && search.hasFocus()) {
            search.clearFocus()
            //Request focus on item view of adapter to remove focus from search view
            endAction?.invoke()
        }
    }

    override fun showSkuBottomSheet(show: Boolean) {
        paymentOptionViewModel?.showSkuBottomSheet(show)
    }

    override fun removeOffers() {
        netBankingAdapter.setOfferUpdated(true)
        InternalConfig.userSelectedOfferInfo = null
        paymentOptionViewModel?.showChangeOfferView(false, isAutoApply = false)
    }

    override fun addNewCard() {
        val upiCollectOption = Utils.getUpiCollectPaymentOption(allBanksList!!)
        if (upiCollectOption != null && upiCollectOption is UPIOption) {
            val paymentFlowState = PaymentFlowState()
            allBanksList?.let {
                val isUpiFlowAvailable = Utils.isPaymentOptionAvailable(
                    it,
                    SdkUiConstants.CP_UPI
                )
                val isTezOmniFlowAvailable = Utils.isPaymentOptionAvailable(
                    it,
                    SdkUiConstants.CP_TEZOMNI
                )
                if (isUpiFlowAvailable && isTezOmniFlowAvailable) {
                    paymentFlowState.paymentState = PaymentState.VpaAndMobileEligibility
                } else if (isUpiFlowAvailable)
                    paymentFlowState.paymentState = PaymentState.VPAEligibility
                else paymentFlowState.paymentState = PaymentState.MobileEligibility

                val walletFragment = WalletFragment.newInstance(
                    Utils.getPaymentModel(
                        upiCollectOption,
                        paymentFlowState
                    )
                )
                paymentOptionViewModel?.loadFragment(
                    walletFragment,
                    TAG_WALLET_FRAGMENT,
                    PaymentType.UPI
                )
            }
            AnalyticsUtils.logL2ClickEvents(requireContext(), PaymentType.UPI, "Other")
        } else ViewUtils.showSnackBar(
            context?.getString(R.string.payu_please_try_another_payment),
            R.drawable.payu_upi,
            this.requireActivity()
        )
    }

    override fun showLoginSettings() {
        paymentOptionViewModel?.showBottomSheetGlobalVaultSettings()
    }
    override fun onDestroyView() {
        rvSectionsAndList = null
        super.onDestroyView()
    }

    override fun onDestroy() {
        validateOfferResultListener = null
        super.onDestroy()
    }

}
