package com.payu.ui.view.customViews

import android.view.View
import android.widget.ImageView
import androidx.fragment.app.FragmentManager
import com.payu.ui.R
import com.payu.ui.model.widgets.RoundedCornerBottomSheet


class BankDownBottomSheet(
    private val fragmentManager: FragmentManager, val tag: String,
    private val roundedCornerBottomSheet: RoundedCornerBottomSheet
) {

    fun show() {
        roundedCornerBottomSheet.show(fragmentManager, tag)
    }

    class Builder(private val fragmentManager: FragmentManager, val tag: String) :
        RoundedCornerBottomSheet.OnBottomSheetListener {
        private lateinit var ivBankDownClose: ImageView

        fun build(): BankDownBottomSheet {

            val roundedCornerBottomSheet = RoundedCornerBottomSheet.newInstance(
                R.layout.bank_down_bottom_sheet
            )
            roundedCornerBottomSheet.setListener(this)
            return BankDownBottomSheet(fragmentManager, tag, roundedCornerBottomSheet)

        }

        override fun getInflatedView(
            view: View,
            roundedCornerBottomSheet: RoundedCornerBottomSheet
        ) {
            ivBankDownClose = view.findViewById(R.id.ivBankDownClose)

            ivBankDownClose.setOnClickListener {
                roundedCornerBottomSheet.dismiss()
            }
        }

        override fun handleBottomSheetClose() {

        }

        override fun bottomSheetDetach() {
        }

        override fun bottomSheetAttach() {
        }
    }

}