package com.payu.ui.view.activities

import android.content.Intent
import android.content.res.ColorStateList
import android.graphics.Color
import android.graphics.PorterDuff
import android.graphics.PorterDuffColorFilter
import android.os.Build
import android.os.Bundle
import android.os.Handler
import android.os.SystemClock
import android.text.Editable
import android.text.InputFilter
import android.text.TextWatcher
import android.util.TypedValue
import android.view.MenuItem
import android.view.View
import android.view.ViewTreeObserver
import android.view.Window
import android.view.WindowManager
import android.view.animation.Animation
import android.view.animation.AnimationSet
import android.view.animation.AnimationUtils
import android.widget.Button
import android.widget.CheckBox
import android.widget.EditText
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.ProgressBar
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.activity.OnBackPressedCallback
import androidx.appcompat.app.AppCompatActivity
import androidx.cardview.widget.CardView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.constraintlayout.widget.Group
import androidx.core.content.ContextCompat
import androidx.core.view.isVisible
import androidx.core.widget.NestedScrollView
import androidx.core.widget.TextViewCompat
import androidx.core.widget.doOnTextChanged
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.google.android.material.appbar.AppBarLayout
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.payu.base.listeners.BaseTransactionListener
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.BottomSheetType
import com.payu.base.models.CardBinInfo
import com.payu.base.models.CardScheme
import com.payu.base.models.CardType
import com.payu.base.models.FetchOfferDetails
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.InternalConfig
import com.payu.base.models.OfferInfo
import com.payu.base.models.OrderDetails
import com.payu.base.models.PayUBillingCycle
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.base.models.SavedCardOption
import com.payu.base.models.SodexoCardOption
import com.payu.base.models.UPIOption
import com.payu.base.models.WalletOption
import com.payu.commonui.utils.CommonUIViewUtils
import com.payu.otpparser.Constants
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.adapters.OrderDetailsListAdapter
import com.payu.ui.model.listeners.HandleBackPress
import com.payu.ui.model.managers.NetworkManager
import com.payu.ui.model.managers.OfferFilterManager
import com.payu.ui.model.models.FragmentModel
import com.payu.ui.model.utils.AnalyticsConstant
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.CPCallbackType
import com.payu.ui.model.utils.HexColorValidator
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.MultipleClickHandler
import com.payu.ui.model.utils.PayUProgressDialog
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.SdkUiConstants.CP_CLOSED
import com.payu.ui.model.utils.SdkUiConstants.TAG_DYNAMIC_FRAGMENT
import com.payu.ui.model.utils.TextColorSelector
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.widgets.RoundedCornerBottomSheet
import com.payu.ui.view.fragments.BankFragment
import com.payu.ui.viewmodel.BaseViewModelFactory
import com.payu.ui.viewmodel.PaymentOptionViewModel
import java.util.Stack

class CheckoutActivity : AppCompatActivity(), RoundedCornerBottomSheet.OnBottomSheetListener,
    View.OnClickListener, View.OnFocusChangeListener {
    private var bottomSheetLayoutId: Int? = null
    private var paymentOptionViewModel: PaymentOptionViewModel? = null
    private var ivMerchantIcon: ImageView? = null
    private var tvAmount: TextView? = null
    private var ivOfferDetails: ImageView? = null
    private var tvOffer: TextView? = null
    private var rlBottomBar: ConstraintLayout? = null
    private var appBarLayout: AppBarLayout? = null
    private var roundedCornerBottomSheet: RoundedCornerBottomSheet? = null
    private var offerRoundedCornerBottomSheet: RoundedCornerBottomSheet? = null
    private var inflatedView: View? = null
    private var offerInflatedView: View? = null
    private var etCvvBottomSheet: EditText? = null
    private var btnPayBottomSheet: Button? = null
    private var ivToolTipCvv: ImageView? = null
    private var llPaymentSection: LinearLayout? = null
    private var transparentView: View? = null
    private var rlSavedCardBottomSheet: ConstraintLayout? = null
    private var saveCardOption: SavedCardOption? = null
    private var upiPackageName: String? = null
    private var phoneNumber: String? = null
    private var isActivityRecreated = false
    private var paymentOption: PaymentOption? = null

    // variable to track event time
    private var mLastClickTime: Long = 0
    private var orderDetailsArrayList: ArrayList<OrderDetails>? = null
    private var offerDetails: ArrayList<OfferInfo>? = null
    private var scrollViewSavedCard: NestedScrollView? = null
    private var globalLayoutListener: ViewTreeObserver.OnGlobalLayoutListener? = null
    private var ivPayULogo: ImageView? = null
    private var ivOrderDetails: ImageView? = null
    private var tvPrivacyPolicy: TextView? = null
    private var tvPayText: TextView? = null
    private var isBottomSheetDisplayed = false
    private var ivOffer: ImageView? = null
    private var tvOfferText: TextView? = null
    private var tvSIEnabledErrorForSavedCard: TextView? = null
    private var tvConsentText: TextView? = null
    private var rlCVV: RelativeLayout? = null
    private var rlAppBar: ConstraintLayout? = null
    private var rlCheckout: ConstraintLayout? = null
    private var rlfragment: LinearLayout? = null
    private var screenType: String? = null
    private var etOTPGv: EditText? = null
    private var pbOTPReadGv: ProgressBar? = null
    private var tvResendOTPGv: TextView? = null
    private var verificationPhoneNumber = ""
    private var isConsentChecked: Boolean ?= null
    private var pbSubmittingGv: ProgressBar? = null
    private var tvOTPInfoGv: TextView? = null
    private var tvVerifyOTPErrorGv: TextView? = null
    private var llVerifyBtnsGv: Group? = null
    private var tvResendOTPErrorGv: TextView? = null
    private var rlSubmittingBtnGv: Group? = null
    private var tvOTPVerificationLimitError: TextView? = null
    private var tvOTPErrorTextGv: TextView? = null
    private var etPhoneNumberGv: EditText? = null
    private var btnVerifyGv: Button? = null
    private var ivphonecodeiconGv: ImageView? = null
    private var fragmentStack = Stack<FragmentModel>()
    private var payUProgressDialog: PayUProgressDialog? = null;
    private var isSavedInstanceCalled: Boolean = false
    private var cvMerchantLogo: CardView? = null
    private var ivLeftArrow: ImageView? = null
    private var offerLayout: ConstraintLayout? = null
    private var fetchOfferDetails: FetchOfferDetails? = null
    private var tvOfferView: TextView? = null
    private var bottomSheetType: BottomSheetType? = null
    private var olwBottomSheet: BottomSheetDialogFragment? = null

    override fun onCreate(savedInstanceState: Bundle?) {

        // Extract data from the intent (if there is any)
        // Chrome Custom Tab (CCT) is not closed automatically. To close CCT, we fire the Intent
        // of CheckoutActivity and close the CCT
        if (intent != null && intent.extras != null) {
            val response = intent.extras?.getString(SdkUiConstants.RESPONSE)
            val map = HashMap<String, String>()
            map[SdkUiConstants.CP_PAYU_RESPONSE] = response.toString()
            map[SdkUiConstants.CP_MERCHANT_RESPONSE] = SdkUiConstants.CP_NULL
            if (response.equals(SdkUiConstants.CANCELLED)) {
                AnalyticsUtils.logCPCallbackEventKibana(this, CPCallbackType.Cancel)
                SdkUiInitializer.checkoutProListener?.onPaymentCancel(true)
            }
            else {
                AnalyticsUtils.logCPCallbackEventKibana(this, CPCallbackType.Success)
                SdkUiInitializer.checkoutProListener?.onPaymentSuccess(map)
            }
            finish()
        }

        if (SdkUiInitializer.apiLayer == null) {
            finish()
        }
        super.onCreate(null)
        window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            window.isNavigationBarContrastEnforced = false
        }
        if (SdkUiInitializer.apiLayer?.payUPaymentParams?.phone != null)
            verificationPhoneNumber = SdkUiInitializer.apiLayer?.payUPaymentParams?.phone!!
        initTheme()
        setContentView(R.layout.activity_checkout_collapsing)
        rlBottomBar = findViewById(R.id.rl_bottom_bar)
        llPaymentSection = findViewById(R.id.llPaymentSection)
        rlCheckout = findViewById(R.id.rlCheckout)
        ivPayULogo = rlBottomBar?.findViewById(R.id.ivPayuLogo)
        tvPrivacyPolicy = rlBottomBar?.findViewById(R.id.tvPrivacyPolicy)
        ivOrderDetails = findViewById(R.id.ivOrderDetails)
        rlfragment = findViewById(R.id.rlfragment)
        cvMerchantLogo = findViewById(R.id.cvMerchantLogo)
        rlBottomBar?.setOnClickListener(this)
        llPaymentSection?.setOnClickListener(this)
        offerLayout = findViewById(R.id.offerLayout)
        tvOffer = findViewById(R.id.tvOffer)
        ivOfferDetails = findViewById(R.id.ivOfferDetails)
        ivOrderDetails?.setOnClickListener(this)
        offerLayout?.setOnClickListener(this)
        tvOffer?.setOnClickListener(this)
        ivOfferDetails?.setOnClickListener(this)
        rlAppBar = findViewById(R.id.rl_app_bar)
        tvPrivacyPolicy?.setOnClickListener(this)
        if (SdkUiInitializer.apiLayer?.config?.showMerchantLogo != true) {
            SdkUiInitializer.apiLayer?.config?.merchantLogo = null
            SdkUiInitializer.apiLayer?.config?.merchantLogoUrl = null
        }
        if (!SdkUiInitializer.apiLayer?.config?.primaryColor.isNullOrEmpty() && SdkUiInitializer.apiLayer?.config?.baseTextColor.isNullOrEmpty()) {
            SdkUiInitializer.apiLayer?.config?.baseTextColor =
                TextColorSelector.getTextColorFromBackgroundColorString(
                    SdkUiInitializer.apiLayer?.config?.primaryColor!!, this
                )
        }

        initCollapsingItems()
        initViewModel(savedInstanceState)
        initColorFilter()
//        AnalyticsUtils.logDeviceAnalytics(this)

        orderDetailsArrayList = SdkUiInitializer.apiLayer?.config?.cartDetails
        ivOrderDetails?.visibility = View.VISIBLE


        /*  if(null!= orderDetailsArrayList && orderDetailsArrayList?.size!!>0){
          val payUSIParams = SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams

          if(null != orderDetailsArrayList && orderDetailsArrayList?.size!! > 0 || payUSIParams != null) {
              llOrderDetails?.visibility = View.VISIBLE
          } else {
              llOrderDetails?.visibility = View.GONE
          }*/


        if (null != SdkUiInitializer.apiLayer?.payUPaymentParams?.phone) {
            verificationPhoneNumber = SdkUiInitializer.apiLayer?.payUPaymentParams?.phone!!
        }

        if (null != savedInstanceState?.getBoolean(SdkUiConstants.CP_IS_BOTTOM_SHEET_VISIBLE)) {
            isBottomSheetDisplayed =
                savedInstanceState.getBoolean(SdkUiConstants.CP_IS_BOTTOM_SHEET_VISIBLE)
        }

        if (null != savedInstanceState?.getParcelable(SdkUiConstants.PAYMENT_OPTION)) {
            isActivityRecreated = true
            paymentOption = savedInstanceState.getParcelable(SdkUiConstants.PAYMENT_OPTION)
            if (null != savedInstanceState.get(SdkUiConstants.PAYMENT_OPTION_PACKAGE_NAME))
                upiPackageName =
                    savedInstanceState.getString(SdkUiConstants.PAYMENT_OPTION_PACKAGE_NAME)

            if (null != savedInstanceState.get(SdkUiConstants.PAYMENT_OPTION_PHONE_NUMBER))
                phoneNumber =
                    savedInstanceState.getString(SdkUiConstants.PAYMENT_OPTION_PHONE_NUMBER)

        }
        if (null != savedInstanceState?.getString(SdkUiConstants.CARD_TOKEN)) {
            isActivityRecreated = true

            saveCardOption = SavedCardOption()
            val cardBinInfo = CardBinInfo()

            saveCardOption?.cardToken =
                savedInstanceState.getString(SdkUiConstants.CARD_TOKEN)!!

            if (null != savedInstanceState.getString(SdkUiConstants.NAME_ON_CARD))
                saveCardOption?.nameOnCard =
                    savedInstanceState.getString(SdkUiConstants.NAME_ON_CARD)!!

            if (null != savedInstanceState.getString(SdkUiConstants.CARD_ALIAS))
                saveCardOption?.cardAlias =
                    savedInstanceState.getString(SdkUiConstants.CARD_ALIAS)!!


            if (null != savedInstanceState.getString(SdkUiConstants.DRAWABLE))
                saveCardOption?.drawable =
                    savedInstanceState.getParcelable(SdkUiConstants.DRAWABLE)!!

            if (null != savedInstanceState.getString(SdkUiConstants.CARD_NUMBER))
                saveCardOption?.cardNumber =
                    savedInstanceState.getString(SdkUiConstants.CARD_NUMBER)!!

            if (null != savedInstanceState.getString(SdkUiConstants.BANK_NAME)) {
                saveCardOption?.bankName =
                    savedInstanceState.getString(SdkUiConstants.BANK_NAME)!!
            }

            if (null != savedInstanceState.get(SdkUiConstants.PAYMENT_TYPE)) {
                val paymentType =
                    savedInstanceState.getSerializable(SdkUiConstants.PAYMENT_TYPE) as PaymentType
                saveCardOption?.paymentType = paymentType
            }

            if (null != savedInstanceState.get(SdkUiConstants.CARD_SCHEME)) {
                val cardScheme =
                    savedInstanceState.getSerializable(SdkUiConstants.CARD_SCHEME) as CardScheme
                cardBinInfo.cardScheme = cardScheme
            }

            if (null != savedInstanceState.get(SdkUiConstants.CARD_TYPE)) {
                val cardType =
                    savedInstanceState.getSerializable(SdkUiConstants.CARD_TYPE) as CardType
                cardBinInfo.cardType = cardType
            }
            saveCardOption?.cardBinInfo = cardBinInfo

            paymentOptionViewModel?.selectedPaymentOption = saveCardOption
        }

        addObservers()
        setBackPressHandler()
    }

    private fun initColorFilter() {
        ivOrderDetails?.setColorFilter(
            ContextCompat.getColor(
                applicationContext,
                R.color.one_payu_baseTextColor
            ), PorterDuff.Mode.SRC_IN
        )
    }

    private fun initTheme() {
        //Below code snippet sets the status bar color
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            val window: Window = window
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS)
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS)
            window.statusBarColor = resources.getColor(R.color.one_payu_colorPrimaryDark)
        }
        setTheme(R.style.OnePayuTheme)
    }

    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        isSavedInstanceCalled = true
        val bottomSheetFragment =
            supportFragmentManager.findFragmentByTag(SdkUiConstants.CP_BOTTOM_SHEET_FRAGMENT)
        if (bottomSheetFragment == null || (null != paymentOptionViewModel && paymentOptionViewModel!!.offerDetailsInflated))
            outState.putBoolean(SdkUiConstants.CP_IS_BOTTOM_SHEET_VISIBLE, false)
        else
            outState.putBoolean(SdkUiConstants.CP_IS_BOTTOM_SHEET_VISIBLE, true)

        if (null != paymentOptionViewModel?.selectedPaymentOption) {

            outState.putString(
                SdkUiConstants.NAME,
                paymentOptionViewModel?.selectedPaymentOption?.bankName
            )
            outState.putBoolean(
                SdkUiConstants.IS_PAYMENT_DOWN,
                paymentOptionViewModel?.selectedPaymentOption?.isBankDown!!
            )
        }


        if (null != paymentOptionViewModel?.selectedPaymentOption && paymentOptionViewModel?.selectedPaymentOption is SavedCardOption) {
            var savedCardOption =
                paymentOptionViewModel?.selectedPaymentOption as SavedCardOption

            outState.putString(
                SdkUiConstants.CARD_TOKEN,
                savedCardOption.cardToken
            )
            outState.putString(
                SdkUiConstants.NAME_ON_CARD,
                savedCardOption.nameOnCard
            )
            outState.putString(
                SdkUiConstants.CARD_ALIAS,
                savedCardOption.cardAlias
            )
            outState.putString(
                SdkUiConstants.BANK_NAME,
                savedCardOption.bankName
            )
            outState.putString(
                SdkUiConstants.CARD_NUMBER,
                savedCardOption.cardNumber
            )
            outState.putSerializable(
                SdkUiConstants.CARD_SCHEME,
                savedCardOption.cardBinInfo?.cardScheme
            )
            outState.putSerializable(
                SdkUiConstants.CARD_TYPE,
                savedCardOption.cardBinInfo?.cardType
            )
            outState.putSerializable(
                SdkUiConstants.PAYMENT_TYPE,
                savedCardOption.paymentType
            )
            outState.putParcelable(
                SdkUiConstants.DRAWABLE,
                savedCardOption.drawable
            )

        }
        if (null != paymentOption) {

            outState.putParcelable(
                SdkUiConstants.PAYMENT_OPTION,
                paymentOption
            )
            if (paymentOption is UPIOption) {
                outState.putString(
                    SdkUiConstants.PAYMENT_OPTION_PACKAGE_NAME,
                    (paymentOption as UPIOption).packageName
                )
            }
            if (paymentOption is WalletOption) {
                outState.putString(
                    SdkUiConstants.PAYMENT_OPTION_PHONE_NUMBER,
                    (paymentOption as WalletOption).phoneNumber
                )
            }

        }
    }

    private fun initViewModel(savedInstanceState: Bundle?) {
        showLoaderDialog(true)
        val map = HashMap<String, Any>()
        paymentOptionViewModel =
            ViewModelProvider(this, BaseViewModelFactory(application, map)).get(
                PaymentOptionViewModel::class.java
            )
        SdkUiInitializer.apiLayer?.connectListener(
            this,
            paymentOptionViewModel as BaseTransactionListener
        )
        /**
         * Initialise NFC so that it would download all the required files by when user will reach Card Screen
         */
        /**
         * Hiding the soft keyboard first if SDK was invoked with keyboard open
         * */
        Handler().postDelayed({
            paymentOptionViewModel?.fetchPaymentOptions(savedInstanceState)
            paymentOptionViewModel?.fetchOfferDetails()
        }, 200)
        if (SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.isPreAuthTxn != true) {
            paymentOptionViewModel?.showUnlockSavedOptionsGlobalVault()
        }

//        adsInformationViewModel = ViewModelProvider(this).get(AdsInformationViewModel::class.java)
    }

    fun collapseToolbar() {

        appBarLayout?.setExpanded(false, true)

    }


    private fun addObservers() {
        paymentOptionViewModel?.loadFragment?.observe(this, Observer { fragmentModel ->
            hideLoaderDialog()
            /* fragmentTransaction.setCustomAnimations(R.anim.payu_fade_in, R.anim.payu_fade_out,
                    R.anim.payu_fade_in, R.anim.payu_fade_out)*/
            /* fragmentTransaction.setCustomAnimations(R.anim.payu_fade_in, R.anim.payu_fade_out,
                     R.anim.payu_fade_in, R.anim.payu_fade_out)*/
            if (fragmentModel.tag == TAG_DYNAMIC_FRAGMENT) {
                dynamicFrag(fragmentModel)
            } else {
                normalFragment(fragmentModel)
            }
        })
        paymentOptionViewModel?.retryError?.observe(this) { value ->
            val message = "${value.getContentIfNotHandled()}"

            ViewUtils.showSnackBar(
                message,
                R.drawable.payu_cards_placeholder,
                this
            )
        }
        paymentOptionViewModel?.headerAmount?.observe(
            this,
            Observer { amount -> tvAmount?.text = amount })

        paymentOptionViewModel?.payText?.observe(
            this,
            Observer { payText ->
                tvPayText?.text = payText
            })

        paymentOptionViewModel?.merchantIcon?.observe(
            this,
            Observer { icon ->
                cvMerchantLogo?.visibility = View.VISIBLE
                ImageViewUtils.setImage(findViewById(R.id.img_merchant_logo), icon)
            }
        )

        paymentOptionViewModel?.showBottomSheet?.observe(this, Observer {
            bottomSheetLayoutId = it.first
            roundedCornerBottomSheet =
                it.second?.let { second -> RoundedCornerBottomSheet.newInstance(it.first, second) }
                    ?: kotlin.run { RoundedCornerBottomSheet.newInstance(it.first) }
            roundedCornerBottomSheet?.show(
                supportFragmentManager,
                SdkUiConstants.CP_BOTTOM_SHEET_FRAGMENT
            )
        })
        paymentOptionViewModel?.showOfferBottomSheet?.observe(this, Observer {
            if (!isBottomSheetDisplayed) {
                bottomSheetLayoutId = it.first
                offerRoundedCornerBottomSheet =
                    RoundedCornerBottomSheet.newInstance(it.first, it.second)
                offerRoundedCornerBottomSheet?.show(
                    supportFragmentManager,
                    SdkUiConstants.CP_BOTTOM_SHEET_FRAGMENT
                )
            }
        })
        paymentOptionViewModel?.showL1BottomSheet?.observe(this, Observer {
            bottomSheetLayoutId = it.first
            bottomSheetType = BottomSheetType.L1_BOTTOM_SHEET
            roundedCornerBottomSheet =
                RoundedCornerBottomSheet.newInstance(it.first)
            roundedCornerBottomSheet?.show(
                supportFragmentManager,
                SdkUiConstants.CP_BOTTOM_SHEET_FRAGMENT
            )
        })

        paymentOptionViewModel?.showOfferAppliedTag?.observe(this) {
            if (it.getContentIfNotHandled() == true) {
                tvOfferView?.visibility = View.VISIBLE
            } else {
                tvOfferView?.visibility = View.GONE
            }
        }

        paymentOptionViewModel?.showProgressDialog?.observe(this, Observer { showProgressDialog ->
            if (showProgressDialog)
                showLoaderDialog(true)
            else
                hideLoaderDialog()
        })

        paymentOptionViewModel?.showAndroidLoader?.observe(this) {
            if (it.getContentIfNotHandled() == true)
                ViewUtils.showProgressDialog(this)
            else
                ViewUtils.hideProgressDialog()
        }

        paymentOptionViewModel?.showLoaderScreen?.observe(this) {
            if (it) {
                showLoaderDialog()
            } else {
                hideLoaderDialog()
            }
        }

        paymentOptionViewModel?.apiError?.observe(this, Observer { errorResponse ->
            AnalyticsUtils.logCPCallbackEventKibana(this, CPCallbackType.Error)
            SdkUiInitializer.checkoutProListener?.onError(errorResponse)
            finish()
        })

        paymentOptionViewModel?.flowComplete?.observe(this, Observer { flowComplete ->
            if (flowComplete) {
                hideLoaderDialog()
                finish()
            }
        })

        paymentOptionViewModel?.hideBottomFooter?.observe(this, Observer { hideBottomView ->

            if (hideBottomView)
                rlBottomBar?.visibility = View.GONE
            else
                rlBottomBar?.visibility = View.VISIBLE
        })

        paymentOptionViewModel?.hideBackNavigation?.observe(this, Observer { hideBackButton ->

            if (hideBackButton)
                supportActionBar?.setDisplayHomeAsUpEnabled(false)
            else
                supportActionBar?.setDisplayHomeAsUpEnabled(true)
        })

        paymentOptionViewModel?.expandToolbar?.observe(this, Observer {
            if (it) appBarLayout?.setExpanded(true) else appBarLayout?.setExpanded(false)
        })

        paymentOptionViewModel?.hideSoftKeyboard?.observe(this, Observer {
            if (it) ViewUtils.hideSoftKeyboard(this)
        })

        paymentOptionViewModel?.popBackStack?.observe(this, Observer {
            if (it) {
                supportFragmentManager.popBackStack()
                if (fragmentStack.isNotEmpty()) {
                    fragmentStack.pop()
                }
            }
        })

        // For retry of OTM, we will clear backstack to handle the back press properly
        paymentOptionViewModel?.retryFlow?.observe(this) {
            if (it) {
                val count = supportFragmentManager.backStackEntryCount
                for (i in 0 until count) {
                    supportFragmentManager.popBackStack()
                }
                fragmentStack.clear()
            }
        }

        paymentOptionViewModel?.showSnackBar?.observe(this, Observer {
            if (it != null) ViewUtils.showSnackBar(it.message, it.icon, this)
        })

        paymentOptionViewModel?.hideBottomSheet?.observe(this, Observer {
            if (it) hideBottomSheet()
        })

        paymentOptionViewModel?.updateSavedCardBottomSheet?.observe(this, Observer {
            if (it != null) setSavedCardInfo(it, inflatedView)
        })
        paymentOptionViewModel?.updateSodexoCardBottomSheet?.observe(this, Observer {
            if (it != null) setSodexoCardInfo(it, inflatedView)
        })

        paymentOptionViewModel?.updateExitDialogBottomSheet?.observe(this, Observer {
            if (it) setExitDialogInfo(inflatedView)
        })

        paymentOptionViewModel?.updateOrderDetailsBottomSheet?.observe(this, Observer {
            if (it) setOrderDetailsInfo(inflatedView)
        })

        paymentOptionViewModel?.updateOfferDetailsBottomSheet?.observe(this, Observer {
            offerInflatedView = inflatedView
            if (it) setOfferDetailsInfo(offerInflatedView)
        })

        paymentOptionViewModel?.updateSkuDetailsBottomSheet?.observe(this) {
            if (it) setSKUOfferDetailsInfo(inflatedView)
        }

        paymentOptionViewModel?.updateBankBottomSheet?.observe(this, Observer {
            if (it != null) {
                paymentOption = it
                setBankBottomSheetInfo(it, inflatedView)
            }
        })

        paymentOptionViewModel?.cvvLengthFilter?.observe(this, Observer {
            etCvvBottomSheet?.filters = arrayOf<InputFilter>(InputFilter.LengthFilter(it))
            etCvvBottomSheet?.addTextChangedListener(object : TextWatcher {
                override fun afterTextChanged(s: Editable) {
                    paymentOptionViewModel?.bottomsheetCvvTextChanged(s.toString(), it)
                }

                override fun beforeTextChanged(
                    s: CharSequence?,
                    start: Int,
                    count: Int,
                    after: Int
                ) {
                }

                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                }

            })
        })

        paymentOptionViewModel?.enablePayButtonBottomSheet?.observe(this, Observer {
            if (it && tvSIEnabledErrorForSavedCard?.visibility == View.GONE)
                ViewUtils.enableView(btnPayBottomSheet)
            else
                ViewUtils.disableView(btnPayBottomSheet)
        })

        paymentOptionViewModel?.savedCardCvvToolTip?.observe(this, Observer {
            if (it != null) {
                ViewUtils.showImageToolTip(this, ivToolTipCvv!!, rlSavedCardBottomSheet, it)
            }
        })

        paymentOptionViewModel?.showTransparentView?.observe(this, Observer {
            if (it) showTranparentView() else hideTransparentView()
        })

        paymentOptionViewModel?.hideToolTip?.observe(this, Observer {
            if (it) ViewUtils.hideToolTip()
        })

        paymentOptionViewModel?.showSavedCardOfferUI?.observe(this, Observer {
            if (it) ivOffer?.visibility = View.VISIBLE else ivOffer?.visibility = View.GONE
            if (it) tvOfferText?.visibility = View.VISIBLE else tvOfferText?.visibility = View.GONE
        })

        paymentOptionViewModel?.savedCardOfferText?.observe(this, Observer {
            tvOfferText?.text = it
        })

        paymentOptionViewModel?.savedCardCvvFieldColor?.observe(this, Observer {
            rlCVV?.setBackgroundResource(it)
        })

        paymentOptionViewModel?.isSISupportedForSavedCard?.observe(this, Observer {
            if (it != null && !it) {
                ivOffer?.visibility = View.GONE
                tvOfferText?.visibility = View.GONE
                tvSIEnabledErrorForSavedCard?.visibility = View.VISIBLE
                tvConsentText?.visibility = View.VISIBLE
            } else {
                tvSIEnabledErrorForSavedCard?.visibility = View.GONE
                tvConsentText?.visibility = View.VISIBLE
            }
        })

        paymentOptionViewModel?.showOfferIcon?.observe(this) {
            this.fetchOfferDetails = it
            if (it != null || (InternalConfig.couponsAvailable && InternalConfig.userSelectedOfferInfo==null)) {
                offerLayout?.visibility = View.VISIBLE
            } else {
                offerLayout?.visibility = View.GONE
            }
        }

        paymentOptionViewModel?.checkoutScreenName?.observe(this, Observer {
            if (it != null) {
                screenType = it
            }
        })

        paymentOptionViewModel?.updateConfigView?.observe(this, { it ->
            if (it != null && it) {
                val backIcon = resources.getDrawable(R.drawable.payu_left_arrow)
                ViewUtils.updateSVGColor(
                    this, backIcon,
                    SdkUiInitializer?.apiLayer?.config?.baseTextColor,
                    R.color.one_payu_baseTextColor
                )

                supportActionBar?.setHomeAsUpIndicator(backIcon)

                tvAmount!!.visibility = View.VISIBLE
                tvPayText!!.visibility = View.VISIBLE
                ivMerchantIcon!!.visibility = View.VISIBLE
                ivOrderDetails?.visibility = View.VISIBLE
            }
            rlCheckout?.visibility = View.VISIBLE

            ViewUtils.updateBackgroundColor(
                this, rlCheckout,
                SdkUiInitializer.apiLayer?.config?.primaryColor, R.color.one_payu_colorPrimary
            )

            ViewUtils.updateBackgroundColor(
                this, rlAppBar,
                SdkUiInitializer.apiLayer?.config?.primaryColor, R.color.one_payu_colorPrimary
            )

            if (!SdkUiInitializer.apiLayer?.config?.primaryColorDark.isNullOrEmpty() &&
                HexColorValidator.validate(SdkUiInitializer.apiLayer?.config?.primaryColorDark)
            )
                setStatusBarColor(Color.parseColor(SdkUiInitializer.apiLayer?.config?.primaryColorDark))
            else
                setStatusBarColor(resources.getColor(R.color.one_payu_colorPrimaryDark))

            if (!SdkUiInitializer.apiLayer?.config?.merchantLogoUrl.isNullOrEmpty())
                SdkUiInitializer.apiLayer?.config?.merchantLogoUrl?.let { it1 ->
                    paymentOptionViewModel?.getImage(
                        it1
                    )
                }
            updateToolbarViewColor()
        })

        paymentOptionViewModel?.updateOTPBottomSheet?.observe(this) {
            if (it) setEnterPhoneBottomSheetInfo(inflatedView)
        }
        paymentOptionViewModel?.gvShowOTPModeBottomSheet?.observe(this) {
            setGlobalVaultAuthenticationBottomSheetInfo(inflatedView, it)
            paymentOptionViewModel?.prepareSmsListener()
        }
        paymentOptionViewModel?.gvResendOTPTimeInt?.observe(
            this
        ) {
            if (it > 1) {
                tvResendOTPGv?.text = applicationContext?.getString(
                    R.string.payu_resend_otp_counter, "" + it
                )
                tvResendOTPGv?.isClickable = false
                tvResendOTPGv?.setTextColor(
                    ContextCompat.getColor(
                        this.baseContext,
                        R.color.payu_color_7b7b7b
                    )
                )
            } else {
                tvResendOTPGv?.isClickable = true
                tvResendOTPGv?.text = applicationContext?.getString(R.string.payu_resend_otp)
                ViewUtils.updateTextColor(
                    this,
                    tvResendOTPGv,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
            }
            if (it > 15 && etOTPGv?.text?.isEmpty() == true) {
                etOTPGv?.hint = applicationContext?.getString(
                    R.string.payu_reading_otp_timer, "" + (it - 15)
                )
                pbOTPReadGv?.visibility = View.VISIBLE
            } else {
                etOTPGv?.hint = applicationContext?.getString(R.string.payu_enter_otp)
                pbOTPReadGv?.visibility = View.GONE
            }
        }
        // To display error on Resend OTP sheet.
        paymentOptionViewModel?.gvResendOTPError?.observe(
            this
        ) {
            tvResendOTPErrorGv?.text = it
        }

        //Display progress on click of submit button
        paymentOptionViewModel?.gvSubmittingTimeInt?.observe(
            this
        ) {
            pbSubmittingGv?.progress = it
        }
        // to handle the successful verification of OTP process
        paymentOptionViewModel?.fetchGVData?.observe(
            this
        ) {
            AnalyticsUtils.logOtpSubmission(
                this.baseContext,
                AnalyticsConstant.CP_OTP_SUBMISSION_STATUS,
                AnalyticsConstant.CP_COMPLETED
            )
            AnalyticsUtils.logOtpSubmissionForKibana(
                this.baseContext,
                AnalyticsConstant.CP_OTP_SUBMISSION_STATUS,
                AnalyticsConstant.CP_COMPLETED
            )
            //To fetch global vault list
            paymentOptionViewModel?.fetchGlobalVault(
                Utils.getGlobalVaultStoredUserToken(baseContext),
                true
            )
        }
        paymentOptionViewModel?.gvVerifyOTPError?.observe(
            this
        ) {
            tvVerifyOTPErrorGv?.text = it
            llVerifyBtnsGv?.visibility = View.VISIBLE
            rlSubmittingBtnGv?.visibility = View.GONE
        }

        paymentOptionViewModel?.gvVerifyOTPExceedError?.observe(this) {
            if (it) {
                tvOTPVerificationLimitError?.visibility = View.GONE
            } else {
                tvOTPVerificationLimitError?.visibility = View.VISIBLE
            }
        }

        paymentOptionViewModel?.logoutBottomSheet?.observe(this) {
            if (it) setSettingsBottomSheetInfo(inflatedView)
        }
        // to display error
        paymentOptionViewModel?.gvSendOTPError?.observe(
            this
        )
        {
            tvOTPErrorTextGv?.text = it
            tvOTPErrorTextGv?.visibility = View.VISIBLE

        }

        paymentOptionViewModel?.showChangeOfferView?.observe(this, Observer {
            if (InternalConfig.emiOfferInfo != null) {
                val totalInstantDiscount = InternalConfig.emiOfferInfo?.nceDiscount?.instant?.plus(
                    InternalConfig.emiOfferInfo?.offerDiscount?.instant ?: 0.0
                )
                paymentOptionViewModel?.updateHeaderAmount(
                    SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull()
                        ?.minus(totalInstantDiscount ?: 0.0),
                    gstPercentageValue = paymentOption?.gstPercentageValue ?: 0.0,
                    additionalCharge = paymentOption?.additionalCharge ?: 0.0,
                    isOfferValid = totalInstantDiscount != null
                )
            } else if (InternalConfig.isPaymentOptionSelected || InternalConfig.userSelectedOfferInfo!=null || InternalConfig.selectedOfferInfo!= null) {
                paymentOptionViewModel?.updateHeaderAmount(
                    gstPercentageValue = paymentOption?.gstPercentageValue ?: 0.0,
                    amount = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull()
                        ?.minus(InternalConfig.selectedOfferInfo?.totalInstantDiscount ?: 0.0),
                    additionalCharge = paymentOption?.additionalCharge ?: 0.0,
                    isOfferValid = it
                )
            } else {
                paymentOptionViewModel?.resetHeaderAmount(paymentOptionViewModel?.isEnachPayment() ?: false)
            }
        })

        paymentOptionViewModel?.selectedOption?.observe(this) {
            paymentOption = it
        }

        paymentOptionViewModel?.verifyButtonVisibility?.observe(this) {
            if (it) {
                ViewUtils.enableView(btnVerifyGv)
            } else {
                ViewUtils.disableView(btnVerifyGv)
            }
        }

        paymentOptionViewModel?.readOtpGV?.observe(this) {
            etOTPGv?.text = it
        }

        paymentOptionViewModel?.hideOlwBottomSheet?.observe(this){
            olwBottomSheet?.dismiss()
            olwBottomSheet = null
        }

        paymentOptionViewModel?.showVerifyOtpBottomSheet?.observe(this) {
            val data = it.getContentIfNotHandled()
            if(data != null) {
                setEnterPhoneBottomSheetInfo(inflatedView)
                paymentOptionViewModel?.initiateSMSReader(this@CheckoutActivity)
                setGlobalVaultAuthenticationBottomSheetInfo(view = inflatedView, true, postVerificationAction = data.postVerifyAction)
                tvOTPInfoGv?.text = data.verifyOtpDesc
                paymentOptionViewModel?.prepareSmsListener()
            }
        }

        paymentOptionViewModel?.showCouponError?.observe(this) {
            val data = it.getContentIfNotHandled()
            if(data?.first == true) {
                val tvCouponError = offerInflatedView?.findViewById<TextView>(R.id.tvCouponError)
                tvCouponError?.text = data.second ?: getString(R.string.this_coupon_is_invalid)
            }
        }

        paymentOptionViewModel?.hideOtpBottomSheet?.observe(this) {
            val data = it.getContentIfNotHandled()
            if(data == true) {
                hideBottomSheet(ignoreOffer = true)
            }
        }


        paymentOptionViewModel?.showOlwBottomSheet?.observe(this, Observer {
            olwBottomSheet?.dismiss()
            olwBottomSheet = it
            it?.show(
                supportFragmentManager,
                SdkUiConstants.CP_BOTTOM_SHEET_FRAGMENT
            )
        })
    }

    private fun dynamicFrag(fragmentModel: FragmentModel) {
        hideLoaderDialog()
        val fragmentTransaction = supportFragmentManager.beginTransaction()
        collapseToolbar()

        paymentOptionViewModel?.hideSoftKeyboard?.value = true
        fragmentModel.handleBackPress = object : HandleBackPress {
            override fun onBackPressed() {
                fragmentModel.fragment?.let {
                    SdkUiInitializer.apiLayer?.onBackPressed(it)
                }

            }
        }
//        rlCheckout?.visibility = View.GONE
        rlfragment?.visibility = View.VISIBLE
        fragmentStack.add(fragmentModel)
        if (fragmentModel.addToBackStack) {
            fragmentTransaction.add(R.id.dynamic_fragment, fragmentModel.fragment!!)
                .addToBackStack(fragmentModel.tag)
                .commit()

        } else {
            fragmentTransaction.add(
                R.id.dynamic_fragment,
                fragmentModel.fragment!!,
                fragmentModel.tag
            )
                .commit()
        }
        supportFragmentManager.executePendingTransactions()
        offerLayout?.visibility = View.GONE
        hideLoaderDialog()
    }

    private fun normalFragment(fragmentModel: FragmentModel) {
        //since paymentOptionFragment is Home hence removing all pending fragment and adding the paymentOptionFragment
        // TODO: use HOME as tag instead of TAG_PAYMENT_OPTION_FRAGMENT and set HOME as tag for both the cases enforced and non-enforce
        if (fragmentModel.tag == SdkUiConstants.TAG_PAYMENT_OPTION_FRAGMENT) {
            for (fragment in supportFragmentManager.fragments) {
                supportFragmentManager.beginTransaction().remove(fragment).commit()
            }
        }
        val fragmentTransaction = supportFragmentManager.beginTransaction()
        rlCheckout?.visibility = View.VISIBLE
        rlfragment?.visibility = View.GONE
        fragmentStack.add(fragmentModel)
        if (fragmentModel.addToBackStack) {
            fragmentTransaction.replace(R.id.fragment_container, fragmentModel.fragment!!)
                .addToBackStack(fragmentModel.tag)
                .commit()

        } else {
            fragmentTransaction.replace(
                R.id.fragment_container,
                fragmentModel.fragment!!,
                fragmentModel.tag
            )
                .commit()
        }
        supportFragmentManager.executePendingTransactions()
        // offerLayout?.visibility = View.VISIBLE
        hideLoaderDialog()

    }

    private fun updateToolbarViewColor() {
        if (!SdkUiInitializer.apiLayer?.config?.baseTextColor.isNullOrEmpty()) {
            ViewUtils.updateTextColor(
                this,
                tvAmount,
                SdkUiInitializer.apiLayer?.config?.baseTextColor, R.color.one_payu_baseTextColor
            )

            ViewUtils.updateTextColor(
                this,
                tvOffer,
                SdkUiInitializer.apiLayer?.config?.baseTextColor, R.color.one_payu_baseTextColor
            )

            ivOfferDetails?.let {
                ViewUtils.updateSVGColor(
                    this,
                    it,
                    SdkUiInitializer.apiLayer?.config?.baseTextColor, R.color.one_payu_baseTextColor
                )
            }

            ivOrderDetails?.let {
                ViewUtils.updateSVGColor(
                    this,
                    it,
                    SdkUiInitializer.apiLayer?.config?.baseTextColor, R.color.one_payu_baseTextColor
                )
            }

            ViewUtils.updateTextColor(
                this,
                tvPayText,
                SdkUiInitializer.apiLayer?.config?.baseTextColor, R.color.one_payu_baseTextColor
            )

            ViewUtils.updateTextColor(
                this,
                tvPrivacyPolicy,
                SdkUiInitializer.apiLayer?.config?.baseTextColor, R.color.one_payu_baseTextColor
            )

            ivPayULogo?.let {
                ViewUtils.updateSVGColor(
                    this, it,
                    SdkUiInitializer?.apiLayer?.config?.baseTextColor,
                    R.color.one_payu_baseTextColor
                )
            }

            ivLeftArrow?.let {
                ViewUtils.updateSVGColor(
                    this,
                    it,
                    SdkUiInitializer.apiLayer?.config?.baseTextColor,
                    R.color.one_payu_baseTextColor
                )
            }
        }
    }

    private fun setStatusBarColor(parseColor: Int) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            val window: Window = window
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS)
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS)
            window.statusBarColor = parseColor
        }
    }

    private fun showTranparentView() {
        globalLayoutListener =
            ViewUtils.attachViewTreeListener(rlSavedCardBottomSheet, transparentView)
        transparentView?.visibility = View.VISIBLE
        //disable scroll when transparent view is visible
        scrollViewSavedCard?.setOnTouchListener({ v, event -> true })
    }

    private fun hideTransparentView() {
        ViewUtils.removeViewTreeListener(globalLayoutListener, rlSavedCardBottomSheet)
        transparentView?.visibility = View.GONE
        //enable scroll when transparent view is hidden
        scrollViewSavedCard?.setOnTouchListener(null)
    }

    private fun initCollapsingItems() {

        tvAmount = findViewById(R.id.tv_amount)
        tvPayText = findViewById(R.id.tv_pay_text)
        ivLeftArrow = findViewById(R.id.payu_header_left_arrow)
        ivLeftArrow?.setOnClickListener(this)
        setAutoTextSizeProperty()
        ivMerchantIcon = findViewById(R.id.img_merchant_logo)
        appBarLayout = findViewById(R.id.appbar)

        if (!offerDetails.isNullOrEmpty()) {
            offerLayout?.visibility = View.VISIBLE
        } else {
            offerLayout?.visibility = View.GONE
        }

        if (SdkUiInitializer.apiLayer?.config?.showMerchantLogo == true) {
            findViewById<CardView>(R.id.cvMerchantLogo)?.visibility =
                View.VISIBLE
        }
        //Handle the views when app bar is expanded
        tvAmount?.alpha = (1f)
        ivOrderDetails?.alpha = (1f)
        ivMerchantIcon?.apply {
            alpha = 1f
        }
        supportActionBar?.setDisplayHomeAsUpEnabled(false)

        val backIcon = resources.getDrawable(R.drawable.payu_left_arrow)
        val porterDuff = PorterDuffColorFilter(
            resources.getColor(R.color.one_payu_baseTextColor),
            PorterDuff.Mode.SRC_IN
        )
        backIcon.colorFilter = porterDuff
        supportActionBar?.setHomeAsUpIndicator(backIcon)
    }

    private fun setAutoTextSizeProperty() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            tvAmount?.setAutoSizeTextTypeUniformWithConfiguration(
                14, 32, 1, TypedValue.COMPLEX_UNIT_DIP
            )
            tvPayText?.setAutoSizeTextTypeUniformWithConfiguration(
                12, 14, 1, TypedValue.COMPLEX_UNIT_DIP
            )
        } else {
            tvAmount?.let {
                TextViewCompat.setAutoSizeTextTypeUniformWithConfiguration(
                    it, 14, 32, 1,
                    TypedValue.COMPLEX_UNIT_DIP
                )
            }
            tvPayText?.let {
                TextViewCompat.setAutoSizeTextTypeUniformWithConfiguration(
                    it, 12, 14, 1,
                    TypedValue.COMPLEX_UNIT_DIP
                )
            }
        }
    }

    override fun onResume() {
        super.onResume()
        if (paymentOptionViewModel?.selectedPaymentMode?.type == PaymentType.UPI) {
//            paymentOptionViewModel?.rePreparePaymentOption()
        }
    }

    private fun showAnimation() {
        val animationSet = AnimationSet(true)
        animationSet.addAnimation(AnimationUtils.loadAnimation(this, R.anim.shake))
        animationSet.setAnimationListener(object : Animation.AnimationListener {
            override fun onAnimationRepeat(animation: Animation?) {
            }

            override fun onAnimationEnd(animation: Animation?) {
                Handler().postDelayed({ ivOfferDetails?.startAnimation(animationSet) }, 2000)
            }

            override fun onAnimationStart(animation: Animation?) {
            }

        })
        ivOfferDetails?.startAnimation(animationSet)
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {

        when (item.itemId) {
            android.R.id.home -> handleBackpress()
        }

        return super.onOptionsItemSelected(item)
    }

    /**
     * Hides the bottom sheet and removes the translucent overlay from UI
     */
    private fun hideBottomSheet(ignoreOffer: Boolean = false) {
        inflatedView = null
        paymentOptionViewModel?.resetBottomSheetFlags()
        roundedCornerBottomSheet?.dismiss()
        roundedCornerBottomSheet = null
        if(ignoreOffer.not()) {
            offerInflatedView = null
            offerRoundedCornerBottomSheet?.dismiss()
            offerRoundedCornerBottomSheet = null
        }
        isBottomSheetDisplayed = false
    }


    private fun removeReplacedFragment() {
        val fragment =
            supportFragmentManager.findFragmentByTag(SdkUiConstants.TAG_REPLACED_FRAGMENT)
        fragment?.let {
            fragmentStack.pop()
            supportFragmentManager.beginTransaction().remove(it).commit()
        }
    }

    private fun handleBackpress() {
        removeReplacedFragment()
        if (supportFragmentManager.backStackEntryCount > 0) {
            val fragmentName =
                supportFragmentManager.getBackStackEntryAt(supportFragmentManager.backStackEntryCount - 1)
                    .name
            paymentOptionViewModel?.handleBackpress(
                supportFragmentManager.backStackEntryCount,
                fragmentName, fragmentStack
            )
            if (supportFragmentManager.backStackEntryCount > 1)
                AnalyticsUtils.logBackButtonClickEvent(
                    applicationContext,
                    SdkUiConstants.CP_CHECKOUT_BACK_BUTTON,
                    screenType!!,
                    false
                )
        } else {
            this.finish()
        }
    }


    /**
     * Get inflated view of the bottom sheet
     * @param view
     * */
    override fun getInflatedView(view: View, roundedCornerBottomSheet: RoundedCornerBottomSheet) {
        /**
         * Dismiss any bottom sheet not loaded from this activity
         * */
        if (!isBottomSheetDisplayed) {
            roundedCornerBottomSheet.dismiss()
            return
        }

        inflatedView = view
        if (null != saveCardOption) {
            if (this.roundedCornerBottomSheet == null)
                this.roundedCornerBottomSheet = roundedCornerBottomSheet
            setSavedCardInfo(saveCardOption!!, view)

        } else {
            if (null != paymentOption && isActivityRecreated) {
                if (this.roundedCornerBottomSheet == null)
                    this.roundedCornerBottomSheet = roundedCornerBottomSheet
                when {
                    paymentOption?.paymentType == PaymentType.UPI -> {
                        val upiOption = UPIOption()
                        preparePaymentOption(upiOption, paymentOption!!)
                        upiOption.packageName = upiPackageName!!
                        setBankBottomSheetInfo(upiOption, view)
                    }

                    paymentOption?.paymentType == PaymentType.WALLET -> {
                        val walletOption = WalletOption()
                        preparePaymentOption(walletOption, paymentOption!!)
                        walletOption.phoneNumber = phoneNumber!!
                        setBankBottomSheetInfo(walletOption, view)
                    }
                }
                paymentOption = null

            } else paymentOptionViewModel?.bottomSheetViewInflated()

        }
    }

    private fun preparePaymentOption(specificOption: PaymentOption, paymentOption: PaymentOption) {

        specificOption.bankName = paymentOption.bankName
        specificOption.isBankDown = paymentOption.isBankDown
        specificOption.drawable = paymentOption.drawable
        specificOption.otherParams = paymentOption.otherParams
        specificOption.paymentType = paymentOption.paymentType
    }

    override fun handleBottomSheetClose() {
        window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN)
        tvSIEnabledErrorForSavedCard?.visibility = View.GONE
        tvConsentText?.visibility = View.GONE
        paymentOptionViewModel?.resetBottomSheetFlags()
    }

    override fun bottomSheetDetach() {
        when (bottomSheetType) {
            BottomSheetType.L1_BOTTOM_SHEET -> {
                InternalConfig.selectedOfferInfo?.let {
                    if (InternalConfig.selectedOfferInfo?.isAutoApply == true && InternalConfig.removeOfferIfNeeded) {
                        InternalConfig.isPaymentOptionSelected = false
                        paymentOptionViewModel?.showChangeOfferView(false)
                    }
                    if(InternalConfig.removeOfferIfNeeded) {
                        InternalConfig.selectedOfferInfo = null
                    }
                }
                InternalConfig.removeOfferIfNeeded = true
            }

            else -> {}
        }
        paymentOptionViewModel?.stopSmsListener()
        isBottomSheetDisplayed = false
    }

    override fun bottomSheetAttach() {
        isBottomSheetDisplayed = true
    }

    private fun setExitDialogInfo(view: View?) {
        val btnNo = view?.findViewById<Button>(R.id.btnNo)
        ViewUtils.updateBackgroundColor(
            this,
            btnNo,
            SdkUiInitializer?.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(btnNo, SdkUiInitializer?.apiLayer?.config?.baseTextColor)

        btnNo
            ?.setOnClickListener {
//                AnalyticsUtils.logConfirmationDialogEvent(applicationContext, SdkUiConstants.CP_NO, SdkUiConstants.CP_SCREEN_CHECKOUT_L1)
                paymentOptionViewModel?.exitDialogNoClicked()
            }

        view?.findViewById<TextView>(R.id.tvYes)
            ?.setOnClickListener {
//                AnalyticsUtils.logConfirmationDialogEvent(applicationContext, SdkUiConstants.CP_YES, SdkUiConstants.CP_SCREEN_CHECKOUT_L1)
                paymentOptionViewModel?.exitDialogYesClicked(fragmentStack)
            }
    }

    private fun setOrderDetailsInfo(view: View?) {
        val txnIdView = view?.findViewById<TextView>(R.id.tvTxn)
        txnIdView?.text = String.format(
            getString(R.string.payu_txn_id_s),
            SdkUiInitializer.apiLayer?.payUPaymentParams?.transactionId
        )
        val tvSubtotalAmount = view?.findViewById<TextView>(R.id.tvSubtotalAmount)
        val tvSubtotalAmountValue = view?.findViewById<TextView>(R.id.tvSubtotalAmountValue)
        val tvConvenienceFeeValue = view?.findViewById<TextView>(R.id.tvConvenienceFeeValue)
        val tvGSTAmount = view?.findViewById<TextView>(R.id.tvGSTValue)
        val tvgstView = view?.findViewById<Group>(R.id.tvGstView)
        val tvconvenienceFeeview = view?.findViewById<Group>(R.id.tvConvenienceFeeView)
        val tvDiscountValue = view?.findViewById<TextView>(R.id.tvOfferDiscountValue)
        val tvCashBackValue = view?.findViewById<TextView>(R.id.tvOfferCashBackValue)
        val lvOfferCashBackView = view?.findViewById<ConstraintLayout>(R.id.lvOfferCashBackView)
        val lvTotalamtView = view?.findViewById<Group>(R.id.lvTotalamtView)
        val tvTotalAmtValue = view?.findViewById<TextView>(R.id.tvTotalAmtValue)
        val tvTotalAmount = view?.findViewById<TextView>(R.id.tvTotalAmt)
        val tvInterestChargedLayout = view?.findViewById<Group>(R.id.lvInterestView)
        val tvInterestChargedValue = view?.findViewById<TextView>(R.id.tvInterestChargedValue)
        val lvNoCostDiscountView = view?.findViewById<Group>(R.id.lvNoCostDiscountView)
        val tvNoCostDiscountValue = view?.findViewById<TextView>(R.id.tvNoCostDiscountValue)
        val lvNoCostCashBackView = view?.findViewById<Group>(R.id.lvNoCostCashBackView)
        val tvNoCostCashBackValue = view?.findViewById<TextView>(R.id.tvNoCostCashBackValue)
        val tvOfferDiscountLayout = view?.findViewById<ConstraintLayout>(R.id.lvOfferDiscountView)
        val additionalCharges = paymentOptionViewModel?.additonalCharges?.toDouble() ?: 0.0
        tvSubtotalAmountValue?.text = getString(
            R.string.payu_amount_with_rupee_symbol,
            (String.format(
                "%.2f",
                SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull()
            ))
        )
        val convenienceFee = paymentOptionViewModel?.convenienceFeeCharges
        if (convenienceFee == "0.0" || convenienceFee == null) {
            tvconvenienceFeeview?.visibility = View.GONE
        } else {
            tvConvenienceFeeValue?.text = getString(
                R.string.payu_amount_with_rupee_symbol,
                (String.format(
                    "%.2f",
                    convenienceFee.toDouble()
                ))
            )
        }
        val gstAmount = paymentOptionViewModel?.gstAmount
        if (gstAmount == "0.0" || gstAmount == null) {
            tvgstView?.visibility = View.GONE
        } else {
            tvGSTAmount?.text = getString(
                R.string.payu_amount_with_rupee_symbol, (String.format(
                    "%.2f",
                    (paymentOptionViewModel?.gstAmount)?.toDouble()
                ) + "(${paymentOptionViewModel?.gstPercent}%)")
            )
        }


        lvTotalamtView?.visibility = View.GONE

        if (InternalConfig.userSelectedOfferInfo!=null || (InternalConfig.selectedOfferInfo != null && InternalConfig.selectedOfferInfo?.isValid == true)) {
            tvOfferDiscountLayout?.visibility = View.GONE
            lvOfferCashBackView?.visibility = View.GONE
            tvInterestChargedLayout?.visibility = View.GONE
            lvNoCostDiscountView?.visibility = View.GONE
            lvNoCostCashBackView?.visibility = View.GONE

            lvTotalamtView?.visibility = View.VISIBLE
            tvTotalAmount?.text = getString(R.string.payu_total_amount)
            tvSubtotalAmountValue?.text = getString(
                R.string.payu_amount_with_rupee_symbol,
                (String.format(
                    "%.2f",
                    SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                ))
            )
            tvTotalAmtValue?.text = getString(
                R.string.payu_amount_with_rupee_symbol,
                (String.format(
                    "%.2f",
                    SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                        ?.minus(InternalConfig.selectedOfferInfo?.totalInstantDiscount ?: 0.0)
                        ?.plus(InternalConfig.interestCharged ?: 0.0)?.plus(additionalCharges)

                ))
            )
            val totalInstantDiscount = InternalConfig.selectedOfferInfo?.totalInstantDiscount ?: 0.0
            val totalCashBackDiscount =
                InternalConfig.selectedOfferInfo?.totalCashbackDiscount ?: 0.0

            if (totalInstantDiscount != 0.0) {
                lvTotalamtView?.visibility = View.VISIBLE
                tvOfferDiscountLayout?.visibility = View.VISIBLE
                tvDiscountValue?.text = getString(
                    R.string.payu_amount_with_rupee_symbol,
                    (String.format(
                        "%.2f",
                        InternalConfig.selectedOfferInfo?.totalInstantDiscount
                    ))
                )
            }
            if (totalCashBackDiscount != 0.0) {
                lvTotalamtView?.visibility = View.VISIBLE
                lvOfferCashBackView?.visibility = View.VISIBLE
                tvCashBackValue?.text = getString(
                    R.string.payu_amount_with_rupee_symbol,
                    (String.format(
                        "%.2f",
                        InternalConfig.selectedOfferInfo?.totalCashbackDiscount
                    ))
                )
            }
            if (InternalConfig.interestCharged != null && InternalConfig.interestCharged != 0.0) {
                tvInterestChargedLayout?.visibility = View.VISIBLE
                tvInterestChargedValue?.text = getString(
                    R.string.payu_amount_with_plus_rupee_symbol,
                    (String.format("%.2f", InternalConfig.interestCharged))
                )
                tvSubtotalAmount?.text = getString(R.string.payu_payable_now)
            }
        }

        if (InternalConfig.emiOfferInfo != null) {
            tvOfferDiscountLayout?.visibility = View.GONE
            lvOfferCashBackView?.visibility = View.GONE
            tvInterestChargedLayout?.visibility = View.GONE
            lvNoCostDiscountView?.visibility = View.GONE
            lvNoCostCashBackView?.visibility = View.GONE

            val offerDiscount = InternalConfig.emiOfferInfo?.offerDiscount
            val nceDiscount = InternalConfig.emiOfferInfo?.nceDiscount
            val totalInstantDiscount =
                (nceDiscount?.instant ?: 0.0).plus(offerDiscount?.instant ?: 0.0)
            val totalCashBack = (nceDiscount?.cashback ?: 0.0).plus(offerDiscount?.cashback ?: 0.0)
            tvSubtotalAmount?.text = getString(R.string.payu_payable_now)
            tvSubtotalAmountValue?.text = getString(
                R.string.payu_amount_with_rupee_symbol,
                (String.format(
                    "%.2f",
                    SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                        ?.minus(totalInstantDiscount ?: 0.0)?.plus(additionalCharges)
                ))
            )
            tvTotalAmount?.text = getString(R.string.payu_total_payable_cost_to_bank)
            tvTotalAmtValue?.text = getString(
                R.string.payu_amount_with_rupee_symbol,
                (String.format(
                    "%.2f",
                    InternalConfig.emiOfferInfo?.totalPayableAmount?.plus(additionalCharges)
                ))
            )
            if (nceDiscount?.instant == 0.0) nceDiscount.instant = null
            if (nceDiscount?.cashback == 0.0) nceDiscount.cashback = null
            if (offerDiscount?.instant == 0.0) offerDiscount.instant = null
            if (offerDiscount?.cashback == 0.0) offerDiscount.cashback = null

            if (InternalConfig.emiOfferInfo?.totalPayableAmount != 0.0)
                lvTotalamtView?.visibility = View.VISIBLE
            else {
                lvTotalamtView?.visibility = View.GONE
                tvInterestChargedLayout?.visibility = View.GONE
            }

            if (totalInstantDiscount != 0.0) {
                offerDiscount?.instant?.let {
                    tvOfferDiscountLayout?.visibility = View.VISIBLE
                    tvDiscountValue?.text = getString(
                        R.string.payu_amount_with_minus_rupee_symbol,
                        (String.format("%.2f", it))
                    )
                }
                nceDiscount?.instant?.let {
                    tvNoCostDiscountValue?.text = getString(
                        R.string.payu_amount_with_minus_rupee_symbol,
                        (String.format("%.2f", nceDiscount.instant))
                    )
                    lvNoCostDiscountView?.visibility = View.VISIBLE
                }

            }
            if (totalCashBack != 0.0) {
                offerDiscount?.cashback?.let {
                    lvOfferCashBackView?.visibility = View.VISIBLE
                    tvCashBackValue?.text = getString(
                        R.string.payu_amount_with_minus_rupee_symbol,
                        (String.format("%.2f", it))
                    )

                }
                nceDiscount?.cashback?.let {
                    lvNoCostCashBackView?.visibility = View.VISIBLE
                    tvNoCostCashBackValue?.text = getString(
                        R.string.payu_amount_with_minus_rupee_symbol,
                        (String.format("%.2f", nceDiscount.cashback))
                    )

                }
            }
            if (InternalConfig.interestCharged?.toInt() != 0 && InternalConfig.interestCharged != null) {
                tvInterestChargedLayout?.visibility = View.VISIBLE
                tvInterestChargedValue?.text = getString(
                    R.string.payu_amount_with_plus_rupee_symbol,
                    (String.format("%.2f", InternalConfig.interestCharged))
                )
                lvTotalamtView?.visibility = View.VISIBLE
            }
        } else if (InternalConfig.interestCharged?.toInt() != 0 && InternalConfig.interestCharged != null) {
            tvInterestChargedLayout?.visibility = View.VISIBLE
            tvSubtotalAmount?.text = getString(R.string.payu_payable_now)
            tvInterestChargedValue?.text = getString(
                R.string.payu_amount_with_plus_rupee_symbol,
                (String.format("%.2f", InternalConfig.interestCharged))
            )
            lvTotalamtView?.visibility = View.VISIBLE
            tvTotalAmount?.text = getString(R.string.payu_total_payable_cost_to_bank)
            tvTotalAmtValue?.text = getString(
                R.string.payu_amount_with_rupee_symbol,
                (String.format(
                    "%.2f",
                    SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull()
                        ?.plus(InternalConfig.interestCharged ?: 0.0)?.plus(additionalCharges)
                ))
            )
        }

        val payUSIParams = SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams
        if (payUSIParams != null) {
            val llSiOrderDetails = view?.findViewById<Group>(R.id.llSiOrderDetails)
            val siAPlanText = view?.findViewById<TextView>(R.id.tv_si_plan_txt)
            val siPlanValue = view?.findViewById<TextView>(R.id.tv_si_plan_value)
            val siFrequencyText = view?.findViewById<TextView>(R.id.tv_si_frequency_txt)
            val siFrequencyValue = view?.findViewById<TextView>(R.id.tv_si_frequency_value)
            val siAmountText = view?.findViewById<TextView>(R.id.tv_amount_txt)
            val siAmountValue = view?.findViewById<TextView>(R.id.tv_amount_value)
            val siStartDate = view?.findViewById<TextView>(R.id.tv_start_date_value)
            val siEndDate = view?.findViewById<TextView>(R.id.tv_end_date_value)
            val tvOtmDetailsText = view?.findViewById<TextView>(R.id.tv_subscription_details_txt)
            if (SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.isPreAuthTxn == true) {
                tvOtmDetailsText?.text = getString(R.string.payu_mandate_details)
                siAmountText?.visibility = View.GONE
                siAmountValue?.visibility = View.GONE
                siAPlanText?.visibility = View.GONE
                siPlanValue?.visibility = View.GONE
                siFrequencyText?.visibility = View.GONE
                siFrequencyValue?.visibility = View.GONE
            } else {
                siAmountText?.text = getString(R.string.payu_max_mandate_amount)
                siAPlanText?.visibility = View.VISIBLE
                siPlanValue?.visibility = View.VISIBLE
                siFrequencyText?.visibility = View.VISIBLE
                siFrequencyValue?.visibility = View.VISIBLE
                siAmountText?.visibility = View.VISIBLE
                siAmountValue?.visibility = View.VISIBLE
                siPlanValue?.text = SdkUiInitializer.apiLayer?.payUPaymentParams?.productInfo
                siFrequencyValue?.text =
                    if (payUSIParams.billingCycle == PayUBillingCycle.ADHOC) getString(R.string.payu_as_presented) else payUSIParams.billingCycle?.name
            }
            llSiOrderDetails?.visibility = View.VISIBLE
            siAmountValue?.text = getString(
                R.string.payu_amount_with_rupee_symbol,
                payUSIParams.billingAmount
            )

            siStartDate?.text = Utils.formatDate(payUSIParams.paymentStartDate, Utils.DATE_FORMAT_yyyy_MM_dd, Utils.DATE_FORMAT_dd_MM_yyyy)
            siEndDate?.text = Utils.formatDate(payUSIParams.paymentEndDate, Utils.DATE_FORMAT_yyyy_MM_dd, Utils.DATE_FORMAT_dd_MM_yyyy)
        }

        val tvSavedCardTxt = view?.findViewById<TextView>(R.id.tvSavedCardTxt)
        val rcvCardDetails = view?.findViewById<RecyclerView>(R.id.rcvCardDetails)
        if (!orderDetailsArrayList.isNullOrEmpty()) {
            rcvCardDetails?.visibility = View.VISIBLE
            tvSavedCardTxt?.visibility = View.VISIBLE
            rcvCardDetails?.layoutManager = LinearLayoutManager(this)
            val adapter = OrderDetailsListAdapter(orderDetailsArrayList!!)
            rcvCardDetails?.adapter = adapter
        } else {
            rcvCardDetails?.visibility = View.GONE
            tvSavedCardTxt?.visibility = View.GONE
        }

        if (paymentOptionViewModel?.isEnachPayment() == true) {
            tvSubtotalAmount?.text = getString(R.string.payu_payable_now)
            tvSubtotalAmountValue?.text = getString(
                R.string.payu_amount_with_rupee_symbol,
                "0.00"
            )
        }

        view?.findViewById<ImageView>(R.id.ivCloseIcon)?.setOnClickListener {
            hideBottomSheet()
        }
    }

    private fun setOfferDetailsInfo(view: View?) {
        view?.findViewById<ImageView>(R.id.ivCloseIcon)?.setOnClickListener {
            hideBottomSheet()
        }
        view?.findViewById<ImageView>(R.id.ivPaymentOptionIcon)?.setOnClickListener {
            hideBottomSheet()
        }

        val rlOfferToolbar = view?.findViewById<ConstraintLayout>(R.id.rlOfferToolbar)
        rlOfferToolbar?.setOnClickListener {
            rlOfferToolbar.requestFocus()
        }

        val rlCoupon = view?.findViewById<ConstraintLayout>(R.id.rlCoupon)
        val applyCouponButton = rlCoupon?.findViewById<Button>(R.id.btnApplyCouponButton)
        val etCoupon = rlCoupon?.findViewById<EditText>(R.id.etField)
        val tvCouponError = view?.findViewById<TextView>(R.id.tvCouponError)
        ViewUtils.disableView(applyCouponButton)
        etCoupon?.doOnTextChanged { text, start, before, count ->
            tvCouponError?.text = ""
            if((text?.length ?: 0) < 1)
                ViewUtils.disableView(applyCouponButton)
            else
                ViewUtils.enableView(applyCouponButton)
        }
        applyCouponButton?.setOnClickListener {
            tvCouponError?.text = ""
            paymentOptionViewModel?.applyCoupon(etCoupon?.text.toString())
        }

        if(InternalConfig.couponsAvailable.not()){
            rlCoupon?.visibility = View.GONE
            tvCouponError?.visibility = View.GONE
        }

        val rlPaymentOffer = view?.findViewById<TextView>(R.id.tvPaymentOffer)
        val skuOffer = view?.findViewById<TextView>(R.id.tvSkuOffer)
        val rewardOffer = view?.findViewById<TextView>(R.id.tvRewardOffer)

        val isPaymentOfferEmpty = fetchOfferDetails?.payuOfferArrayList?.filter { it.toDisplay }.isNullOrEmpty()
        val isRewardOffersEmpty = fetchOfferDetails?.payuRewardOfferArrayList?.filter { it.toDisplay }.isNullOrEmpty()
        val isSkuOffersEmpty = fetchOfferDetails?.payuSkuOfferList?.filter { it.toDisplay }.isNullOrEmpty()

        var tabCount = 0;

        if(isPaymentOfferEmpty)
            rlPaymentOffer?.visibility = View.GONE
        else tabCount++

        if(isRewardOffersEmpty)
            rewardOffer?.visibility = View.GONE
        else tabCount++

        if(isSkuOffersEmpty)
            skuOffer?.visibility = View.GONE
        else tabCount++

        if (tabCount > 1) {
            view?.findViewById<ConstraintLayout>(R.id.llOffersTab)?.visibility =
                View.VISIBLE
            if(isPaymentOfferEmpty.not()) {
                updateOfferView(
                    fetchOfferDetails?.payuOfferArrayList,
                    highlightedOfferTab = rlPaymentOffer,
                    disabledOfferTab1 = skuOffer,
                    disabledOfferTab2 = rewardOffer
                )
                rlPaymentOffer?.setOnClickListener {
                    updateOfferTextView(
                        view,
                        tvPaymentOfferColor = R.color.payu_color_ffffff,
                        tvSkuOfferColor = R.color.one_payu_colorPrimary,
                        tvRewardOfferColor = R.color.one_payu_colorPrimary,
                    )
                    updateOfferView(
                        fetchOfferDetails?.payuOfferArrayList,
                        highlightedOfferTab = rlPaymentOffer,
                        disabledOfferTab1 = skuOffer,
                        disabledOfferTab2 = rewardOffer
                    )
                }
            }
            if(isRewardOffersEmpty.not()) {
                rewardOffer?.setOnClickListener {
                    updateOfferTextView(
                        view,
                        tvPaymentOfferColor = R.color.one_payu_colorPrimary,
                        tvSkuOfferColor = R.color.one_payu_colorPrimary,
                        tvRewardOfferColor = R.color.payu_color_ffffff
                    )
                    updateOfferView(
                        fetchOfferDetails?.payuRewardOfferArrayList,
                        highlightedOfferTab = rewardOffer,
                        disabledOfferTab1 = skuOffer,
                        disabledOfferTab2 = rlPaymentOffer
                    )
                }
                if(isPaymentOfferEmpty){
                    rewardOffer?.performClick()
                }
            }
            if(isSkuOffersEmpty.not()) {
                skuOffer?.setOnClickListener {
                    updateOfferTextView(
                        view,
                        tvPaymentOfferColor = R.color.one_payu_colorPrimary,
                        tvSkuOfferColor = R.color.payu_color_ffffff,
                        tvRewardOfferColor = R.color.one_payu_colorPrimary,
                    )
                    updateOfferView(
                        fetchOfferDetails?.payuSkuOfferList,
                        highlightedOfferTab = skuOffer,
                        disabledOfferTab1 = rewardOffer,
                        disabledOfferTab2 = rlPaymentOffer
                    )
                }
            }
        } else if (isPaymentOfferEmpty.not()) {
            view?.findViewById<ConstraintLayout>(R.id.llOffersTab)?.visibility = View.GONE
            updateOfferView(fetchOfferDetails?.payuOfferArrayList, highlightedOfferTab = rlPaymentOffer, disabledOfferTab1 = skuOffer, disabledOfferTab2 = rewardOffer)
        } else if (isRewardOffersEmpty.not()) {
            view?.findViewById<ConstraintLayout>(R.id.llOffersTab)?.visibility = View.GONE
            updateOfferView(fetchOfferDetails?.payuRewardOfferArrayList, highlightedOfferTab = rewardOffer, disabledOfferTab1 = skuOffer, disabledOfferTab2 = rlPaymentOffer)
        } else {
            view?.findViewById<ConstraintLayout>(R.id.llOffersTab)?.visibility = View.GONE
            updateOfferView(fetchOfferDetails?.payuSkuOfferList, highlightedOfferTab = skuOffer, disabledOfferTab1 = rewardOffer, disabledOfferTab2 = rlPaymentOffer)
        }

        if(isPaymentOfferEmpty && isRewardOffersEmpty && isSkuOffersEmpty){
            view?.findViewById<ConstraintLayout>(R.id.llOffersTab)?.visibility = View.GONE
            view?.findViewById<FrameLayout>(R.id.offersContainer)?.visibility = View.GONE
            view?.findViewById<ConstraintLayout>(R.id.clEmptyOffers)?.visibility = View.VISIBLE
        }

    }

    private fun setBankBottomSheetInfo(
        paymentOption: PaymentOption,
        view: View?
    ) {
        var param = ImageParam(paymentOption, false, R.drawable.payu_credit_debit_cards)
        SdkUiInitializer.apiLayer?.getImageForPaymentOption(
            param,
            onFetchImageListener = object : OnFetchImageListener {
                override fun onImageGenerated(result: ImageDetails) {
                    ImageViewUtils.setImage(view?.findViewById(R.id.ivBank), result)
                }
            })

        val btnPayBy = view?.findViewById<Button>(R.id.btnPayBy)
        tvOfferView = view?.findViewById(R.id.tvOfferView)
        ViewUtils.updateBackgroundColor(
            this,
            btnPayBy,
            SdkUiInitializer?.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(btnPayBy, SdkUiInitializer?.apiLayer?.config?.baseTextColor)

        btnPayBy?.text = getString(R.string.payu_pay_by, paymentOption.bankName)
        val pg = Utils.getValueFromPaymentOption<String>(
            SdkUiConstants.CP_PG,
            paymentOption.otherParams as HashMap<String, Any?>
        )
        val bankCode = Utils.getValueFromPaymentOption<String>(
            SdkUiConstants.CP_BANK_CODE,
            paymentOption.otherParams as HashMap<String, Any?>
        )
        if (bankCode != SdkUiConstants.CP_TEZ) {
            val category = Utils.getCategoryForOffer(pg)
            Handler().postDelayed({
                paymentOptionViewModel?.validateOffer(category, bankCode)
            }, 300)
        }
        btnPayBy?.setOnClickListener {

            InternalConfig.removeOfferIfNeeded = false
            // Preventing multiple clicks, using threshold of 1 second
            if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) return@setOnClickListener
            mLastClickTime = SystemClock.elapsedRealtime()

            if (ViewUtils.isInternetAvailable(applicationContext)) {
                paymentOptionViewModel?.makePayment(paymentOption)
                hideBottomSheet()
            } else {
                hideBottomSheet()
                NetworkManager.registerReceiver(applicationContext)
                ViewUtils.showSnackBar(
                    resources.getString(R.string.payu_no_internet_connection),
                    R.drawable.payu_no_internet,
                    this
                )
            }
        }
    }


    private fun setSavedCardInfo(savedCardOption: SavedCardOption, view: View?) {
        val category = Utils.getCategoryForOffer(savedCardOption.cardBinInfo?.cardType.toString())
        savedCardOption.cardBinInfo?.binNumber?.let {
            paymentOptionViewModel?.fetchBinBaseDetails(
                it, savedCardOption.cardToken, category, savedCardOption.bankCode
            )
        }
        tvSIEnabledErrorForSavedCard = view?.findViewById(R.id.tv_card_error)
        tvConsentText = view?.findViewById(R.id.tv_consent_text)

        tvSIEnabledErrorForSavedCard?.visibility = View.GONE
        tvConsentText?.visibility = View.GONE
        view?.findViewById<TextView>(R.id.tvBankName)?.text =
            paymentOptionViewModel?.selectedPaymentOption?.bankName
        view?.findViewById<TextView>(R.id.tvPaymentOption)?.text =
            savedCardOption.cardBinInfo?.cardType?.getTypeName()
        view?.findViewById<TextView>(R.id.tvPaymentOptionDetail)?.text =
            Utils.getFormattedString(
                savedCardOption.cardNumber,
                savedCardOption.cardBinInfo?.cardScheme
            )
        val param = ImageParam(savedCardOption, true, R.drawable.payu_credit_debit_cards)

        SdkUiInitializer.apiLayer?.getImageForPaymentOption(
            param,
            object : OnFetchImageListener {
                override fun onImageGenerated(result: ImageDetails) {
                    ImageViewUtils.setImage(
                        view?.findViewById(R.id.ivPaymentOptionIcon),
                        result
                    )
                }
            })
        btnPayBottomSheet = view?.findViewById(R.id.btnPay)
        ViewUtils.updateBackgroundColor(
            this,
            btnPayBottomSheet,
            SdkUiInitializer?.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(
            btnPayBottomSheet,
            SdkUiInitializer?.apiLayer?.config?.baseTextColor
        )

        rlSavedCardBottomSheet = view?.findViewById(R.id.rlSavedCardBottomSheet)
        etCvvBottomSheet = view?.findViewById(R.id.etCvv)

        ivOffer = view?.findViewById(R.id.ivOffer)
        tvOfferText = view?.findViewById(R.id.tvOfferText)
        paymentOptionViewModel?.initOffersUI(savedCardOption)

        paymentOptionViewModel?.updateBottomSheetCvvFilter(savedCardOption)
        btnPayBottomSheet?.setOnClickListener {
            if (ViewUtils.isInternetAvailable(applicationContext)) {
                savedCardOption.cvv = etCvvBottomSheet?.text.toString()
                ViewUtils.hideSoftKeyboardFromToken(this, it)
                //Log Analytics
                AnalyticsUtils.logMakePaymentEvent(
                    applicationContext,
                    savedCardOption,
                    null,
                    SdkUiConstants.CP_SAVE_CARD
                )
                paymentOptionViewModel?.makeStoreCardPayment(savedCardOption)
            } else {
                hideBottomSheet()
                NetworkManager.registerReceiver(applicationContext)
                ViewUtils.showSnackBar(
                    applicationContext.getString(R.string.payu_no_internet_connection),
                    R.drawable.payu_no_internet,
                    this
                )
            }
        }

        ivToolTipCvv = view?.findViewById(R.id.ivToolTipCvv)
        ivToolTipCvv?.setOnClickListener {
            paymentOptionViewModel?.savedCardCvvToolTipClicked(savedCardOption.cardBinInfo?.cardScheme)
        }

        transparentView = view?.findViewById(R.id.transparentView)
        transparentView?.setOnClickListener(this)
        resetSavedCardOption()
        etCvvBottomSheet?.onFocusChangeListener = this
    }

    private fun setSodexoCardInfo(savedCardOption: SodexoCardOption, view: View?) {

        view?.findViewById<TextView>(R.id.tvBankName)?.text =
            paymentOptionViewModel?.selectedPaymentOption?.bankName
        view?.findViewById<TextView>(R.id.tvPaymentOption)?.text = "FOOD CARD"
        view?.findViewById<TextView>(R.id.tvPaymentOptionDetail)?.text =
            Utils.getFormattedString(
                savedCardOption.cardNumber,
                savedCardOption.cardBinInfo?.cardScheme
            )

        view?.findViewById<TextView>(R.id.tvAmount)?.text = savedCardOption.balance


        val param = ImageParam(savedCardOption, true, R.drawable.payu_credit_debit_cards)

        SdkUiInitializer.apiLayer?.getImageForPaymentOption(
            param,
            object : OnFetchImageListener {
                override fun onImageGenerated(result: ImageDetails) {
                    ImageViewUtils.setImage(
                        view?.findViewById(R.id.ivPaymentOptionIcon),
                        result
                    )
                }
            })
        btnPayBottomSheet = view?.findViewById(R.id.btnPay)
        ViewUtils.updateBackgroundColor(
            this,
            btnPayBottomSheet,
            SdkUiInitializer?.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(
            btnPayBottomSheet,
            SdkUiInitializer?.apiLayer?.config?.baseTextColor
        )

        rlSavedCardBottomSheet = view?.findViewById(R.id.rlSavedCardBottomSheet)

        btnPayBottomSheet?.setOnClickListener {
            if (ViewUtils.isInternetAvailable(applicationContext)) {

                AnalyticsUtils.logMakePaymentEvent(applicationContext, savedCardOption)
                paymentOptionViewModel?.makePayment(savedCardOption)
            } else {
                hideBottomSheet()
                NetworkManager.registerReceiver(applicationContext)
                ViewUtils.showSnackBar(
                    applicationContext.getString(R.string.payu_no_internet_connection),
                    R.drawable.payu_no_internet,
                    this
                )
            }
        }
        transparentView = view?.findViewById(R.id.transparentView)
        transparentView?.setOnClickListener(this)
        resetSavedCardOption()
    }


    private fun updateLoginBottomSheet(view: View?){

        val globalVaultOTPVerification =
            view?.findViewById<ConstraintLayout>(R.id.llGlobalVaultOTPVerification)
        val consentParentView =
            globalVaultOTPVerification?.findViewById<ConstraintLayout>(R.id.rlConsentSwitch)
        val consentCheckBox =
            consentParentView?.findViewById<CheckBox>(R.id.switchSaveCard)
        consentCheckBox?.setOnCheckedChangeListener { _, isChecked ->
            isConsentChecked = isChecked
        }

        consentCheckBox?.buttonTintList = if(SdkUiInitializer.apiLayer?.config?.primaryColor != null){
            ColorStateList.valueOf(Color.parseColor(SdkUiInitializer.apiLayer?.config?.primaryColor))
        } else {
            ColorStateList.valueOf(ContextCompat.getColor(applicationContext, R.color.payu_color_ffffff))
        }

        if(InternalConfig.isUserPersonalizedOffersAvailable.not() || InternalConfig.isOfferEnabled.not()){
            consentParentView?.visibility = View.GONE
        } else {
            consentCheckBox?.isChecked = false
            isConsentChecked = false
            val consentSendOtpDesc =
                consentParentView?.findViewById<TextView>(R.id.tvSaveCard)
            val consentSendOtpInfoNudge =
                consentParentView?.findViewById<ImageView>(R.id.ivSavedCardNudge)
            consentSendOtpInfoNudge?.isVisible = false
            consentSendOtpDesc?.text = getString(R.string.payu_rewards_consent_message)
            consentSendOtpDesc?.setTextColor(ContextCompat.getColor(applicationContext, R. color. payu_color_7b7b7b))
        }

    }

    private fun setEnterPhoneBottomSheetInfo(view: View?) {

        val titleAndSubtitle = paymentOptionViewModel?.getLoginBottomSheetTileAndDescriptionText()
        val tvSendOtpTitle: TextView? = view?.findViewById(R.id.tvOfferTitle)
        val tvSendOtpTitleDesc: TextView? = view?.findViewById(R.id.tvSendOTPDescGv)
        tvSendOtpTitle?.text = titleAndSubtitle?.first ?: ""
        tvSendOtpTitleDesc?.text = titleAndSubtitle?.second ?: ""

        tvOTPErrorTextGv = view?.findViewById(R.id.tvOTPErrorTextGv)
        etPhoneNumberGv = view?.findViewById(R.id.etPhoneNumberGv)
        btnVerifyGv = view?.findViewById(R.id.btnVerifyGv)
        tvOTPInfoGv = view?.findViewById(R.id.tvOTPInfoGv)
        ivphonecodeiconGv = view?.findViewById(R.id.iv_phonecodeiconGv)
        etPhoneNumberGv?.text = Editable.Factory.getInstance()
            .newEditable(verificationPhoneNumber)
        paymentOptionViewModel?.onChangeOfPhoneNumber(verificationPhoneNumber)
        //To store mobile number from EditText Field
        etPhoneNumberGv?.doOnTextChanged { text, _, _, _ -> // Do stuff
            tvOTPErrorTextGv?.visibility = View.GONE
            verificationPhoneNumber = text.toString()
            if (verificationPhoneNumber.isNotEmpty())
                ivphonecodeiconGv?.visibility = View.VISIBLE
            else ivphonecodeiconGv?.visibility = View.GONE

            paymentOptionViewModel?.onChangeOfPhoneNumber(text)
        }


        ViewUtils.updateTextColor(
            this,
            btnVerifyGv,
            SdkUiInitializer.apiLayer?.config?.baseTextColor, R.color.one_payu_baseTextColor
        )
        ViewUtils.updateBackgroundColor(
            this,
            btnVerifyGv,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )

        //to handle on click of Verify Button
        btnVerifyGv?.setOnClickListener {

            //To Check if it is Valid PhoneNumber or not and proceed.
            if (Utils.isValidPhoneNumber(verificationPhoneNumber)) {
                val eventData = HashMap<String, Any>()
                eventData[SdkUiConstants.CP_CTA_TYPE] = SdkUiConstants.CP_TYPE_ACTION
                AnalyticsUtils.logData(
                    this.baseContext,
                    AnalyticsConstant.CP_GV_OTP_AUTH_INITIATED,
                    eventData
                )
                AnalyticsUtils.logKibanaInfoEvent(
                    context = this,
                    eventKey = SdkUiConstants.CP_LOGIN_BOTTOM_SHEET_SEND_OTP_CLICKED,
                    screenName = paymentOptionViewModel?.getScreenName()
                )
                paymentOptionViewModel?.sendOTPGlobalVault(verificationPhoneNumber)
                tvOTPInfoGv?.text =
                    applicationContext?.getString(
                        R.string.payu_otp_description,
                        verificationPhoneNumber
                    )

            } else {
                tvOTPErrorTextGv?.visibility = View.VISIBLE
                tvOTPErrorTextGv?.text =
                    applicationContext?.getString(R.string.payu_phone_number_invalid)
            }
        }
        view?.findViewById<TextView>(R.id.tvSkipGv)?.setOnClickListener {
            hideBottomSheet()
            val eventData = HashMap<String, Any>()
            AnalyticsUtils.logData(
                this.baseContext,
                AnalyticsConstant.CP_SKIP_CLICKED,
                eventData
            )
            AnalyticsUtils.logKibanaInfoEvent(
                context = this,
                eventKey = SdkUiConstants.CP_LOGIN_BOTTOM_SHEET_CANCELLED,
                screenName = paymentOptionViewModel?.getScreenName()
            )
        }
        view?.findViewById<ImageView>(R.id.iv_phonecodeiconGv)?.setOnClickListener {
            verificationPhoneNumber = ""
            etPhoneNumberGv?.text = Editable.Factory.getInstance()
                .newEditable(verificationPhoneNumber)
            ivphonecodeiconGv?.visibility = View.GONE
        }

    }

    private fun setSettingsBottomSheetInfo(view: View?) {
        view?.findViewById<ConstraintLayout>(R.id.rlChangePhoneNumber)?.setOnClickListener {
            AnalyticsUtils.logKibanaInfoEvent(
                context = this,
                eventKey = SdkUiConstants.CP_LOGIN_CHANGE_PHONE_NUMBER_CLICKED,
                screenName = paymentOptionViewModel?.getScreenName()
            )
            hideBottomSheet()
            paymentOptionViewModel?.showBottomSheetGlobalVaultSendOTP()
            paymentOptionViewModel?.initiateSMSReader(this)
        }

        view?.findViewById<ConstraintLayout>(R.id.rlLogout)?.setOnClickListener {
            AnalyticsUtils.logKibanaInfoEvent(
                context = this,
                eventKey = SdkUiConstants.CP_LOGOUT_CLICKED,
                screenName = paymentOptionViewModel?.getScreenName()
            )
            paymentOptionViewModel?.logoutFromGlobalVault()
            hideBottomSheet()
        }

        view?.findViewById<ConstraintLayout>(R.id.rlManagePaymentOption)?.setOnClickListener {
            paymentOptionViewModel?.manageSavedOptions()
            hideBottomSheet()
        }
    }

    private fun setGlobalVaultAuthenticationBottomSheetInfo(view: View?, it: Boolean, postVerificationAction: (()-> Unit)? = null) {
        updateLoginBottomSheet(view)
        val globalVaultOTPVerification =
            view?.findViewById<ConstraintLayout>(R.id.llGlobalVaultOTPVerification)
        val globalVaultPhoneNumberVerification =
            view?.findViewById<ConstraintLayout>(R.id.llGlobalVaultPhoneNumberVerification)
        tvResendOTPErrorGv = view?.findViewById(R.id.tvResendOTPErrorGv)
        tvVerifyOTPErrorGv = view?.findViewById(R.id.tvVerifyOTPErrorGv)
        pbOTPReadGv = view?.findViewById(R.id.pbOtpReadGv)
        tvResendOTPGv = view?.findViewById(R.id.tvResendOtpGv)
        etOTPGv = view?.findViewById(R.id.etOtpGv)
        rlSubmittingBtnGv = view?.findViewById(R.id.rlSubmitting_btnGv)
        llVerifyBtnsGv = view?.findViewById(R.id.llVerifyBtnsGv)
        pbSubmittingGv = view?.findViewById(R.id.pbSubmittingGv)
        tvOTPVerificationLimitError = view?.findViewById(R.id.tvOTPVerificationLimitError)

        if (it) {
            AnalyticsUtils.logKibanaInfoEvent(
                context = this,
                eventKey = SdkUiConstants.CP_LOGIN_VERIFY_OTP_BOTTOM_SHEET_SHOWN,
                screenName = paymentOptionViewModel?.getScreenName()
            )
            globalVaultOTPVerification?.visibility = View.VISIBLE
            globalVaultPhoneNumberVerification?.visibility = View.GONE
            CommonUIViewUtils.updateLayoutSecurity(this, true)
        } else {
            AnalyticsUtils.logKibanaInfoEvent(
                context = this,
                eventKey = SdkUiConstants.CP_LOGIN_BOTTOM_SHEET_SHOWN,
                screenName = paymentOptionViewModel?.getScreenName()
            )
            globalVaultOTPVerification?.visibility = View.GONE
            globalVaultPhoneNumberVerification?.visibility = View.VISIBLE
            rlSubmittingBtnGv?.visibility = View.GONE
            llVerifyBtnsGv?.visibility = View.VISIBLE
            CommonUIViewUtils.updateLayoutSecurity(this, false)
        }
        tvResendOTPErrorGv?.text = ""
        tvVerifyOTPErrorGv?.text = ""

        // To hide bottom sheet on click of Cancel button
        view?.findViewById<TextView>(R.id.tvCancelGv)?.setOnClickListener {
            AnalyticsUtils.logKibanaInfoEvent(
                context = this,
                eventKey = SdkUiConstants.CP_LOGIN_VERIFY_OTP_BOTTOM_SHEET_CANCELLED,
                screenName = paymentOptionViewModel?.getScreenName()
            )
            hideBottomSheet(ignoreOffer = true)
            CommonUIViewUtils.updateLayoutSecurity(this, false)
        }

        val tvSubmitOtp = view?.findViewById<TextView>(R.id.btnVerifyOTPGv)
        ViewUtils.updateTextColor(
            this,
            tvSubmitOtp,
            SdkUiInitializer.apiLayer?.config?.baseTextColor, R.color.one_payu_baseTextColor
        )
        ViewUtils.updateBackgroundColor(
            this,
            tvSubmitOtp,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )

        // To hide bottom sheet on click of Verify button
        tvSubmitOtp?.setOnClickListener {
            AnalyticsUtils.logKibanaInfoEvent(
                context = this,
                eventKey = SdkUiConstants.CP_LOGIN_VERIFY_OTP_BUTTON_CLICKED,
                screenName = paymentOptionViewModel?.getScreenName()
            )

            tvResendOTPErrorGv?.text = ""


            etOTPGv!!.doOnTextChanged { text, _, _, _ -> // Do stuff
                pbOTPReadGv?.visibility = View.GONE
                tvVerifyOTPErrorGv?.text = ""
            }
            if (etOTPGv!!.text.length == 6) {
                rlSubmittingBtnGv?.visibility = View.VISIBLE
                llVerifyBtnsGv?.visibility = View.GONE
                tvVerifyOTPErrorGv?.text = ""
                if(postVerificationAction == null)
                    paymentOptionViewModel?.verifyOTPGlobalVault(
                        userConsent = isConsentChecked,
                        verificationPhoneNumber = verificationPhoneNumber,
                        otp = etOTPGv?.text.toString()
                    )
                else
                    paymentOptionViewModel?.verifyOTPForCouponVerification(
                        userConsent = isConsentChecked,
                        otp = etOTPGv?.text.toString(),
                        postVerificationAction = postVerificationAction
                    )
                CommonUIViewUtils.updateLayoutSecurity(this, false)
                //  pbSubmitOTPGv.visibility = View.VISIBLE

            } else {
                tvVerifyOTPErrorGv?.text =
                    applicationContext?.getString(R.string.payu_otp_invalid)
            }
        }

        val tvResentOtp = view?.findViewById<TextView>(R.id.tvResendOtpGv)

        // To hide bottom sheet on click of Resend OTP button
        tvResentOtp?.setOnClickListener {
            AnalyticsUtils.logKibanaInfoEvent(
                context = this,
                eventKey = SdkUiConstants.CP_LOGIN_RESEND_OTP_BUTTON_CLICKED,
                screenName = paymentOptionViewModel?.getScreenName()
            )

            tvResendOTPErrorGv?.text = ""
            tvResendOTPGv?.text = applicationContext?.getString(R.string.payu_resending_otp)

            if (postVerificationAction == null) {
                paymentOptionViewModel?.resendOTPGlobalVault(
                    verificationPhoneNumber
                )
            } else {
                paymentOptionViewModel?.reSendOTPForCouponVerification()
            }

            val eventData = HashMap<String, Any>()
            AnalyticsUtils.logData(this.baseContext, AnalyticsConstant.CP_OTP_RESEND, eventData)
            AnalyticsUtils.logEventNameForKibana(
                this.baseContext,
                AnalyticsConstant.CP_OTP_RESEND
            )
        }

    }

    /**
     * reset savedCardOption to null, as we are Handling the flow on DNK mode. We created this object to save the
     * select Card from Saved option and Inflate the data [getInflatedView]
     */
    private fun resetSavedCardOption() {
        this.saveCardOption = null
    }

    override fun onClick(v: View?) {
        if (MultipleClickHandler.isSafeOnClickListener()) {
            when (v?.id) {
                R.id.rl_bottom_bar, R.id.llPaymentSection -> {
                    ViewUtils.clearFocusFromSearchView(this)
                    ViewUtils.hideToolTip()
                }

                R.id.transparentView -> paymentOptionViewModel?.transparentViewClicked()

                R.id.ivOrderDetails -> {
                    AnalyticsUtils.logCheckoutViewDetailsCTAClickEvent(
                        applicationContext,
                        SdkUiConstants.AMOUNT_INFO,
                        screenType!!
                    )
                    paymentOptionViewModel?.showOrderDetails()
                }

                R.id.tvOffer, R.id.ivOfferDetails, R.id.offerLayout -> {
                    AnalyticsUtils.logCheckoutOfferDetailsCTAClickEvent(
                        applicationContext,
                        SdkUiConstants.CP_OFFER_INFO,
                        screenType!!
                    )
                    paymentOptionViewModel?.showOfferDetails()
                }

                R.id.tvPrivacyPolicy -> {
                   ViewUtils.openPrivacyUrl(this)
                }

                R.id.payu_header_left_arrow -> {
                    handleBackpress()
                }

            }
        }
    }

    override fun onStop() {
        super.onStop()
//        if (progressDialog != null) {
//            progressDialog!!.dismiss()
//            progressDialog = null
//        }
        ViewUtils.hideSoftKeyboard(this)
    }

    override fun onDestroy() {
        super.onDestroy()
        ViewUtils.hideProgressDialog()
        if (!isSavedInstanceCalled) {
            AnalyticsUtils.logResetCpForKibana(applicationContext, CP_CLOSED)
            SdkUiInitializer.apiLayer?.reset()
            NetworkManager.unRegisterReceiver(applicationContext)
            ViewUtils.removeViewTreeListener(globalLayoutListener, rlSavedCardBottomSheet)
        }
        InternalConfig.selectedOfferInfo?.let { InternalConfig.selectedOfferInfo = null }
        InternalConfig.userSelectedOfferInfo?.let { InternalConfig.userSelectedOfferInfo = null }
        InternalConfig.isRetryTxn = false
        SdkUiInitializer.apiLayer?.resetApiResponseRepo()
        OfferFilterManager.clearCouponCache()
        SdkUiInitializer.clearReferences()
        ViewUtils.clearContextRefs()
        offerRoundedCornerBottomSheet = null
        roundedCornerBottomSheet = null
        inflatedView = null
        offerInflatedView = null
    }


    private fun enableDarkTheme() {
        ivPayULogo?.setColorFilter(
            resources.getColor(R.color.payu_color_ffffff),
            PorterDuff.Mode.SRC_IN
        )
        tvPrivacyPolicy?.setTextColor(resources.getColor(R.color.payu_color_ffffff))
    }

    private fun enableLightTheme() {
        ivPayULogo?.setColorFilter(
            resources.getColor(R.color.payu_color_000000),
            PorterDuff.Mode.SRC_IN
        )
        tvPrivacyPolicy?.setTextColor(resources.getColor(R.color.payu_color_000000))

    }

    override fun onFocusChange(v: View?, hasFocus: Boolean) {
        if (v?.id == R.id.etCvv && hasFocus) {
            paymentOptionViewModel?.savedCardCVVFocused()
        }
    }

    private fun showLoaderDialog(isLaunchPage: Boolean = false) {

        if (payUProgressDialog == null) {
            payUProgressDialog = PayUProgressDialog(this, null, isLaunchPage)
        }
        payUProgressDialog?.show()
    }

    private fun hideLoaderDialog() {
        if ((payUProgressDialog != null) && (payUProgressDialog!!.isShowing)) {
            payUProgressDialog!!.dismiss()
            payUProgressDialog = null
        }
    }

    private fun updateOfferView(
        offerList: ArrayList<OfferInfo>?,
        highlightedOfferTab: TextView?,
        disabledOfferTab1: TextView?,
        disabledOfferTab2: TextView?
    ) {
        offerList?.let {
            ViewUtils.updateBackgroundColor(
                this,
                highlightedOfferTab,
                SdkUiInitializer.apiLayer?.config?.primaryColor,
                R.color.one_payu_colorPrimary
            )
            ViewUtils.updateBackgroundColor(
                this,
                disabledOfferTab1,
                null,
                R.color.payu_color_ffffff
            )
            ViewUtils.updateBackgroundColor(
                this,
                disabledOfferTab2,
                null,
                R.color.payu_color_ffffff
            )
            val filteredList = arrayListOf<OfferInfo>().also {newList ->  newList.addAll(it.filter { it.toDisplay }) }
            offerRoundedCornerBottomSheet?.childFragmentManager?.beginTransaction()?.replace(
                R.id.offersContainer,
                BankFragment.newInstance(filteredList, false),
                SdkUiConstants.TAG_BANK_FRAGMENT
            )?.commit()
        }
    }

    private fun updateOfferTextView(view: View, tvSkuOfferColor: Int, tvPaymentOfferColor: Int, tvRewardOfferColor: Int) {
        view.findViewById<TextView>(R.id.tvSkuOffer)?.setTextColor(
            ContextCompat.getColor(
                applicationContext,
                tvSkuOfferColor
            )
        )
        view.findViewById<TextView>(R.id.tvPaymentOffer)?.setTextColor(
            ContextCompat.getColor(
                applicationContext,
                tvPaymentOfferColor
            )
        )
        view.findViewById<TextView>(R.id.tvRewardOffer)?.setTextColor(
            ContextCompat.getColor(
                applicationContext,
                tvRewardOfferColor
            )
        )
    }

    private fun setSKUOfferDetailsInfo(view: View?) {
        view?.findViewById<ImageView>(R.id.ivCloseIcon)?.setOnClickListener {
            hideBottomSheet()
        }
        view?.findViewById<ImageView>(R.id.ivPaymentOptionIcon)?.setOnClickListener {
            hideBottomSheet()
        }
        view?.findViewById<TextView>(R.id.tvOfferAndDiscounts)?.text =
            applicationContext.getString(R.string.payu_detailed_offer_breakup)
        val rlTotalAmt = view?.findViewById<ConstraintLayout>(R.id.rlTotalAmt)
        rlTotalAmt?.visibility = View.VISIBLE
        ViewUtils.updateBackgroundColor(
            this,
            rlTotalAmt,
            (R.color.payu_color_99DBE9F9).toString(),
            R.color.payu_color_99DBE9F9
        )
        view?.findViewById<TextView>(R.id.tvTotalSkuAmtValue)?.text = Utils.getFormattedAmount(
            SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                ?.minus(InternalConfig.selectedOfferInfo?.totalInstantDiscount ?: 0.0),
            this
        )
        val skuDetailsList = ArrayList<OfferInfo>()
        for ((offerKey, offerInfo) in InternalConfig.selectedOfferInfo?.offerMap ?: mapOf()) {
            skuDetailsList.add(offerInfo)
        }
        roundedCornerBottomSheet?.childFragmentManager?.beginTransaction()?.replace(
            R.id.skuContainer,
            BankFragment.newInstance(skuDetailsList, true),
            SdkUiConstants.TAG_BANK_FRAGMENT
        )?.commit()

    }


    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (requestCode == Constants.NATIVE_SMS_READER_PERMISSION_ID)
            paymentOptionViewModel?.sendResultToOtpParser(requestCode = requestCode, resultCode = resultCode, data = data)
    }

    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<String?>,
        grantResults: IntArray
    ) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
    }

    private fun setBackPressHandler() {
        onBackPressedDispatcher.addCallback(this, object : OnBackPressedCallback(true) {
            override fun handleOnBackPressed() {
                handleBackpress()
            }
        })
    }

}
