package com.payu.ui.model.utils

import android.annotation.SuppressLint
import android.app.Activity
import android.app.ProgressDialog
import android.content.Context
import android.content.Intent
import android.content.pm.PackageInfo
import android.content.pm.PackageManager
import android.content.res.ColorStateList
import android.graphics.Color
import android.graphics.PorterDuff
import android.graphics.PorterDuffColorFilter
import android.graphics.drawable.Drawable
import android.graphics.drawable.GradientDrawable
import android.net.ConnectivityManager
import android.net.NetworkCapabilities
import android.net.Uri
import android.os.Build
import android.telephony.TelephonyManager
import android.text.Spannable
import android.text.SpannableString
import android.text.SpannableStringBuilder
import android.text.style.ImageSpan
import android.util.DisplayMetrics
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.view.ViewTreeObserver
import android.view.animation.TranslateAnimation
import android.view.inputmethod.InputMethodManager
import android.webkit.WebView
import android.widget.Button
import android.widget.EditText
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.annotation.DrawableRes
import androidx.annotation.Nullable
import androidx.appcompat.widget.AppCompatImageView
import androidx.appcompat.widget.SwitchCompat
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.ContextCompat
import androidx.core.content.res.ResourcesCompat
import androidx.core.graphics.ColorUtils
import androidx.core.graphics.drawable.DrawableCompat
import androidx.core.widget.ImageViewCompat
import androidx.vectordrawable.graphics.drawable.Animatable2Compat
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat
import com.google.android.material.appbar.AppBarLayout
import com.google.android.material.appbar.CollapsingToolbarLayout
import com.google.android.material.snackbar.BaseTransientBottomBar
import com.google.android.material.snackbar.Snackbar
import com.payu.base.models.PaymentType
import com.payu.base.models.PayuToolbar
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.models.ToolTipModel
import com.payu.ui.model.utils.SdkUiConstants.PRIVACY_POLICY_URL
import com.payu.ui.model.widgets.ViewToolTip
import java.lang.reflect.Method
import java.text.DateFormat
import java.text.SimpleDateFormat
import java.util.Date
import java.util.concurrent.TimeUnit


object ViewUtils {
    private var snackbar: Snackbar? = null
    var savedCardHeight = 0
    var savedCardHeightWithAddCard = 0
    private var snackBarText: TextView? = null
    private var snackBarIcon: ImageView? = null
    private var progressDialog: ProgressDialog? = null

    fun showSnackBar(
        message: String?,
        icon: Int?,
        activityContext: Activity?,
        bgColor: Int? = null
    ) {
        if (activityContext != null && !activityContext.isFinishing && !activityContext.isDestroyed && !message.isNullOrEmpty()) {
            //Avoid displaying snackbar if already displayed
            if (snackbar != null && snackbar!!.isShown) updateSnackBarContent(message, icon)
            else {

                // Create the Snackbar
                val parentView: AppBarLayout = activityContext.findViewById(R.id.appbar)
                snackbar = Snackbar.make(parentView, "", Snackbar.LENGTH_INDEFINITE)
                snackbar?.animationMode = BaseTransientBottomBar.ANIMATION_MODE_FADE

                // Get the Snackbar's layout view
                val snackbarLayout = (snackbar?.view as Snackbar.SnackbarLayout).also {
                    it.setBackgroundColor(Color.TRANSPARENT)
                }

                // Inflate our custom view
                val snackView: View =
                    activityContext.layoutInflater.inflate(R.layout.payu_custom_snackbar, null)
                snackBarText = snackView.findViewById(R.id.tvSnackBarMessage)
                snackBarText?.text = message

                snackBarIcon = snackView.findViewById(R.id.ivSnackBarIcon)
                if (icon != null) snackBarIcon?.setImageResource(icon)


                val ivSnackBarClose = snackView.findViewById<ImageView>(R.id.ivSnackBarClose)
                ivSnackBarClose.setOnClickListener {
                    dismissSnackBar()
                }

                val rlSnackBar = snackView.findViewById<ConstraintLayout>(R.id.rlSnackBar)
                if (isDarkColor(
                        getComputedColor(
                            activityContext.applicationContext,
                            R.color.one_payu_colorPrimary
                        )
                    )
                ) {
                    rlSnackBar.background.setTint(
                        getComputedColor(
                            activityContext.applicationContext,
                            R.color.payu_color_ffffff
                        )
                    )
                    snackBarText?.setTextColor(
                        getComputedColor(
                            activityContext.applicationContext,
                            R.color.payu_color_000000
                        )
                    )
                } else {
                    rlSnackBar.background.setTint(
                        getComputedColor(
                            activityContext.applicationContext,
                            R.color.payu_color_000000
                        )
                    )
                    snackBarText?.setTextColor(
                        getComputedColor(
                            activityContext.applicationContext,
                            R.color.payu_color_ffffff
                        )
                    )
                    ImageViewCompat.setImageTintList(
                        snackBarIcon!!,
                        ColorStateList.valueOf(
                            getComputedColor(
                                activityContext.applicationContext,
                                R.color.payu_color_ffffff
                            )
                        )
                    )
                    ImageViewCompat.setImageTintList(
                        ivSnackBarClose,
                        ColorStateList.valueOf(
                            getComputedColor(
                                activityContext.applicationContext,
                                R.color.payu_color_ffffff
                            )
                        )
                    )
                }

                bgColor?.let {
                    rlSnackBar.background.setTint(
                        getComputedColor(
                            activityContext.applicationContext,
                            bgColor
                        )
                    )
                }

                //If the view is not covering the whole snackbar layout, add this line
                snackbarLayout.setPadding(0, 0, 0, 0)

                // Add the view to the Snackbar's layout
                snackbarLayout.addView(snackView, 0)

                val params =
                    snackbarLayout.layoutParams as FrameLayout.LayoutParams
                params.gravity = Gravity.TOP
                params.topMargin =
                    activityContext.resources.getDimension(R.dimen.payu_dimen_19dp).toInt()
                snackbarLayout.layoutParams = params

                // Show the Snackbar
                snackbar?.show()
                rlSnackBar.postDelayed({ snackbar?.dismiss() }, 3000)

            }
        }
    }

    private fun updateSnackBarContent(message: String, icon: Int?) {
        snackBarText?.text = message
        if (icon != null) snackBarIcon?.setImageResource(icon)
    }

    fun getComputedColor(context: Context, color: Int) = ContextCompat.getColor(context, color)

    fun dismissSnackBar() {
        if (snackbar != null && snackbar!!.isShown) {
            snackbar?.dismiss()
            snackbar = null
            snackBarText = null
            snackBarIcon = null
        }
    }

    fun isInternetAvailable(context: Context): Boolean {
        var result = false

        if (context == null)
            return result

        val connectivityManager =
            context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            val networkCapabilities = connectivityManager.activeNetwork ?: return false
            val actNw =
                connectivityManager.getNetworkCapabilities(networkCapabilities) ?: return false
            result = when {
                actNw.hasTransport(NetworkCapabilities.TRANSPORT_WIFI) -> true
                actNw.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR) -> true
                actNw.hasTransport(NetworkCapabilities.TRANSPORT_ETHERNET) -> true
                else -> false
            }
        } else {
            connectivityManager.run {
                connectivityManager.activeNetworkInfo?.run {
                    result = when (type) {
                        ConnectivityManager.TYPE_WIFI -> true
                        ConnectivityManager.TYPE_MOBILE -> true
                        ConnectivityManager.TYPE_ETHERNET -> true
                        else -> false
                    }

                }
            }
        }

        return result
    }

    fun hideSoftKeyboard(activity: Activity?) {
        if (activity != null && !activity.isFinishing && !activity.isDestroyed) {
            val imm: InputMethodManager =
                activity.getSystemService(Activity.INPUT_METHOD_SERVICE) as InputMethodManager
            //Find the currently focused view, so we can grab the correct window token from it.
            var view = activity.currentFocus
            //If no view currently has focus, create a new one, just so we can grab a window token from it
            if (view == null) {
                view = View(activity)
            }
            imm.hideSoftInputFromWindow(view.windowToken, 0)
        }
    }

    fun hideSoftKeyboardFromToken(activity: Activity, view: View?) {
        if (activity != null && !activity.isFinishing && !activity.isDestroyed) {
            val imm: InputMethodManager =
                activity.getSystemService(Activity.INPUT_METHOD_SERVICE) as InputMethodManager
            imm.hideSoftInputFromWindow(view?.windowToken, 0)
        }
    }

    fun showSoftKeyboard(activity: Activity) {
        if (activity != null && !activity.isFinishing && !activity.isDestroyed) {
            val imm: InputMethodManager? =
                activity.getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager?
            imm?.toggleSoftInput(
                InputMethodManager.SHOW_FORCED,
                InputMethodManager.HIDE_IMPLICIT_ONLY
            )
        }
    }

    fun isSimSupport(context: Context): Boolean {

        if (context == null)
            return false

        val tm =
            context.getSystemService(Context.TELEPHONY_SERVICE) as? TelephonyManager //gets the current TelephonyManager
        return tm?.simState != TelephonyManager.SIM_STATE_ABSENT
    }

    /**
     * Function to remove focus from single editext searchview
     * */
    fun clearFocusFromSearchView(activity: Activity) {
        if (activity != null && !activity.isFinishing && !activity.isDestroyed) {

            val search = activity.findViewById<EditText>(R.id.search_src_text)
            if (search != null && search.hasFocus()) {
                //Request focus on root view of search view to remove focus
                val v = activity.findViewById<ConstraintLayout>(R.id.rlSearchView)
                if (null != v && v.isFocusable) v.requestFocus()
            }
        }
    }

    fun getToolbar(
        context: Context,
        additionalCharge: Double?,
        paymentType: PaymentType? = null
    ): PayuToolbar {
        val toolbar = PayuToolbar()
        if (!SdkUiInitializer.apiLayer?.config?.baseTextColor.isNullOrEmpty()
            && HexColorValidator.validate(SdkUiInitializer.apiLayer?.config?.baseTextColor)
        )
            toolbar.textColor = Color.parseColor(SdkUiInitializer.apiLayer?.config?.baseTextColor)
        else toolbar.textColor = ContextCompat.getColor(context, R.color.one_payu_baseTextColor)


        if (!SdkUiInitializer.apiLayer?.config?.primaryColor.isNullOrEmpty()
            && HexColorValidator.validate(SdkUiInitializer.apiLayer?.config?.primaryColor)
        )
            toolbar.bgColor = Color.parseColor(SdkUiInitializer.apiLayer?.config?.primaryColor)
        else toolbar.bgColor = ContextCompat.getColor(context, R.color.one_payu_colorPrimary)

        val merchantName: String = context.getString(
            R.string.payu_pay_merchant,
            SdkUiInitializer.apiLayer?.config?.merchantName?.take(20)
        )
        val amount: String = if (Utils.isEnachPayment(paymentType)) context.getString(
            R.string.payu_amount_with_rupee_symbol,
            "0.0"
        ) else if (additionalCharge != null) context.getString(
            R.string.payu_amount_with_rupee_symbol, String.format(
                "%.2f", SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()?.plus(
                    additionalCharge
                )
            )
        )
        else context.getString(
            R.string.payu_amount_with_rupee_symbol,
            SdkUiInitializer.apiLayer?.payUPaymentParams?.amount
        )
        toolbar.title = "$merchantName $amount"
        return toolbar
    }

    fun enableView(view: View?) {
        view?.alpha = 1f
        view?.isEnabled = true
    }

    internal fun enableViews(views: List<View>?) {
        views?.forEach { view ->
            view?.alpha = 1f
            view?.isEnabled = true
        }
    }

    fun disableView(view: View?) {
        view?.alpha = 0.5f
        view?.isEnabled = false
    }

    internal fun disableViews(views: List<View>?) {
        views?.forEach { view ->
            view?.alpha = 0.5f
            view?.isEnabled = false
        }
    }

    fun showImageToolTip(
        activity: Activity,
        anchorView: View,
        rootView: View?,
        toolTipModel: ToolTipModel
    ) {
        if (!(activity.isFinishing || activity.isDestroyed)) {
            showToolTip(
                activity, anchorView, rootView, prepareCustomView(
                    toolTipModel.title,
                    toolTipModel.description,
                    activity,
                    true,
                    toolTipModel.imageId
                )
            )
        }
    }

    fun showTextToolTip(
        activity: Activity,
        anchorView: View,
        rootView: View?,
        toolTipModel: ToolTipModel
    ) {
        if (!(activity.isFinishing || activity.isDestroyed)) {
            showToolTip(
                activity, anchorView, rootView, prepareCustomView(
                    toolTipModel.title,
                    toolTipModel.description,
                    activity,
                    false,
                    null
                )
            )
        }
    }

    private fun showToolTip(
        activity: Activity,
        anchorView: View,
        rootView: View?,
        view: View
    ) {
        val viewToolTip: ViewToolTip =
            if (rootView == null) ViewToolTip.on(activity, anchorView) else ViewToolTip.on(
                activity,
                rootView,
                anchorView
            )
        viewToolTip
            .customView(view)
            .color(
                ContextCompat.getColor(
                    activity.applicationContext,
                    R.color.payu_tooltip_color
                )
            )
            .margin(
                activity.resources.getDimension(R.dimen.payu_dimen_18dp).toInt(),
                0,
                activity.resources.getDimension(
                    R.dimen.payu_dimen_18dp
                ).toInt(),
                0
            )
            .corner(activity.resources.getDimension(R.dimen.payu_dimen_20dp).toInt())
            .arrowHeight(activity.resources.getDimension(R.dimen.payu_dimen_10dp).toInt())
            .arrowWidth(activity.resources.getDimension(R.dimen.payu_dimen_7dp).toInt())
            .distanceWithView(0)
            .autoHide(false, 1000)
            .position(ViewToolTip.Position.TOP)
            .show()
    }

    private fun prepareCustomView(
        title: String?,
        description: String?,
        activity: Activity,
        showImage: Boolean,
        imageId: Int?
    ): View {
        val view = activity.layoutInflater.inflate(R.layout.custom_image_tooltip, null)
        val llToolTip = view.findViewById<ConstraintLayout>(R.id.llToolTip)
        val tvToolTiptitle = view.findViewById<TextView>(R.id.tvToolTiptitle)
        val tvToolTipContent = view.findViewById<TextView>(R.id.tvToolTipContent)
        val rlToolTip = view.findViewById<ConstraintLayout>(R.id.rlToolTip)

        val toolTipWidth = getToolTipWidth(activity)
        val layoutParams = FrameLayout.LayoutParams(
            toolTipWidth,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        rlToolTip.layoutParams = layoutParams

        tvToolTiptitle.text = title
        tvToolTipContent.text = description
        tvToolTiptitle.setTextColor(
            ContextCompat.getColor(
                activity.applicationContext,
                R.color.payu_color_ffffff
            )
        )
        tvToolTipContent.setTextColor(
            ContextCompat.getColor(
                activity.applicationContext,
                R.color.payu_color_ffffff
            )
        )
        llToolTip.setBackgroundColor(
            ContextCompat.getColor(
                activity.applicationContext,
                R.color.payu_tooltip_color
            )
        )

        val ivToolTipImage = view.findViewById<ImageView>(R.id.ivToolTipImage)
        ivToolTipImage.also {
            it.requestLayout()
            it.layoutParams.width = toolTipWidth / 3
        }

        if (showImage && imageId != null) {
            ivToolTipImage.setImageResource(imageId)
            ivToolTipImage.visibility = View.VISIBLE
        } else ivToolTipImage.visibility = View.GONE

        return view
    }

    /**
     * Compute tooltip width dynamically based on screen width
     * */
    private fun getToolTipWidth(activity: Activity): Int {
        val displayMetrics = DisplayMetrics()
        activity.windowManager.defaultDisplay.getMetrics(displayMetrics)
        return (displayMetrics.widthPixels * 0.75).toInt()
    }

    fun hideToolTip() {
        ViewToolTip.hide()
    }

    fun isDarkColor(color: Int): Boolean {
        return ColorUtils.calculateLuminance(color) < 0.5
    }

    /**
     * Function to attach view tree listener on a layout to keep track of latest height and width of view then set this
     * height and width to a transparent view which will appear as an overlay above this view
     * @param viewGroup view whose view tree needs to be observed
     * @param transparentView view which act as an overlay with same height and width as viewGroup passed in method
     * @return an instance of ViewTreeObserver.OnGlobalLayoutListener
     * */
    fun attachViewTreeListener(
        viewGroup: ViewGroup?,
        transparentView: View?
    ): ViewTreeObserver.OnGlobalLayoutListener? {
        val vto: ViewTreeObserver? = viewGroup?.viewTreeObserver
        var globalLayoutListener: ViewTreeObserver.OnGlobalLayoutListener? = null
        vto?.addOnGlobalLayoutListener(object : ViewTreeObserver.OnGlobalLayoutListener {
            override fun onGlobalLayout() {
                globalLayoutListener = this
                val width: Int = viewGroup.measuredWidth
                val height: Int = viewGroup.measuredHeight
                val transparentViewParams =
                    RelativeLayout.LayoutParams(width, height)
                transparentView?.layoutParams = transparentViewParams
            }
        })
        return globalLayoutListener
    }

    /**
     * Function to remove the view tree observer from a view
     * @param globalLayoutListener listener to remove
     * @param viewGroup view from whom the listener should be removed
     * */
    fun removeViewTreeListener(
        globalLayoutListener: ViewTreeObserver.OnGlobalLayoutListener?,
        viewGroup: ViewGroup?
    ) {
        if (globalLayoutListener == null)
            return

        viewGroup?.viewTreeObserver?.removeOnGlobalLayoutListener(globalLayoutListener)
    }

    fun showProgressDialog(context: Context?) {
        context?.let {
            if (progressDialog == null) {
                progressDialog = ProgressDialog(it)
                progressDialog!!.setMessage(it.getString(R.string.payu_please_wait))
                progressDialog!!.setCancelable(false)
                progressDialog!!.show()
            } else {
                progressDialog!!.show()
            }
        }
    }

    fun hideProgressDialog() {
        if ((progressDialog != null) && (progressDialog!!.isShowing)) {
            progressDialog!!.dismiss()
            progressDialog = null
        }
    }

    fun getDeviceDensity(activity: Activity): String {
        val metrics = DisplayMetrics()
        activity.windowManager.defaultDisplay.getMetrics(metrics)
        return metrics.densityDpi.toString() + ""
    }

    /**
     * Calculate network status
     *
     * @param context
     * @return
     */
    fun getNetworkStatus(context: Context?): String {
        try {
            if (null != context) {
                val cm =
                    context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
                val activeNetwork = cm.activeNetworkInfo
                if (activeNetwork != null) { // connected to the internet
                    if (activeNetwork.type == ConnectivityManager.TYPE_WIFI) {
                        // connected to wifi
                        return "Wifi"
                    } else if (activeNetwork.type == ConnectivityManager.TYPE_MOBILE) {
                        // connected to the mobile provider's data plan
                        val mTelephonyManager =
                            context.getSystemService(Context.TELEPHONY_SERVICE) as
                                    TelephonyManager

                        if (mTelephonyManager == null) return "?"
                        else {
                            return when (mTelephonyManager.networkType) {
                                TelephonyManager.NETWORK_TYPE_GPRS -> "GPRS"
                                TelephonyManager.NETWORK_TYPE_EDGE -> "EDGE"
                                TelephonyManager.NETWORK_TYPE_CDMA -> "CDMA"
                                TelephonyManager.NETWORK_TYPE_1xRTT, TelephonyManager.NETWORK_TYPE_IDEN -> "2G"
                                TelephonyManager.NETWORK_TYPE_UMTS, TelephonyManager.NETWORK_TYPE_EVDO_0, TelephonyManager.NETWORK_TYPE_EVDO_A, TelephonyManager.NETWORK_TYPE_HSDPA, TelephonyManager.NETWORK_TYPE_HSUPA, TelephonyManager.NETWORK_TYPE_HSPA -> "HSPA"
                                TelephonyManager.NETWORK_TYPE_EVDO_B, TelephonyManager.NETWORK_TYPE_EHRPD, TelephonyManager.NETWORK_TYPE_HSPAP -> "3G"
                                TelephonyManager.NETWORK_TYPE_LTE -> "4G"
                                else -> "?"
                            }
                        }
                    }
                }
            }
        } catch (e: Exception) {
            return "?"
        }
        return "?"
    }

    @SuppressLint("PrivateApi")
    @Nullable
    fun getCurrentWebViewPackageInfo(): PackageInfo? {
        var pInfo: PackageInfo? = null
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            //starting with Android O (API 26) they added a new method specific for this
            pInfo = WebView.getCurrentWebViewPackage()
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            //with Android Lollipop (API 21) they started to update the WebView
            //as a separate APK with the PlayStore and they added the
            //getLoadedPackageInfo() method to the WebViewFactory class and this
            //should handle the Android 7.0 behaviour changes too
            try {
                val webViewFactory = Class.forName("android.webkit.WebViewFactory")
                val method: Method = webViewFactory.getMethod("getLoadedPackageInfo")
                pInfo = method.invoke(null) as PackageInfo?
            } catch (e: java.lang.Exception) {
                e.printStackTrace()
            }
        } else {
            //before Lollipop the WebView was bundled with the
            //OS, the fixed versions can be found online, for example:
            //Android 4.4 has WebView version 30.0.0.0
            //Android 4.4.3 has WebView version 33.0.0.0
            //etc...
        }
        return pInfo
    }

    /**
     * Return current time of system in the format "yyyy-MM-dd HH:mm:ss"
     *
     * @return system current time in string
     */
    fun getSystemCurrentTime(): String? {
        try {
            val currentDate = Date(System.currentTimeMillis())
            val df: DateFormat = SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
            return df.format(currentDate)
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
        return ""
    }

    /**
     * Returns app version like 1.2.0, etx
     * @param context Context
     * @return app version as a string
     * */
    fun getAppVersion(context: Context): String {
        val manager: PackageManager = context.packageManager
        val info: PackageInfo = manager.getPackageInfo(
            context.packageName, 0
        )
        return info.versionName
    }

    fun getTimeDifferenceInSeconds(apiCalledTime: Long, currentTime: Long) = "${
        TimeUnit.MILLISECONDS.toSeconds(
            currentTime - apiCalledTime
        )
    } seconds"

    fun showSpanView(context: Context, filteredString: String, drawable: Int, view: TextView) {
        val name = SpannableStringBuilder()
        name.append(filteredString + "   ")
        val ss = SpannableString("  ")
        ss.setSpan(ImageSpan(context, drawable), 0, 1, Spannable.SPAN_INCLUSIVE_INCLUSIVE)
        name.append(ss)
        view.transformationMethod = null
        view.setText(name, TextView.BufferType.SPANNABLE)
    }

    fun shakeAnimationInView(view: View?) {
        val animationSet = TranslateAnimation(0f, 25f, 0f, 0f)
        animationSet.duration = 80
        animationSet.repeatCount = 3
        animationSet.repeatMode = 2
        view?.startAnimation(animationSet)

    }

    fun updateTextColor(context: Context, view: TextView?, color: String?, defaultColor: Int) {
        if (!color.isNullOrEmpty() && HexColorValidator.validate(color))
            view?.setTextColor(Color.parseColor(color))
        else
            view?.setTextColor(ContextCompat.getColor(context, defaultColor))
    }

    fun updateBackgroundColor(context: Context, view: View?, color: String?, defaultColor: Int) {
        if (!color.isNullOrEmpty() && HexColorValidator.validate(color)
            && view != null && view.background != null
        ) {
            val unwrappedDrawable: Drawable? =
                view.background
            val wrappedDrawable: Drawable = DrawableCompat.wrap(unwrappedDrawable!!)
            wrappedDrawable.mutate()
            DrawableCompat.setTint(wrappedDrawable, Color.parseColor(color))
        } else {
            val unwrappedDrawable: Drawable? =
                view?.background
            unwrappedDrawable?.let {
                val wrappedDrawable: Drawable = DrawableCompat.wrap(unwrappedDrawable)
                wrappedDrawable.mutate()
                DrawableCompat.setTint(wrappedDrawable, context.resources.getColor(defaultColor))
            }
        }
    }

    fun updateContentScrimColor(view: CollapsingToolbarLayout?, color: String?) {
        if (!color.isNullOrEmpty() && HexColorValidator.validate(color)
            && view != null && view.contentScrim != null
        ) {
            val unwrappedDrawable: Drawable? =
                view.contentScrim
            val wrappedDrawable: Drawable = DrawableCompat.wrap(unwrappedDrawable!!)
            wrappedDrawable.mutate()
            DrawableCompat.setTint(wrappedDrawable, Color.parseColor(color))
        }
    }

    fun updateSVGColor(context: Context, view: ImageView, color: String?, defaultColor: Int) {
        if (!color.isNullOrEmpty() && view != null && HexColorValidator.validate(color))
            view?.setColorFilter(Color.parseColor(color))
        else if (view != null)
            view?.setColorFilter(context?.resources.getColor(defaultColor), PorterDuff.Mode.SRC_IN)
    }

    fun updateSVGColor(context: Context, view: Drawable, color: String?, defaultColor: Int) {
        if (!color.isNullOrEmpty() && view != null && HexColorValidator.validate(color)) {
            val porterDuff = PorterDuffColorFilter(
                Color.parseColor(color),
                PorterDuff.Mode.SRC_IN
            )
            view.colorFilter = porterDuff
        } else if (view != null) {
            val porterDuff = PorterDuffColorFilter(
                context.resources.getColor(defaultColor),
                PorterDuff.Mode.SRC_IN
            )
            view.colorFilter = porterDuff
        }
    }

    fun updateStrokeColor(context: Context, view: View?, color: String?, defaultColor: Int) {
        if (!color.isNullOrEmpty() && view != null &&
            view.background != null && HexColorValidator.validate(color)
        ) {
            val drawable: GradientDrawable = view.background as GradientDrawable
            drawable.mutate()
            drawable.setStroke(3, Color.parseColor(color))
        } else if (view != null && view.background != null) {
            updateStrokeColor(context, view, defaultColor)
        }
    }

    fun updateStrokeColor(context: Context, view: View?, color: Int = R.color.payu_color_338f9dbd) {
        if (view != null && view.background != null) {
            val drawable: GradientDrawable = view.background as GradientDrawable
            drawable.mutate()
            drawable.setStroke(
                3,
                ContextCompat.getColor(context, color)
            )
        }
    }

    fun updateButtonTextColor(view: Button?, color: String?) {
        if (!color.isNullOrEmpty() && view != null &&
            !view.text.isNullOrEmpty() && HexColorValidator.validate(color)
        ) {
            view.setTextColor(Color.parseColor(color))
        }
    }

    fun changeProgressDialog(progressDialog: ProgressDialog, color: String?) {
        if (!color.isNullOrEmpty() && HexColorValidator.validate(color)) {
            val progressbar = progressDialog.findViewById(android.R.id.progress) as ProgressBar
            progressbar.indeterminateDrawable.setColorFilter(
                Color.parseColor(color),
                PorterDuff.Mode.SRC_IN
            )
        }
    }

    fun changeProgressBarColor(progressBar: ProgressBar?, color: String?) {
        if (!color.isNullOrEmpty() && HexColorValidator.validate(color)) {
            progressBar?.indeterminateTintList =
                ColorStateList.valueOf(Color.parseColor(color))
        }
    }

    fun changeSwitchTrackAndThumbColor(
        context: Context,
        switchCompat: SwitchCompat,
        color: String?,
        defaultColor: Int
    ) {
        var finalColor = ContextCompat.getColor(context, defaultColor)
        if (!color.isNullOrEmpty() && HexColorValidator.validate(color))
            finalColor = Color.parseColor(color)

        val states = arrayOf(
            intArrayOf(android.R.attr.state_checked),
            intArrayOf()
        )
        val trackColors = intArrayOf(
            ColorUtils.setAlphaComponent(finalColor, 77),
            ColorUtils.setAlphaComponent(Color.GRAY, 77),
        )
        val selectedColors = intArrayOf(
            finalColor,
            Color.GRAY
        )

        DrawableCompat.setTintList(
            DrawableCompat.wrap(switchCompat.trackDrawable),
            ColorStateList(states, trackColors)
        )

        DrawableCompat.setTintList(
            DrawableCompat.wrap(switchCompat.thumbDrawable),
            ColorStateList(states, selectedColors)
        )

    }

    internal fun getDrawable(context: Context, resID: Int): Drawable? {
        return ResourcesCompat.getDrawable(context.resources, resID, context.theme)

    }

    /**
     * Function will show the keyboard and focus on editText
     * @param view EditText
     */
    internal fun showSoftKeyboard(view: View) {
        view.requestFocus()
        val imm = view.context
            .getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
        imm.toggleSoftInput(
            InputMethodManager.SHOW_FORCED,
            InputMethodManager.HIDE_IMPLICIT_ONLY
        )
    }

    fun hideSoftKeyboard(view: View) {
        view.clearFocus()
        val imm: InputMethodManager = view.context
            .getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
        imm.hideSoftInputFromWindow(view.windowToken, 0)
    }

    internal fun AppCompatImageView.applyLoopingAnimatedVectorDrawable(@DrawableRes avdResId: Int) {
        val animated = AnimatedVectorDrawableCompat.create(context, avdResId)
        animated?.registerAnimationCallback(object : Animatable2Compat.AnimationCallback() {
            override fun onAnimationEnd(drawable: Drawable?) {
                this@applyLoopingAnimatedVectorDrawable.post { animated.start() }
            }
        })
        this.setImageDrawable(animated)
        animated?.start()
    }


    fun showNetworkError(context : Context) {
        showSnackBar(
            context?.resources?.getString(R.string.payu_no_internet_connection),
            R.drawable.payu_no_internet,
            context as Activity
        )
    }

    internal fun openPrivacyUrl(activity: Activity?) {
        val browserIntent =
            Intent(Intent.ACTION_VIEW, Uri.parse(PRIVACY_POLICY_URL))
        activity?.packageManager?.let {
            if (browserIntent.resolveActivity(it) != null) {
                activity?.startActivity(browserIntent)
            }
        }
    }

    internal fun clearContextRefs(){
        snackBarIcon = null
        snackbar = null
        snackBarText = null
        progressDialog = null
    }

    internal fun AppCompatImageView.applyLoopingAnimatedVectorDrawable(@DrawableRes avdResId: Int,
                                                                       activity: Activity) {
        val animated = AnimatedVectorDrawableCompat.create(activity, avdResId)
        animated?.registerAnimationCallback(object : Animatable2Compat.AnimationCallback() {
            override fun onAnimationEnd(drawable: Drawable?) {
                this@applyLoopingAnimatedVectorDrawable.post { animated.start() }
            }
        })
        this.setImageDrawable(animated)
        animated?.start()
    }

    /**
     * Init PayU Progress Dialog Default Loader Settings
     *
     * @param context
     */
    internal fun setPayUDialogSettings(imageView: AppCompatImageView?, activity: Activity) {
        imageView?.applyLoopingAnimatedVectorDrawable(R.drawable.payu_loader, activity);
    }

}