package com.payu.ui.model.listeners

import android.view.View
import com.payu.base.models.PaymentOption

interface OnBankAdapterListener {
    fun emiSelected(paymentOption: PaymentOption, isForcedPayment: Boolean)
    fun itemSelected(paymentOption: PaymentOption, isOfferValid: Boolean = false, isTopItem: Boolean)
    fun itemUnSelected(isTopItem: Boolean)
    fun removeOffer()
    fun validateOffer(
        paymentOption: PaymentOption,
        validateOfferResultListener: ValidateOfferResultListener
    )

    fun isActivityAlive(): Boolean
    fun showSnackBar(
        message: String?,
        icon: Int?,
        bgColor: Int? = null
    )

    fun getCurrentFocus(): View?
    fun clearFocus(endAction: (() -> Unit)?)
}