package com.payu.ui.model.adapters.viewholders

import android.content.Context
import android.content.res.Resources
import android.view.View
import android.widget.TextView
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.models.InternalConfig
import com.payu.base.models.OfferInfo
import com.payu.ui.R
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils

class SKUOfferListViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
    private val tvOfferName: TextView = itemView.findViewById(R.id.tvOfferName)
    private val tvOfferDetails: TextView = itemView.findViewById(R.id.tvOfferDetails)
    private val tvSKUAmount: TextView = itemView.findViewById(R.id.tvSKUAmount)
    private val tvSkuDiscount: TextView = itemView.findViewById(R.id.tvSkuDiscount)

    fun bind(offerInfo: OfferInfo?) {
        tvOfferName.text = offerInfo?.sku?.skuName?.trim()
        tvOfferDetails.visibility = View.VISIBLE
        tvOfferDetails.text = offerInfo?.description?.trim()
        tvSKUAmount.visibility = View.VISIBLE
        tvSKUAmount.text = Utils.getFormattedAmount(
            (offerInfo?.sku?.skuAmount?.toDouble()
                ?: 0.0) * (offerInfo?.sku?.quantity?.toDouble() ?: 0.0),
            itemView.context
        )
        val discount =
            if (offerInfo?.isNoCostEmi == true) InternalConfig.emiOfferInfo?.nceDiscount?.total else offerInfo?.discountDetailsOfOffers?.discount
        if (discount != null) {
            tvSkuDiscount.visibility = View.VISIBLE
            if (offerInfo?.offerType == SdkUiConstants.CP_CASHBACK || offerInfo?.offerType == SdkUiConstants.CP_REWARD) {
                tvSkuDiscount.text =
                    getDiscountText(itemView.context, discount, R.string.payu_cashback)
            } else {
                tvSkuDiscount.text =
                    getDiscountText(itemView.context, discount, R.string.payu_off_text)
            }
        }

        ViewUtils.updateBackgroundColor(
            itemView.context,
            tvSkuDiscount,
            ContextCompat.getColor(itemView.context, R.color.payu_color_34A853).toString(),
            R.color.payu_color_34A853
        )
    }

    private fun getDiscountText(context: Context, discount: Double, resId: Int): String {
        val discountText = "${
            Utils.getFormattedAmount(
                discount,
                context,
                R.string.payu_amount_text
            )
        } ${context.getString(resId)}"
        val width = (Resources.getSystem().displayMetrics.widthPixels * 0.012)
        return if (discountText.length <= width) {
            discountText
        } else {
            context.getString(
                R.string.payu_sku_discount_string, Utils.getFormattedAmount(
                    discount,
                    context,
                    R.string.payu_amount_text
                ), context.getString(resId)
            )
        }
    }

}
