package com.payu.ui.model.adapters.viewholders

import android.content.Context
import android.view.View
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils


open class QuickOptionViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

    val ivPaymentOptionIcon: ImageView = itemView.findViewById(R.id.ivPaymentOptionIcon)
    val tvPaymentOptionName: TextView = itemView.findViewById(R.id.tvPaymentOptionName)
    val tvOfferText: TextView = itemView.findViewById(R.id.tvOfferText)
    val btnProceedToPay: Button = itemView.findViewById(R.id.btnProceedToPay)
    val rlQuickOptions: ConstraintLayout = itemView.findViewById(R.id.rlQuickOptions)
    private val tvBankDown: TextView = itemView.findViewById(R.id.tvBankDown)

    var onItemClickListener: ((paymentMode: PaymentMode, position: Int, isBalanceFetched: Boolean) -> Unit)? =
        null

    init {
        btnProceedToPay.context?.let {
            ViewUtils.updateBackgroundColor(
                it,
                btnProceedToPay,
                SdkUiInitializer.apiLayer?.config?.primaryColor,
                R.color.one_payu_colorPrimary
            )
            ViewUtils.updateTextColor(
                it,
                btnProceedToPay,
                SdkUiInitializer.apiLayer?.config?.baseTextColor,
                R.color.one_payu_baseTextColor
            )
        }
    }

    private fun handleItemSelection(paymentType: PaymentType?) {
        btnProceedToPay.visibility =
            if (paymentType != PaymentType.CARD) View.VISIBLE else View.GONE
        InternalConfig.isPaymentOptionSelected = paymentType != PaymentType.CARD
    }

    private fun handleNoSelection() {
        btnProceedToPay.visibility = View.GONE
    }

    internal fun showBankDownView() {
        tvBankDown.visibility = View.VISIBLE
        tvOfferText.visibility = View.GONE
        rlQuickOptions.isEnabled = false
        ViewUtils.disableViews(listOf(ivPaymentOptionIcon, tvPaymentOptionName))
    }

    internal fun showOfferView(
        isOfferValid: Boolean = false
    ) {
        tvBankDown.visibility = View.GONE
        tvOfferText.visibility = View.VISIBLE
        rlQuickOptions.isEnabled = true
        ViewUtils.enableViews(listOf(ivPaymentOptionIcon, tvPaymentOptionName))

        if (isOfferValid && InternalConfig.isPaymentOptionSelected) {
            tvOfferText.text = tvOfferText.context?.getString(R.string.payu_offer_applied)
            tvOfferText.context?.let {
                ViewUtils.updateBackgroundColor(
                    it,
                    tvOfferText,
                    R.color.payu_color_36b37e.toString(),
                    R.color.payu_color_36b37e
                )
            }
        } else {
            tvOfferText.text = tvOfferText.context?.getString(R.string.payu_offers)
            tvOfferText.context?.let {
                ViewUtils.updateBackgroundColor(
                    it,
                    tvOfferText,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
            }
        }
    }

    internal fun showDefaultView() {
        tvOfferText.visibility = View.GONE
        rlQuickOptions.isEnabled = true
        ViewUtils.enableViews(listOf(ivPaymentOptionIcon, tvPaymentOptionName))
    }

    internal fun makePayment(context: Context, paymentOption: PaymentOption) {
        SdkUiInitializer.apiLayer?.updatePaymentState(
            Utils.getPaymentModel(
                paymentOption,
                null
            ),
            ViewUtils.getToolbar(
                context,
                paymentOption.additionalCharge
            )
        )
    }

    internal fun updateSelectedItem(
        paymentMode: PaymentMode,
        selectedPosition: Int
    ) {
        if (selectedPosition == absoluteAdapterPosition)
            handleItemSelection(paymentMode.type)
        else {
            paymentMode.isOfferValid = false
            handleNoSelection()
        }

    }
}