package com.payu.ui.model.adapters.viewholders

import android.content.Context
import android.view.View
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.models.InternalConfig
import com.payu.ui.R
import com.payu.ui.model.listeners.OnNetBankingAdapterListener
import com.payu.ui.model.utils.MultipleClickHandler

class OfferViewHolder(view: View) : RecyclerView.ViewHolder(view) {
    private val context: Context = view.context
    private var changeOfferOption: ConstraintLayout? = view.findViewById(R.id.changeOfferOption)
    private var tvOfferTitle: TextView? = view.findViewById(R.id.tvOfferTitle)
    private var tvOfferDisc: TextView? = view.findViewById(R.id.tvOfferDisc)
    private var tvOfferDetails: TextView? = view.findViewById(R.id.tvOfferDetails)
    private var removeOfferButton: TextView? = view.findViewById(R.id.tvRemoveOfferButton)
    fun bind(onNetBankingAdapterListener: OnNetBankingAdapterListener) {
        val offerKeySet = HashSet<String>()
        InternalConfig.selectedOfferInfo?.offerMap?.values?.forEach {
            it.offerKey?.let { it1 -> offerKeySet.add(it1) }
        }
        val length = offerKeySet.size
        if (length > 1) {
            tvOfferTitle?.text = context.getString(
                R.string.payu_offer_applied_text,
                length.toString()
            )
            tvOfferDisc?.visibility = View.GONE
        } else if (length == 1) {
            val offerMap = InternalConfig.selectedOfferInfo?.offerMap;
            val offerKey = offerMap?.keys?.first()
            tvOfferTitle?.text =
                offerMap?.get(offerKey)?.title
            tvOfferDisc?.visibility = View.VISIBLE
            tvOfferDisc?.text =
                offerMap?.get(offerKey)?.description
        } else changeOfferOption?.visibility = View.GONE
        if (InternalConfig.selectedOfferInfo?.isSkuOffer == true) tvOfferDetails?.visibility =
            View.VISIBLE else tvOfferDetails?.visibility = View.GONE


        tvOfferDetails?.setOnClickListener {
            onNetBankingAdapterListener.showSkuBottomSheet(true)
        }

        removeOfferButton?.setOnClickListener {
            if (MultipleClickHandler.isSafeOnClickListener()) {
                onNetBankingAdapterListener.removeOffers()
            }
        }
    }
}
