package com.payu.ui.model.adapters

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.BnplOption
import com.payu.base.models.CardOption
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.base.models.UPIOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.SdkUiConstants

class SavedOptionsListAdapter(
    private var savedCardsList: ArrayList<PaymentMode>,
    private val savedOptionListener: SavedOptionsListener
) :
    RecyclerView.Adapter<SavedOptionsListAdapter.ViewHolder>() {

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        private val ivPaymentOptionIcon: ImageView = itemView.findViewById(R.id.ivPaymentOptionIcon)
        private val tvPaymentOptionName: TextView = itemView.findViewById(R.id.tvPaymentOptionName)
        private val tvPaymentOptionDetail: TextView =
            itemView.findViewById(R.id.tvPaymentOptionDetail)
        private val ivRightArrow: ImageView = itemView.findViewById(R.id.ivRightArrow)

        fun bind(paymentMode: PaymentMode) {
            val paymentOption = paymentMode.optionDetail?.first()
            ivRightArrow.setImageResource(R.drawable.payu_delete)
            var param: ImageParam? = null
            when (paymentMode.type) {
                PaymentType.CARD -> {
                    val cardOption = paymentOption as CardOption
                    if (!paymentMode.name.equals(SdkUiConstants.CP_NULL, ignoreCase = true)) {
                        tvPaymentOptionName.text =
                            paymentOption.bankName + " " + paymentOption.cardBinInfo?.cardType?.getTypeName()
                    }

                    tvPaymentOptionDetail.text = cardOption.cardNumber
                    param = ImageParam(paymentOption, true, R.drawable.payu_cards_placeholder)

                }

                PaymentType.UPI, PaymentType.UPI_INTENT -> {
                    tvPaymentOptionDetail.text = (paymentOption as UPIOption).vpa
                    tvPaymentOptionName.text = paymentOption.bankName
                    param = ImageParam(paymentOption, false, R.drawable.payu_upi)
                }

                PaymentType.NB -> {

                    tvPaymentOptionDetail.text =
                        tvPaymentOptionDetail.context?.getString(R.string.payu_pay_using_nb_text)
                    tvPaymentOptionName.text =
                        paymentOption?.bankName + " " + tvPaymentOptionName.context.getString(R.string.payu_netbanking)
                    param = paymentOption?.let { ImageParam(it, false, R.drawable.payu_netbanking) }
                }

                PaymentType.WALLET -> {
                    tvPaymentOptionDetail.text =
                        tvPaymentOptionDetail.context?.getString(R.string.pay_using_wallet_text)
                    tvPaymentOptionName.text =
                        paymentOption?.bankName + " " + tvPaymentOptionName.context.getString(R.string.payu_wallet)
                    param = paymentOption?.let { ImageParam(it, false, R.drawable.payu_wallet) }
                }
                PaymentType.BNPL -> {
                    tvPaymentOptionDetail.text = (paymentOption as BnplOption).phoneNumber
                    tvPaymentOptionName.text = paymentOption.bankName
                    param = ImageParam(paymentOption, false, R.drawable.payu_wallet)
                }

            }

            if (param != null) {
                SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                    param,
                    object : OnFetchImageListener {
                        override fun onImageGenerated(result: ImageDetails) {
                            ImageViewUtils.setImage(ivPaymentOptionIcon, result)
                        }
                    })
            }
        }

        init {
            ivRightArrow.setOnClickListener {
                savedCardsList[bindingAdapterPosition].optionDetail?.first()?.let { it1 ->
                    savedOptionListener.onDeleteClicked(
                        bindingAdapterPosition,
                        it1
                    )
                }
            }
        }

    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        val view: View = inflater.inflate(R.layout.saved_options_list, parent, false)
        return ViewHolder(view)
    }

    override fun getItemCount(): Int {
        return savedCardsList.size
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.bind(savedCardsList[position])
    }

    interface SavedOptionsListener {
        fun onDeleteClicked(deleteIndex: Int, savedCardOption: PaymentOption)
    }
}