package com.payu.ui.model.adapters

import android.view.View
import android.widget.ImageView
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.constraintlayout.widget.Group
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils

open class RecommendationRecyclerViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
    internal var phoneNo = SdkUiInitializer.apiLayer?.payUPaymentParams?.phone
    internal var onItemClickListener: ((view: View, paymentMode: PaymentMode, position: Int) -> Unit)? =
        null

    class VerifiedPaymentOptionViewHolder(itemView: View) :
        RecommendationRecyclerViewHolder(itemView) {
        internal var unlockSavedOptionsIcon: ImageView = itemView.findViewById(R.id.ivImage)
        internal var tvUnlockSavedOptionsTitle: TextView = itemView.findViewById(R.id.pay_using_s)

        private var phoneNoText: TextView = itemView.findViewById(R.id.phoneNo)
        private var llVerified: ConstraintLayout = itemView.findViewById(R.id.llVerified)
        private var tvOfferText: TextView = itemView.findViewById(R.id.tvOfferText)
        fun bind(paymentMode: PaymentMode) {
            val context = itemView.context
            setPaymentOptionImage(unlockSavedOptionsIcon, paymentMode, false)
            tvUnlockSavedOptionsTitle.text = paymentMode.name
            when (paymentMode.type) {
                PaymentType.BNPL -> {
                    if (!Utils.getGlobalVaultStoredUserToken(context).second.isNullOrEmpty())
                        phoneNo =
                            Utils.getGlobalVaultStoredUserToken(context).second
                    phoneNoText.text = phoneNo
                    updateOfferView(paymentMode, tvOfferText)
                }

                PaymentType.NB, PaymentType.WALLET -> {
                    phoneNoText.text = paymentMode.l1OptionSubText
                    updateOfferView(paymentMode, tvOfferText)
                }

                else -> {
                    phoneNoText.text = paymentMode.l1OptionSubText
                }
            }

            llVerified.setOnClickListener {
                onItemClickListener?.invoke(it, paymentMode, bindingAdapterPosition)
            }
        }

        private fun updateOfferView(paymentMode: PaymentMode, view: View) {
            val bankCode = Utils.getValueFromPaymentOption<String>(
                SdkUiConstants.CP_BANK_CODE,
                paymentMode.optionDetail?.get(0)?.otherParams as? HashMap<String, Any?>
            ).toString()
            if (Utils.isOfferAvailable(
                    bankCode,
                    paymentMode.type!!
                ) && Utils.isOfferSelected()
            ) {
                view.visibility = View.VISIBLE
                ViewUtils.updateBackgroundColor(
                    view.context,
                    view,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
            } else view.visibility = View.GONE
        }
    }

    class NonVerifiedPaymentOptionViewHolder(itemView: View) :
        RecommendationRecyclerViewHolder(itemView) {

        internal var nonVerifiedTile: ConstraintLayout = itemView.findViewById(R.id.include2)
        internal var unlockTile: ConstraintLayout = itemView.findViewById(R.id.unlockTile)

        internal var unlockSavedOptionsIcon: ImageView?= null
        internal var tvUnlockSavedOptionsTitle: TextView?= null

        private var tvUnlockVerifiedSubTitle: TextView = itemView.findViewById(R.id.view_your_s)
        private var tvUnlockUnVerifiedSubTitle: TextView = itemView.findViewById(R.id.view_your_unlock_s)
        private var rlUnlockSavedOptionsGlobalVault: ConstraintLayout =
            itemView.findViewById(R.id.rlUnlockSavedOptionsGlobalVault)
        private var tvOfferText: TextView = itemView.findViewById(R.id.tvOfferText)
        private var unlockTileGp: Group = itemView.findViewById(R.id.unlock_tile_gp)
        private var nonVerifiedRETileGp: Group = itemView.findViewById(R.id.non_verified_tile)


        fun bind(paymentMode: PaymentMode) {
            if (paymentMode.unlockOptionsTile) {
                itemView.background = ContextCompat.getDrawable(itemView.context, R.drawable.grey_gradient_bg)
                unlockSavedOptionsIcon = unlockTile.findViewById(R.id.ivImage)
                tvUnlockSavedOptionsTitle = unlockTile.findViewById(R.id.pay_using_s)
                unlockTileGp.visibility = View.VISIBLE
                nonVerifiedRETileGp.visibility = View.GONE
                if(paymentMode.l1OptionSubText.isNullOrEmpty())
                    tvUnlockUnVerifiedSubTitle.visibility = View.GONE
                else {
                    tvUnlockUnVerifiedSubTitle.visibility = View.VISIBLE
                }

            } else {
                itemView.background = ContextCompat.getDrawable(itemView.context, R.drawable.components)
                unlockSavedOptionsIcon = nonVerifiedTile.findViewById(R.id.ivImage)
                tvUnlockSavedOptionsTitle = nonVerifiedTile.findViewById(R.id.pay_using_s)
                unlockTileGp.visibility = View.GONE
                nonVerifiedRETileGp.visibility = View.VISIBLE
            }

            val bankCode = Utils.getValueFromPaymentOption<String>(
                SdkUiConstants.CP_BANK_CODE,
                paymentMode.optionDetail?.get(0)?.otherParams as? HashMap<String, Any?>
            ).toString()
            when (paymentMode.type) {
                PaymentType.CARD, PaymentType.WALLET, PaymentType.NB, PaymentType.BNPL, PaymentType.UPI -> {
                    if (paymentMode.type == PaymentType.UPI)
                        unlockSavedOptionsIcon?.setImageResource(R.drawable.powered_by_upi)
                    else
                        unlockSavedOptionsIcon?.let { setPaymentOptionImage(it, paymentMode, false) }
                    if (Utils.isOfferAvailable(
                            bankCode,
                            paymentMode.type!!
                        ) && Utils.isOfferSelected()
                    ) {
                        tvOfferText.visibility = View.VISIBLE
                        ViewUtils.updateBackgroundColor(
                            tvOfferText.context,
                            tvOfferText,
                            SdkUiInitializer.apiLayer?.config?.primaryColor,
                            R.color.one_payu_colorPrimary
                        )
                    } else tvOfferText.visibility = View.GONE
                }

                else -> {
                    unlockSavedOptionsIcon?.background =
                        ViewUtils.getDrawable(
                            itemView.context,
                            R.drawable.payu_unlock
                        )

                }

            }
            tvUnlockSavedOptionsTitle?.text = paymentMode.name
            tvUnlockVerifiedSubTitle.text = paymentMode.l1OptionSubText
            tvUnlockUnVerifiedSubTitle.text = paymentMode.l1OptionSubText
            rlUnlockSavedOptionsGlobalVault.setOnClickListener {
                onItemClickListener?.invoke(it, paymentMode, bindingAdapterPosition)
            }
        }
    }

    internal fun setPaymentOptionImage(
        view: ImageView,
        paymentMode: PaymentMode,
        isCardScheme: Boolean
    ) {
        var paymentOption = PaymentOption()
        if (!paymentMode.optionDetail.isNullOrEmpty())
            paymentOption = paymentMode.optionDetail?.get(0)!!
        val param = paymentOption.let {
            ImageParam(
                it,
                isCardScheme,
                Utils.getDefaultDrawable(paymentMode.type)
            )
        }
        if (param != null) {
            SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                param,
                object : OnFetchImageListener {
                    override fun onImageGenerated(result: ImageDetails) {
                        ImageViewUtils.setImage(view, result)
                    }
                })
        }
    }

}
