package com.payu.ui.model.adapters

import android.os.SystemClock
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import android.widget.Toast
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.fragment.app.FragmentManager
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentType
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.listeners.BottomSheetValidateApiListener
import com.payu.ui.model.listeners.OfferApplyListener
import com.payu.ui.model.listeners.OnOtherPaymentOptionsAdapterListener
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils


class OtherPaymentOptionsAdapter(
    val offerApplyListener: OfferApplyListener,
    val bottomSheetValidateApiListener: BottomSheetValidateApiListener?,
    var otherOptionList: ArrayList<PaymentMode>,
    var childFragmentManager: FragmentManager,
    val onOtherPaymentOptionsAdapterListener: OnOtherPaymentOptionsAdapterListener
) :
    RecyclerView.Adapter<OtherPaymentOptionsAdapter.ViewHolder>() {

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val ivPaymentOptionIcon: ImageView = itemView.findViewById(R.id.ivPaymentOptionIcon)
        val ivRightArrow: ImageView = itemView.findViewById(R.id.ivRightArrow)
        val tvPaymentOptionName: TextView = itemView.findViewById(R.id.tvPaymentOptionName)
        val tvOfferText: TextView = itemView.findViewById(R.id.tvOfferText)
        val tvBankDown: TextView = itemView.findViewById(R.id.tvBankDown)
        val clOtherOptions: ConstraintLayout = itemView.findViewById(R.id.clOtherOptions)
        val rvTopUpiIntent: RecyclerView = itemView.findViewById(R.id.rvTopUpiIntent)
        val tvNoCostEmi: TextView = itemView.findViewById(R.id.tvNoCostEmi)

        // variable to track event time
        private var mLastClickTime: Long = 0

        init {
            clOtherOptions.setOnClickListener {
                // Preventing multiple clicks, using threshold of 1 second
                if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) return@setOnClickListener
                mLastClickTime = SystemClock.elapsedRealtime()

                val currentItem = otherOptionList[bindingAdapterPosition]

                if (currentItem.type != PaymentType.UPI) {
                    onOtherPaymentOptionsAdapterListener.setSelectedPaymentMode(currentItem)
                    onOtherPaymentOptionsAdapterListener.otherOptionSelected(currentItem)
                    if (currentItem.type == PaymentType.NEFTRTGS) {
                        if (currentItem.optionDetail?.size == 1) {
                            currentItem.optionDetail?.first()?.let { it1 ->
                                onOtherPaymentOptionsAdapterListener.updateSelectedPaymentOption(it1)
                                onOtherPaymentOptionsAdapterListener.validateOffer()
                            }
                        }
                    }

                } else {
                    if (!currentItem.optionDetail.isNullOrEmpty()) {
                        val intentUpiOption =
                            if (currentItem.optionDetail?.size == 2) currentItem.optionDetail?.get(1) else currentItem.optionDetail?.get(
                                0
                            )
                        val intentUpiAppList =
                            Utils.prepareTopUpiAppList(intentUpiOption?.optionList)

                        if (intentUpiAppList.size == 1) {
                            onOtherPaymentOptionsAdapterListener.setSelectedPaymentMode(currentItem)
                            onOtherPaymentOptionsAdapterListener.otherOptionSelected(currentItem)
                        }
                    } else {
                        val context = clOtherOptions.context
                        Toast.makeText(
                            context,
                            context.getString(R.string.payu_no_payment_mode_available),
                            Toast.LENGTH_SHORT
                        ).show()
                    }
                }
            }
        }

        fun bind(position: Int) {
            tvPaymentOptionName.text = otherOptionList[position].name
            if (otherOptionList[position].isOfferValid) {
                tvOfferText.visibility =
                    View.VISIBLE
                itemView.context?.let {
                    ViewUtils.updateBackgroundColor(
                        it,
                        tvOfferText,
                        SdkUiInitializer.apiLayer?.config?.primaryColor,
                        R.color.one_payu_colorPrimary
                    )
                }
            } else tvOfferText.visibility = View.GONE
            rvTopUpiIntent.visibility = View.GONE
            when (otherOptionList[position].type) {

                PaymentType.CARD -> {
                    ivPaymentOptionIcon.setImageResource(R.drawable.payu_credit_debit_cards)
                }

                PaymentType.NB -> {
                    ivPaymentOptionIcon.setImageResource(R.drawable.payu_netbanking)
                }

                PaymentType.UPI -> {
                    if (otherOptionList[position].isPaymentModeDown) showPaymentModeDownView(
                        otherOptionList[position],
                        this
                    )
                    ivPaymentOptionIcon.setImageResource(R.drawable.payu_upi)

                    //Handling for top upi apps in L1 page
                    val paymentMode = otherOptionList[position]
                    if (paymentMode.optionDetail != null && paymentMode.optionDetail?.size!! > 0) {
                        val intentUpiOption =
                            if (paymentMode.optionDetail?.size == 3) paymentMode.optionDetail?.get(2) else if (paymentMode.optionDetail?.size == 2) paymentMode.optionDetail?.get(
                                1
                            ) else paymentMode.optionDetail?.get(
                                0
                            )
                        val intentUpiAppList =
                            Utils.prepareTopUpiAppList(intentUpiOption?.optionList)

                        if (intentUpiAppList.size > 1) {
                            rvTopUpiIntent.visibility = View.VISIBLE
                            rvTopUpiIntent.layoutManager =
                                LinearLayoutManager(
                                    itemView.context,
                                    LinearLayoutManager.HORIZONTAL,
                                    false
                                )
                            rvTopUpiIntent.adapter = UpiIntentAdapter(
                                offerApplyListener,
                                bottomSheetValidateApiListener,
                                intentUpiAppList,
                                onOtherPaymentOptionsAdapterListener,
                                paymentMode,
                                childFragmentManager
                            )

                            ivRightArrow.setOnClickListener {
                                onOtherPaymentOptionsAdapterListener.setSelectedPaymentMode(
                                    otherOptionList[position]
                                )
                                onOtherPaymentOptionsAdapterListener.otherOptionSelected(
                                    otherOptionList[position]
                                )
                            }
                        }
                    }
                }

                PaymentType.WALLET -> {
                    ivPaymentOptionIcon.setImageResource(R.drawable.payu_wallet)
                }

                PaymentType.EMI -> {
                    if (!InternalConfig.noCostEmi.isNullOrEmpty()) {
                        tvNoCostEmi.visibility = View.VISIBLE
                        itemView.context?.let {
                            ViewUtils.updateBackgroundColor(
                                it,
                                tvNoCostEmi,
                                SdkUiInitializer.apiLayer?.config?.primaryColor,
                                R.color.one_payu_colorPrimary
                            )
                        }
                    }
                    ivPaymentOptionIcon.setImageResource(R.drawable.payu_emi)
                }

                PaymentType.BNPL -> {
                    ivPaymentOptionIcon.setImageResource(R.drawable.payu_bnpl)
                }

                PaymentType.L1_OPTION -> {
                    val paymentOption = otherOptionList[position].optionDetail?.get(0)
                    if (paymentOption == null) {
                        ivPaymentOptionIcon.setImageResource(R.drawable.payu_upi)
                        return
                    }


                    val param = ImageParam(
                        paymentOption!!,
                        false,
                        Utils.getDefaultDrawable(paymentOption.paymentType)
                    )
                    SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                        param,
                        onFetchImageListener = object : OnFetchImageListener {
                            override fun onImageGenerated(result: ImageDetails) {
                                ImageViewUtils.setImage(ivPaymentOptionIcon, result)
                            }
                        })
                    when (otherOptionList[position].optionDetail?.get(0)?.isBankDown) {
                        true -> showBankDownView(
                            this
                        )
                    }
                }

                PaymentType.NEFTRTGS -> {
                    ivPaymentOptionIcon.setImageResource(R.drawable.payu_neft_rtgs)
                }

                else -> ivPaymentOptionIcon.setImageResource(R.drawable.payu_credit_debit_cards)

            }
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        val startTime = System.currentTimeMillis();
        val view: View = inflater.inflate(R.layout.other_option_list_item, parent, false)
        return ViewHolder(view)
    }

    override fun getItemCount(): Int {
        return otherOptionList.size
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.bind(position)
    }

    private fun showPaymentModeDownView(
        paymentMode: PaymentMode,
        holder: ViewHolder
    ) {
        holder.tvBankDown.text = paymentMode.l1OptionSubText
        showBankDownView(holder)
    }

    private fun showBankDownView(holder: ViewHolder) {
        holder.tvBankDown.visibility = View.VISIBLE
        holder.tvOfferText.visibility = View.GONE
        holder.clOtherOptions.isEnabled = false
        ViewUtils.disableView(holder.ivPaymentOptionIcon)
        ViewUtils.disableView(holder.tvPaymentOptionName)
        ViewUtils.disableView(holder.ivRightArrow)

    }
}