package com.payu.ui

import android.app.Activity
import com.payu.base.models.BaseApiLayer
import com.payu.ui.model.listeners.PayUCheckoutProListener
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.SdkUiConstants.CP_INIT

object SdkUiInitializer {

    //api layer that will be used for all api calls
    var apiLayer: BaseApiLayer? = null

    //handler that connects SDKUI with merchant app and passes all transaction related callbacks
    var checkoutProListener: PayUCheckoutProListener? = null
    

    fun startPayment(
        activity: Activity,
        apiLayer: BaseApiLayer,
        checkoutProListener: PayUCheckoutProListener
    ) {
        this.apiLayer = apiLayer
        this.checkoutProListener = checkoutProListener
        AnalyticsUtils.logInitCpForKibana(activity, CP_INIT)
        SdkUiInitializerHelper.openQrScannerOrCheckout(activity)
    }

    internal fun clearReferences(){
        apiLayer = null
        checkoutProListener = null
    }

}