package com.payu.ui


import androidx.fragment.app.FragmentActivity
import androidx.lifecycle.ViewModelProvider
import com.payu.ui.model.listeners.onProgressDialogBackPressListener
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.CPCallbackType
import com.payu.ui.model.utils.PayUProgressDialog
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.view.customViews.QuickPayBottomSheet
import com.payu.ui.viewmodel.BaseViewModelFactory
import com.payu.ui.viewmodel.CommonViewModel

class CheckOutUi(private val activity: FragmentActivity): onProgressDialogBackPressListener {

    private var commonViewModel: CommonViewModel? = null
    private var payUProgressDialog: PayUProgressDialog? = null
    private val PAYU_VM_KEY = this.javaClass.simpleName.plus(System.currentTimeMillis())

    init {
        initViewModel()
    }

    private fun initViewModel() {
        val map = HashMap<String, Any>()
        commonViewModel = ViewModelProvider(
            activity,
            BaseViewModelFactory(activity.application, map)
        )[PAYU_VM_KEY, CommonViewModel::class.java]
        val storedUserToken = Utils.getGlobalVaultStoredUserToken(activity.applicationContext)
        val hashMap = HashMap<String, String>()
        hashMap[SdkUiConstants.USER_TOKEN] = storedUserToken.first ?: ""
        hashMap[SdkUiConstants.MOBILE_NUMBER] = storedUserToken.second ?: ""
        commonViewModel?.fetchPaymentOptions(hashMap)
        addObserver()
    }

    private fun addObserver() {

        commonViewModel?.openCheckout?.observe(activity) {
            if (it.getContentIfNotHandled() == true) commonViewModel?.openCheckout(activity)
        }

        commonViewModel?.showProgressDialog?.observe(activity) { showProgressDialog ->
            if (showProgressDialog)
                showLoaderDialog()
            else {
                android.os.Handler().postDelayed({
                    hideLoaderDialog()
                }, 200)

            }
        }
        commonViewModel?.openQuickPay?.observe(activity) {
                val quickPayBottomSheet =
                    QuickPayBottomSheet.Builder(activity, it).build()
                quickPayBottomSheet.show()
        }

    }

    private fun showLoaderDialog() {

        if (payUProgressDialog == null) {
            payUProgressDialog = PayUProgressDialog(activity, null, true, this)
        }
        payUProgressDialog?.show()
    }

    private fun hideLoaderDialog() {
        try {
            if ((payUProgressDialog != null) && (payUProgressDialog?.isShowing == true)) {
                payUProgressDialog?.dismiss()
                payUProgressDialog = null
            }
        } catch (_: Exception) {

        } finally {
            payUProgressDialog = null
        }
    }

    override fun onBackPressListener() {
        payUProgressDialog?.dismiss()
        SdkUiInitializer.apiLayer?.resetApiResponseRepo()
        AnalyticsUtils.logCPCallbackEventKibana(activity.applicationContext, CPCallbackType.Cancel)
        SdkUiInitializer.checkoutProListener?.onPaymentCancel(true)

        SdkUiInitializer.apiLayer?.cancelQuickPayTask()
    }

}