package com.payu.base.models.calculateEmi

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
class EmiDetails(
    var transactionAmount: Double = 0.0,
    var emiAmount: Double = 0.0,
    var additionalCost: Double = 0.0,
    var bankRate: Double = 0.0,
    var bankCharge: Double = 0.0,
    var amount: Double = 0.0,
    var cardType: String? = null,
    var tenure: String? = null,
    var loanAmount: String? = null,
    var nceDiscount: NceDiscount? = null,
    var offerDiscount: NceDiscount? = null,
    var totalPayableAmount: Double = 0.0,
    var subventionAmount: Double = 0.0,
    var emiValue: Double = 0.0,
    var emiInterestPaid: Double = 0.0,
    var emiBankCode: String? = null,
    var processingFee: Double ? = null,
    var processingFeeMessage: String ? = null
) : Parcelable
