package com.payu.base.models

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
data class SelectedOfferInfo(
    val amount: Double?,
    val totalCashbackDiscount: Double? = 0.0,
    val totalInstantDiscount: Double? = 0.0,
    val totalDiscountedAmount: Double? = 0.0,
    val isSkuOffer: Boolean = false,
    val isAutoApply: Boolean = true,
    val isNoCostEmi: Boolean = false,
    val isValidated: Boolean = false,
    val isValid: Boolean = false,
    val offerMap: HashMap<String, OfferInfo>?,
    val failureReason: String? = null
) : Parcelable
