package com.payu.base.models

import android.graphics.Bitmap
import android.os.Parcelable
import kotlinx.parcelize.IgnoredOnParcel
import kotlinx.parcelize.Parcelize

@Parcelize
open class PaymentOption(
    var bankName: String = "",
    var isBankDown: Boolean = false,
    var drawable: Bitmap? = null,
    var subText: String = "",
    var offerKey: String? = null,
    var paymentType: PaymentType? = null,
    var paymentMode: String? = null,
    open var additionalCharge: Double? = null,
    open var gstPercentageValue: Double? = null,
    var optionList: ArrayList<PaymentOption>? = null,
    var verificationModeList: ArrayList<PayUBeneficiaryVerificationMode>? = null,
    var priority: Int = -1,
    var phoneNumber: String = "",
    var bankCode: String? = null,
    var imageURL: String? = null,
    var imageUpdatedOn: Long? = null,
    var category: String? = null,
    var userAgent: String? = null,
    var isSecureWebview: Boolean = false,
    var isOfferValid: Boolean = false,
    var shouldSaveCard: Boolean = false,
    var isQuickPayTxn: Boolean = false,
    var pgAppVersion: String? = null,
    var feeCombinations: FeeCombinations?= null,
    var error: String?= null
) : Parcelable {

    @IgnoredOnParcel
    var cardBinInfo: CardBinInfo? = null

    @IgnoredOnParcel
    var otherParams: Any? = null

    @IgnoredOnParcel
    var ifscCode: String? = null

    @IgnoredOnParcel
    var accountNumber: String? = null


    constructor(
        bankName: String = "",
        isBankDown: Boolean = false,
        drawable: Bitmap? = null,
        subText: String = "",
        offerKey: String? = null,
        paymentType: PaymentType? = null,
        paymentMode: String? = null,
        additionalCharge: Double? = null,
        gst: Double? = null,
        optionList: ArrayList<PaymentOption>? = null,
        verificationModeList: ArrayList<PayUBeneficiaryVerificationMode>? = null,
        priority: Int = -1,
        phoneNumber: String = "",
        cardBinInfo: CardBinInfo,
        otherParams: Any?,
        bankCode: String? = null,
        imageURL: String? = null,
        imageUpdatedOn: Long? = null,
        category: String? = null,
        userAgent: String? = null,
        accountNo: String?,
        ifscCode: String?,
        feeCombinations: FeeCombinations? = null
    ) : this(
        bankName,
        isBankDown,
        drawable,
        subText,
        offerKey,
        paymentType,
        paymentMode,
        additionalCharge,
        gst,
        optionList,
        verificationModeList,
        priority,
        phoneNumber,
        bankCode,
        imageURL,
        imageUpdatedOn,
        category,
        userAgent,
        feeCombinations = feeCombinations
    ) {
        this.otherParams = otherParams
        this.cardBinInfo = cardBinInfo
        this.accountNumber = accountNo
        this.ifscCode = ifscCode
    }

}