package com.payu.base.models

import android.os.Parcel
import android.os.Parcelable

class PaymentMode() : Parcelable {
    var name: String = ""
    open var isBankDown: Boolean = false
    open var gst: Double? = null
    var type: PaymentType? = null
    var paymentId: String? = null
    var isPaymentModeDown: Boolean = false
    var isOfferValid: Boolean = false
    var optionDetail: ArrayList<PaymentOption>? = null
    var l1OptionSubText: String? = null
    var isGlobalVaultPaymentMode: Boolean = false
    var unlockOptionsTile: Boolean = false


    constructor(paymentType: PaymentType) : this() {
        this.type = paymentType
    }

    constructor(paymentType: PaymentType, paymentId: String?) : this() {
        this.type = paymentType
        this.paymentId = paymentId
    }

    override fun describeContents() = 0
    override fun writeToParcel(dest: Parcel, flags: Int) = with(dest) {
        dest.writeValue(gst)
    }

    companion object {
        @JvmField
        val CREATOR: Parcelable.Creator<PaymentMode> = object : Parcelable.Creator<PaymentMode> {
            override fun createFromParcel(source: Parcel): PaymentMode {
                val paymentMode = PaymentMode()
                val gstValue = source.readValue(Double::class.java.classLoader)
                if (gstValue != null) {
                    paymentMode.gst = gstValue as Double
                }
                return paymentMode
            }

            override fun newArray(size: Int): Array<PaymentMode?> = arrayOfNulls(size)
        }
    }

    fun getPaymentType(): String {
        return type.toString()
    }
}