package com.payu.base.models

import com.payu.base.AnalyticsConstant
import org.json.JSONObject

class PayUSIParams(builder: Builder) {
    var isFreeTrial: Boolean = false
        private set

    var billingCycle: PayUBillingCycle? = null
        private set

    var billingInterval = 0
        private set

    var billingAmount: String? = null
        private set

    var billingCurrency = "INR"
        private set

    var paymentStartDate: String? = null
        private set

    var paymentEndDate: String? = null
        private set

    var remarks: String? = null
        private set

    var billingLimit: PayuBillingLimit? = null
        private set

    var billingRule: PayuBillingRule? = null
        private set

    var billingDate: String? = null
        private set

    var enachFeedbackHandlerMessage: String? = null
        private set
    var enachFeedbackHandlerTitle: String? = null
        private set

    var enachEnableFeedback: Boolean? = false
        private set

    var enachEnableFeedbackHandler: Boolean? = false
        private set

    var ccCardType: String? = null // example: CC/DC

    var ccCategory: String? = null //example: MAST, VISA etc

    //To be filled in case of netbanking
    var beneficiaryDetail: PayUBeneficiaryDetail? = null

    var isPreAuthTxn: Boolean = false
        private set


    init {
        this.isFreeTrial = builder.isFreeTrial
        this.billingCycle = builder.billingCycle
        this.billingInterval = builder.billingInterval
        this.billingAmount = builder.billingAmount
        this.billingCurrency = builder.billingCurrency
        this.paymentStartDate = builder.paymentStartDate
        this.paymentEndDate = builder.paymentEndDate
        this.remarks = builder.remarks
        this.billingLimit = builder.billingLimit
        this.billingRule = builder.billingRule
        this.billingDate = builder.billingDate
        this.enachFeedbackHandlerMessage = builder.enachFeedbackHandlerMessage
        this.enachFeedbackHandlerTitle = builder.enachFeedbackHandlerTitle
        this.enachEnableFeedbackHandler = builder.enachFeedbackHandler
        this.enachEnableFeedback = builder.enachEnableFeedback
        this.isPreAuthTxn = builder.isPreAuthTxn
    }

    class Builder {
        internal var isFreeTrial: Boolean = false
        internal var billingCycle: PayUBillingCycle? = null
        internal var billingInterval = 0
        internal var billingAmount: String? = null
        internal var paymentStartDate: String? = null
        internal var paymentEndDate: String? = null
        internal var remarks: String? = null
        internal var billingCurrency = "INR"
        internal var billingLimit: PayuBillingLimit? = null
        internal var billingRule: PayuBillingRule? = null
        internal var billingDate: String? = null
        internal var enachFeedbackHandlerMessage: String? =
            "We Appreciate Your Input! Share Your Feedback and Help Us Enhance Your Experience."
        internal var enachFeedbackHandlerTitle: String? = "Share Your Feedback"
        internal var enachFeedbackHandler: Boolean = false
        internal var enachEnableFeedback: Boolean = false
        internal var isPreAuthTxn: Boolean = false

        fun setIsFreeTrial(isFreeTrial: Boolean): Builder {
            this.isFreeTrial = isFreeTrial
            return this
        }

        fun setBillingCycle(billingCycle: PayUBillingCycle): Builder {
            this.billingCycle = billingCycle
            return this
        }

        fun setBillingInterval(billingInterval: Int): Builder {
            this.billingInterval = billingInterval
            return this
        }

        fun setBillingAmount(billingAmount: String): Builder {
            this.billingAmount = billingAmount
            return this
        }

        fun setBillingCurrency(billingCurrency: String): Builder {
            this.billingCurrency = billingCurrency
            return this
        }

        fun setPaymentStartDate(paymentStartDate: String): Builder {
            this.paymentStartDate = paymentStartDate
            return this
        }

        fun setPaymentEndDate(paymentEndDate: String): Builder {
            this.paymentEndDate = paymentEndDate
            return this
        }

        fun setRemarks(remarks: String): Builder {
            this.remarks = remarks
            return this
        }

        fun setBillingRule(billingRule: PayuBillingRule): Builder {
            this.billingRule = billingRule
            return this
        }

        fun setBillingLimit(billingLimit: PayuBillingLimit): Builder {
            this.billingLimit = billingLimit
            return this
        }

        fun setBillingDate(billingDate: String): Builder {
            this.billingDate = billingDate
            return this
        }

        fun setPreAuthTxn(isPreAuthTxn: Boolean): Builder {
            this.isPreAuthTxn = isPreAuthTxn
            return this
        }

        /**
         * This will show a dialog on transaction success with configurable
         * title and message which will redirect user to the default browser
         * on the ENACH feedback page
         * @param isAutoHandle true | false : handles the redirection automatically if true
         * @param message String: message to show on dialog
         * @param title String: title of the dialog
         */
        @JvmOverloads
        fun enableEnachFeedback(
            isAutoHandle: Boolean = true,
            title: String? = this.enachFeedbackHandlerTitle,
            message: String? = this.enachFeedbackHandlerMessage
        ): Builder {
            this.enachFeedbackHandler = isAutoHandle
            this.enachEnableFeedback = true
            this.enachFeedbackHandlerMessage = message
            this.enachFeedbackHandlerTitle = title
            return this
        }

        fun build(): PayUSIParams {
            return PayUSIParams(this)
        }
    }

    fun convertToJson(): JSONObject {
        val jsonObject = JSONObject()
        jsonObject.put(AnalyticsConstant.PAYU_IS_FREE_TRIAL, isFreeTrial)
        jsonObject.put(AnalyticsConstant.PAYU_BILLING_CYCLE, billingCycle)
        jsonObject.put(AnalyticsConstant.PAYU_BILLING_INTERVAL, billingInterval)
        jsonObject.put(AnalyticsConstant.PAYU_BILLING_AMOUNT, billingAmount)
        jsonObject.put(AnalyticsConstant.PAYU_BILLING_CURRENCY, billingCurrency)
        jsonObject.put(AnalyticsConstant.PAYU_PAYMENT_START_DATE, paymentStartDate)
        jsonObject.put(AnalyticsConstant.PAYU_PAYMENT_END_DATE, paymentEndDate)
        jsonObject.put(AnalyticsConstant.PAYU_REMARKS, remarks)
        jsonObject.put(AnalyticsConstant.PAYU_BILLING_LIMIT, billingLimit)
        jsonObject.put(AnalyticsConstant.PAYU_BILLING_RULE, billingRule)
        jsonObject.put(AnalyticsConstant.PAYU_BILLING_DATE, billingDate)
        jsonObject.put(AnalyticsConstant.PAYU_ENACH_FEEDBACK_HANDLER_MESSAGE, enachFeedbackHandlerMessage)
        jsonObject.put(AnalyticsConstant.PAYU_ENACH_FEEDBACK_HANDLER_TITLE, enachFeedbackHandlerTitle)
        jsonObject.put(AnalyticsConstant.PAYU_ENACH_ENABLE_FEEDBACK, enachEnableFeedback)
        jsonObject.put(AnalyticsConstant.PAYU_ENACH_ENABLE_FEEDBACK_HANDLER, enachEnableFeedbackHandler)
        jsonObject.put(AnalyticsConstant.PAYU_CC_CARD_TYPE, ccCardType)
        jsonObject.put(AnalyticsConstant.PAYU_CC_CATEGORY, ccCategory)
        jsonObject.put(AnalyticsConstant.PAYU_BENEFICIARY_DETAILS, beneficiaryDetail?.convertToJson().toString())
        return jsonObject
    }


}