package com.payu.base.models

import com.payu.base.AnalyticsConstant
import org.json.JSONObject
import java.util.regex.Pattern

class PayUPaymentParams(builder: Builder) {

    var amount: String? = null
        private set

    var isProduction: Boolean = true
        private set

    var key: String? = null
        private set

    var transactionId: String? = null
        private set

    var productInfo: String? = null
        private set

    var firstName: String? = null
        private set

    var email: String? = null
        private set

    var phone: String = ""
        private set

    var surl: String? = null
        private set

    var furl: String? = null
        private set

    var userCredential: String? = null
        private set

    var payUSIParams: PayUSIParams? = null
        private set

    var additionalParams: HashMap<String, Any?>? = HashMap()

    var splitPaymentDetails: String? = null
    var category: String? = null
        private set
    var userToken: String? = null
        private set
    var skuDetails: SkuDetails ? = null
        private set

    var enableNativeOTP: Boolean = false
        private set

    var beneficiaryDetailList: List<PayUBeneficiaryDetail>? = null
        private set
    var additionalCharges: String? = null
        private set
    var percentageAdditionalCharges: String? = null
        private set

    var enforcementOfferKeys: List<String>? = null
        private set
    var payUWealthProducts: List<PayUWealthProducts>? = null
        private set

    var addressDetails: PayUAddressDetails? = null
        private set

    init {
        this.amount = builder.amount
        this.isProduction = builder.isProduction
        this.key = builder.key
        this.transactionId = builder.transactionId
        this.productInfo = builder.productInfo
        this.firstName = builder.firstName
        this.email = builder.email
        this.surl = builder.surl
        this.furl = builder.furl
        this.userCredential = builder.userCredential
        this.phone = builder.phone
        this.additionalParams = builder.additionalParams
        this.payUSIParams = builder.payUSIParams
        this.splitPaymentDetails = builder.splitPaymentDetails
        this.category = builder.category
        this.userToken = builder.userToken
        this.skuDetails = builder.skuDetails
        this.enableNativeOTP = builder.enableNativeOTP
        this.beneficiaryDetailList = builder.beneficiaryDetailList
        this.additionalCharges = builder.additionalCharges
        this.percentageAdditionalCharges = builder.percentageAdditionalCharges
        this.enforcementOfferKeys = builder.enforcementOfferKeys
        this.payUWealthProducts = builder.payUWealthProducts
        this.addressDetails = builder.addressDetails
    }

    class Builder {
        internal var amount: String? = null
        internal var isProduction: Boolean = true
        internal var key: String? = null
        internal var transactionId: String? = null
        internal var productInfo: String? = null
        internal var firstName: String? = null
        internal var email: String? = null
        internal var udf1: String? = null
        internal var udf2: String? = null
        internal var udf3: String? = null
        internal var udf4: String? = null
        internal var udf5: String? = null
        internal var surl: String? = null
        internal var furl: String? = null
        internal var userCredential: String? = null
        internal var phone: String = ""
        internal var additionalParams: HashMap<String, Any?>? = HashMap()
        internal var payUSIParams: PayUSIParams? = null
        internal var splitPaymentDetails: String? = null
        internal var category: String? = null
        internal var userToken: String? = null
        internal var skuDetails: SkuDetails ? = null
        internal var enableNativeOTP: Boolean = false
        internal var beneficiaryDetailList: List<PayUBeneficiaryDetail>? = null
        internal var additionalCharges: String? = null
        internal var percentageAdditionalCharges: String? = null
        internal var enforcementOfferKeys: List<String>? = null
        internal var payUWealthProducts: List<PayUWealthProducts>? = null
        internal var addressDetails: PayUAddressDetails? = null

        fun setSplitPaymentDetails(splitPaymentDetails: String?): Builder {
            this.splitPaymentDetails = splitPaymentDetails
            return this
        }

        fun setAmount(amount: String?): Builder {
            this.amount = amount
            return this
        }

        fun setAdditionalParams(additionalParams: HashMap<String, Any?>?): Builder {
            this.additionalParams = additionalParams
            return this
        }

        fun setIsProduction(isProduction: Boolean): Builder {
            this.isProduction = isProduction
            return this
        }

        fun setKey(key: String?): Builder {
            this.key = key
            return this
        }

        fun setTransactionId(transactionId: String?): Builder {
            this.transactionId = transactionId
            return this
        }

        fun setProductInfo(productInfo: String?): Builder {
            this.productInfo = productInfo
            return this
        }

        fun setFirstName(firstName: String?): Builder {
            this.firstName = firstName
            return this
        }

        fun setEmail(email: String?): Builder {
            this.email = email
            return this
        }

        fun setSurl(surl: String?): Builder {
            this.surl = surl
            return this
        }

        fun setFurl(furl: String?): Builder {
            this.furl = furl
            return this
        }

        fun setUserCredential(userCredential: String?): Builder {
            this.userCredential = userCredential
            return this
        }

        //TODO: Temporary commented code
//        fun setPhone(phone: String): Builder {
//            this.phone = phone
//            return this
//        }

        //TODO: Temporarily written code to removed and above api has to used. Below code
        // suppose to be handled at backend
        fun setPhone(phone: String): Builder {
            if (!phone.isNullOrEmpty()) {
                val VALIDATE_MOBILE_NUMBER_REGEX = "[6789][0-9]{9}?"
                val pattern = Pattern.compile(VALIDATE_MOBILE_NUMBER_REGEX)
                val matcher = pattern.matcher(phone)
                if (matcher.matches()) {
                    this.phone = phone
                } else {
                    this.phone = "9999999999"
                }
            }
            return this
        }

        fun setPayUSIParams(payUSIParams: PayUSIParams?): Builder {
            this.payUSIParams = payUSIParams
            return this
        }

        fun setCategory(category: String?): Builder {
            this.category = category
            return this
        }

        fun setUserToken(userToken: String?): Builder {
            this.userToken = userToken
            return this
        }

        fun setSkuDetails(skuDetails: SkuDetails): Builder {
            this.skuDetails = skuDetails
            return this
        }

        fun setEnableNativeOtp(value: Boolean): Builder {
            this.enableNativeOTP = value
            return this
        }

        fun setBeneficiaryDetailsList(beneficiaryDetailsList: List<PayUBeneficiaryDetail>): Builder {
            this.beneficiaryDetailList = beneficiaryDetailsList
            return this
        }

        fun setAdditionalCharges(additionalCharges: String): Builder {
            this.additionalCharges = additionalCharges
            return this
        }

        fun setPercentageAdditionalCharges(percentageAdditionalCharges: String): Builder {
            this.percentageAdditionalCharges = percentageAdditionalCharges
            return this
        }

        fun setEnforcementOfferKeys(enforcementOfferKeys: List<String>?): Builder {
            this.enforcementOfferKeys = enforcementOfferKeys
            return this
        }

        fun setPayUWealthProducts(payUWealthProducts: List<PayUWealthProducts>): Builder {
            this.payUWealthProducts = payUWealthProducts
            return this
        }

        fun setAddressDetails(addressDetails: PayUAddressDetails): Builder {
            this.addressDetails = addressDetails
            return this
        }

        fun build(): PayUPaymentParams {
            return PayUPaymentParams(this)
        }
    }

    fun convertToJson(): JSONObject {
        val jsonObject = JSONObject()
        jsonObject.put(AnalyticsConstant.PAYU_AMOUNT, amount)
        jsonObject.put(AnalyticsConstant.PAYU_IS_PRODUCTION, isProduction)
        jsonObject.put(AnalyticsConstant.PAYU_KEY, key)
        jsonObject.put(AnalyticsConstant.PAYU_TRANSACTION_ID, transactionId)
        jsonObject.put(AnalyticsConstant.PAYU_PRODUCT_INFO, productInfo)
        jsonObject.put(AnalyticsConstant.PAYU_FIRST_NAME, firstName)
        jsonObject.put(AnalyticsConstant.PAYU_EMAIL, email)
        jsonObject.put(AnalyticsConstant.PAYU_PHONE, phone)
        jsonObject.put(AnalyticsConstant.PAYU_SURL, surl)
        jsonObject.put(AnalyticsConstant.PAYU_FURL, furl)
        jsonObject.put(AnalyticsConstant.PAYU_USER_CREDENTIALS, userCredential)
        payUSIParams?.let {
            jsonObject.put(AnalyticsConstant.PAYU_PAYU_SI_PARAMS, it.convertToJson().toString())
        }
        additionalParams?.let {
            val param = JSONObject(it).toString()
            jsonObject.put(AnalyticsConstant.PAYU_ADDITIONAL_PARAMS, param)
        }
        jsonObject.put(AnalyticsConstant.PAYU_SPLIT_PAYMENT_DETAILS, splitPaymentDetails)
        jsonObject.put(AnalyticsConstant.PAYU_CATEGORY, category)
        jsonObject.put(AnalyticsConstant.PAYU_USER_TOKEN, userToken)
        skuDetails?.let {
            jsonObject.put(AnalyticsConstant.PAYU_SKU_DETAILS, it.toString())
        }
        jsonObject.put(AnalyticsConstant.PAYU_ENABLE_NATIVE_OTP, enableNativeOTP)
        jsonObject.put(AnalyticsConstant.PAYU_ADDITIONAL_CHARGES, additionalCharges)
        jsonObject.put(AnalyticsConstant.PAYU_PERCENTAGE_ADDITIONAL_CHARGES, percentageAdditionalCharges)
        beneficiaryDetailList?.let {  list ->
            val beneficiaryList = list.map { it.convertToJson().toString() }
            jsonObject.put(AnalyticsConstant.PAYU_BENEFICIARY_DETAILS, beneficiaryList.joinToString())
        }
        return jsonObject
    }
}