package com.payu.base.models

enum class PayUBeneficiaryVerificationMode(val modeName: String, val gcdApiParam: String, val paymentApiParam: String) {
    NET_BANKING("Net Banking", "NB", "NET_BANKING"),
    DEBIT_CARD("Debit Card", "DC", "DEBIT_CARD"),
    AADHAAR("Aadhaar", "ADHR", "AADHAAR");

    companion object {
        fun typeFrom(param: String): PayUBeneficiaryVerificationMode? {
            return when(param.lowercase()) {
                "dc", "debit_card", "debit card", "debitcard" -> DEBIT_CARD
                "nb", "net_banking", "net banking", "netbanking" -> NET_BANKING
                "aadhaar", "adhr" -> AADHAAR
                else -> null
            }
        }
    }
}