package com.payu.base.models

import com.payu.base.AnalyticsConstant
import org.json.JSONObject

class PayUBeneficiaryDetail(builder: Builder) {
    var beneficiaryName: String? = null
        private set

    var beneficiaryAccountNumber: String? = null
        private set

    var beneficiaryIfsc: String? = null
        private set

    var verificationMode: PayUBeneficiaryVerificationMode? = null

    var beneficiaryAccountType: PayUBeneficiaryAccountType? = null
        private set

    init {
        this.beneficiaryName = builder.beneficiaryName
        this.beneficiaryAccountNumber = builder.beneficiaryAccountNumber
        this.beneficiaryIfsc = builder.beneficiaryIfsc
        this.verificationMode = builder.verificationMode
        this.beneficiaryAccountType = builder.beneficiaryAccountType
    }

    class Builder {
        internal var beneficiaryName: String? = null
        internal var beneficiaryAccountNumber: String? = null
        internal var beneficiaryIfsc: String? = null
        internal var verificationMode: PayUBeneficiaryVerificationMode? = null
        internal var beneficiaryAccountType: PayUBeneficiaryAccountType? = null

        fun setBeneficiaryName(beneficiaryName: String): Builder {
            this.beneficiaryName = beneficiaryName
            return this
        }

        fun setBeneficiaryIfsc(beneficiaryIfsc: String): Builder {
            this.beneficiaryIfsc = beneficiaryIfsc
            return this
        }

        fun setVerificationMode(verificationMode: PayUBeneficiaryVerificationMode?): Builder {
            this.verificationMode = verificationMode
            return this
        }

        fun setBeneficiaryAccountNumber(beneficiaryAccountNumber: String): Builder {
            this.beneficiaryAccountNumber = beneficiaryAccountNumber
            return this
        }

        fun setBeneficiaryAccountType(beneficiaryAccountType: PayUBeneficiaryAccountType): Builder {
            this.beneficiaryAccountType = beneficiaryAccountType
            return this
        }

        fun build(): PayUBeneficiaryDetail {
            return PayUBeneficiaryDetail(this)
        }
    }

    fun convertToJson(): JSONObject {
        val jsonObject = JSONObject()
        jsonObject.put(AnalyticsConstant.PAYU_BENEFICIARY_NAME, beneficiaryName)
        jsonObject.put(AnalyticsConstant.PAYU_BENEFICIARY_ACCOUNT_NUMBER, beneficiaryAccountNumber)
        jsonObject.put(AnalyticsConstant.PAYU_BENEFICIARY_IFSC, beneficiaryIfsc)
        jsonObject.put(AnalyticsConstant.PAYU_VERIFICATION_MODE, verificationMode)
        jsonObject.put(AnalyticsConstant.PAYU_BENEFICIARY_ACCOUNT_TYPE, beneficiaryAccountType)
        return jsonObject
    }

}