package com.payu.base.models

enum class PayUBeneficiaryAccountType {
    CURRENT {
        override fun getTypeName(): String = "Current account"
    },
    SAVINGS {
        override fun getTypeName(): String = "Savings account"
    };

    abstract fun getTypeName(): String

    companion object {
        fun typeFrom(name: String): PayUBeneficiaryAccountType? {
            return when(name.lowercase()) {
                "current account", "current" -> CURRENT
                "savings account", "savings", "saving" -> SAVINGS
                else -> null
            }
        }
    }

}