package com.payu.base.models

data class PayUAddressDetails(
    val lastName: String? = null,
    val address1: String? = null,
    val address2: String? = null,
    val city: String? = null,
    val state: String? = null,
    val country: String? = null,
    val zipcode: String? = null
) {
    class Builder {
        private var lastName: String? = null
        private var address1: String? = null
        private var address2: String? = null
        private var city: String? = null
        private var state: String? = null
        private var country: String? = null
        private var zipcode: String? = null

        fun setLastName(lastName: String): Builder = apply { this.lastName = lastName }
        fun setAddress1(address1: String): Builder = apply { this.address1 = address1 }
        fun setAddress2(address2: String): Builder = apply { this.address2 = address2 }
        fun setCity(city: String): Builder = apply { this.city = city }
        fun setState(state: String): Builder = apply { this.state = state }
        fun setCountry(country: String): Builder = apply { this.country = country }
        fun setZipcode(zipcode: String): Builder = apply { this.zipcode = zipcode }

        fun build(): PayUAddressDetails {
            return PayUAddressDetails(
                lastName = lastName,
                address1 = address1,
                address2 = address2,
                city = city,
                state = state,
                country = country,
                zipcode = zipcode
            )
        }
    }
}