package com.payu.base.models

import android.os.Parcel
import android.os.Parcelable
import com.payu.base.AnalyticsConstant
import org.json.JSONObject

class OrderDetails : Parcelable {

    var key: String? = null
        private set
    var value: String? = null
        private set

    constructor(key: String, value: String) {
        this.key = key
        this.value = value
    }

    protected constructor(`in`: Parcel) {
        key = `in`.readString()
        value = `in`.readString()
    }

    override fun writeToParcel(dest: Parcel, flags: Int) {
        dest.writeString(key)
        dest.writeString(value)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object {
        @JvmField
        val CREATOR: Parcelable.Creator<OrderDetails> =
            object : Parcelable.Creator<OrderDetails> {
                override fun createFromParcel(`in`: Parcel): OrderDetails {
                    return OrderDetails(`in`)
                }

                override fun newArray(size: Int): Array<OrderDetails?> {
                    return arrayOfNulls(size)
                }
            }
    }

    fun convertToJson(): JSONObject {
        val jsonObject = JSONObject()
        jsonObject.put(AnalyticsConstant.PAYU_KEY, key)
        jsonObject.put(AnalyticsConstant.PAYU_VALUE, value)
        return jsonObject
    }
}
