package com.payu.base.models

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
data class OfferInfo(
    val sku: SKU?,
    val type: String?,
    val offerKey: String?,
    val title: String?,
    val description: String?,
    val tnc: String?,
    val tncLink: String?,
    val minTxnAmount: Double?,
    val maxTxnAmount: Double?,
    val offerType: String?,
    val validFrom: String?,
    val validTo: String?,
    val isNoCostEmi: Boolean,
    val isSkuOffer: Boolean,
    val isAllPaymentMethodsAvailable: Boolean,
    val discountDetailsOfOffers: DiscountDetailsofOffers?,
    val nbOptionOfferInfoList: ArrayList<PaymentOptionOfferinfo>?,
    val walletOptionOfferInfoList: ArrayList<PaymentOptionOfferinfo>?,
    val upiOptionOfferInfoList: ArrayList<PaymentOptionOfferinfo>?,
    val bnplOptionOfferInfoList: ArrayList<PaymentOptionOfferinfo>?,
    val cardsOfferInfo: CardsOfferInfo?,
    val emiOfferInfo: EmiOfferInfo?,
    val clwOptionOfferInfoList:  ArrayList<PaymentOptionOfferinfo>?,
    val toDisplay: Boolean,
    val isUserVerificationRequired: Boolean,
    val userDetail: PayUUserDetail? = null
) : Parcelable