package com.payu.base.models

import com.payu.base.models.calculateEmi.NceDiscount
import kotlinx.parcelize.Parcelize

@Parcelize
class EMIOption : CardOption() , Cloneable{
    var bankShortName: String? = null
    var months: Int = 0
    var minimumTxnAmount: Int = 0
    var maximumTxnAmount: Int = 0
    var supportedBins: ArrayList<String>? = null
    var emiType: EmiType? = null
    var emiValue: Double = 0.0
    var interestRate: Double = 0.0
    var interestCharged: Double = 0.0
    var isBankOption: Boolean = false
    var isEligible: Boolean = false
    var lowestInterestRate: Double = 0.0
    var panNumber: String? = null
    var totalPayableAmount: Double = 0.0
    var nceDiscount: NceDiscount? = null
    var offerDiscount: NceDiscount? = null
    var isNoCostEmi: Boolean = false
    var processingFee: Double = 0.0
    var processingFeeMessage: String? = null
    var isOfferAvailable: Boolean = false

    public override fun clone(): Any {
        return super.clone() as EMIOption
    }
}