package com.payu.base.models

import android.app.Activity
import androidx.fragment.app.Fragment
import com.payu.base.listeners.BaseApiListener
import com.payu.base.listeners.BaseTransactionListener
import com.payu.base.listeners.EmiCalculationListener
import com.payu.base.listeners.OnCardBinInfoListener
import com.payu.base.listeners.OnDeleteSavedOptionListener
import com.payu.base.listeners.OnEmiDetailsListener
import com.payu.base.listeners.OnFetchGaidListener
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.listeners.OnGVQuickPayListener
import com.payu.base.listeners.OnIFSCDetailsListener
import com.payu.base.listeners.OnLookupApiListener
import com.payu.base.listeners.OnValidateOfferListener
import com.payu.base.listeners.PaymentVerificationListener
import com.payu.base.listeners.VerifyServiceListener
import com.payu.base.models.calculateEmi.CalculateEmiRequest


abstract class BaseApiLayer(payUPaymentParams: PayUPaymentParams, config: BaseConfig) {

    var config: BaseConfig = BaseConfig()
    var payUPaymentParams: PayUPaymentParams

    init {
        this.payUPaymentParams = payUPaymentParams
        this.config = config
    }

    abstract fun connectListener(
        context: Activity,
        baseTransactionListener: BaseTransactionListener
    )

    abstract fun fetchPaymentOptions(
        baseApiListener: BaseApiListener,
        listener: (ArrayList<PaymentMode>?) -> Unit
    )
    abstract fun updatePaymentState(paymentModel: PaymentModel, toolbar: PayuToolbar? = null)
    abstract fun getPaymentState(paymentModel: PaymentModel): PaymentFlowState?
    abstract fun onBackPressed(fragment: Fragment)
    abstract fun getImageForPaymentOption(
        imageParam: ImageParam,
        onFetchImageListener: OnFetchImageListener
    )

    abstract fun verifyEligibilityAPI(
        paymentOption: PaymentOption,
        verifyServiceListener: VerifyServiceListener
    )

    abstract fun emiDetails(emiDetailsListener: OnEmiDetailsListener?)
    open fun reset() {} //function to reset layer flags/cache
    abstract fun deleteSavedOption(
        paymentOption: PaymentOption,
        onDeleteSavedOptionListener: OnDeleteSavedOptionListener
    )

    abstract fun callLookupApi(cardOption: CardOption, onLookupApiListener: OnLookupApiListener)
    abstract fun fetchIFSCDetails(ifscCode: String, onIFSCDetailsListener: OnIFSCDetailsListener)
    abstract fun getEnforcedState(): PaymentState?
    abstract fun getBalanceFromSodexo(
        sodexoBalanceListener: (QuickOptionsModel?) -> Unit?
    )
    abstract fun fetchOfferDetails(resetCache: Boolean?= false, loggedInPhoneNumber: String?= null, offerListener: (FetchOfferDetails?) -> Unit?)
    abstract fun getRetryCount(): Int
    abstract fun setRetryCount(retryCount: Int)
    abstract fun validateOfferDetails(
        category: String,
        cardNumber: String?,
        paymentCode: String?,
        cardToken: String?,
        loggedInPhoneNumber: String?,
        validateOfferListener: OnValidateOfferListener
    )

    abstract fun getBitmapImageFormURL(imageURL: String, onFetchImageListener: OnFetchImageListener)
    abstract fun fetchConfig()
    abstract fun fetchQuickPay(
        quickPayEnum: GlobalVaultAPIsCommand,
        map: HashMap<String, String>,
        onGVQuickPayListener: OnGVQuickPayListener
    )

    abstract fun fetchGvQuickPay(
        map: HashMap<String, String>,
        isNeedToApiCall: Boolean = false,
        onGvQuickPayListener: (QuickOptionsModel?) -> Unit?

    )

    abstract fun getBalanceForClosedLoopWallet(
        walletIdentifier: String?,
        mobile: String,
        onGVQuickPayListener: (QuickOptionsModel?) -> Unit?
    )

    abstract fun verifyPayment(paymentVerificationListener: PaymentVerificationListener)

    abstract fun fetchGaid(onFetchGaidListener: OnFetchGaidListener)
    abstract fun callDeviceInfoApi(payuId: String, gaid: String)
    abstract fun calculateEmiApi(
        calculateEmiRequest: CalculateEmiRequest,
        emiCalculationListener: EmiCalculationListener
    )

    abstract fun resetApiResponseRepo()
    abstract fun fetchRetryOptions(quickOptionsListener: (QuickOptionsModel?) -> Unit?, listener: (ArrayList<PaymentMode>?) -> Unit?)

    abstract fun cancelQuickPayTask()
    abstract fun fetchConvenienceFee(
        mode: String,
        variableDynamicList: ArrayList<VariableDynamics>,
        onFetchConvFeeResponse: (HashMap<String, List<ConvenienceFeeCharges>>?) -> Unit
    )
    abstract fun fetchBinBaseDetails(
        cardNumber: String,
        cardToken: String?,
        category: String?,
        paymentCode: String?,
        onBinBaseDetailsResponse: (BinBaseDetails?) -> Unit
    )

    abstract fun sendOlwOtp(
        walletIdentifier: String,
        bankCode: String,
        mobile: String,
        v2ApiResponseListener: (OlwAPIResponse?) -> Unit?
    )

    abstract fun setMPin(
        otp: String,
        mPin: String,
        mobile: String,
        walletIdentifier: String,
        bankCode: String,
        action: String,
        v2ApiResponseListener: (SetMPinResponse?) -> Unit?
    )

    abstract fun verifyMPin(
        mPin: String,
        walletIdentifier: String,
        bankCode: String,
        mobile: String,
        v2ApiResponseListener: (OlwAPIResponse?) -> Unit?
    )

    abstract fun fetchBalanceForOlw(
        olwPaymentOption: OlwPaymentOption?,
        mobile: String,
        bankCode: String,
        v2ApiResponseListener: (OlwPaymentOption?) -> Unit?
    )
}