package com.payu.base.listeners

import android.webkit.WebView
import androidx.fragment.app.Fragment
import com.payu.base.models.PaymentModel

interface BaseTransactionListener : BaseApiListener {

    fun onPaymentSuccess(response: Any)
    fun onPaymentFailure(response: Any)
    fun onPaymentCancel()

    fun loadNextState(paymentModel: PaymentModel)
    fun loadNextState(fragment: Fragment?)
    fun setWebViewProperties(webView: WebView?, bank: Any?)
    fun loadRetryPaymentOption()
    fun showLoaderScreen(showLoader: Boolean)
}