package com.payu.assetprovider

import android.content.Context
import android.graphics.Bitmap
import androidx.appcompat.content.res.AppCompatResources
import androidx.core.graphics.drawable.toBitmap


object Utils {

    fun getBitmapFromDrawable(context: Context, drawableId: Int): Bitmap? {
        return AppCompatResources.getDrawable(context, drawableId)?.toBitmap()
//        return BitmapFactory.decodeResource(context.applicationContext.resources, drawableId);
    }

    fun getResourceForTypes(types: String,defaultDrawableId:Int): Int {
        return when (types) {
            PaymentTypes.ALLB.name.toLowerCase() -> R.drawable.ic_allahabadbank
            PaymentTypes.ADBB.name.toLowerCase(), PaymentTypes.ANDBENCC.name.toLowerCase() -> R.drawable.ic_andhrabank
            PaymentTypes.ABNBTPV.name.toLowerCase() -> R.drawable.ic_andhrabank
            PaymentTypes.ABIRLA.name.toLowerCase() -> R.drawable.ic_aditya_birla_payments
            PaymentTypes.AXISCNB.name.toLowerCase(), PaymentTypes.AXIS.name.toLowerCase() -> R.drawable.ic_axisbank
            PaymentTypes.AXIB.name.toLowerCase(), PaymentTypes.UTIBENCC.name.toLowerCase() -> R.drawable.ic_axisbank
            PaymentTypes.AXNBTPV.name.toLowerCase()-> R.drawable.ic_axisbank
            PaymentTypes.AIRNB.name.toLowerCase()-> R.drawable.ic_airtel
            PaymentTypes.BBRB.name.toLowerCase(), PaymentTypes.BOB.name.toLowerCase()->R.drawable.ic_bank_of_baroda
            PaymentTypes.BBCB.name.toLowerCase(), PaymentTypes.BARBENCC.name.toLowerCase()->R.drawable.ic_bank_of_baroda
            PaymentTypes.BBKB.name.toLowerCase()->R.drawable.ic_bankofbahrainkuwait
            PaymentTypes.BHNB.name.toLowerCase()->R.drawable.the_bharat_co_op_bank_ltd
            PaymentTypes.BMNN.name.toLowerCase()->R.drawable.ic_payzapp
            PaymentTypes.BOIB.name.toLowerCase()->R.drawable.ic_bank_of_india
            PaymentTypes.BOMB.name.toLowerCase(), PaymentTypes.MAHBENCC.name.toLowerCase()->R.drawable.ic_bank_of_maharastra
            PaymentTypes.CABB.name.toLowerCase(), PaymentTypes.CNRBENCC.name.toLowerCase()->R.drawable.ic_canara_bank
            PaymentTypes.CBNBTPV.name.toLowerCase()->R.drawable.ic_canara_bank
            PaymentTypes.CBIB.name.toLowerCase(), PaymentTypes.CBINENCC.name.toLowerCase()->R.drawable.ic_central_bank_of_india
            PaymentTypes.CITNB.name.toLowerCase()->R.drawable.ic_citi
            PaymentTypes.CITIRDR.name.toLowerCase(), PaymentTypes.CITI.name.toLowerCase()->R.drawable.ic_citi
            PaymentTypes.CORP.name.toLowerCase()->R.drawable.ic_corporation_bank
            PaymentTypes.CRBP.name.toLowerCase()->R.drawable.ic_corporation_bank
            PaymentTypes.CRPB.name.toLowerCase()->R.drawable.ic_corporation_bank
            PaymentTypes.CSBN.name.toLowerCase()->R.drawable.ic_catholic_syrianbank
            PaymentTypes.CSBNBTPV.name.toLowerCase()->R.drawable.ic_catholic_syrianbank
            PaymentTypes.CSMSNB.name.toLowerCase(), PaymentTypes.COSBENCC.name.toLowerCase()->R.drawable.ic_cosmos_bank
            PaymentTypes.CUBB.name.toLowerCase(), PaymentTypes.CIUBENCC.name.toLowerCase()->R.drawable.ic_city_union_bank
            PaymentTypes.DBSB.name.toLowerCase()->R.drawable.ic_dbs_bank
            PaymentTypes.DCBB.name.toLowerCase(), PaymentTypes.DCBLENCC.name.toLowerCase()->R.drawable.ic_dcb
            PaymentTypes.DCBCORP.name.toLowerCase()->R.drawable.ic_dcb
            PaymentTypes.DENN.name.toLowerCase()->R.drawable.ic_dena_bank
            PaymentTypes.DLSB.name.toLowerCase(), PaymentTypes.DLXBENCC.name.toLowerCase() ->R.drawable.ic_dhanlaxmi_bank
            PaymentTypes.DLSBCORP.name.toLowerCase()->R.drawable.ic_dhanlaxmi_bank
            PaymentTypes.DLSNBTPV.name.toLowerCase()->R.drawable.ic_dhanlaxmi_bank
            PaymentTypes.DSHB.name.toLowerCase(), PaymentTypes.DEUTENCC.name.toLowerCase()->R.drawable.ic_deutsche_bank
            PaymentTypes.FEDB.name.toLowerCase(), PaymentTypes.FDRLENCC.name.toLowerCase()->R.drawable.ic_federal_bank
            PaymentTypes.HDFB.name.toLowerCase(),PaymentTypes.HDFCENCC.name.toLowerCase()->R.drawable.ic_hdfc_bank
            PaymentTypes.HDFCCONB.name.toLowerCase(), PaymentTypes.HDFC.name.toLowerCase()->R.drawable.ic_hdfc_bank
            PaymentTypes.HDFNBTPV.name.toLowerCase()->R.drawable.ic_hdfc_bank
            PaymentTypes.ICIB.name.toLowerCase()->R.drawable.ic_icici_bank
            PaymentTypes.ICICB.name.toLowerCase(), PaymentTypes.ICICENCC.name.toLowerCase()->R.drawable.ic_icici_bank
            PaymentTypes.ICICICNB.name.toLowerCase(), PaymentTypes.ICICI.name.toLowerCase()->R.drawable.ic_icici_bank
            PaymentTypes.ICINBTPV.name.toLowerCase()->R.drawable.ic_icici_bank
            PaymentTypes.IDBB.name.toLowerCase(), PaymentTypes.IBKLENCC.name.toLowerCase()->R.drawable.ic_idbi
            PaymentTypes.IDBC.name.toLowerCase()->R.drawable.ic_idbi
            PaymentTypes.IDFCNB.name.toLowerCase(),   PaymentTypes.IDFBENCC.name.toLowerCase()->R.drawable.ic_idfc_bank
            PaymentTypes.IDFNBTPV.name.toLowerCase()->R.drawable.ic_idfc_bank
            PaymentTypes.INDB.name.toLowerCase()->R.drawable.ic_indian_bank
            PaymentTypes.INGB.name.toLowerCase()->R.drawable.ic_ing_vysya_bank
            PaymentTypes.INIB.name.toLowerCase(), PaymentTypes.INDUS.name.toLowerCase(),
            PaymentTypes.INDBENCC.name.toLowerCase()->R.drawable.ic_indus_ind_bank
            PaymentTypes.INOB.name.toLowerCase(), PaymentTypes.IOBAENCC.name.toLowerCase()->R.drawable.ic_indian_overseas_bank
            PaymentTypes.IOB.name.toLowerCase()->R.drawable.ic_indian_overseas_bank
            PaymentTypes.IOBNBTPV.name.toLowerCase()->R.drawable.ic_indian_overseas_bank
            PaymentTypes.JAKB.name.toLowerCase()->R.drawable.ic_j_k_bank
            PaymentTypes.JSBNB.name.toLowerCase()->R.drawable.janata_sahakari_bank_pune
            PaymentTypes.KRKB.name.toLowerCase(), PaymentTypes.KARBENCC.name.toLowerCase()->R.drawable.ic_karnataka_bank
            PaymentTypes.KRVB.name.toLowerCase(), PaymentTypes.KVBLENCC.name.toLowerCase()->R.drawable.ic_karur_vysya_bank
            PaymentTypes.KRVBC.name.toLowerCase()->R.drawable.ic_karur_vysya_bank
            PaymentTypes.KVBNBTPV.name.toLowerCase()->R.drawable.ic_karur_vysya_bank
            PaymentTypes.LVBD.name.toLowerCase()->R.drawable.ic_laxmi_vilas_bank
            PaymentTypes.LVRB.name.toLowerCase()->R.drawable.ic_laxmi_vilas_bank
            PaymentTypes.LVBNBTPV.name.toLowerCase()->R.drawable.ic_laxmi_vilas_bank
            PaymentTypes.LVCB.name.toLowerCase()->R.drawable.ic_laxmi_vilas_bank
            PaymentTypes.OBCB.name.toLowerCase(), PaymentTypes.ORBCENCC.name.toLowerCase()->R.drawable.ic_oriental_bank_of_commerce
            PaymentTypes.OBCNBTPV.name.toLowerCase()->R.drawable.ic_oriental_bank_of_commerce
            PaymentTypes.PMNB.name.toLowerCase()->R.drawable.punjab_maharashtra_co_operative_bank_limited
            PaymentTypes.PNBB.name.toLowerCase(), PaymentTypes.PUNBENCC.name.toLowerCase()->R.drawable.ic_punjab_national_bank
            PaymentTypes.PNBNBTPV.name.toLowerCase()->R.drawable.ic_punjab_national_bank
            PaymentTypes.CPNB.name.toLowerCase()->R.drawable.ic_punjab_national_bank
            PaymentTypes.PSBNB.name.toLowerCase(), PaymentTypes.PSIBENCC.name.toLowerCase()->R.drawable.ic_punjab_sind_bank
            PaymentTypes.RBL.name.toLowerCase(), PaymentTypes.RATNENCC.name.toLowerCase() ->R.drawable.ic_rbl
            PaymentTypes.RTN.name.toLowerCase()->R.drawable.ic_rbl
            PaymentTypes.RYBS.name.toLowerCase()->R.drawable.ic_royal_bank_of_scotland
            PaymentTypes.SBBJB.name.toLowerCase()->R.drawable.ic_state_bank_of_india_corporate
            PaymentTypes.SBHB.name.toLowerCase()->R.drawable.ic_state_bank_of_india_corporate
            PaymentTypes.SBIB.name.toLowerCase(), PaymentTypes.SBINENCC.name.toLowerCase() -> R.drawable.ic_state_bank_of_india_corporate
            PaymentTypes.SBINBTPV.name.toLowerCase()->R.drawable.ic_state_bank_of_india_corporate
            PaymentTypes.SBMB.name.toLowerCase()->R.drawable.ic_state_bank_of_india_corporate
            PaymentTypes.SBNCORP.name.toLowerCase()->R.drawable.ic_state_bank_of_india_corporate
            PaymentTypes.SBPB.name.toLowerCase()->R.drawable.ic_state_bank_of_india_corporate
            PaymentTypes.SBTB.name.toLowerCase(), PaymentTypes.SBI.name.toLowerCase()->R.drawable.ic_state_bank_of_india_corporate
            PaymentTypes.SCBNB.name.toLowerCase(), PaymentTypes.SCB.name.toLowerCase(),
            PaymentTypes.SCBLENCC.name.toLowerCase()->R.drawable.ic_standard_chartered_bank
            PaymentTypes.SDCB.name.toLowerCase()->R.drawable.ic_standard_chartered_bank
            PaymentTypes.SOIB.name.toLowerCase(), PaymentTypes.SIBLENCC.name.toLowerCase()->R.drawable.ic_south_india_bank
            PaymentTypes.SRSWT.name.toLowerCase()->R.drawable.ic_saraswat_bank
            PaymentTypes.SVCB.name.toLowerCase()->R.drawable.ic_shamrao_vithal
            PaymentTypes.SVCNB.name.toLowerCase()->R.drawable.ic_shamrao_vithal
            PaymentTypes.SYDB.name.toLowerCase(), PaymentTypes.SYNBENCC.name.toLowerCase()->R.drawable.syndicate_bank
            PaymentTypes.SYNDB.name.toLowerCase()->R.drawable.syndicate_bank
            PaymentTypes.TBON.name.toLowerCase()->R.drawable.the_nainital_bank
            PaymentTypes.TMBB.name.toLowerCase(), PaymentTypes.TMBLENCC.name.toLowerCase()->R.drawable.ic_tamilnad_mercantile_bank
            PaymentTypes.UBIB.name.toLowerCase(), PaymentTypes.UBINENCC.name.toLowerCase()->R.drawable.ic_union_bankof_india
            PaymentTypes.UBIBC.name.toLowerCase()->R.drawable.ic_union_bankof_india
            PaymentTypes.UCOB.name.toLowerCase(), PaymentTypes.UCBAENCC.name.toLowerCase()->R.drawable.ic_uco_bank
            PaymentTypes.UNIB.name.toLowerCase(), PaymentTypes.UTBIENCC.name.toLowerCase()->R.drawable.ic_united_bank_of_india
            PaymentTypes.VJYB.name.toLowerCase()->R.drawable.ic_vijaya_bank
            PaymentTypes.YESB.name.toLowerCase(), PaymentTypes.YES.name.toLowerCase(), PaymentTypes.
            YESBENCC.name.toLowerCase()->R.drawable.ic_yes_bank
            PaymentTypes.YESNBTPV.name.toLowerCase()->R.drawable.ic_yes_bank
            PaymentTypes.HSBC.name.toLowerCase() -> R.drawable.ic_hsbc
            PaymentTypes.AMON.name.toLowerCase()->R.drawable.ic_airtel
            PaymentTypes.AMZPAY.name.toLowerCase()->R.drawable.ic_amazon
            PaymentTypes.BKASH.name.toLowerCase()->R.drawable.ic_bkash
            PaymentTypes.CPMC.name.toLowerCase(), PaymentTypes.CITIENCC.name.toLowerCase()->R.drawable.ic_citi
            PaymentTypes.DONE.name.toLowerCase()->R.drawable.ic_done_card
            PaymentTypes.FREC.name.toLowerCase()->R.drawable.ic_freecharge
            PaymentTypes.ICASH.name.toLowerCase()->R.drawable.ic_icash
            PaymentTypes.IDM.name.toLowerCase()->R.drawable.ic_icash
            PaymentTypes.ITZC.name.toLowerCase()->R.drawable.ic_itzcash
            PaymentTypes.JIOM.name.toLowerCase()->R.drawable.ic_jio_money
            PaymentTypes.OLAM.name.toLowerCase()->R.drawable.ic_ola_money
            PaymentTypes.OXICASH.name.toLowerCase()->R.drawable.ic_oxigen
            PaymentTypes.PAYCASH.name.toLowerCase()->R.drawable.ic_paycash
            PaymentTypes.PAYTM.name.toLowerCase(), PaymentTypes.PYTMENCC.name.toLowerCase()->R.drawable.ic_paytm
            PaymentTypes.PAYZ.name.toLowerCase()->R.drawable.ic_payzapp
            PaymentTypes.PHONEPE.name.toLowerCase()->R.drawable.ic_phonepe
            PaymentTypes.PPINAPP.name.toLowerCase()->R.drawable.ic_phonepe
            PaymentTypes.PPINTENT.name.toLowerCase()->R.drawable.ic_phonepe
            PaymentTypes.PPSDKLES.name.toLowerCase()->R.drawable.ic_phonepe
            PaymentTypes.TEZ.name.toLowerCase(), "google_pay" -> R.drawable.ic_google_pay
            PaymentTypes.YESW.name.toLowerCase()->R.drawable.ic_yespay
            PaymentTypes.ZIPCASH.name.toLowerCase()->R.drawable.ic_payzapp
            "162b",PaymentTypes.KOTAK.name.toLowerCase(), PaymentTypes.KKBKENCC.name.toLowerCase()->R.drawable.ic_kotak
            PaymentTypes.VISA.name.toLowerCase()->R.drawable.payu_visa
            PaymentTypes.DISCOVER.name.toLowerCase()->R.drawable.payu_discover
            PaymentTypes.MAST.name.toLowerCase()->R.drawable.payu_master_card
            PaymentTypes.MAES.name.toLowerCase()->R.drawable.payu_maestro
            PaymentTypes.SMAE.name.toLowerCase()->R.drawable.payu_maestro
            PaymentTypes.JCB.name.toLowerCase()->R.drawable.payu_jcb
            PaymentTypes.RUPAY.name.toLowerCase(), PaymentTypes.RUPAYCC.name.toLowerCase() -> R.drawable.payu_rupay
            PaymentTypes.AMEX.name.toLowerCase()->R.drawable.payu_amex
            PaymentTypes.DINR.name.toLowerCase()->R.drawable.payu_dinersclub
            PaymentTypes.USFBENCC.name.toLowerCase() -> R.drawable.payu_ujjivan_bank
            PaymentTypes.AUBLENCC.name.toLowerCase() -> R.drawable.payu_au_bank
            PaymentTypes.ESFBENCC.name.toLowerCase() -> R.drawable.payu_equitas_bank
            PaymentTypes.JSFBENCC.name.toLowerCase() -> R.drawable.payu_jana_bank
            else -> defaultDrawableId
        }
    }

    fun getDrawablesForTypes(context: Context, types: String,defaultDrawableId:Int): Bitmap? {
        return getBitmapFromDrawable(context, getResourceForTypes(types,defaultDrawableId))
    }
}