package com.payu.assetprovider

import android.content.Context
import androidx.annotation.Keep

class AssetManager private constructor(var _context: Context) {


    fun get(key: String, callback: BitmapCallback) {
        get(key,R.drawable.ic_placeholder,callback)
    }

    fun get(key: String,defaultDrawableId:Int,callback: BitmapCallback) {
        val bitmap = Utils.getDrawablesForTypes(_context, key,defaultDrawableId)
        callback.onBitmapReceived(key, bitmap!!)
    }

    @Keep companion object {
        private val INSTANCE: AssetManager? = null

        @Synchronized
        fun getInstance(context: Context): AssetManager {
            return INSTANCE?.let { return INSTANCE }
                ?: run {
                    return AssetManager(context)
                }
        }
    }

}