//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.paymentparamhelper;


import java.util.HashSet;
import java.util.Set;

/**
 * Created by franklin on 5/31/15.
 * Payu constants
 * User can make use in API request, response, bundles, validations etc,
 */
public interface PayuConstants {

    // payu default params
    String DEVICE_TYPE = "device_type";
    // payment modes
    String CC = "CC";
    String EMI = "EMI";
    String CASH = "CASH";
    String BNPL = "BNPL";
    String NB = "NB";

    String PAYU_MONEY = "PAYU_MONEY";
    String UPI = "upi";
    String ICICPL = "ICICPL";
    String SIMPL = "SIMPL";
    String UPITPV = "UPITPV";
    String TEZTPV = "TEZTPV";
    String INTTPV = "INTTPV";
    String INTOTM = "INTOTM";
    String UPIOTM = "UPIOTM";
    String TEZ = "TEZ";
    String TEZOMNI = "TEZOMNI";
    String OLAM = "OLAM";
    String TWID = "TWID";
    String OLA_MONEY = "OLA_MONEY";
    String SAMSUNG_PAY = "SAMPAY";
    String PHONEPE_INTENT = "PPINTENT";
    String UPI_INTENT = "INTENT";
    String PAY_BY_REWARDS = "PAY_BY_REWARDS";
    String NEFT_RTGS = "NEFTRTGS";
    String EFT_AXIS = "EFTAXIS";
    String SODEXO = "SODEXO";
    String MC = "MC";
    String LAZYPAY = "LAZYPAY";


    // payment mode params
    String PG = "pg";
    String BANK_CODE = "bankcode";
    String PG_BANK_CODE = "bankCode";
    String CC_NUM = "ccnum";
    String CC_NAME = "ccname";
    String C_CVV = "ccvv";
    String CC_EXP_MON = "ccexpmon";
    String CC_EXP_YR = "ccexpyr";
    String STORE_CARD_TOKEN = "store_card_token";
    String STORED_CARD = "store_card";
    String USER_CREDENTIALS = "user_credentials";
    String USER_TOKEN = "userToken";
    String USER_TOKEN_PAYMENT = "user_token";
    String VPA = "vpa";
    String VPA_PHONE = "vpa_phone";
    String NOTIFY_URL = "notifyurl";
    String SALT_VERSION = "salt_version";
    String TWID_CUSTOMER_HASH = "twid_customer_hash";
    String STORED_CARD_TOKEN_TYPE = "storecard_token_type";
    String STORED_CARD_ADDITIONAL_INFO = "additional_info";
    String SOURCE_ID = "source_id";
    String SAVE_SODEXO_CARD = "save_sodexo_card";

    String PAYU_SKUS_DETAILS = "skusDetail";

    //cardless bank names
    String ZEST = "ZEST";
    String BAJFIN = "BAJFIN";

    // cvvless inputs


    // payment mandatory parms
    String KEY = "key";
    String TXNID = "txnid";
    String AMOUNT = "amount";
    String PRODUCT_INFO = "productinfo";
    String PRE_AUTHORIZE = "pre_authorize";
    String FIRST_NAME = "firstname";
    String BENEFICIARY_ACCOUNT_NUMBER = "beneficiaryAccountNumber";
    String IFSC_CODE = "ifscCode";
    String BENEFICIARY_DETAILS = "beneficiarydetail";
    String TPV = "TPV";
    String API_VERSION = "api_version";
    String EMAIL = "email";
    String SURL = "surl";
    String FURL = "furl";
    String HASH = "hash";

    // payment other params
    String OFFER_KEY = "offer_key";
    String F_OFFER_KEY = "offerKey";
    String PHONE = "phone";
    String LASTNAME = "lastname";
    String ADDRESS1 = "address1";
    String ADDRESS2 = "address2";
    String CITY = "city";
    String STATE = "state";
    String COUNTRY = "country";
    String ZIPCODE = "zipcode";

    String CODURL = "codurl";
    String DROP_CATEGORY = "drop_category";
    String ENFORCE_PAYMETHOD = "enforce_paymethod";
    String CUSTOM_NOTE = "custom_note";
    String NOTE_CATEGORY = "note_category";
    String SHIPPING_FIRSTNAME = "shipping_firstname";
    String SHIPPING_LASTNAME = "shipping_lastname";
    String SHIPPING_ADDRESS1 = "shipping_address1";
    String SHIPPING_ADDRESS2 = "shipping_address2";
    String SHIPPING_CITY = "shipping_city";
    String SHIPPING_STATE = "shipping_state";
    String SHIPPING_CONTRY = "shipping_county";
    String SHIPPING_ZIPCODE = "shipping_zipcode";
    String SHIPPING_PHONE = "shipping_phone";
    String LOOKUPID = "lookupId";
    String SPLIT_REQUEST = "splitRequest";
    String OUTLET_ID = "outletId";

    //udf collection
    String UDF1 = "udf1";
    String UDF2 = "udf2";
    String UDF3 = "udf3";
    String UDF4 = "udf4";
    String UDF5 = "udf5";
    String RETRY_SDK = "&sdk_retry=1";
    String ADDITIONAL_CHARGES = "additional_charges";
    String PERCENTAGE_ADDITIONAL_CHARGES = "percentage_additional_charges";
    String BINS_DATA = "bins_data";
    String BIN_LEVEL = "binLevel";
    String DATA = "data";
    String CONVENIENCE_FEE_DATA = "convenienceFeeData";
    String CONVENIENCE_FEE = "convenienceFee";
    String GST = "gst";
    String PAYU_VALIDATE_OFFER_REQUEST_JSON = "validateOfferRequest";
    String PAYU_CHARGE_UUIDS = "chargeUUIDs";
    String PAYU_REQUEST_UUID = "requestUUID";

    // issuer collections

    String VISA = "VISA";
    String LASER = "LASER";
    String MAES = "MAES";
    String MAST = "MAST";
    String AMEX = "AMEX";
    String DINR = "DINR";
    String JCB = "JCB";
    String SMAE = "SMAE";
    String RUPAY = "RUPAY";
    String UNDEFINED = "UNDEFINED";

    // webservice api constants

    String DEFAULT = "default";


    int MAX_VPA_SIZE = 50;
    int MAX_PHONE_VPA_SIZE = 10;
    // commands

    @Deprecated
    String GET_NETBANKING_STATUS = "getNetbankingStatus";
    @Deprecated
    String GET_ISSUING_BANK_STATUS = "getIssuingBankStatus";
    @Deprecated
    String GET_MERCHANT_IBIBO_CODES = "get_merchant_ibibo_codes";
    // hash generation api not for merchats
    @Deprecated
    String MOBILE_HASH_TEST_WS = "mobileHashTestWs";
    // status
    String ERROR = "ERROR";
    String SUCCESS = "SUCCESS";
    // Response data
    String PAYUW = "PAYUW";
    String WALLET = "wallet";

    // user cards

    String NAME_ON_CARD = "name_on_card";
    String CARD_NAME = "card_name";

    // for bundle
    @Deprecated
    String PAYMENT_DEFAULT_PARAMS = "payment_default_params";

    // sets and lists

    Set<String> PG_SET = new HashSet<String>();
    String[] PAYMENT_PARAMS_ARRAY = {KEY, TXNID, AMOUNT, PRODUCT_INFO, FIRST_NAME, EMAIL, SURL, FURL, HASH, UDF1, UDF2, UDF3, UDF4, UDF5, BENEFICIARY_ACCOUNT_NUMBER, RETRY_SDK, USER_CREDENTIALS};
    // Shared preference file name
    INIT init = new INIT();

    // subvention amount - used with payment url (_payment)
    String SUBVENTION_AMOUNT = "subvention_amount";

    //Analytics
    String PLATFORM_KEY = "platform";
    String PLATFORM_VALUE = "android";
    String SDK_PLATFORM_KEY = "sdk_platform";
    String NAME_KEY = "name";
    String NAME_VALUE = "pgsdk";
    String VERSION_KEY = "version";
    String CARD_NUMBER = "card_number";
    String CVV = "cvv";
    String EXPIRY_MONTH = "expiry_month";
    String EXPIRY_YEAR = "expiry_year";
    String CARD_TOKEN = "card_token";
    String CARD_BIN = "card_bin";
    String SPLIT_PAYMENT_DETAILS = "split_Payment_Details";
    String SI_PARAMS = "si_params";
    String BENEFICIARY_IFSC = "beneficiary_ifsc";
    String CC_CARD_TYPE = "cc_card_type";
    String CC_CATEGORY = "cc_category";
    String IS_FREE_TRIAL = "is_free_trial";
    String SI = "si";
    String CARD_TOKEN_TYPE = "card_token_type";
    String SUBVENTION_ELIGIBILITY = "subvention_eligibility";
    String SODEXO_SOURCE_ID = "sodexo_source_id";
    String CATEGORY = "category";
    String PAYMENT_CODE = "payment_code";
    String CARD_HASH = "card_hash";
    String CARD_MASK = "card_mask";


    class INIT {
        static {
            //PG_SET
            PG_SET.add(CC);
            PG_SET.add(EMI);
            PG_SET.add(CASH);
            PG_SET.add(NB);
            PG_SET.add(PAYU_MONEY);
            PG_SET.add(UPI);
            PG_SET.add(TEZ);
            PG_SET.add(SAMSUNG_PAY);
            PG_SET.add(PHONEPE_INTENT);
            PG_SET.add(UPI_INTENT);
            PG_SET.add(OLA_MONEY);
            PG_SET.add(PAY_BY_REWARDS);
            PG_SET.add(BNPL);
            PG_SET.add(CLW);
            PG_SET.add(OLW);

            // For getEmiAmountAccordingToInterest
        }

        INIT() {
        }
    }

    String BENEFICIARY_NAME = "beneficiaryName";
    String BENEFICIARY_ACCOUNT_TYPE = "beneficiaryAccountType";
    String BILLING_INTERVAL = "billingInterval";
    String BILLING_CYCLE = "billingCycle";
    String BILLING_AMOUNT = "billingAmount";
    String BILLING_CURRENCY = "billingCurrency";
    String BILLING_START_DATE = "paymentStartDate";
    String BILLING_END_DATE = "paymentEndDate";
    String BILLING_REMARKS = "remarks";
    String BILLING_LIMIT = "billingLimit";
    String BILLING_RULE = "billingRule";
    String BILLING_DATE = "billingDate";
    String ENACH = "ENACH";
    String SI_API_VERSION = "api_version";
    String SI_VALUE = "si";
    String SI_DETAILS = "si_details";
    String DC = "DC";
    String SI_FREE_TRIAL = "free_trial";
    String SI_FREE_TRIAL_API_VERSION = "11";
    String VERTIFICATION_MODE = "verificationMode";


    String SPLIT_PAYMENT_TYPE = "type";
    String SPLIT_PAYMENT_INFO = "splitInfo";
    String SPLIT_PAYMENT_AGGREGATOR_SUB_TXN_ID = "aggregatorSubTxnId";
    String SPLIT_PAYMENT_AGGREGATOR_SUB_AMOUNT = "aggregatorSubAmt";
    String SPLIT_PAYMENT_AGGREGATOR_CHARGES = "aggregatorCharges";
    String TOKENISED_CARD_LAST_4_DIGITS = "last4Digits";
    String TOKENISED_CARD_TAVV = "tavv";
    String TOKENISED_CARD_TRID = "trid";
    String TOKENISED_CARD_TOKENREFNO = "tokenRefNo";
    String HASH_NAME = "hashName";
    String HASH_STRING = "hashString";
    String POST_SALT = "postSalt";


    //Hybrid
    String HYBRID_LOOKUP_ID="lookup_id";
    String HYBRID_NOTIFY_URL = "notify_url";
    String HYBRID_BENEFICIARY_ACCOUNT_NUMBER = "beneficiary_account_number";
    String HYBRID_IFSC_CODE = "beneficiary_ifsc";
    String HYBRID_BANK_CODE = "bank_code";
    String HYBRID_BENEFICIARY_DETAILS = "beneficiary_details";
    String HYBRID_BENEFICIARY_NAME = "beneficiary_name";
    String HYBRID_BENEFICIARY_ACCOUNT_TYPE = "beneficiary_account_type";
    String HYBRID_BILLING_INTERVAL = "billing_interval";
    String HYBRID_BILLING_CYCLE = "billing_cycle";
    String HYBRID_BILLING_AMOUNT = "billing_amount";
    String HYBRID_BILLING_CURRENCY = "billing_currency";
    String HYBRID_BILLING_START_DATE = "payment_start_date";
    String HYBRID_BILLING_END_DATE = "payment_end_date";
    String HYBRID_BILLING_REMARKS = "remarks";
    String HYBRID_BILLING_LIMIT = "billing_limit";
    String HYBRID_BILLING_RULE = "billing_rule";
    String HYBRID_BILLING_DATE = "billing_date";

    String THREEDS2_SDK_INFO = "sdkInfo";
    String THREEDS2_SDK_ENC_DATA = "sdkEncData";
    String THREEDS2_SDK_APP_ID = "sdkAppID";
    String THREEDS2_SDK_REFERENCE_NUMBER = "sdkReferenceNumber";
    String THREEDS2_SDK_TRANS_ID = "sdkTransID";
    String THREEDS2_SDK_EMPHEM_KEY = "sdkEphemPubKey";
    String THREEDS2_SDK_EMPHEM_KEY_CRV = "crv";
    String THREEDS2_SDK_EMPHEM_KEY_KTY = "kty";
    String THREEDS2_SDK_EMPHEM_KEY_X = "x";
    String THREEDS2_SDK_EMPHEM_KEY_Y = "y";
    String THREEDS2_SDK_REQUEST_DATA = "threeDS2RequestData";
    String THREEDS2_SDK_DEVICE_CHANNEL = "deviceChannel";
    String THREEDS2_SDK_DEVICE_CHANNEL_VALUE = "APP";
    String THREEDS2_SDK_VERSION = "threeDSVersion";
    String THREEDS2_SDK_VERSION_VALUE = "2.1.0";
    String THREEDS2_SDK_MAX_TIMEOUT = "sdkMaxTimeout";
    String THREEDS2_SDK_DEVICE_RENDER_OPTIONS = "deviceRenderOptions";
    String THREEDS2_SDK_INTERFACE = "sdkInterface";
    String THREEDS2_SDK_UI_TYPE = "sdkUiType";

    //Global Vault
    String PAYU_REQUESTID = "requestId";
    String GV_REQUESTTYPE = "requestType";
    String GV_USER_CRED = "userCredential";


    String ICICI = "HDFC";

    String PANNUMBER = "panNumber";

    String CLW = "clw";
    String OLW = "olw";
    String PAY = "PAY";
    String WALLET_URN = "walletUrn";
    String UPI_APP_NAME = "upiAppName";
    String UPI_USER_AGENT = "User-Agent";
    String LOAD_AMOUNT = "load_amount";

    // sku api constant
    String P_SKUS = "skus";
    String P_SKU_ID = "skuId";
    String P_SKU_AMOUNT = "skuAmount";
    String P_QUANTITY = "quantity";
    String P_OFFER_KEY = "offerKeys";
    String P_AUTO_APPLY_OFFER = "autoApplyOffer";
    String P_SKU_NAME = "sku_name";
    String P_ITEMS = "items";
    String P_SKU_DETAILS = "sku_details";
    String P_SKU_M_ID = "sku_id";
    String P_SKU_M_AMOUNT = "amount_per_sku";
    String P_AUTO_APPLY_M_OFFER = "offer_auto_apply";
    String P_CART_DETAILS = "cart_details";
    String P_IS_NO_COST_EMI = "isNoCostEmi";
    String P_PHONE_NO = "phoneNo";
    String P_SKU_DISCOUNT_DETAILS = "skusDiscountDetail";
    String P_SKU_T_DISCOUNT_DETAILS = "skuTotalDiscountDetail";
    String P_SKU = "sku";

    String P_DEVICE_DETAILS = "device_details";

    String PAYU_CASH_CARD = "cashcard";
    String SI_API_VERSION_VALUE = "7";
    String TPV_API_VERSION_VALUE = "6";
    String TPV_MF_API_VERSION_VALUE = "21";
    String LOGGED_IN_PHONE_NUMBER = "loggedInPhoneNumber";
    String IS_CONSENTED = "isConsented";
    String USER_DETAIL = "userDetail";
    String SOMETHING_WENT_WRONG_ERROR = "Something went wong.";
    String PAYU_CAPTURE = "capture";

    String PAYU_COMBINATIONS = "combinations";
    String PAYU_COMBINATION_UUID = "combinationUUID";
    String PAYU_CHARGES = "charges";
    String PAYU_CHARGE_UUID = "chargeUUID";
    String PAYU_CHARGE_NAME = "chargeName";
    String PAYU_BASE_FEE = "baseFee";
    String PAYU_TAX_AMT = "taxAmount";
    String PAYU_RULE_ID = "ruleId";
    String PAYU_ID = "payuId";
    String PAYU_TIME_STAMP = "timeStamp";
    String PAYU_COMMON_DYNAMIC_ATTRIBUTES = "commonDynamicAttributes";
    String PAYU_VARIABLE_DYNAMIC_ATTRIBUTES = "variableDynamicAttributes";
    String PAYU_COMBINATION_KEY = "combinationKey";
    String PAYU_IS_PRICING_CF_ENABLED = "isPricingCFEnable";
    String PAYU_CLIENT_ID = "clientId";
    String PAYU_PERCENTAGE_ADDITIONAL_CHARGES = "percentageAdditionalCharges";
    String PAYU_IS_SI_TXN = "isSITxn";
    String PAYU_TXN_ID = "txnId";
    String PAYU_PRICING_CF_DATA = "pricing_cf_data";
    String PAYU_ONE = "1";
    String PAYU_ZERO = "0";
    String PAYU_VALIDATE_OFFER_DATA = "validate_offer_data";

    String PAYU_TYPE = "type";
    String PAYU_PLAN = "plan";
    String PAYU_FOLIO = "folio";
    String PAYU_OPTION = "option";
    String PAYU_SCHEME = "scheme";
    String PAYU_RECEIPT = "receipt";
    String PAYU_MF_MEMBER_ID = "mf_member_id";
    String PAYU_MF_USER_ID = "mf_user_id";
    String PAYU_MF_PARTNER = "mf_partner";
    String PAYU_MF_INVESTMENT_TYPE = "mf_investment_type";
    String PAYU_MF_AMC_CODE = "mf_amc_code";
    String PAYU_PRODUCT = "products";
    // OLW

    String PAYU_NEW_MPIN = "newMpin";
    String PAYU_CLIENT_TXN_ID = "clientTxnId";
    String PAYU_REQUEST_DATE_TIME = "requestDateTime";
    String PAYU_ACTION = "action";
    String PAYU_CUSTOMER_MOBILE = "customerMobile";
    String PAYU_DEVICE_ID = "deviceId";
    String PAYU_OTP = "otp";
    String PAYU_MPIN = "mpin";
    String PAYU_TOKEN = "token";
    String PAYU_DEVICE__ID = "device_id";
    String PAYU_IS_MPIN_SET = "mpinSet";
    String PAYU_CUSTOMER_REGISTERED = "customerRegistered";
    String PAYU_AES_GCM_NO_PADDING= "AES/GCM/NoPadding";
    String PAYU_RSA = "RSA";
    String PAYU_PPI_INFO = "ppiInfo";
    String PAYU_BALANCE = "balance";

    interface PayuLoyalityConstant {
        String subPart1 = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjPcMyfn0akKLoSWWMsTRh3V1OC97X+pbQms7KOs1RHdKXts2McAJpIdd8TIZbpZiSU6yo3CnRA+Kml+iOGmhmCKmEIs64cR4dG7M1rOIR8rnM1QymVrWRG7h/u17HNDfS29VwUacLE5Ag0rO9Z6AwjnsYUD+t7dd6t7Ll7c3QEn";
        String subPart2 = "/3+MZNzHEbkoN2tg8iGIM5HoL0241IfO/cz7yfLGrmDWxEQZZGiwG1YcC5/BI87MkvmEgW/6lBydoc0XnHAbFm2w1ZO17qEvDEr8VkZ";
        String subPart3 = "YUjzwRjBDbdvstSTMgGM/RCbyvfMbZ0BVLpX8AT3JGB6e3/ABE8xbbBtFGcE5BgDLrrwIDAQAB";
    }

    interface PayUPaymentConstant {
        String subPart1_payment = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0yvzZRJI6c4qdhh3zmT4TvMypvzR+bPiVTCFduRODtF+Lq2zPQEQ74eiz4NC6QNeWH89+";
        String subPart2_payment = "0FM7bvwOSGvKeAhut6ilbf+7UT1SeXjxvH7HC+6gZp5dsOUp4B+J2bl39uuQFnYa94qOlPs3gI+GptSC6Z9rciJB2SBv86zJ9JNdsAVfLgpB+P7+Xg68oD524/EqMUVHdJeeAXl9MmRk";
        String subPart3_payment = "/dgYKtaB6JOWBohBebbNqiuO4f+9WlZzUwdimGbdVVXhBxFi5zHnXGKQF3XjVdJd9RCCXkL+LqEOd1315vsXp0YEYWxUbnpQ9mFdnqJRQQZV8w5Q1iYqUNkcOym43NqHigM1wIDAQAB";
        String PAYU_OLW_KEY = "olw_encrypted_key";
    }
}
