package com.payu.paymentparamhelper.parser;

import com.payu.paymentparamhelper.PaymentParams;
import com.payu.paymentparamhelper.PaymentPostParams;
import com.payu.paymentparamhelper.PayuConstants;
import com.payu.paymentparamhelper.PayuErrors;
import com.payu.paymentparamhelper.PayuUtils;
import com.payu.paymentparamhelper.PostData;
import com.payu.paymentparamhelper.siparams.BeneficiaryDetails;
import com.payu.paymentparamhelper.siparams.SIParams;
import com.payu.paymentparamhelper.siparams.SIParamsDetails;
import com.payu.paymentparamhelper.siparams.enums.BeneficiaryAccountType;
import com.payu.paymentparamhelper.siparams.enums.BillingCycle;
import com.payu.paymentparamhelper.siparams.enums.BillingLimit;
import com.payu.paymentparamhelper.siparams.enums.BillingRule;

import java.util.HashMap;

public class HashMapToPostDataHybrid {
    private HashMap<String, Object> payUPaymentParams;

    public HashMapToPostDataHybrid(HashMap<String, Object> paymentConfig) {
        this.payUPaymentParams = paymentConfig;
    }

    private PaymentParams getCommonPaymentParams() {
        PaymentParams mPaymentParamsUpiSdk = new PaymentParams();
        mPaymentParamsUpiSdk.setKey(PayuUtils.valueOf(payUPaymentParams.get(ParserConstants.KEY))); //Your Merchant Key
        mPaymentParamsUpiSdk.setProductInfo(PayuUtils.valueOf(payUPaymentParams.get(ParserConstants.PRODUCT_INFO)));
        mPaymentParamsUpiSdk.setFirstName(PayuUtils.valueOf(payUPaymentParams.get(ParserConstants.FIRST_NAME))); //Customer First name
        mPaymentParamsUpiSdk.setEmail(PayuUtils.valueOf(payUPaymentParams.get(ParserConstants.EMAIL))); //Customer Email
        mPaymentParamsUpiSdk.setTxnId(PayuUtils.valueOf(payUPaymentParams.get(ParserConstants.TRANSACTION_ID))); //Your transaction id
        mPaymentParamsUpiSdk.setAmount(PayuUtils.valueOf(payUPaymentParams.get(ParserConstants.AMOUNT)));//Your transaction Amount(In Double as String)
        mPaymentParamsUpiSdk.setSurl(PayuUtils.valueOf(payUPaymentParams.get(ParserConstants.ANDROID_SURL)));
        mPaymentParamsUpiSdk.setFurl(PayuUtils.valueOf(payUPaymentParams.get(ParserConstants.ANDROID_FURL)));
        setAdditionalParams(mPaymentParamsUpiSdk);
        mPaymentParamsUpiSdk.setPhone(PayuUtils.valueOf(payUPaymentParams.get(ParserConstants.PHONE))); //Customer Phone Number
        mPaymentParamsUpiSdk.setHash(PayuUtils.valueOf((((HashMap<String, Object>) payUPaymentParams.get(ParserConstants.HASHES)).get(ParserConstants.PAYMENT))));//Payment Hash
        return mPaymentParamsUpiSdk;

    }

    private void setAdditionalParams(PaymentParams mPaymentParamsUpiSdk) {
        if (payUPaymentParams.get(ParserConstants.ADDITIONAL_PARAMS) instanceof HashMap) {
            HashMap<String, Object> additionalParams = (HashMap<String, Object>) payUPaymentParams.get(ParserConstants.ADDITIONAL_PARAMS);
            mPaymentParamsUpiSdk.setUdf1(PayuUtils.valueOf(additionalParams.get(ParserConstants.UDF_1)));
            mPaymentParamsUpiSdk.setUdf2(PayuUtils.valueOf(additionalParams.get(ParserConstants.UDF_2)));
            mPaymentParamsUpiSdk.setUdf3(PayuUtils.valueOf(additionalParams.get(ParserConstants.UDF_3)));
            mPaymentParamsUpiSdk.setUdf4(PayuUtils.valueOf(additionalParams.get(ParserConstants.UDF_4)));
            mPaymentParamsUpiSdk.setUdf5(PayuUtils.valueOf(additionalParams.get(ParserConstants.UDF_5)));
        } else {
            mPaymentParamsUpiSdk.setUdf1(ParserConstants.UDF_1);
            mPaymentParamsUpiSdk.setUdf2(ParserConstants.UDF_2);
            mPaymentParamsUpiSdk.setUdf3(ParserConstants.UDF_3);
            mPaymentParamsUpiSdk.setUdf4(ParserConstants.UDF_4);
            mPaymentParamsUpiSdk.setUdf5(ParserConstants.UDF_5);
        }
    }

    public PostData parse(String paymentMode) {
        PostData postData = new PostData();
        postData.setCode(PayuErrors.MISSING_PARAMETER_EXCEPTION);
        postData.setStatus(PayuConstants.ERROR);
        postData.setResult(PayuErrors.MANDATORY_PRAMS_NOT_PASSED);
        PaymentParams paymentParams = getCommonPaymentParams();
        if (payUPaymentParams.containsKey(PayuConstants.HYBRID_LOOKUP_ID)) {
            paymentParams.setLookupId(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.HYBRID_LOOKUP_ID)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.CARD_NUMBER)) {
            paymentParams.setCardNumber(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.CARD_NUMBER)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.CVV)) {
            paymentParams.setCvv(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.CVV)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.EXPIRY_MONTH)) {
            paymentParams.setExpiryMonth(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.EXPIRY_MONTH)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.EXPIRY_YEAR)) {
            paymentParams.setExpiryYear(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.EXPIRY_YEAR)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.NAME_ON_CARD)) {
            paymentParams.setNameOnCard(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.NAME_ON_CARD)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.STORED_CARD)) {
            paymentParams.setStoreCard(PayuUtils.parseInt(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.STORED_CARD))));
        }
        if (payUPaymentParams.containsKey(PayuConstants.USER_CREDENTIALS)) {
            paymentParams.setUserCredentials(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.USER_CREDENTIALS)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.CARD_TOKEN)) {
            paymentParams.setCardToken(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.CARD_TOKEN)));
        }

        if (payUPaymentParams.containsKey(PayuConstants.OFFER_KEY)) {
            paymentParams.setOfferKey(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.OFFER_KEY)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.CARD_BIN)) {
            paymentParams.setCardBin(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.CARD_BIN)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.SUBVENTION_AMOUNT)) {
            paymentParams.setSubventionAmount(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.SUBVENTION_AMOUNT)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.HYBRID_NOTIFY_URL)) {
            paymentParams.setNotifyURL(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.HYBRID_NOTIFY_URL)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.SPLIT_PAYMENT_DETAILS)) {
            paymentParams.setSplitPaymentDetails(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.SPLIT_PAYMENT_DETAILS)));
        }

        if (payUPaymentParams.containsKey(PayuConstants.HYBRID_BENEFICIARY_ACCOUNT_NUMBER)) {
            paymentParams.setBeneficiaryAccountNumber(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.HYBRID_BENEFICIARY_ACCOUNT_NUMBER)));
        }

        if (payUPaymentParams.containsKey(PayuConstants.HYBRID_IFSC_CODE)) {
            paymentParams.setIfscCode(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.HYBRID_IFSC_CODE)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.HYBRID_BANK_CODE)) {
            paymentParams.setBankCode(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.HYBRID_BANK_CODE)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.SI_PARAMS)) {
            try {
              SIParams siParams = new SIParams();
                HashMap<String, Object> siParamMap = (HashMap<String, Object>) payUPaymentParams.get(PayuConstants.SI_PARAMS);

                BeneficiaryDetails beneficiaryDetails = new BeneficiaryDetails();
                if(siParamMap!=null && siParamMap.containsKey(PayuConstants.HYBRID_BENEFICIARY_DETAILS)){
                  HashMap<String, Object> beneficiaryDetailsMap = (HashMap<String, Object>) siParamMap.get(PayuConstants.HYBRID_BENEFICIARY_DETAILS);
                  beneficiaryDetails.setBeneficiaryAccountNumber(PayuUtils.valueOf(beneficiaryDetailsMap.get(PayuConstants.HYBRID_BENEFICIARY_ACCOUNT_NUMBER)));
                  beneficiaryDetails.setBeneficiaryIfsc(PayuUtils.valueOf(beneficiaryDetailsMap.get(PayuConstants.BENEFICIARY_IFSC)));
                  beneficiaryDetails.setBeneficiaryName(PayuUtils.valueOf(beneficiaryDetailsMap.get(PayuConstants.HYBRID_BENEFICIARY_NAME)));
                  beneficiaryDetails.setBeneficiaryAccountType(PayuUtils.parseInt(PayuUtils.valueOf(beneficiaryDetailsMap.get(PayuConstants.HYBRID_BENEFICIARY_ACCOUNT_TYPE))) == 1 ? BeneficiaryAccountType.CURRENT : BeneficiaryAccountType.SAVINGS);
                  siParams.setBeneficiarydetail(beneficiaryDetails);
                }


                SIParamsDetails siParamDetails = new SIParamsDetails();
                HashMap<String, Object> siParamDetailsMap = (HashMap<String, Object>) siParamMap.get(PayuConstants.SI_DETAILS);

                siParamDetails.setBillingAmount(PayuUtils.valueOf(siParamDetailsMap.get(PayuConstants.HYBRID_BILLING_AMOUNT)));
                siParamDetails.setBillingCurrency(PayuUtils.valueOf(siParamDetailsMap.get(PayuConstants.HYBRID_BILLING_CURRENCY)));
                BillingCycle cycle = BillingCycle.ONCE;
                switch (String.valueOf(siParamDetailsMap.get(PayuConstants.HYBRID_BILLING_CYCLE))) {
                    case ParserConstants.YEARLY:
                        cycle = BillingCycle.YEARLY;
                        break;
                    case ParserConstants.MONTHLY:
                        cycle = BillingCycle.MONTHLY;
                        break;
                    case ParserConstants.WEEKLY:
                        cycle = BillingCycle.WEEKLY;
                        break;
                    case ParserConstants.ADHOC:
                        cycle = BillingCycle.ADHOC;
                        break;
                    case ParserConstants.DAILY:
                        cycle = BillingCycle.DAILY;
                        break;
                }
                siParamDetails.setBillingCycle(cycle);
                siParamDetails.setBillingDate(PayuUtils.valueOf(siParamDetailsMap.get(PayuConstants.HYBRID_BILLING_DATE)));

                siParamDetails.setBillingInterval(PayuUtils.parseInt(PayuUtils.valueOf(siParamDetailsMap.get(PayuConstants.HYBRID_BILLING_INTERVAL))));
                switch (String.valueOf(siParamDetailsMap.get(PayuConstants.HYBRID_BILLING_LIMIT))) {
                    case ParserConstants.BEFORE:
                        siParamDetails.setBillingLimit(BillingLimit.BEFORE);
                        break;
                    case ParserConstants.AFTER:
                        siParamDetails.setBillingLimit(BillingLimit.AFTER);
                        break;
                }


                if(PayuUtils.valueOf(String.valueOf(siParamDetailsMap.get(PayuConstants.HYBRID_BILLING_RULE)))!=null){
                    siParamDetails.setBillingRule(String.valueOf(siParamDetailsMap.get(PayuConstants.HYBRID_BILLING_RULE)).equals("MAX") ? BillingRule.MAX : BillingRule.EXACT);
                }
                siParamDetails.setPaymentEndDate(PayuUtils.valueOf(siParamDetailsMap.get(PayuConstants.HYBRID_BILLING_END_DATE)));
                siParamDetails.setPaymentStartDate(PayuUtils.valueOf(siParamDetailsMap.get(PayuConstants.HYBRID_BILLING_START_DATE)));
                if (siParamDetailsMap.containsKey(PayuConstants.HYBRID_BILLING_REMARKS)) {
                    siParamDetails.setRemarks(PayuUtils.valueOf(siParamDetailsMap.get(PayuConstants.HYBRID_BILLING_REMARKS)));
                }


                siParams.setSi_details(siParamDetails);
                siParams.setCcCardType(PayuUtils.valueOf(siParamMap.get(PayuConstants.CC_CARD_TYPE)));
                siParams.setCcCategory(PayuUtils.valueOf(siParamMap.get(PayuConstants.CC_CATEGORY)));
                siParams.setFree_trial(Boolean.parseBoolean(PayuUtils.valueOf(siParamMap.get(PayuConstants.IS_FREE_TRIAL))));
                siParams.setSi(PayuUtils.valueOf(siParamMap.get(PayuConstants.SI)));
                paymentParams.setSiParams(siParams);
            } catch (Exception e) {
                postData.setResult(PayuErrors.INVALID_SI_DETAILS);
                return postData;
            }

        }
        if (payUPaymentParams.containsKey(PayuConstants.SAVE_SODEXO_CARD)) {
            paymentParams.setSaveSodexoCard(PayuUtils.parseInt(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.SAVE_SODEXO_CARD))));
        }
        if (payUPaymentParams.containsKey(PayuConstants.CARD_TOKEN_TYPE)) {
            paymentParams.setCardTokenType(PayuUtils.parseInt(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.CARD_TOKEN_TYPE))));
        }
        if (payUPaymentParams.containsKey(PayuConstants.SUBVENTION_ELIGIBILITY)) {
            paymentParams.setSubventionEligibility(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.SUBVENTION_ELIGIBILITY)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.TWID_CUSTOMER_HASH)) {
            paymentParams.setTwidCustomerHash(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.TWID_CUSTOMER_HASH)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.SODEXO_SOURCE_ID)) {
            paymentParams.setSodexoSourceId(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.SODEXO_SOURCE_ID)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.WALLET_URN)) {
            paymentParams.setWalletUrn(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.WALLET_URN)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.CATEGORY)) {
            paymentParams.setCategory(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.CATEGORY)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.USER_TOKEN)) {
            paymentParams.setUserToken(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.USER_TOKEN)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.VPA)) {
            paymentParams.setVpa(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.VPA)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.PAYMENT_CODE)) {
            paymentParams.setPaymentCode(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.PAYMENT_CODE)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.CARD_HASH)) {
            paymentParams.setCardHash(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.CARD_HASH)));
        }
        if (payUPaymentParams.containsKey(PayuConstants.CARD_MASK)) {
            paymentParams.setCardMask(PayuUtils.valueOf(payUPaymentParams.get(PayuConstants.CARD_MASK)));
        }
        postData = new PaymentPostParams(paymentParams, paymentMode).getPaymentPostParams();
        return postData;


    }

}
