package com.payu.otpparser

import android.Manifest
import android.app.Activity
import android.content.Context
import android.content.Intent
import android.content.pm.PackageInfo
import android.content.pm.PackageManager
import android.os.Build
import androidx.annotation.RequiresApi
import androidx.core.content.ContextCompat
import org.json.JSONObject
import java.net.URLEncoder
import java.text.DateFormat
import java.text.SimpleDateFormat
import java.util.*


object Utils {
    private val OTP_PARSER_PREF = "OTP_PARSER_PREF"
    fun fetchVerificationCode(message: String): String {
        return Regex("\\b(\\d{6,8})").find(message)?.value ?: ""
    }

    fun isPermissionAvailable(context: Context): Boolean {
        return ContextCompat.checkSelfPermission(
            context,
            Manifest.permission.RECEIVE_SMS
        ) == PackageManager.PERMISSION_GRANTED
    }

    fun checkSmsPermissionAvailable(context: Context): Boolean {
        val pm: PackageManager = context.packageManager
        try {
            val packageInfo: PackageInfo =
                pm.getPackageInfo(context.packageName, PackageManager.GET_PERMISSIONS)
            var requestedPermissions: Array<String?>? = null
            if (packageInfo != null) {
                requestedPermissions = packageInfo.requestedPermissions
            }
            if (requestedPermissions != null && requestedPermissions.isNotEmpty()) {

                if (requestedPermissions.contains(Manifest.permission.RECEIVE_SMS))
                    return true
            }
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
        }
        return false
    }

    fun getLogMessage(
        context: Context,
        key: String?,
        value: String?,
        sdkMerchantKey: String?,
        trnxID: String?
    ): String? {
        return try {
            val eventAnalytics = JSONObject()
            eventAnalytics.put(Constants.TXNID, trnxID)
            eventAnalytics.put(Constants.MERCHANT_KEY, sdkMerchantKey)
            eventAnalytics.put(Constants.EVENT_KEY, key)
            eventAnalytics.put(Constants.VALUE, URLEncoder.encode(value, "UTF-8"))
            eventAnalytics.put(Constants.PACKAGE_NAME, context.packageName)
            eventAnalytics.put(
                Constants.TIMESTAMP,
                getSystemCurrentTime()
            )

            eventAnalytics.put(
                Constants.VERSION_CODE,
                getVersionCode(context)
            )
            eventAnalytics.toString()
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
            "{}"
        }
    }

    private fun getSystemCurrentTime(): String? {
        try {
            val currentDate = Date(System.currentTimeMillis())
            val df: DateFormat = SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
            return df.format(currentDate)
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
        return ""
    }

    fun getVersionCode(context: Context): String? {
        try {
            val pInfo =
                context.packageManager.getPackageInfo(context.packageName, 0)
            return pInfo.versionName
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
        }
        return ""
    }



    fun setPermissionDenyingStatus(
        context: Context,
        permission: String?
    ) {
        SharedPrefsUtils.storeBooleanInSharedPreferences(context,permission,true, OTP_PARSER_PREF)
    }

    fun getPermissionDenyingStatusSharedPref(
        context: Context,
        permission: String?
    ): Boolean {
      return  SharedPrefsUtils.getBooleanFromSharedPreferences(context,permission, OTP_PARSER_PREF)
    }


    @RequiresApi(api = Build.VERSION_CODES.M)
    fun checkNeverAskAgainSelectedRationale(activity: Activity, permission: String?): Boolean {
        return activity.shouldShowRequestPermissionRationale(permission!!)
    }

    /**
     * Method to check if the intent is being thrown by Gms Service
     */
    fun checkifIntentIsValid(intent: Intent?, activity: Activity): Boolean {
        val componentName = intent?.resolveActivity(activity.packageManager)
        return componentName?.packageName.toString().equals("com.google.android.gms") &&
                componentName?.className.toString()
                    .equals("com.google.android.gms.auth.api.phone.ui.UserConsentPromptActivity")
    }

}