package com.payu.otpparser


import android.content.Context
import android.content.Context.MODE_PRIVATE
import android.content.SharedPreferences
import com.payu.payuanalytics.analytics.utils.EncryptionUtils


object SharedPrefsUtils {

    private fun getSharedPref(
        context: Context,
        fileName: String
    ): SharedPreferences {
        EncryptionUtils.getKeys(context)
        return context.getSharedPreferences(fileName, MODE_PRIVATE)
    }


    fun storeBooleanInSharedPreferences(
        context: Context,
        key: String?,
        value: Boolean?,
        fileName: String
    ) {
        val sharedPreferences = getSharedPref(context, fileName)
        val editor = sharedPreferences.edit()
        value?.let { nonNullValue ->
            editor?.putString(
                key,
                EncryptionUtils.encrypt(
                    context,
                    nonNullValue.toString()
                )
            )
        }
        editor?.apply()

    }

    fun getBooleanFromSharedPreferences(context: Context, key: String?, fileName: String): Boolean {
        try {
            val sharedPreferences = getSharedPref(context, fileName)
            var decodedString: String? = null
            key?.let { nonNullKey ->
                decodedString = sharedPreferences.getString(nonNullKey, "")
                decodedString = decodedString?.let { nonNullDecodedString ->
                    EncryptionUtils.decrypt(
                        context,
                        nonNullDecodedString
                    )
                }
            }
            return decodedString?.toBoolean() ?: false
        } catch (e: Exception) {
            removeAllFromSharedPref(context, fileName)
            return false
        }
    }

    /**
     * Simple helper method to remove all the keys from given shared pref file.
     *
     * @param context
     * @param prefName
     */
    private fun removeAllFromSharedPref(context: Context, prefName: String) {
        try {
            val settings: SharedPreferences = getSharedPref(context, prefName)
            settings.edit()?.clear()?.apply()
        } catch (e: java.lang.Exception) {
        }
    }

    fun deleteFromSharedPreferences(context: Context, key: String?, fileName: String) {
        val sharedPreferences = getSharedPref(context, fileName)
        val editor = sharedPreferences.edit()
        editor?.remove(key)
        editor?.apply()
    }

}