package com.payu.otpparser

import android.content.Intent
import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.annotation.Keep

class OtpParser private constructor(activity: ComponentActivity) : OtpHandlerCallback {
    private var handler: OtpHandler = OtpHandler(activity, this)

    init {
        activity.lifecycle.addObserver(handler)
    }

    fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        handler.onActivityResult(requestCode, resultCode, data)
    }

    fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<out String>,
        grantResults: IntArray
    ) {
        handler.onRequestPermissionsResult(requestCode, permissions, grantResults)

    }

    fun startListening(otpCallback: OtpCallback) {
        PayUOtpParserConfig.otpCallback = otpCallback
        handler.startListening()
    }

    fun startListening(otpCallback: OtpCallback, bundle: Bundle) {
        PayUOtpParserConfig.otpCallback = otpCallback
        handler.setBundle(bundle)
        handler.startListening()
    }

    fun stopListening() {
        handler.stopSmsListening()
    }

    @Keep
    companion object {
        @Volatile
        private var instance: OtpParser? = null

        @JvmStatic
        fun getInstance(activity: ComponentActivity): OtpParser {
            val checkInstance = instance
            if (checkInstance != null) {
                return checkInstance
            }

            return synchronized(this) {
                val checkInstanceAgain = instance
                if (checkInstanceAgain != null) {
                    checkInstanceAgain
                } else {
                    val created = OtpParser(activity)
                    instance = created
                    created
                }
            }
        }
    }

    fun setFragCallback(fragCallback: FragCallback) {
        handler.setFragCallback(fragCallback)
    }

    override fun lifeCycleOnDestroy() {
        instance = null
    }

}