package in.oliveboard.sdk.ui.fragments;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.squareup.otto.Subscribe;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.ClearTest;
import in.oliveboard.sdk.presenter.model.MockSingleDataModel;
import in.oliveboard.sdk.presenter.model.RefreshFragment;
import in.oliveboard.sdk.presenter.model.RefreshTestInfo;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.model.TestStatusEventModel;
import in.oliveboard.sdk.ui.SummeryActivity;
import in.oliveboard.sdk.ui.TestModuleActivity;
import in.oliveboard.sdk.ui.TestUpgradeActivity;
import in.oliveboard.sdk.ui.WebActivity;
import in.oliveboard.sdk.ui.adapters.MockTestListAdaptor;
import in.oliveboard.sdk.ui.base.BaseFragment;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.DialogUtils;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.LargeDataHandler;
import in.oliveboard.sdk.utils.MainEventBus;
import in.oliveboard.sdk.utils.RecyclerItemClickListener;
import in.oliveboard.sdk.utils.Utils;
import in.oliveboard.sdk.utils.onDialogOptionCalled;
import in.oliveboard.sdk.utils.onDialogUtilCalled;

public class MockFragment extends BaseFragment implements SwipeRefreshLayout.OnRefreshListener, CommonContract.View, onDialogUtilCalled,onDialogOptionCalled {
    SwipeRefreshLayout swipeRefreshLayout;
    RecyclerView recyclerView;
    TextView mockHeader;
    TextView noOfTests;
    RelativeLayout mockHeaderLayout;

    int usernewApp = 0;
    String paymentUrl, buyUrl, examName = "";
    String descriptionText;
    int forcePostion;

    TestPresenter presenter = new TestPresenter();
    ArrayList<ArrayList<String>> mockTestList = new ArrayList<>();
    MockTestListAdaptor mockTestListAdaptor;
    String urlTest;

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater,container,savedInstanceState);
        view = inflater.inflate(getLayoutId(), container, false);

        if (presenter != null) {
            presenter.initialize(getArguments());
        }

        swipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_container);
        recyclerView = (RecyclerView)view.findViewById(R.id.recycler_view_mock);
        mockHeader = (TextView)view.findViewById(R.id.title_head);
        noOfTests = (TextView)view.findViewById(R.id.desc_head);
        mockHeaderLayout = (RelativeLayout)view.findViewById(R.id.head);
        return view;
    }


    @Override
    protected void initializeDagger() {
       // App app = (App) getActivity().getApplicationContext();

    }

    @Override
    protected void initializePresenter() {
        super.presenter = presenter;
        presenter.setView(this);

    }

    @Override
    protected void initializeActivity() {
        recyclerView.setHasFixedSize(true);
        recyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
        recyclerView.addOnItemTouchListener(
                new RecyclerItemClickListener(getActivity(), recyclerView, new RecyclerItemClickListener.OnItemClickListener() {
                    @Override
                    public void onItemClick(View view, int position) {
                        if (descriptionText != null && position == 0) {
                            return;
                        } else if (descriptionText != null) {
                            position = position - 1;
                        }

                        if ("AV".equalsIgnoreCase(mockTestList.get(position).get(0)) && usernewApp == 0 || "AV".equalsIgnoreCase(mockTestList.get(position).get((mockTestList.get(position).size() - 2))) && usernewApp == 0) {

                            if ("AV".equalsIgnoreCase(mockTestList.get(position).get((mockTestList.get(position).size() - 2)))) {
                                startActivity(new Intent(getActivity(), WebActivity.class).putExtra(Constants.BUNDLE_WEB_URL, mockTestList.get(position).get((mockTestList.get(position).size() - 1))).putExtra("ForceReload", true).putExtra("action_header", mockTestList.get(position).get(0)));

                            } else {
                                startActivity(new Intent(getActivity(), WebActivity.class).putExtra(Constants.BUNDLE_WEB_URL, mockTestList.get(position).get((mockTestList.get(position).size() - 1))).putExtra("ForceReload", true).putExtra("action_header", mockTestList.get(position).get(1)));

                            }

                        } else if ("CO".equalsIgnoreCase(mockTestList.get(position).get(0)) || "CO".equalsIgnoreCase(mockTestList.get(position).get((mockTestList.get(position).size() - 2)))) {

//                            DebugMonitor.getLogger().d("somedata","<>"+new Gson().toJson(mockTestList.get(position)));
                            if (getArguments().getBoolean("isMockTest")) {

                                startActivity(new Intent(getActivity(), SummeryActivity.class).putExtra("exam_name", mockTestList.get(position).get(1)).putExtra(Constants.BUNDLE_SUMMERY_URL, mockTestList.get(position).get((mockTestList.get(position).size() - 1))));

                            } else {

                                startActivity(new Intent(getActivity(), SummeryActivity.class).putExtra("exam_name", mockTestList.get(position).get(0)).putExtra(Constants.BUNDLE_SUMMERY_URL, mockTestList.get(position).get((mockTestList.get(position).size() - 1))));

                            }


                        } else if ("UP".equalsIgnoreCase(mockTestList.get(position).get(0)) || "UP".equalsIgnoreCase(mockTestList.get(position).get((mockTestList.get(position).size() - 2)))) {
                            try {
                                DialogUtils.getInstance().gotoPurchaseDialog(MockFragment.this, MockFragment.this);
                            } catch (Exception e) {
                            }

                        } else if ("CS".equalsIgnoreCase(mockTestList.get(position).get(0)) || "CS".equalsIgnoreCase(mockTestList.get(position).get((mockTestList.get(position).size() - 2)))) {


                        } else {
                            if(LargeAppInfo.getInstance().getExamRunning())
                            {
                                forcePostion=position;
                                DialogUtils.getInstance().multipleOptionFragmentDialog(getActivity(),MockFragment.this,"Alert","You are currently attending a test this action will clear the current test \n Are you sure to continue ?","Yes","No");
                            }
                            else {
                                if (mockTestList.get(position).size() > 0) {
                                    if (getArguments().getBoolean("isMockTest")) {
                                        examName = mockTestList.get(position).get(1);
                                    } else {
                                        examName = mockTestList.get(position).get(0);
                                    }
//                                showProgressDialog(((App)getActivity().getApplicationContext()).getLang().equals("hi")?getString(R.string.str_loading_test_hindi):getString(R.string.str_loading_test));
                                    showProgressDialog(getString(R.string.str_loading_test));

                                    urlTest = mockTestList.get(position).get((mockTestList.get(position).size() - 1));
                                    if (presenter != null) {
                                        presenter.callNativeTestApp(mockTestList.get(position).get((mockTestList.get(position).size() - 1)),getContext());
                                    }

                                } else {
                                    Log.e("Error", "Ya has error");
                                }
                            }
                        }


                    }

                    @Override
                    public void onItemLongClick(View view, int position) {

                    }
                })
        );

        if (getArguments().containsKey(Constants.BUNDLE_KEY_EXAM_URL)) {
           // LogEvents.getInstance().passEvents(getActivity(), "MockTestScreen", "view_page");

            mockHeader.setText(getArguments().getString(Constants.BUNDLE_TITLES));
            swipeRefreshLayout.setOnRefreshListener(this);
            swipeRefreshLayout.setColorSchemeResources(R.color.primary_color_dark,
                    android.R.color.holo_green_dark,
                    android.R.color.holo_orange_dark,
                    android.R.color.holo_blue_dark);

            if (LargeDataHandler.getInstance().getSingleData(getArguments().getString(Constants.BUNDLE_TITLES)) != null) {
                mockTestList.clear();
                mockTestList.addAll(LargeDataHandler.getInstance().getSingleData(getArguments().getString(Constants.BUNDLE_TITLES)).mockListDataList);
                descriptionText = LargeDataHandler.getInstance().getSingleData(getArguments().getString(Constants.BUNDLE_TITLES)).mockDescriptionText;
                usernewApp = LargeDataHandler.getInstance().getSingleData(getArguments().getString(Constants.BUNDLE_TITLES)).usenewapp;
                paymentUrl = LargeDataHandler.getInstance().getSingleData(getArguments().getString(Constants.BUNDLE_TITLES)).paymentUrl;
                buyUrl = LargeDataHandler.getInstance().getSingleData(getArguments().getString(Constants.BUNDLE_TITLES)).buyUrl;
                if (descriptionText != null && descriptionText.length() > 4) {
                    descriptionText = descriptionText.replaceAll("\n", "\n\n");
                }
            }
            mockTestListAdaptor = new MockTestListAdaptor(getActivity(), mockTestList, descriptionText);
            recyclerView.setAdapter(mockTestListAdaptor);

            if (Utils.isConnectionAvailable(getActivity())) {

                if (mockTestList.size() == 0) {
                    if (isAdded()) {
                        if (swipeRefreshLayout != null) {
                            swipeRefreshLayout.post(new Runnable() {
                                @Override
                                public void run() {
                                    if (swipeRefreshLayout != null)
                                        swipeRefreshLayout.setRefreshing(true);
                                }
                            });
                        }
                    }
                    if (presenter != null) {
                        presenter.callMockSingleTest(getArguments().getString(Constants.BUNDLE_KEY_EXAM_URL),getContext());
                    }
                } else {
                    noOfTests.setText("" + mockTestList.size() + " Mock Tests");
                }


            } else {
                Utils.showToast(getActivity(), Constants.ERROR_INTERNET_STATUS);
            }
        }

    }

    @Override
    public int getLayoutId() {
        return R.layout.fragment_mock_olivesdk;
    }

    public static MockFragment newInstance(int position, String url, String title) {

        Bundle bundleData = new Bundle();
        bundleData.putInt(Constants.BUNDLE_KEY_POSITION, position);
        bundleData.putString(Constants.BUNDLE_KEY_EXAM_URL, url);
        bundleData.putString(Constants.BUNDLE_TITLES, title);
        bundleData.putBoolean("isMockTest", true);
        MockFragment planFragment = new MockFragment();
        planFragment.setArguments(bundleData);
        return planFragment;
    }

    public static MockFragment newInstance(int position, String title) {
        Bundle bundleData = new Bundle();
        bundleData.putInt(Constants.BUNDLE_KEY_POSITION, position);
        bundleData.putString(Constants.BUNDLE_TITLES, title);
        bundleData.putBoolean("isMockTest", false);
        MockFragment planFragment = new MockFragment();
        planFragment.setArguments(bundleData);
        return planFragment;
    }

    @Override
    public void onSuccess(Object responseModel) {
        if (isAdded()) {

            if (responseModel instanceof MockSingleDataModel) {
                LargeDataHandler.getInstance().addSingleMockData(getArguments().getString(Constants.BUNDLE_TITLES), (MockSingleDataModel) responseModel);
                mockTestList.clear();
                mockTestList.addAll(((MockSingleDataModel) responseModel).mockListDataList);
                noOfTests.setText("" + ((MockSingleDataModel) responseModel).mockListDataList.size() + " Mock Tests");
                usernewApp = ((MockSingleDataModel) responseModel).usenewapp;
                paymentUrl = ((MockSingleDataModel) responseModel).paymentUrl;
                buyUrl = ((MockSingleDataModel) responseModel).buyUrl;
                if (((MockSingleDataModel) responseModel).mockDescriptionText != null) {
                    descriptionText = ((MockSingleDataModel) responseModel).mockDescriptionText;
                    mockTestListAdaptor.onMockDescripionChange(((MockSingleDataModel) responseModel).mockDescriptionText);
                    mockTestListAdaptor.notifyDataSetChanged();

                } else {
                    descriptionText = null;
                    mockTestListAdaptor.notifyDataSetChanged();

                }
                if (swipeRefreshLayout != null) {
                    swipeRefreshLayout.setRefreshing(false);
                }
            } else if (responseModel instanceof TestResponseModel) {
                hideProgressDialog();
            }
            if (swipeRefreshLayout != null) {
                swipeRefreshLayout.setRefreshing(false);
            }
        }
//        swipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void onFailed() {
        if (swipeRefreshLayout != null) {
            swipeRefreshLayout.setRefreshing(false);
        }
        hideProgressDialog();

//        swipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void onSuccess(List responseModel) {

    }

    @Override
    public void onAuthFailed() {
        if (isVisible()) {
            BasicConfig.getInstance().onAuthFailed(this);
        }
    }

    @Override
    public void onSuccess(String response) {

    }

    @Override
    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accurecy) {

    }

    @Override
    public void onTestDataCallback(TestResponseModel response, ArrayList testAnswerModelArrayList, boolean status, TreeMap questionSet) {

        if (isAdded()) {
            hideProgressDialog();
            if (swipeRefreshLayout != null) {
                swipeRefreshLayout.setRefreshing(false);
            }
            if (status) {
                if (response != null) {
                    LargeAppInfo.getInstance().clearAllData();

                    LargeAppInfo.getInstance().setQuestionInfo(response);
                    LargeAppInfo.getInstance().setQuestionSet(questionSet);
                    LargeAppInfo.getInstance().setQuestionAnswerInfo(testAnswerModelArrayList);

                    if (getArguments().containsKey(Constants.BUNDLE_KEY_EXAM_URL)) {
                        startActivity(new Intent(getActivity(), TestModuleActivity.class).putExtra(Constants.BASE_BUNDLE_EXAM_NAME, examName).putExtra(Constants.BASE_BUNDLE_URL, urlTest).putExtra(Constants.IS_MOCK, true));

                    } else {
                        startActivity(new Intent(getActivity(), TestModuleActivity.class).putExtra(Constants.BASE_BUNDLE_EXAM_NAME, examName).putExtra(Constants.BASE_BUNDLE_URL, urlTest).putExtra(Constants.IS_MOCK, false));

                    }
//                startActivity(new Intent(getActivity(), TestModuleActivity.class).putExtra("extra", new byte[1024 * 2000004]).putExtra(Constants.BASE_BUNDLE_EXAM_NAME, examName).putExtra(Constants.BASE_BUNDLE_URL, urlTest).putExtra(Constants.IS_MOCK, true));

                }
            } else {
                Toast.makeText(getActivity(), "try again", Toast.LENGTH_LONG).show();

            }
        }
    }

    @Override
    public void onRefresh() {
        if (getArguments().containsKey(Constants.BUNDLE_KEY_EXAM_URL)) {
            if (presenter != null) {
                presenter.callMockSingleTest(getArguments().getString(Constants.BUNDLE_KEY_EXAM_URL),getContext());
            }
        }
    }

    @Override
    public void onOptionDialogSelected(int position) {

    }

    @Override
    public void onAutoDialogSelected() {

    }

    @Override
    public void onSubmitDialogSelected() {

    }

    @Override
    public void onExitApp() {

    }

    @Override
    public void onExitWithoutPause() {

    }

    @Override
    public void onTryAgain() {

    }

    @Override
    public void onPauseTest(boolean value) {

    }

    @Override
    public void startTest(boolean value) {

    }

    @Override
    public void retyPermission() {

    }

    @Override
    public void gotoPurchase() {
        if (getActivity() != null) {

            getActivity().startActivity(new Intent(getActivity(), TestUpgradeActivity.class).putExtra(Constants.PAYMENT_TYPE, (buyUrl == null ? paymentUrl : buyUrl)));
        }

    }

    @Override
    public void noPhoneAction() {

    }

    @Override
    public void openPermissionSetting() {

    }

    @Subscribe
    public void getTestSubmitStatus(TestStatusEventModel statusEventModel) {
        // listen for subscribed event
        if (getArguments().containsKey(Constants.BUNDLE_KEY_EXAM_URL)) {
            if (isAdded() && getUserVisibleHint()) {
                if (!statusEventModel.refreshWholeTest) {
                    if (presenter != null) {
                        presenter.callMockSingleTest(getArguments().getString(Constants.BUNDLE_KEY_EXAM_URL),getContext());
                    }
                }
            }
        }
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            MainEventBus.getInstance().register(this);
        } catch (Exception e) {

        }


    }

    @Override
    public void onDetach() {
        super.onDetach();
        try {
            MainEventBus.getInstance().unregister(this);
        } catch (Exception e) {

        }

        //dismissDialog();

    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (presenter != null) {
            presenter.unSubscribe();
        }
    }

    @Subscribe
    public void onRefresh(RefreshTestInfo refresh) {
//        Log.d("inside","uhahha");
        if (presenter != null) {
//            Log.d("inside","uhahhaiffffffffffffffffffffffffffffffff");

            if (getArguments().containsKey(Constants.BUNDLE_KEY_EXAM_URL)) {
                if (isAdded() && getUserVisibleHint()) {
//                    Log.d("inside", "uhahha5555555555555555555");
                    presenter.callMockSingleTest(getArguments().getString(Constants.BUNDLE_KEY_EXAM_URL),getContext());
                }
            }

        }
    }

    @Override
    public void onFailed(String message) {

    }


    @Subscribe
    public void refreshData(RefreshFragment fragment) {
        if (mockTestList != null && mockTestList.size() == 0) {
        }
    }

    @Override
    public void onPositiveClick() {
        MainEventBus.getInstance().post(new ClearTest());
        if (mockTestList.get(forcePostion).size() > 0) {
            if (getArguments().getBoolean("isMockTest")) {
                examName = mockTestList.get(forcePostion).get(1);
            } else {
                examName = mockTestList.get(forcePostion).get(0);
            }
//                                showProgressDialog(((App)getActivity().getApplicationContext()).getLang().equals("hi")?getString(R.string.str_loading_test_hindi):getString(R.string.str_loading_test));
            showProgressDialog(getString(R.string.str_loading_test));

            urlTest = mockTestList.get(forcePostion).get((mockTestList.get(forcePostion).size() - 1));
            if (presenter != null) {
                presenter.callNativeTestApp(mockTestList.get(forcePostion).get((mockTestList.get(forcePostion).size() - 1)),getContext());
            }

        } else {
            Log.e("Error", "Ya has error");
        }
    }

    @Override
    public void onNegativeClick() {

    }
}
