package in.oliveboard.sdk.ui;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ProgressDialog;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.MenuItem;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import java.util.Objects;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.RefreshTestInfo;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.DialogUtils;
import in.oliveboard.sdk.utils.MainEventBus;
import in.oliveboard.sdk.utils.Utils;
import in.oliveboard.sdk.utils.onDialogUtilCalled;

public class WebActivity extends AppCompatActivity implements onDialogUtilCalled {
    WebView webView;
    Toolbar toolbar;
    protected ProgressDialog progressDialog;
    boolean loadedOnce = false;
    boolean calledTestRefresh=false;

    @SuppressLint("SetJavaScriptEnabled")
    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_webview_olivesdk);

        toolbar = findViewById(R.id.toolbar);
        webView = findViewById(R.id.webView);


        toolbar.setNavigationIcon(R.drawable.icon_toolbar);
        setSupportActionBar(toolbar);

        Objects.requireNonNull(getSupportActionBar()).setTitle(getIntent().getStringExtra("action_header"));
        getSupportActionBar().setDisplayShowTitleEnabled(true);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
       // LogEvents.getInstance().passEvents(getApplicationContext(),"WebTestSectionScreen","view_page");

        if (Utils.isConnectionAvailable(WebActivity.this)) {

            WebSettings webSettings = webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webView.getSettings().setLoadWithOverviewMode(true);
            webView.getSettings().setUseWideViewPort(true);
            webView.setScrollBarStyle(WebView.SCROLLBARS_OUTSIDE_OVERLAY);
            webView.setScrollbarFadingEnabled(false);
            webView.getSettings().setSaveFormData(false);

            webView.setWebViewClient(new WebViewClient() {

                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if (Utils.isConnectionAvailable(WebActivity.this)) {
                        view.loadUrl(url);
                    } else {
                        Utils.showToast(WebActivity.this, Constants.ERROR_INTERNET_STATUS);
                    }

                    return true;
                }

                @Override
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
//                    Log.d("urlz",url+">>>>>>>>>>>>>>>>>>>>>>>>"+loadedOnce);

//                    showProgressDialog(((App)getApplicationContext()).getLang().equals("hi")?getString(R.string.progress_text_hindi):getString(R.string.progress_text));
                      showProgressDialog(getString(R.string.progress_text));

                    if(!(Objects.requireNonNull(getIntent().getExtras()).containsKey(Constants.IS_WALLET_LOAD))) {

                        if (getIntent().getExtras().containsKey("ForceReload") && loadedOnce) {
                            if (url != null) {
                                if (url.toLowerCase().contains("sol.php") || url.toLowerCase().contains("solution")) {
//                                Log.d("urlz",url+">>>>>>>>>>>>>>called>>>>>>>>>>");
                                    calledTestRefresh=true;

                                    MainEventBus.getInstance().post(new RefreshTestInfo());
                                }
//                                } else {
////                                Log.d("urlz",url+">>>>>>>>>>>>>>called??>>>>>>>>>>");
//
//                                    MainEventBus.getInstance().post(new RefreshTestInfo());
//                                }
                            }

                        }
                    }
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    loadedOnce = true;
                    hideProgressDialog();

                }
            });

            webView.loadUrl(getIntent().getStringExtra(Constants.BUNDLE_WEB_URL));
        } else {
            Utils.showToast(WebActivity.this, Constants.ERROR_INTERNET_STATUS);

        }
    }
    //    @Override
//    protected void initializeDagger() {
//
//
//    }
//
//    @Override
//    protected void savedInstance(Bundle savedInstanceState) {
//
//    }
//
//    @Override
//    protected void initializePresenter() {
//
//    }
//
//    @Override
//    public int getLayoutId() {
//        return R.layout.activity_webview;
//    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    protected void onDestroy() {
        super.onDestroy();
        if(Objects.requireNonNull(getIntent().getExtras()).containsKey(Constants.IS_WALLET_LOAD)) {
//            MainEventBus.getInstance().post(new ReCheckWallet());
            Log.d("if","yes");
        }
        else if(!calledTestRefresh)
        {
            MainEventBus.getInstance().post(new RefreshTestInfo());

        }
    }

    @Override
    protected void onStop() {

        super.onStop();
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    public void onBackPressed() {
        if(!(Objects.requireNonNull(getIntent().getExtras()).containsKey(Constants.IS_WALLET_LOAD))) {

            hideProgressDialog();
            if (getIntent().getExtras() != null && getIntent().getExtras().containsKey("hasExitDialog")) {
                finish();
            } else {
                DialogUtils.getInstance().exitDialog(WebActivity.this, this);
            }
        }
        else
        {
            super.onBackPressed();
        }

    }

    @Override
    public void onOptionDialogSelected(int position) {

    }

    @Override
    public void onAutoDialogSelected() {

    }

    @Override
    public void onSubmitDialogSelected() {

    }

    @Override
    public void onExitApp() {
        finish();
    }

    @Override
    public void onExitWithoutPause() {

    }

    @Override
    public void onTryAgain() {

    }

    @Override
    public void onPauseTest(boolean value) {

    }

    @Override
    public void startTest(boolean value) {

    }

    @Override
    public void retyPermission() {

    }

    @Override
    public void gotoPurchase() {

    }

    @Override
    public void noPhoneAction() {

    }

    @Override
    public void openPermissionSetting() {

    }

    @TargetApi(Build.VERSION_CODES.KITKAT)
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                if(Objects.requireNonNull(getIntent().getExtras()).containsKey(Constants.IS_WALLET_LOAD)) {
                   finish();
                }
                else if (getIntent().getExtras() != null && getIntent().getExtras().containsKey("hasExitDialog")) {
                    finish();
                } else {
                    DialogUtils.getInstance().exitDialog(WebActivity.this, this);
                }

//                finish();

        }
        return super.onOptionsItemSelected(item);
    }

    protected void showProgressDialog(String message) {


        if (progressDialog == null || !progressDialog.isShowing()) {
            progressDialog = new ProgressDialog(this);
            progressDialog.setMessage(message);
            progressDialog.setCanceledOnTouchOutside(false);
            if (!isFinishing()) {
                progressDialog.show();
            }
        }
    }

    protected void hideProgressDialog() {
        try {
            if (progressDialog != null && progressDialog.isShowing()) {
                if (!isFinishing()) {
                    progressDialog.dismiss();
                }
            }
        }
        catch (Exception e)
        {

            Log.d("catch","catch");
        }
    }
}

