package in.oliveboard.sdk.utils;

import android.content.SharedPreferences;

public class BaseSharedPreferences {

    private SharedPreferences mSharedPreferences;

    public BaseSharedPreferences(SharedPreferences mSharedPreferences) {
        this.mSharedPreferences = mSharedPreferences;
    }

    public void putData(String key, int data) {
        mSharedPreferences.edit().putInt(key,data).apply();
    }

    public void putBooleanData(String key, boolean data) {
        mSharedPreferences.edit().putBoolean(key,data).apply();
    }
    public boolean getBooleanData(String key)
    {
        return mSharedPreferences.getBoolean(key,false);
    }

    public String getStringData(String key)
    {
        return mSharedPreferences.getString(key,"");
    }

    public int getData(String key) {
        return mSharedPreferences.getInt(key,0);
    }

    public void putStringData(String key, String data) {
        mSharedPreferences.edit().putString(key,data).apply();

    }
    public void putLongData(String key, long data){
        mSharedPreferences.edit().putLong(key,data).apply();
    }
    public long getLongData(String key){
        return mSharedPreferences.getLong(key,0);
    }

    public void clearData() {
        mSharedPreferences.edit().clear().commit();
//        editor.commit();
    }
}