package in.oliveboard.sdk.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;

public class AppPreferences {
    private SharedPreferences appSharedPrefs;
    private Editor prefsEditor;

    @SuppressLint("CommitPrefEdits")
    public AppPreferences(Context context, String Preferncename) {
        this.appSharedPrefs = context.getSharedPreferences(Preferncename,
                Activity.MODE_PRIVATE);
        this.prefsEditor = appSharedPrefs.edit();
    }

    public String getData(String key) {
        return appSharedPrefs.getString(key, "");
    }

    public void clearpref(Context prefcontect, String name) {
        this.appSharedPrefs = prefcontect.getSharedPreferences(
                name, 0);
        this.appSharedPrefs.edit().clear().apply();
    }

    public void clearData() {
        if(appSharedPrefs!=null) {
            appSharedPrefs.edit().clear().apply();
        }
//        editor.commit();
    }


    public void SaveData(String Tag, String text) {
        prefsEditor.putString(Tag, text);
        prefsEditor.commit();
    }

    public int getIntData(String key) {
        // return appSharedPrefs.getString(key, "");
        return appSharedPrefs.getInt(key, 0);
    }


    public void SaveIntData(String text, Integer Tag) {
        // prefsEditor.putString(Tag, text);
        prefsEditor.putInt(text, Tag);
        prefsEditor.commit();
    }

    public boolean getBoolean(String key) {
        return appSharedPrefs.getBoolean(key, false);

    }

    public void putLongData(String key, long value) {
        prefsEditor.putLong(key, value);
        prefsEditor.commit();
    }

    public long getLongData(String key) {
        return appSharedPrefs.getLong(key,0);

    }

    public void saveBoolean(String key, boolean b) {
        prefsEditor.putBoolean(key, b);
        prefsEditor.commit();
    }
}