package in.oliveboard.sdk.ui.adapters;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import java.util.ArrayList;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.MockIndex;
import in.oliveboard.sdk.utils.MainEventBus;


public class AllBanksAdapter extends RecyclerView.Adapter<AllBanksAdapter.MyViewHolder>
        implements GridExamsAdapter.ItemClickListener {

    private ArrayList<Object> banksList;
    private Context mContext;

    public AllBanksAdapter(Context context, ArrayList<Object> allBanksNExams) {
        this.mContext = context;
        this.banksList = allBanksNExams;
    }

    @Override
    public MyViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_item_banks_olivesdk, parent, false);
        return new MyViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(MyViewHolder holder, int position) {
        holder.bankNames.setText(((ArrayList<String>) ((ArrayList<Object>) (banksList.get(position))).get(0)).get(0));

        final GridLayoutManager layoutManager = new GridLayoutManager(mContext, 2);
        holder.examsList.setLayoutManager(layoutManager);
        GridExamsAdapter adapter1 = new GridExamsAdapter(mContext, this, position,
                ((ArrayList<ArrayList<String>>) ((ArrayList<Object>) (banksList.get(position))).get(1)));
        holder.examsList.setAdapter(adapter1);
    }

    @Override
    public int getItemCount() {
        return banksList.size();
    }

    @Override
    public void onItemClick(int position, int parentPosition) {
        MainEventBus.getInstance().post(new MockIndex(
                ((ArrayList<ArrayList<String>>) ((ArrayList<Object>) (banksList.get(parentPosition))).get(1)).get(position).get(3),
                ((ArrayList<ArrayList<String>>) ((ArrayList<Object>) (banksList.get(parentPosition))).get(1)).get(position).get(0)));
    }

    public class MyViewHolder extends RecyclerView.ViewHolder {
        public TextView bankNames;
        RecyclerView examsList;

        public MyViewHolder(View view) {
            super(view);
            bankNames = (TextView) view.findViewById(R.id.bind_banks_title);
            examsList = (RecyclerView) view.findViewById(R.id.bind_banks_recycle_exams);
        }
    }
}
