package in.oliveboard.sdk.presenter;

import java.util.List;
import java.util.Map;

import in.oliveboard.sdk.log.DebugMonitor;
import in.oliveboard.sdk.presenter.base.BaseCallback;
import in.oliveboard.sdk.presenter.base.Presenter;
import in.oliveboard.sdk.presenter.interfaces.AuthCallback;
import in.oliveboard.sdk.presenter.interfaces.AuthContract;
import in.oliveboard.sdk.presenter.model.PushModel;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.usecase.AuthUseCase;
import in.oliveboard.sdk.utils.BaseSharedPreferences;


public class AuthPresenter extends Presenter<AuthContract.View> implements AuthCallback {

    private final AuthUseCase authUseCase = new AuthUseCase();

    @Override

    public void onUserRegister(Map<String, String> userInfo) {
        if(authUseCase!=null) {
            authUseCase.getSignUpResponse(callback, userInfo);
        }
    }

    @Override
    public void onUserLogin(Map<String, String> userInfo) {
        if(authUseCase!=null) {
            authUseCase.getLoginResponse(callback, userInfo);
        }
    }

    @Override
    public void onUserChangePassword(Map<String, String> userInfo) {
        if(authUseCase!=null) {
            authUseCase.getChangePasswordResponse(callback, userInfo);
        }
    }

    private final BaseCallback callback = new BaseCallback() {
        @Override
        public void onSuccess() {


        }

        @Override
        public void onSuccess(Object model) {
            if(getView()!=null) {
                getView().onLoginSuccess(model);
            }
        }

        @Override
        public void onSuccess(String response) {

        }

        @Override
        public void onSolutionSuccess(TestResponseModel model) {

        }

        @Override
        public void onLoginSuccess(String token) {
            if(getView()!=null) {
                getView().loginSuccess(token);
            }
        }

        @Override
        public void onAuthFailed() {
            getView().onAuthFailed();
        }

        @Override
        public void onFail() {
            if (getView() != null) {
                getView().onFailed();
            }

        }

        @Override
        public void onFail(String message) {
            if (getView() != null) {
                getView().onFailed(message);
            }
        }

        @Override
        public void onSuccess(List model) {

        }
    };
}
